/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.internal.builders.TestBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortBuilder
extends TestBuilder {
    public static final String BUILDER_NAME = "org.eclipse.core.tests.resources.sortbuilder";
    protected static SortBuilder singleton;
    protected static final ArrayList<SortBuilder> allInstances;
    public static String SORT_ORDER;
    public static String ASCENDING;
    public static String DESCENDING;
    public static String SORTED_FOLDER;
    public static String UNSORTED_FOLDER;
    public static String DEFAULT_SORTED_FOLDER;
    public static String DEFAULT_UNSORTED_FOLDER;
    private int triggerForLastBuild = -1;
    private boolean wasDeltaNull = false;
    protected final ArrayList<IResource> changedResources = new ArrayList();
    private boolean requestForgetState = false;

    static {
        allInstances = new ArrayList();
        SORT_ORDER = "SortOrder";
        ASCENDING = "Ascending";
        DESCENDING = "Descending";
        SORTED_FOLDER = "SortedFolder";
        UNSORTED_FOLDER = "UnsortedFolder";
        DEFAULT_SORTED_FOLDER = "SortedFolder";
        DEFAULT_UNSORTED_FOLDER = "UnsortedFolder";
    }

    public static SortBuilder[] allInstances() {
        return allInstances.toArray(new SortBuilder[allInstances.size()]);
    }

    public static SortBuilder getInstance() {
        return singleton;
    }

    public static void resetSingleton() {
        singleton = null;
    }

    public SortBuilder() {
        singleton = this;
        allInstances.add(this);
    }

    private void build(IFile unsortedFile) throws CoreException {
        InputStream is = unsortedFile.getContents();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                int c;
                while ((c = is.read()) != -1) {
                    bos.write(c);
                }
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new ResourceException(75, null, "IOException sorting file", (Throwable)e);
        }
        byte[] bytes = bos.toByteArray();
        this.quicksort(bytes, 0, bytes.length - 1, this.isSortOrderAscending());
        IFile sortedFile = (IFile)this.convertToSortedResource((IResource)unsortedFile);
        this.createResource((IResource)sortedFile);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        sortedFile.setContents((InputStream)bis, true, false, null);
    }

    @Override
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        String project;
        this.arguments = args;
        super.build(kind, args, monitor);
        this.triggerForLastBuild = kind;
        IResourceDelta delta = this.getDelta(this.getProject());
        this.recordChangedResources(delta);
        boolean bl = this.wasDeltaNull = delta == null;
        if (delta == null || kind == 6) {
            this.fullBuild();
        } else {
            try {
                this.incrementalBuild(delta);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "tests", 75, "Incremental build failed due to internal error", (Throwable)e));
            }
        }
        if (this.requestForgetState) {
            this.requestForgetState = false;
            this.forgetLastBuiltState();
        }
        if ((project = (String)this.arguments.get("InterestingProject")) != null) {
            return new IProject[]{this.getProject().getWorkspace().getRoot().getProject(project)};
        }
        return new IProject[0];
    }

    private IResource convertToSortedResource(IResource unsortedResource) throws CoreException {
        IPath sortedFolderRelativePath = unsortedResource.getProjectRelativePath().removeFirstSegments(1);
        int type = unsortedResource.getType();
        if (type == 2) {
            return this.getSortedFolder().getFolder(sortedFolderRelativePath);
        }
        if (type == 1) {
            return this.getSortedFolder().getFile(sortedFolderRelativePath);
        }
        throw new ResourceException(366, null, "Wrong resource type", null);
    }

    private void createResource(IResource resource) throws CoreException {
        if (resource.exists()) {
            return;
        }
        this.createResource((IResource)resource.getParent());
        int type = resource.getType();
        if (type == 2) {
            ((IFolder)resource).create(true, true, null);
        } else if (type == 1) {
            ((IFile)resource).create(null, true, null);
        } else {
            throw new ResourceException(366, null, "Wrong resource type", null);
        }
    }

    private void deleteResource(IResource resource) throws CoreException {
        if (!resource.exists()) {
            return;
        }
        int type = resource.getType();
        if (type == 2) {
            IFolder folder = (IFolder)resource;
            IResource[] members = folder.members();
            int i = 0;
            while (i < members.length) {
                this.deleteResource(members[i]);
                ++i;
            }
            folder.delete(true, null);
        } else if (type == 1) {
            ((IFile)resource).delete(true, null);
        } else {
            throw new ResourceException(366, null, "Wrong resource type", null);
        }
    }

    private void fullBuild() throws CoreException {
        try {
            IFolder sortedFolder = this.getSortedFolder();
            IFolder unsortedFolder = this.getUnsortedFolder();
            if (sortedFolder.exists()) {
                IResource[] members = sortedFolder.members();
                int i = 0;
                while (i < members.length) {
                    this.deleteResource(members[i]);
                    ++i;
                }
            }
            if (unsortedFolder.exists()) {
                this.fullBuild((IResource)unsortedFolder);
            }
        }
        catch (Exception e) {
            throw new ResourceException(75, null, "Sort builder failed", (Throwable)e);
        }
    }

    private void fullBuild(IResource unsortedResource) throws Exception {
        if (unsortedResource.getType() == 1) {
            this.build((IFile)unsortedResource);
        } else {
            IResource[] members = ((IFolder)unsortedResource).members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                this.fullBuild(member);
                ++i;
            }
        }
    }

    public IResource[] getAffectedResources() {
        return this.changedResources.toArray(new IResource[this.changedResources.size()]);
    }

    private IFolder getSortedFolder() {
        String sortedFolder = (String)this.arguments.get(SORTED_FOLDER);
        if (sortedFolder == null) {
            sortedFolder = DEFAULT_SORTED_FOLDER;
        }
        return this.getProject().getFolder(sortedFolder);
    }

    private IFolder getUnsortedFolder() {
        String unsortedFolder = (String)this.arguments.get(UNSORTED_FOLDER);
        if (unsortedFolder == null) {
            unsortedFolder = DEFAULT_UNSORTED_FOLDER;
        }
        return this.getProject().getFolder(unsortedFolder);
    }

    private void incrementalBuild(IResourceDelta delta) throws CoreException {
        IResource unsortedResource = delta.getResource();
        IPath unsortedFolderPath = this.getUnsortedFolder().getFullPath();
        IPath deltaPath = delta.getResource().getFullPath();
        boolean isUnderUnsortedFolder = unsortedFolderPath.isPrefixOf(deltaPath);
        boolean isOverUnsortedFolder = deltaPath.isPrefixOf(unsortedFolderPath);
        if (isUnderUnsortedFolder) {
            int status = delta.getKind();
            int changeFlags = delta.getFlags();
            int type = unsortedResource.getType();
            IResource sortedResource = this.convertToSortedResource(unsortedResource);
            if (status == 2) {
                if (sortedResource.exists()) {
                    sortedResource.delete(false, null);
                }
            } else if (type == 1 && status == 1) {
                this.build((IFile)unsortedResource);
            } else if (type == 1 && status == 4 && (changeFlags & 0x100) != 0) {
                this.build((IFile)unsortedResource);
            }
        }
        if (isUnderUnsortedFolder || isOverUnsortedFolder) {
            IResourceDelta[] affectedChildren = delta.getAffectedChildren();
            int i = 0;
            while (i < affectedChildren.length) {
                this.incrementalBuild(affectedChildren[i]);
                ++i;
            }
        }
    }

    private boolean isSortOrderAscending() {
        String sortOrder = (String)this.arguments.get(SORT_ORDER);
        return !DESCENDING.equals(sortOrder);
    }

    private void quicksort(byte[] bytes, int start, int end, boolean ascendingOrder) {
        if (start >= end || start < 0 || end >= bytes.length) {
            return;
        }
        int pos = start;
        int mid = (start + end) / 2;
        this.swap(bytes, start, mid);
        int i = start + 1;
        while (i <= end) {
            if (ascendingOrder && bytes[i] < bytes[start] || !ascendingOrder && bytes[i] > bytes[start]) {
                this.swap(bytes, ++pos, i);
            }
            ++i;
        }
        this.swap(bytes, start, pos);
        this.quicksort(bytes, start, pos, ascendingOrder);
        this.quicksort(bytes, pos + 1, end, ascendingOrder);
    }

    private void recordChangedResources(IResourceDelta delta) throws CoreException {
        this.changedResources.clear();
        if (delta == null) {
            return;
        }
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                SortBuilder.this.changedResources.add(delta.getResource());
                return true;
            }
        });
    }

    public void requestForgetLastBuildState() {
        this.requestForgetState = true;
    }

    private void swap(byte[] bytes, int pos1, int pos2) {
        byte temp = bytes[pos1];
        bytes[pos1] = bytes[pos2];
        bytes[pos2] = temp;
    }

    public String toString() {
        return "SortBuilder(" + this.getProject() + ')';
    }

    public boolean wasAutoBuild() {
        return this.triggerForLastBuild == 9;
    }

    public boolean wasBuilt() {
        return this.triggerForLastBuild != -1;
    }

    public boolean wasDeltaNull() {
        return this.wasDeltaNull;
    }

    public boolean wasFullBuild() {
        return this.triggerForLastBuild == 6;
    }

    public boolean wasIncrementalBuild() {
        return this.triggerForLastBuild == 10;
    }
}

