/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.filesystem.bogus;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.filesystem.bogus.BogusFileStore;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryFileSystem;

public class BogusFileSystem
extends MemoryFileSystem {
    public static final String SCHEME_BOGUS = "bogus";
    private static BogusFileSystem instance;

    public static BogusFileSystem getInstance() {
        BogusFileSystem tmpInstance = instance;
        if (tmpInstance != null) {
            return tmpInstance;
        }
        instance = new BogusFileSystem();
        return instance;
    }

    public static URI toURI(IPath path) {
        try {
            return new URI(SCHEME_BOGUS, path.setDevice(null).toPortableString(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public BogusFileSystem() {
        instance = this;
    }

    public IFileStore getStore(URI uri) {
        return new BogusFileStore(Path.fromPortableString((String)uri.getSchemeSpecificPart()));
    }
}

