/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.filesystem.broken;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Assert;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class BrokenFileStore
extends FileStore {
    private URI uri;

    public BrokenFileStore(URI uri) {
        this.uri = uri;
    }

    public BrokenFileStore(IPath path) {
        try {
            this.uri = new URI(this.uri.getScheme(), path.toString(), null);
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        this.fail();
        return null;
    }

    private void fail() throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.core.tests.resources", 1, "This exception is thrown on purpose as part of a test", null));
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        this.fail();
        return null;
    }

    private IPath getPath() {
        return new Path(this.uri.getSchemeSpecificPart());
    }

    public IFileStore getChild(String name) {
        return new BrokenFileStore(this.getPath().append(name));
    }

    public String getName() {
        return this.getPath().lastSegment();
    }

    public IFileStore getParent() {
        IPath path = this.getPath();
        if (path.segmentCount() == 0) {
            return null;
        }
        return new BrokenFileStore(path.removeLastSegments(1));
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        this.fail();
        return null;
    }

    public URI toURI() {
        return this.uri;
    }
}

