/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.TestingSupport;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class LocalSyncTest
extends LocalStoreTest
implements ICoreConstants {
    public LocalSyncTest() {
    }

    public LocalSyncTest(String name) {
        super(name);
    }

    public void assertExistsInFileSystemWithNoContent(IFile target) {
        LocalSyncTest.assertTrue((boolean)this.existsInFileSystemWithNoContent((IResource)target));
    }

    public String[] defineHierarchy() {
        return new String[]{"/File1", "/Folder1/", "/Folder1/File1", "/Folder1/Folder2/"};
    }

    private boolean existsInFileSystemWithNoContent(IResource resource) {
        IPath path = resource.getLocation();
        return path.toFile().exists() && path.toFile().length() == 0L;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(LocalSyncTest.class);
        return suite;
    }

    public void testProjectDeletion() {
        Project project = (Project)this.projects[0];
        TestingSupport.waitForSnapshot();
        IResource[] resources = this.buildResources((IContainer)project, this.defineHierarchy());
        this.ensureExistsInWorkspace(resources, true);
        Workspace.clear((File)project.getLocation().toFile());
        try {
            project.refreshLocal(2, null);
            LocalSyncTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        LocalSyncTest.assertTrue((String)"1.1", (boolean)project.exists());
        int i = 1;
        while (i < resources.length) {
            LocalSyncTest.assertTrue((String)"1.2", (!resources[i].exists() ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testProjectWithNoResources() {
        Project project = (Project)this.projects[0];
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            LocalSyncTest.fail((String)"1.0", (Throwable)e);
        }
        LocalSyncTest.assertTrue((String)"1.1", (boolean)project.exists());
    }

    public void testSimpleSync() {
        Project project = (Project)this.projects[0];
        IFile index = project.getFile((IPath)new Path("index.html"));
        IFile toc = project.getFile((IPath)new Path("toc.html"));
        IFile file = project.getFile((IPath)new Path("file"));
        IFolder folder = project.getFolder((IPath)new Path("folder"));
        this.ensureExistsInWorkspace(index, "");
        this.ensureExistsInWorkspace((IResource)toc, true);
        this.ensureExistsInWorkspace(file, "");
        this.ensureExistsInWorkspace((IResource)folder, true);
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            LocalSyncTest.fail((String)"0.0", (Throwable)e);
        }
        this.assertExistsInWorkspace((IResource)index);
        this.assertExistsInFileSystemWithNoContent(index);
        this.assertExistsInWorkspace((IResource)toc);
        this.assertExistsInFileSystem((IResource)toc);
        LocalSyncTest.assertTrue((boolean)toc.exists());
        this.assertExistsInWorkspace((IResource)file);
        this.assertExistsInFileSystemWithNoContent(file);
        LocalSyncTest.assertTrue((boolean)file.exists());
        LocalSyncTest.assertTrue((file.getType() == 1 ? 1 : 0) != 0);
        this.assertExistsInWorkspace((IResource)folder);
        LocalSyncTest.assertTrue((folder.getType() == 2 ? 1 : 0) != 0);
        this.ensureDoesNotExistInFileSystem((IResource)toc);
        this.ensureDoesNotExistInFileSystem((IResource)file);
        this.ensureDoesNotExistInFileSystem((IResource)folder);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            LocalSyncTest.fail((String)"3.0", (Throwable)e);
        }
        file = project.getFolder((IPath)new Path("file"));
        folder = project.getFile((IPath)new Path("folder"));
        this.ensureExistsInFileSystem((IResource)file);
        this.ensureExistsInFileSystem((IFile)folder);
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            LocalSyncTest.fail((String)"4.0", (Throwable)e);
        }
        this.assertExistsInWorkspace((IResource)index);
        this.assertExistsInFileSystemWithNoContent(index);
        this.assertDoesNotExistInFileSystem((IResource)toc);
        this.assertDoesNotExistInWorkspace((IResource)toc);
        this.assertExistsInWorkspace((IResource)file);
        this.assertExistsInFileSystem((IResource)file);
        LocalSyncTest.assertTrue((boolean)file.exists());
        LocalSyncTest.assertTrue((file.getType() == 2 ? 1 : 0) != 0);
        this.assertExistsInWorkspace((IResource)folder);
        this.assertExistsInFileSystem((IResource)folder);
        LocalSyncTest.assertTrue((boolean)file.exists());
        LocalSyncTest.assertTrue((folder.getType() == 1 ? 1 : 0) != 0);
    }
}

