/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.ResourceTest;

public class RefreshLocalPerformanceTest
extends ResourceTest {
    public static final String bigSiteDevice = "d:";
    public static final IPath bigSiteLocation = new Path("d:", "/bigsite");
    public Date startDate;

    public RefreshLocalPerformanceTest() {
    }

    public RefreshLocalPerformanceTest(String name) {
        super(name);
    }

    protected int countChildren(File root) {
        String[] children = root.list();
        if (children == null) {
            return 0;
        }
        int result = 0;
        int i = 0;
        while (i < children.length) {
            File child = new File(root, children[i]);
            if (child.isDirectory()) {
                result += this.countChildren(child);
            }
            ++result;
            ++i;
        }
        return result;
    }

    public String dispTime(long diff) {
        return String.valueOf(diff);
    }

    public void startClock() {
        this.startDate = new Date();
    }

    public long stopClock() {
        Date stopDate = new Date();
        return stopDate.getTime() - this.startDate.getTime();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(RefreshLocalPerformanceTest.class.getName());
        suite.addTest((Test)new RefreshLocalPerformanceTest("testLocalRefreshPerformance"));
        return suite;
    }

    public void testLocalRefreshPerformance() throws Exception {
        if (!bigSiteLocation.toFile().isDirectory()) {
            return;
        }
        int n = 10;
        IProject project = RefreshLocalPerformanceTest.getWorkspace().getRoot().getProject("MyTestProject");
        IProjectDescription description = RefreshLocalPerformanceTest.getWorkspace().newProjectDescription(project.getName());
        description.setLocation(bigSiteLocation);
        long averageWithTree = 0L;
        long averageWithoutTree = 0L;
        long[] withoutTree = new long[n];
        long[] withTree = new long[n];
        int numberOfFiles = this.countChildren(bigSiteLocation.toFile());
        System.out.println("Number of local resources: " + numberOfFiles);
        int i = 0;
        while (i < n) {
            project.create(description, null);
            project.open(null);
            System.out.print("NO TREE: ");
            this.startClock();
            project.refreshLocal(2, null);
            withoutTree[i] = this.stopClock();
            System.out.println(this.dispTime(withoutTree[i]));
            System.out.print("TREE: ");
            this.startClock();
            project.refreshLocal(2, null);
            withTree[i] = this.stopClock();
            System.out.println(this.dispTime(withTree[i]));
            averageWithoutTree += withoutTree[i];
            averageWithTree += withTree[i];
            project.delete(false, false, null);
            ++i;
        }
        System.out.println("Average without tree: " + (averageWithoutTree /= (long)n));
        System.out.println("Average with tree: " + (averageWithTree /= (long)n));
    }
}

