/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class SymlinkResourceTest
extends LocalStoreTest {
    public SymlinkResourceTest() {
    }

    public SymlinkResourceTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(SymlinkResourceTest.class);
    }

    protected void mkLink(IFileStore dir, String src, String tgt, boolean isDir) {
        try {
            this.createSymLink(dir.toLocalFile(0, this.getMonitor()), src, tgt, isDir);
        }
        catch (CoreException e) {
            SymlinkResourceTest.fail((String)"mkLink", (Throwable)e);
        }
    }

    protected void createBug232426Structure(IFileStore rootDir) throws CoreException {
        IFileStore folderA = rootDir.getChild("a");
        IFileStore folderB = rootDir.getChild("b");
        IFileStore folderC = rootDir.getChild("c");
        folderA.mkdir(0, this.getMonitor());
        folderB.mkdir(0, this.getMonitor());
        folderC.mkdir(0, this.getMonitor());
        this.mkLink(folderA, "link", new Path("../b").toOSString(), true);
        this.mkLink(folderB, "linkA", new Path("../a").toOSString(), true);
        this.mkLink(folderB, "linkC", new Path("../c").toOSString(), true);
        this.mkLink(folderC, "link", new Path("../b").toOSString(), true);
    }

    protected void createBug358830Structure(IFileStore rootDir) throws CoreException {
        IFileStore folderA = rootDir.getChild("a");
        folderA.mkdir(0, this.getMonitor());
        this.mkLink(folderA, "link", new Path("../").toOSString(), true);
    }

    public void testBug232426() throws Exception {
        if (SymlinkResourceTest.isWindowsVistaOrHigher()) {
            return;
        }
        if ((EFS.getLocalFileSystem().attributes() & 0x20) == 0) {
            return;
        }
        final IProject project = this.projects[0];
        SymlinkResourceTest.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.delete(8, SymlinkResourceTest.this.getMonitor());
                project.create(null);
                SymlinkResourceTest.this.createBug232426Structure(EFS.getStore((URI)project.getLocationURI()));
                project.open(128, SymlinkResourceTest.this.getMonitor());
            }
        }, null);
        this.waitForRefresh();
        project.accept(new IResourceVisitor(){
            int resourceCount = 0;

            public boolean visit(IResource resource) {
                ++this.resourceCount;
                SymlinkResourceTest.assertTrue((this.resourceCount <= 8 ? 1 : 0) != 0);
                return true;
            }
        });
    }

    public void testBug358830() throws Exception {
        if (SymlinkResourceTest.isWindowsVistaOrHigher()) {
            return;
        }
        if ((EFS.getLocalFileSystem().attributes() & 0x20) == 0) {
            return;
        }
        final IProject project = this.projects[0];
        SymlinkResourceTest.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.delete(8, SymlinkResourceTest.this.getMonitor());
                project.create(null);
                SymlinkResourceTest.this.createBug358830Structure(EFS.getStore((URI)project.getLocationURI()));
                project.open(128, SymlinkResourceTest.this.getMonitor());
            }
        }, null);
        this.waitForRefresh();
        final int[] resourceCount = new int[1];
        project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) {
                resourceCount[0] = resourceCount[0] + 1;
                return true;
            }
        });
        SymlinkResourceTest.assertEquals((int)3, (int)resourceCount[0]);
    }
}

