/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.propertytester;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestSuite;
import org.eclipse.core.internal.propertytester.FilePropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.tests.resources.ResourceTest;

public class FilePropertyTesterTest
extends ResourceTest {
    private static final String CONTENT_TYPE_ID = "contentTypeId";
    private static final String IS_KIND_OF = "kindOf";
    private static final String USE_FILENAME_ONLY = "useFilenameOnly";
    private FilePropertyTester tester = null;
    private IProject project = null;
    private IProgressMonitor monitor = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.monitor = new NullProgressMonitor();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project = root.getProject("project1");
        this.project.create(this.monitor);
        this.project.open(this.monitor);
        this.tester = new FilePropertyTester();
    }

    protected void tearDown() throws Exception {
        this.project.delete(true, this.monitor);
        super.tearDown();
    }

    public static TestSuite suite() {
        return new TestSuite(FilePropertyTesterTest.class);
    }

    public void testNonExistingTextFile() throws Throwable {
        String expected = "org.eclipse.core.runtime.text";
        IFile target = this.project.getFile("tmp.txt");
        boolean ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[0], (Object)expected);
        FilePropertyTesterTest.assertFalse((String)"1.0", (boolean)ret);
        ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[]{IS_KIND_OF}, (Object)expected);
        FilePropertyTesterTest.assertFalse((String)"1.1", (boolean)ret);
        ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[]{USE_FILENAME_ONLY}, (Object)expected);
        FilePropertyTesterTest.assertTrue((String)"1.2", (boolean)ret);
        ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[]{IS_KIND_OF, USE_FILENAME_ONLY}, (Object)expected);
        FilePropertyTesterTest.assertTrue((String)"1.3", (boolean)ret);
    }

    public void testExistingTextFile() throws Throwable {
        String expected = "org.eclipse.core.runtime.text";
        IFile target = this.project.getFile("tmp.txt");
        target.create(this.getRandomContents(), true, this.getMonitor());
        boolean ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[0], (Object)expected);
        FilePropertyTesterTest.assertTrue((String)"1.0", (boolean)ret);
        ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[]{IS_KIND_OF}, (Object)expected);
        FilePropertyTesterTest.assertTrue((String)"1.1", (boolean)ret);
        ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[]{USE_FILENAME_ONLY}, (Object)expected);
        FilePropertyTesterTest.assertTrue((String)"1.2", (boolean)ret);
        ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[]{IS_KIND_OF, USE_FILENAME_ONLY}, (Object)expected);
        FilePropertyTesterTest.assertTrue((String)"1.3", (boolean)ret);
    }

    public void testNonExistingNsRootElementFile() throws Throwable {
        String expectedBase = "org.eclipse.core.runtime.xml";
        String expectedExact = "org.eclipse.core.tests.resources.ns-root-element";
        IFile target = this.project.getFile("tmp.xml");
        boolean ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[0], (Object)expectedExact);
        FilePropertyTesterTest.assertFalse((String)"1.0", (boolean)ret);
        ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[]{IS_KIND_OF}, (Object)expectedBase);
        FilePropertyTesterTest.assertFalse((String)"1.1", (boolean)ret);
        ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[]{USE_FILENAME_ONLY}, (Object)expectedBase);
        FilePropertyTesterTest.assertTrue((String)"1.2", (boolean)ret);
        ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[]{IS_KIND_OF, USE_FILENAME_ONLY}, (Object)expectedBase);
        FilePropertyTesterTest.assertTrue((String)"1.3", (boolean)ret);
    }

    public void testExistingNsRootElementFile() throws Throwable {
        String expectedBase = "org.eclipse.core.runtime.xml";
        String expectedExact = "org.eclipse.core.tests.resources.ns-root-element";
        IFile target = this.project.getFile("tmp.xml");
        byte[] bytes = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><prefix:rootElement1 xmlns:prefix='urn:eclipse.core.runtime.ns1'/>".getBytes("UTF-8");
        target.create((InputStream)new ByteArrayInputStream(bytes), true, this.getMonitor());
        boolean ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[0], (Object)expectedExact);
        FilePropertyTesterTest.assertTrue((String)"1.0", (boolean)ret);
        ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[]{IS_KIND_OF}, (Object)expectedBase);
        FilePropertyTesterTest.assertTrue((String)"1.1", (boolean)ret);
        ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[]{USE_FILENAME_ONLY}, (Object)expectedBase);
        FilePropertyTesterTest.assertTrue((String)"1.2", (boolean)ret);
        ret = this.tester.test((Object)target, CONTENT_TYPE_ID, (Object[])new String[]{IS_KIND_OF, USE_FILENAME_ONLY}, (Object)expectedBase);
        FilePropertyTesterTest.assertTrue((String)"1.3", (boolean)ret);
    }
}

