/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.BuildConfiguration;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public class ProjectReferencesTest
extends ResourceTest {
    private IProject project0;
    private IProject project1;
    private IProject project2;
    private IProject project3;
    private IBuildConfiguration project0v0;
    private IBuildConfiguration project0v1;
    private IBuildConfiguration project1v0;
    private IBuildConfiguration project1v1;
    private IBuildConfiguration project2v0;
    private IBuildConfiguration project3v0;
    private IBuildConfiguration project3v1;
    private String bc0 = "Variant0";
    private String bc1 = "Variant1";
    private String nonExistentBC = "foo";

    public static Test suite() {
        return new TestSuite(ProjectReferencesTest.class);
    }

    public ProjectReferencesTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.project0 = ProjectReferencesTest.getWorkspace().getRoot().getProject("ProjectReferencesTest_p0");
        this.project1 = ProjectReferencesTest.getWorkspace().getRoot().getProject("ProjectReferencesTest_p1");
        this.project2 = ProjectReferencesTest.getWorkspace().getRoot().getProject("ProjectReferencesTest_p2");
        this.project3 = ProjectReferencesTest.getWorkspace().getRoot().getProject("ProjectReferencesTest_p3");
        this.ensureExistsInWorkspace((IResource[])new IProject[]{this.project0, this.project1, this.project2, this.project3}, true);
        this.setUpVariants(this.project0);
        this.setUpVariants(this.project1);
        this.setUpVariants(this.project2);
        this.setUpVariants(this.project3);
        this.project0v0 = new BuildConfiguration(this.project0, this.bc0);
        this.project0v1 = new BuildConfiguration(this.project0, this.bc1);
        this.project1v0 = new BuildConfiguration(this.project1, this.bc0);
        this.project1v1 = new BuildConfiguration(this.project1, this.bc1);
        this.project2v0 = new BuildConfiguration(this.project2, this.bc0);
        this.project3v0 = new BuildConfiguration(this.project3, this.bc0);
        this.project3v1 = new BuildConfiguration(this.project3, this.bc1);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.project0.delete(true, null);
        this.project1.delete(true, null);
        this.project2.delete(true, null);
        this.project3.delete(true, null);
    }

    private IBuildConfiguration getRef(IProject project) {
        return new BuildConfiguration(project, null);
    }

    private void setUpVariants(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        desc.setBuildConfigs(new String[]{this.bc0, this.bc1});
        project.setDescription(desc, this.getMonitor());
    }

    public void testAddReferencesToNonExistantConfigs() throws CoreException {
        IProjectDescription desc = this.project0.getDescription();
        ProjectReferencesTest.assertFalse((String)"1.0", (boolean)this.project0.hasBuildConfig(this.nonExistentBC));
        desc.setBuildConfigReferences(this.nonExistentBC, new IBuildConfiguration[]{this.project1v0});
        this.project0.setDescription(desc, this.getMonitor());
        ProjectReferencesTest.assertFalse((String)"2.0", (boolean)this.project0.hasBuildConfig(this.nonExistentBC));
        this.assertEquals("3.1", new IBuildConfiguration[0], desc.getBuildConfigReferences(this.nonExistentBC));
        try {
            this.project0.getReferencedBuildConfigs(this.nonExistentBC, true);
            ProjectReferencesTest.fail((String)"3.2");
        }
        catch (CoreException coreException) {}
    }

    public void testChangingBuildConfigurations() throws CoreException {
        IProjectDescription desc = this.project0.getDescription();
        Object[] refs = new IBuildConfiguration[]{this.project0v1, this.project1v0};
        Object[] refs2 = new IBuildConfiguration[]{this.project1v1, this.project1v0};
        desc.setBuildConfigReferences(this.project0v0.getName(), (IBuildConfiguration[])refs);
        desc.setBuildConfigReferences(this.project0v1.getName(), (IBuildConfiguration[])refs2);
        this.project0.setDescription(desc, this.getMonitor());
        desc = this.project0.getDescription();
        this.assertEquals("1.0", refs, desc.getBuildConfigReferences(this.project0v0.getName()));
        this.assertEquals("1.1", refs2, desc.getBuildConfigReferences(this.project0v1.getName()));
        desc.setBuildConfigs(new String[]{this.project0v0.getName(), this.project0v1.getName()});
        this.project0.setDescription(desc, this.getMonitor());
        desc = this.project0.getDescription();
        this.assertEquals("2.0", refs, desc.getBuildConfigReferences(this.project0v0.getName()));
        this.assertEquals("2.1", refs2, desc.getBuildConfigReferences(this.project0v1.getName()));
        desc.setBuildConfigs(new String[]{this.project0v0.getName()});
        this.project0.setDescription(desc, this.getMonitor());
        desc = this.project0.getDescription();
        this.assertEquals("3.0", refs, desc.getBuildConfigReferences(this.project0v0.getName()));
        this.assertEquals("3.1", new IBuildConfiguration[0], desc.getBuildConfigReferences(this.project0v1.getName()));
        desc.setBuildConfigs(new String[]{this.project0v0.getName()});
        this.project0.setDescription(desc, this.getMonitor());
        desc = this.project0.getDescription();
        this.assertEquals("4.0", refs, desc.getBuildConfigReferences(this.project0v0.getName()));
        this.assertEquals("4.1", new IBuildConfiguration[0], desc.getBuildConfigReferences(this.project0v1.getName()));
    }

    public void testMixedProjectAndBuildConfigRefs() throws CoreException {
        IProjectDescription desc = this.project0.getDescription();
        desc.setDynamicReferences(new IProject[]{this.project1, this.project3});
        this.project0.setDescription(desc, this.getMonitor());
        desc = this.project0.getDescription();
        this.assertEquals("1.1", new IProject[]{this.project1, this.project3}, desc.getDynamicReferences());
        this.assertEquals("1.2", new IBuildConfiguration[0], desc.getBuildConfigReferences(this.project0v0.getName()));
        this.assertEquals("1.3", new IBuildConfiguration[0], desc.getBuildConfigReferences(this.project0v1.getName()));
        this.assertEquals("1.4", new IBuildConfiguration[]{this.project1.getActiveBuildConfig(), this.project3.getActiveBuildConfig()}, this.project0.getReferencedBuildConfigs(this.project0v0.getName(), false));
        this.assertEquals("1.5", new IBuildConfiguration[]{this.project1.getActiveBuildConfig(), this.project3.getActiveBuildConfig()}, this.project0.getReferencedBuildConfigs(this.project0v1.getName(), false));
        desc.setBuildConfigReferences(this.project0v0.getName(), new IBuildConfiguration[]{this.project3v1, this.project2v0, this.project1v0});
        this.project0.setDescription(desc, this.getMonitor());
        desc = this.project0.getDescription();
        this.assertEquals("2.1", new IProject[]{this.project1, this.project3}, desc.getDynamicReferences());
        this.assertEquals("2.2", new IBuildConfiguration[]{this.project3v1, this.project2v0, this.project1v0}, desc.getBuildConfigReferences(this.project0v0.getName()));
        this.assertEquals("2.3", new IBuildConfiguration[]{this.project3v1, this.project2v0, this.project1v0, this.project3v0}, this.project0.getReferencedBuildConfigs(this.project0v0.getName(), false));
        this.assertEquals("2.4", new IBuildConfiguration[]{this.project1.getActiveBuildConfig(), this.project3.getActiveBuildConfig()}, this.project0.getReferencedBuildConfigs(this.project0v1.getName(), false));
    }

    public void testSetAndGetProjectReferences() throws CoreException {
        IProjectDescription desc = this.project0.getDescription();
        desc.setReferencedProjects(new IProject[]{this.project3, this.project1});
        desc.setDynamicReferences(new IProject[]{this.project1, this.project2});
        this.project0.setDescription(desc, this.getMonitor());
        desc = this.project1.getDescription();
        desc.setReferencedProjects(new IProject[]{this.project0});
        desc.setDynamicReferences(new IProject[0]);
        this.project1.setDescription(desc, this.getMonitor());
        desc = this.project2.getDescription();
        desc.setReferencedProjects(new IProject[0]);
        desc.setDynamicReferences(new IProject[0]);
        this.project2.setDescription(desc, this.getMonitor());
        desc = this.project3.getDescription();
        desc.setReferencedProjects(new IProject[0]);
        desc.setDynamicReferences(new IProject[]{this.project0});
        this.project3.setDescription(desc, this.getMonitor());
        desc = this.project0.getDescription();
        this.assertEquals("1.0", new IProject[]{this.project3, this.project1}, desc.getReferencedProjects());
        this.assertEquals("1.1", new IProject[]{this.project1, this.project2}, desc.getDynamicReferences());
        this.assertEquals("1.3", new IBuildConfiguration[0], desc.getBuildConfigReferences(this.bc0));
        this.assertEquals("2.0", new IProject[]{this.project3, this.project1, this.project2}, this.project0.getReferencedProjects());
        this.assertEquals("2.1", new IProject[]{this.project1, this.project3}, this.project0.getReferencingProjects());
        this.assertEquals("2.2", new IBuildConfiguration[]{this.project3v0, this.project1v0, this.project2v0}, this.project0.getReferencedBuildConfigs(this.project0v0.getName(), true));
    }

    public void testSetAndGetProjectConfigReferences() throws CoreException {
        IProjectDescription desc = this.project0.getDescription();
        desc.setReferencedProjects(new IProject[]{this.project1});
        desc.setDynamicReferences(new IProject[]{this.project3});
        desc.setBuildConfigReferences(this.bc0, new IBuildConfiguration[]{this.project2v0, this.project1v0});
        desc.setBuildConfigReferences(this.bc1, new IBuildConfiguration[]{this.project2v0});
        this.project0.setDescription(desc, this.getMonitor());
        desc = this.project1.getDescription();
        desc.setReferencedProjects(new IProject[]{this.project0});
        desc.setBuildConfigReferences(this.bc0, new IBuildConfiguration[]{this.project0v1});
        desc.setBuildConfigReferences(this.bc1, new IBuildConfiguration[0]);
        this.project1.setDescription(desc, this.getMonitor());
        desc = this.project3.getDescription();
        desc.setBuildConfigReferences(this.bc0, new IBuildConfiguration[]{this.project0v1});
        desc.setBuildConfigReferences(this.bc1, new IBuildConfiguration[0]);
        this.project3.setDescription(desc, this.getMonitor());
        desc = this.project0.getDescription();
        this.assertEquals("1.0", new IProject[]{this.project1}, desc.getReferencedProjects());
        this.assertEquals("1.1", new IProject[]{this.project3}, desc.getDynamicReferences());
        this.assertEquals("1.3", new IBuildConfiguration[]{this.project2v0, this.project1v0}, desc.getBuildConfigReferences(this.bc0));
        this.assertEquals("1.5", new IBuildConfiguration[]{this.project2v0}, desc.getBuildConfigReferences(this.bc1));
        this.assertEquals("2.0", new IProject[]{this.project2, this.project1, this.project3}, this.project0.getReferencedProjects());
        this.assertEquals("2.1", new IProject[]{this.project1, this.project3}, this.project0.getReferencingProjects());
        this.assertEquals("2.2", new IBuildConfiguration[]{this.project2v0, this.project1v0, this.project3.getActiveBuildConfig()}, this.project0.getReferencedBuildConfigs(this.project0v0.getName(), true));
        this.assertEquals("2.3", new IBuildConfiguration[]{this.project2v0, this.project1.getActiveBuildConfig(), this.project3.getActiveBuildConfig()}, this.project0.getReferencedBuildConfigs(this.project0v1.getName(), true));
    }

    public void testReferencesToActiveConfigs() throws CoreException {
        IProjectDescription desc = this.project0.getDescription();
        desc.setBuildConfigReferences(this.bc0, new IBuildConfiguration[]{this.getRef(this.project1)});
        this.project0.setDescription(desc, this.getMonitor());
        this.assertEquals("1.0", new IBuildConfiguration[]{this.getRef(this.project1)}, desc.getBuildConfigReferences(this.bc0));
        this.assertEquals("1.1", new IBuildConfiguration[]{this.project1v0}, this.project0.getReferencedBuildConfigs(this.project0v0.getName(), true));
    }
}

