/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.CancelingProgressMonitor;
import org.eclipse.core.tests.harness.TestBarrier;
import org.eclipse.core.tests.internal.resources.TestWorkspaceJob;
import org.eclipse.core.tests.resources.ResourceTest;

public class WorkspaceConcurrencyTest
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(WorkspaceConcurrencyTest.class);
    }

    public WorkspaceConcurrencyTest() {
        super("");
    }

    public WorkspaceConcurrencyTest(String name) {
        super(name);
    }

    private void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void testEndRuleInWorkspaceOperation() {
        try {
            final IProject project = WorkspaceConcurrencyTest.getWorkspace().getRoot().getProject("testEndRuleInWorkspaceOperation");
            WorkspaceConcurrencyTest.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    Job.getJobManager().endRule((ISchedulingRule)project);
                }
            }, (ISchedulingRule)project, 0, this.getMonitor());
            WorkspaceConcurrencyTest.fail((String)"1.0");
        }
        catch (CoreException e) {
            WorkspaceConcurrencyTest.fail((String)"1.99", (Throwable)e);
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testCancelOnBlocked() {
        this.ensureExistsInWorkspace((IResource)WorkspaceConcurrencyTest.getWorkspace().getRoot().getProject("P1"), true);
        final int[] barrier = new int[1];
        final Throwable[] error = new Throwable[1];
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                barrier[0] = 1;
                try {
                    TestBarrier.waitForStatus((int[])barrier, (int)5);
                }
                catch (Throwable e) {
                    error[0] = e;
                }
            }
        };
        WorkspaceConcurrencyTest.getWorkspace().addResourceChangeListener(listener);
        try {
            TestWorkspaceJob testJob = new TestWorkspaceJob(10L);
            testJob.setTouch(true);
            testJob.setRule((ISchedulingRule)WorkspaceConcurrencyTest.getWorkspace().getRoot());
            testJob.schedule();
            TestBarrier.waitForStatus((int[])barrier, (int)1);
            final boolean[] canceled = new boolean[1];
            Thread t2 = new Thread(new Runnable(){

                public void run() {
                    try {
                        WorkspaceConcurrencyTest.getWorkspace().run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) {
                            }
                        }, (IProgressMonitor)new CancelingProgressMonitor());
                    }
                    catch (CoreException e) {
                        WorkspaceConcurrencyTest.fail((String)"1.99", (Throwable)e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        canceled[0] = true;
                    }
                }
            });
            t2.start();
            try {
                t2.join();
            }
            catch (InterruptedException e) {
                WorkspaceConcurrencyTest.fail((String)"1.88", (Throwable)e);
            }
            WorkspaceConcurrencyTest.assertTrue((String)"2.0", (boolean)canceled[0]);
            barrier[0] = 5;
            try {
                testJob.join();
            }
            catch (InterruptedException interruptedException) {}
            if (error[0] != null) {
                WorkspaceConcurrencyTest.fail((String)"3.0", (Throwable)error[0]);
            }
        }
        finally {
            WorkspaceConcurrencyTest.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    public void testRunnableWithOtherRule() {
        ISchedulingRule rule = new ISchedulingRule(){

            public boolean contains(ISchedulingRule rule) {
                return rule == this;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this;
            }
        };
        try {
            WorkspaceConcurrencyTest.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                }
            }, rule, 0, this.getMonitor());
        }
        catch (CoreException e) {
            WorkspaceConcurrencyTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testRunWhileBuilding() {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject touch = workspace.getRoot().getProject("ToTouch");
        IProject rule = workspace.getRoot().getProject("jobThree");
        final IFile ruleFile = rule.getFile("somefile.txt");
        this.ensureExistsInWorkspace((IResource)rule, true);
        this.ensureExistsInWorkspace((IResource)touch, true);
        this.ensureExistsInWorkspace((IResource)ruleFile, true);
        final Throwable[] failure = new Throwable[1];
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    touch.touch(null);
                }
                catch (CoreException e) {
                    failure[0] = e;
                }
                catch (RuntimeException e) {
                    failure[0] = e;
                }
            }
        };
        workspace.addResourceChangeListener(listener, 16);
        try {
            final int[] status = new int[3];
            Job jobOne = new Job("jobOne"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        workspace.run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                workspace.build(10, monitor);
                                status[0] = 3;
                                TestBarrier.waitForStatus((int[])status, (int)0, (int)4);
                            }
                        }, null);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            jobOne.schedule();
            TestBarrier.waitForStatus((int[])status, (int)0, (int)3);
            Job jobTwo = new Job("jobTwo"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        workspace.run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) {
                                status[1] = 3;
                                status[0] = 4;
                                TestBarrier.waitForStatus((int[])status, (int)1, (int)4);
                            }
                        }, null, 0, null);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            jobTwo.schedule();
            Job jobThree = new Job("jobThree"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        workspace.run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                status[2] = 3;
                                status[1] = 4;
                                ruleFile.touch(null);
                                TestBarrier.waitForStatus((int[])status, (int)2, (int)4);
                            }
                        }, workspace.getRuleFactory().modifyRule((IResource)ruleFile), 0, null);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            jobThree.schedule();
            this.waitForCompletion(jobTwo);
            status[2] = 4;
            this.waitForCompletion(jobThree);
            IStatus result = jobOne.getResult();
            if (!result.isOK()) {
                WorkspaceConcurrencyTest.fail((String)"1.0", (Throwable)new CoreException(result));
            }
            if (!(result = jobTwo.getResult()).isOK()) {
                WorkspaceConcurrencyTest.fail((String)"1.1", (Throwable)new CoreException(result));
            }
            if (!(result = jobThree.getResult()).isOK()) {
                WorkspaceConcurrencyTest.fail((String)"1.2", (Throwable)new CoreException(result));
            }
            if (failure[0] != null) {
                WorkspaceConcurrencyTest.fail((String)"1.3", (Throwable)failure[0]);
            }
        }
        finally {
            workspace.removeResourceChangeListener(listener);
        }
    }

    private void waitForCompletion(Job job) {
        int i = 0;
        while (job.getState() != 0) {
            this.sleep(100L);
            WorkspaceConcurrencyTest.assertTrue((String)"Timeout waiting for job to complete", (i++ < 1000 ? 1 : 0) != 0);
        }
    }
}

