/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.watson.DefaultElementComparator;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeReader;
import org.eclipse.core.internal.watson.ElementTreeWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.watson.ElementTreeSerializationTest;
import org.eclipse.core.tests.internal.watson.TestUtil;

public class DeltaChainFlatteningTest
extends ElementTreeSerializationTest {
    protected ElementTree[] fDeltaChain;
    protected ElementTree[] fRefriedDeltaChain;

    public DeltaChainFlatteningTest() {
        super(null);
    }

    public DeltaChainFlatteningTest(String name) {
        super(name);
    }

    public Object doRead(ElementTreeReader reader, DataInputStream input) throws IOException {
        return reader.readDeltaChain((DataInput)input);
    }

    public void doTest(IPath path, int depth) {
        this.fSubtreePath = path;
        this.fDepth = depth;
        this.fDeltaChain = TestUtil.doRoutineOperations(this.fTree, project1);
        TestUtil.scramble(this.fDeltaChain);
        ElementTree[] refried = (ElementTree[])this.doPipeTest();
        int j = 0;
        while (j < refried.length) {
            TestUtil.assertEqualTrees("Same after delta chain serialize", this.fDeltaChain[j], refried[j], this.fSubtreePath, this.fDepth);
            ++j;
        }
    }

    public void doWrite(ElementTreeWriter writer, DataOutputStream output) throws IOException {
        writer.writeDeltaChain(this.fDeltaChain, this.fSubtreePath, this.fDepth, (DataOutput)output, DefaultElementComparator.getComparator());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fTree = TestUtil.createTestElementTree();
        this.fDeltaChain = TestUtil.doManyRoutineOperations(this.fTree, project1);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(DeltaChainFlatteningTest.class);
        return suite;
    }

    public void test0() {
        this.doExhaustiveTests();
    }
}

