/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeReader;
import org.eclipse.core.internal.watson.ElementTreeWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.watson.ElementTreeSerializationTest;
import org.eclipse.core.tests.internal.watson.TestUtil;

public class TreeFlatteningTest
extends ElementTreeSerializationTest {
    public TreeFlatteningTest() {
    }

    public TreeFlatteningTest(String name) {
        super(name);
    }

    public Object doRead(ElementTreeReader reader, DataInputStream input) throws IOException {
        return reader.readTree((DataInput)input);
    }

    public void doTest(IPath path, int depth) {
        this.fTree = TestUtil.createTestElementTree();
        this.fSubtreePath = path;
        this.fDepth = depth;
        ElementTree newTree = (ElementTree)this.doPipeTest();
        TestUtil.assertEqualTrees(String.valueOf(this.getClass().toString()) + "test0", this.fTree, newTree, this.fSubtreePath, this.fDepth);
    }

    public void doWrite(ElementTreeWriter writer, DataOutputStream output) throws IOException {
        writer.writeTree(this.fTree, this.fSubtreePath, this.fDepth, (DataOutput)output);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fTree = TestUtil.createTestElementTree();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TreeFlatteningTest.class);
        return suite;
    }

    public void test0() {
        this.fTree = TestUtil.createTestElementTree();
        ElementTree newTree = (ElementTree)this.doFileTest();
        TestUtil.assertEqualTrees(String.valueOf(this.getClass().toString()) + "test0", this.fTree, newTree);
    }

    public void testExhaustive() {
        this.doExhaustiveTests();
    }

    public void testNullData() {
        this.fTree = TestUtil.createTestElementTree();
        this.fTree = this.fTree.newEmptyDelta();
        this.fTree.setElementData(solution, null);
        this.fTree.setElementData(folder2, null);
        this.fTree.immutable();
        ElementTree newTree = (ElementTree)this.doPipeTest();
        TestUtil.assertEqualTrees(String.valueOf(this.getClass().toString()) + "test0", this.fTree, newTree);
    }

    public void testWriteRoot() {
        this.fTree = TestUtil.createTestElementTree();
        this.fSubtreePath = Path.ROOT;
        ElementTree newTree = (ElementTree)this.doPipeTest();
        TestUtil.assertEqualTrees(String.valueOf(this.getClass().toString()) + "test0", this.fTree, newTree, this.fSubtreePath);
    }
}

