/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;

public class DeltaDebugListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        try {
            System.out.println();
            this.visitingProcess(delta);
        }
        catch (CoreException coreException) {}
    }

    protected boolean visit(IResourceDelta change) {
        System.out.println(((ResourceDelta)change).toDebugString());
        return true;
    }

    protected void visitingProcess(IResourceDelta change) throws CoreException {
        if (!this.visit(change)) {
            return;
        }
        int kind = 7;
        int memberFlags = 3;
        IResourceDelta[] children = change.getAffectedChildren(kind, memberFlags);
        int i = 0;
        while (i < children.length) {
            this.visitingProcess(children[i]);
            ++i;
        }
    }
}

