/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.ResourceTest;

public class ExampleWorkspaceTest
extends ResourceTest {
    public ExampleWorkspaceTest() {
    }

    public ExampleWorkspaceTest(String name) {
        super(name);
    }

    protected IProject getTestProject() {
        return ExampleWorkspaceTest.getWorkspace().getRoot().getProject("testProject");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ExampleWorkspaceTest.class.getName());
        suite.addTest((Test)new ExampleWorkspaceTest("testProjectCreation"));
        suite.addTest((Test)new ExampleWorkspaceTest("testFolderCreation"));
        suite.addTest((Test)new ExampleWorkspaceTest("testFileCreation"));
        suite.addTest((Test)new ExampleWorkspaceTest("testFileInFolderCreation"));
        suite.addTest((Test)new ExampleWorkspaceTest("testSetContents"));
        suite.addTest((Test)new ExampleWorkspaceTest("testFileOverFolder"));
        suite.addTest((Test)new ExampleWorkspaceTest("testFolderOverFile"));
        suite.addTest((Test)new ExampleWorkspaceTest("testFolderDeletion"));
        suite.addTest((Test)new ExampleWorkspaceTest("testFileDeletion"));
        suite.addTest((Test)new ExampleWorkspaceTest("testProjectDeletion"));
        return suite;
    }

    public void testFileCreation() throws Throwable {
        IFile target = this.getTestProject().getFile("testFile");
        target.create(null, true, this.getMonitor());
        ExampleWorkspaceTest.assertTrue((boolean)target.exists());
    }

    public void testFileDeletion() throws Throwable {
        IFile target = this.getTestProject().getFile("testFileForDelete");
        target.create(null, true, this.getMonitor());
        ExampleWorkspaceTest.assertTrue((boolean)target.exists());
        target.delete(true, this.getMonitor());
        ExampleWorkspaceTest.assertTrue((!target.exists() ? 1 : 0) != 0);
    }

    public void testFileInFolderCreation() throws Throwable {
        IFile target = this.getTestProject().getFile((IPath)new Path("testFolder/testFile2"));
        target.create(this.getRandomContents(), true, this.getMonitor());
        ExampleWorkspaceTest.assertTrue((boolean)target.exists());
    }

    public void testFileOverFolder() throws Throwable {
        IFolder existing = this.getTestProject().getFolder("testFolder");
        ExampleWorkspaceTest.assertTrue((boolean)existing.exists());
        IFile target = ExampleWorkspaceTest.getWorkspace().getRoot().getFile(existing.getFullPath());
        try {
            target.create(null, true, this.getMonitor());
        }
        catch (CoreException coreException) {
            ExampleWorkspaceTest.assertTrue((boolean)existing.exists());
            return;
        }
        ExampleWorkspaceTest.fail((String)"Should not be able to create file over folder");
    }

    public void testFolderCreation() throws Throwable {
        IFolder target = this.getTestProject().getFolder("testFolder");
        target.create(true, true, this.getMonitor());
        ExampleWorkspaceTest.assertTrue((boolean)target.exists());
    }

    public void testFolderDeletion() throws Throwable {
        IProject project = this.getTestProject();
        IResource[] before = this.buildResources((IContainer)project, new String[]{"c/", "c/b/", "c/x", "c/b/y", "c/b/z"});
        this.ensureExistsInWorkspace(before, true);
        this.assertExistsInWorkspace(before);
        project.getFolder("c").delete(true, this.getMonitor());
        this.assertDoesNotExistInWorkspace(before);
    }

    public void testFolderOverFile() throws Throwable {
        IFile existing = this.getTestProject().getFile("testFile");
        ExampleWorkspaceTest.assertTrue((boolean)existing.exists());
        IFolder target = ExampleWorkspaceTest.getWorkspace().getRoot().getFolder(existing.getFullPath());
        try {
            target.create(true, true, this.getMonitor());
        }
        catch (CoreException coreException) {
            ExampleWorkspaceTest.assertTrue((boolean)existing.exists());
            return;
        }
        ExampleWorkspaceTest.fail((String)"Should not be able to create folder over a file");
    }

    public void testProjectCreation() throws Throwable {
        IProject target = this.getTestProject();
        target.create(null, this.getMonitor());
        ExampleWorkspaceTest.assertTrue((boolean)target.exists());
        target.open(this.getMonitor());
        ExampleWorkspaceTest.assertTrue((boolean)target.isOpen());
    }

    public void testProjectDeletion() throws Throwable {
        IProject target = this.getTestProject();
        target.delete(true, this.getMonitor());
        ExampleWorkspaceTest.assertTrue((String)"Project Deletion failed", (!target.exists() ? 1 : 0) != 0);
    }

    public void testSetContents() throws Throwable {
        IFile target = this.getTestProject().getFile("testFile");
        String testString = this.getRandomString();
        target.setContents(this.getContents(testString), true, false, this.getMonitor());
        InputStream content = null;
        try {
            content = target.getContents();
            ExampleWorkspaceTest.assertTrue((String)"get not equal set", (boolean)this.compareContent(content, this.getContents(testString)));
        }
        finally {
            content.close();
        }
    }
}

