/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.RegexFileInfoMatcher;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.tests.resources.ResourceTest;

public class FilteredResourceTest
extends ResourceTest {
    private static final String REGEX_FILTER_PROVIDER = "org.eclipse.core.resources.regexFilterMatcher";
    protected String childName = "File.txt";
    protected IProject closedProject;
    protected IFile existingFileInExistingProject;
    protected IFolder existingFolderInExistingFolder;
    protected IFolder existingFolderInExistingProject;
    protected IProject existingProject;
    protected IPath localFile;
    protected IPath localFolder;
    protected IFile nonExistingFileInExistingFolder;
    protected IFile nonExistingFileInExistingProject;
    protected IFile nonExistingFileInOtherExistingProject;
    protected IFolder nonExistingFolderInExistingFolder;
    protected IFolder nonExistingFolderInExistingProject;
    protected IFolder nonExistingFolderInOtherExistingProject;
    protected IFolder nonExistingFolder2InOtherExistingProject;
    protected IProject otherExistingProject;

    public static Test suite() {
        return new TestSuite(FilteredResourceTest.class);
    }

    public FilteredResourceTest() {
    }

    public FilteredResourceTest(String name) {
        super(name);
    }

    protected void doCleanup() throws Exception {
        this.ensureExistsInWorkspace(new IResource[]{this.existingProject, this.otherExistingProject, this.closedProject, this.existingFolderInExistingProject, this.existingFolderInExistingFolder, this.existingFileInExistingProject}, true);
        this.closedProject.close(this.getMonitor());
        this.ensureDoesNotExistInWorkspace(new IResource[]{this.nonExistingFolderInExistingProject, this.nonExistingFolderInExistingFolder, this.nonExistingFolderInOtherExistingProject, this.nonExistingFolder2InOtherExistingProject, this.nonExistingFileInExistingProject, this.nonExistingFileInOtherExistingProject, this.nonExistingFileInExistingFolder});
        this.resolve(this.localFolder).toFile().mkdirs();
        this.createFileInFileSystem(this.resolve(this.localFile), this.getRandomContents());
    }

    protected IPath resolve(IPath path) {
        return path;
    }

    protected URI resolve(URI uri) {
        return uri;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.existingProject = FilteredResourceTest.getWorkspace().getRoot().getProject("ExistingProject");
        this.otherExistingProject = FilteredResourceTest.getWorkspace().getRoot().getProject("OtherExistingProject");
        this.closedProject = FilteredResourceTest.getWorkspace().getRoot().getProject("ClosedProject");
        this.existingFolderInExistingProject = this.existingProject.getFolder("existingFolderInExistingProject");
        this.existingFolderInExistingFolder = this.existingFolderInExistingProject.getFolder("existingFolderInExistingFolder");
        this.nonExistingFolderInExistingProject = this.existingProject.getFolder("nonExistingFolderInExistingProject");
        this.nonExistingFolderInOtherExistingProject = this.otherExistingProject.getFolder("nonExistingFolderInOtherExistingProject");
        this.nonExistingFolder2InOtherExistingProject = this.otherExistingProject.getFolder("nonExistingFolder2InOtherExistingProject");
        this.nonExistingFolderInExistingFolder = this.existingFolderInExistingProject.getFolder("nonExistingFolderInExistingFolder");
        this.existingFileInExistingProject = this.existingProject.getFile("existingFileInExistingProject");
        this.nonExistingFileInExistingProject = this.existingProject.getFile("nonExistingFileInExistingProject");
        this.nonExistingFileInOtherExistingProject = this.otherExistingProject.getFile("nonExistingFileInOtherExistingProject");
        this.nonExistingFileInExistingFolder = this.existingFolderInExistingProject.getFile("nonExistingFileInExistingFolder");
        this.localFolder = this.getRandomLocation();
        this.localFile = this.localFolder.append(this.childName);
        this.doCleanup();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Workspace.clear((File)this.resolve(this.localFolder).toFile());
    }

    public void testCreateFilterOnFolder() {
        try {
            FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
            this.existingFolderInExistingProject.createFilter(13, matcherDescription, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingProject.getFile("foo");
        IFile bar = this.existingFolderInExistingProject.getFile("bar");
        this.ensureExistsInWorkspace(new IResource[]{foo, bar}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            this.existingProject.close(this.getMonitor());
            this.existingProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.2", (Throwable)e);
        }
        IResourceFilterDescription[] filters = null;
        try {
            filters = this.existingFolderInExistingProject.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.4", (int)filters.length, (int)1);
        FilteredResourceTest.assertEquals((String)"1.5", (String)filters[0].getFileInfoMatcherDescription().getId(), (String)REGEX_FILTER_PROVIDER);
        FilteredResourceTest.assertEquals((String)"1.6", (Object)filters[0].getFileInfoMatcherDescription().getArguments(), (Object)"foo");
        FilteredResourceTest.assertEquals((String)"1.7", (int)filters[0].getType(), (int)13);
        FilteredResourceTest.assertEquals((String)"1.8", (Object)filters[0].getResource(), (Object)this.existingFolderInExistingProject);
        IResource[] members = null;
        try {
            members = this.existingFolderInExistingProject.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.9", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.0", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"2.1", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)members[0].getName(), (String)"foo");
        IWorkspace workspace = this.existingProject.getWorkspace();
        FilteredResourceTest.assertTrue((String)"2.3", (!workspace.validateFiltered((IResource)bar).isOK() ? 1 : 0) != 0);
        FilteredResourceTest.assertTrue((String)"2.4", (boolean)workspace.validateFiltered((IResource)foo).isOK());
    }

    public void testCreateFilterOnProject() {
        try {
            FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
            this.existingProject.createFilter(9, matcherDescription, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFolder foo = this.existingProject.getFolder("foo");
        IFolder bar = this.existingProject.getFolder("bar");
        this.ensureExistsInWorkspace(new IResource[]{foo, bar}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            this.existingProject.close(this.getMonitor());
            this.existingProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.2", (Throwable)e);
        }
        IResourceFilterDescription[] filters = null;
        try {
            filters = this.existingProject.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.4", (int)filters.length, (int)1);
        FilteredResourceTest.assertEquals((String)"1.5", (String)filters[0].getFileInfoMatcherDescription().getId(), (String)REGEX_FILTER_PROVIDER);
        FilteredResourceTest.assertEquals((String)"1.6", (Object)filters[0].getFileInfoMatcherDescription().getArguments(), (Object)"foo");
        FilteredResourceTest.assertEquals((String)"1.7", (int)filters[0].getType(), (int)9);
        FilteredResourceTest.assertEquals((String)"1.8", (Object)filters[0].getResource(), (Object)this.existingProject);
        IResource[] members = null;
        try {
            members = this.existingProject.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.9", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.0", (int)members.length, (int)3);
        int i = 0;
        while (i < members.length) {
            if (members[i].getType() == 2) {
                FilteredResourceTest.assertEquals((String)"2.1", (int)members[i].getType(), (int)2);
                FilteredResourceTest.assertEquals((String)"2.2", (String)members[i].getName(), (String)"foo");
            }
            ++i;
        }
        IWorkspace workspace = this.existingProject.getWorkspace();
        FilteredResourceTest.assertTrue((String)"2.1", (!workspace.validateFiltered((IResource)bar).isOK() ? 1 : 0) != 0);
        FilteredResourceTest.assertTrue((String)"2.2", (boolean)workspace.validateFiltered((IResource)foo).isOK());
    }

    public void testCreateFilterOnLinkedFolder() {
        IPath location = this.getRandomLocation();
        IFolder folder = this.nonExistingFolderInExistingProject;
        try {
            folder.createLink(location, 0, this.getMonitor());
            FilteredResourceTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        try {
            FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
            folder.createFilter(5, matcherDescription, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = folder.getFile("foo");
        IFile bar = folder.getFile("bar");
        this.ensureExistsInWorkspace(new IResource[]{foo, bar}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            this.existingProject.close(this.getMonitor());
            this.existingProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.2", (Throwable)e);
        }
        IResourceFilterDescription[] filters = null;
        try {
            filters = folder.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.4", (int)filters.length, (int)1);
        FilteredResourceTest.assertEquals((String)"1.5", (String)filters[0].getFileInfoMatcherDescription().getId(), (String)REGEX_FILTER_PROVIDER);
        FilteredResourceTest.assertEquals((String)"1.6", (Object)filters[0].getFileInfoMatcherDescription().getArguments(), (Object)"foo");
        FilteredResourceTest.assertEquals((String)"1.7", (int)filters[0].getType(), (int)5);
        FilteredResourceTest.assertEquals((String)"1.8", (Object)filters[0].getResource(), (Object)folder);
        IResource[] members = null;
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.9", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.0", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"2.1", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)members[0].getName(), (String)"foo");
        IWorkspace workspace = this.existingProject.getWorkspace();
        FilteredResourceTest.assertTrue((String)"2.1", (!workspace.validateFiltered((IResource)bar).isOK() ? 1 : 0) != 0);
        FilteredResourceTest.assertTrue((String)"2.2", (boolean)workspace.validateFiltered((IResource)foo).isOK());
    }

    public void testCreateFilterOnLinkedFolderAndTarget() {
        IPath location = this.existingFolderInExistingFolder.getLocation();
        IFolder folder = this.nonExistingFolderInExistingProject;
        try {
            folder.createLink(location, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"0.5");
        }
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.cpp");
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.h");
        IResourceFilterDescription filterDescription2 = null;
        try {
            folder.createFilter(6, matcherDescription1, 0, this.getMonitor());
            filterDescription2 = this.existingFolderInExistingFolder.createFilter(6, matcherDescription2, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IResource[] members = null;
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.2", (int)members.length, (int)0);
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.4", (int)members.length, (int)0);
        IFile newFile = this.existingFolderInExistingFolder.getFile("foo.cpp");
        try {
            FilteredResourceTest.assertTrue((String)"1.5", (boolean)newFile.getLocation().toFile().createNewFile());
        }
        catch (IOException e1) {
            FilteredResourceTest.fail((String)"1.6", (Throwable)e1);
        }
        try {
            this.existingFolderInExistingFolder.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.7", (Throwable)e);
        }
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.8", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.9", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"2.0", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.1", (String)members[0].getName(), (String)"foo.cpp");
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.2", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.3", (int)members.length, (int)0);
        newFile = this.existingFolderInExistingFolder.getFile("foo.h");
        try {
            FilteredResourceTest.assertTrue((String)"2.5", (boolean)newFile.getLocation().toFile().createNewFile());
        }
        catch (IOException e1) {
            FilteredResourceTest.fail((String)"2.6", (Throwable)e1);
        }
        try {
            this.existingFolderInExistingFolder.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.7", (Throwable)e);
        }
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.8", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.9", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"3.0", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"3.1", (String)members[0].getName(), (String)"foo.cpp");
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"3.2", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"3.3", (int)members.length, (int)0);
        try {
            folder.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"3.4", (Throwable)e);
        }
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"3.8", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"3.9", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"4.0", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"4.1", (String)members[0].getName(), (String)"foo.cpp");
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"4.2", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"4.3", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"4.4", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"4.5", (String)members[0].getName(), (String)"foo.h");
        newFile = this.existingFolderInExistingFolder.getFile("foo.text");
        try {
            FilteredResourceTest.assertTrue((String)"5.5", (boolean)newFile.getLocation().toFile().createNewFile());
        }
        catch (IOException e1) {
            FilteredResourceTest.fail((String)"5.6", (Throwable)e1);
        }
        try {
            this.existingFolderInExistingFolder.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"5.7", (Throwable)e);
        }
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"5.8", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"5.9", (int)members.length, (int)2);
        FilteredResourceTest.assertEquals((String)"6.0", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"6.1", (String)members[0].getName(), (String)"foo.cpp");
        FilteredResourceTest.assertEquals((String)"6.2", (int)members[1].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"6.3", (String)members[1].getName(), (String)"foo.text");
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"6.4", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"6.5", (int)members.length, (int)2);
        FilteredResourceTest.assertEquals((String)"6.6", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"6.7", (String)members[0].getName(), (String)"foo.h");
        FilteredResourceTest.assertEquals((String)"6.8", (int)members[1].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"6.9", (String)members[1].getName(), (String)"foo.text");
        try {
            newFile.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"7.0", (Throwable)e);
        }
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"7.1", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"7.2", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"7.3", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"7.4", (String)members[0].getName(), (String)"foo.cpp");
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"7.5", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"7.6", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"7.7", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"7.8", (String)members[0].getName(), (String)"foo.h");
        try {
            filterDescription2.delete(0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"8.0");
        }
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"8.1", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"8.2", (int)members.length, (int)2);
        FilteredResourceTest.assertEquals((String)"8.3", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"8.4", (String)members[0].getName(), (String)"foo.cpp");
        FilteredResourceTest.assertEquals((String)"8.4.1", (int)members[1].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"8.4.2", (String)members[1].getName(), (String)"foo.h");
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"8.5", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"8.6", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"8.7", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"8.8", (String)members[0].getName(), (String)"foo.h");
        try {
            this.existingFolderInExistingFolder.createFilter(6, matcherDescription2, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"9.0");
        }
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"9.1", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"9.2", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"9.3", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"9.4", (String)members[0].getName(), (String)"foo.cpp");
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"9.5", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"9.6", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"9.7", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"9.8", (String)members[0].getName(), (String)"foo.h");
    }

    public void testIResource_isFiltered() {
        IFolder folder = this.existingFolderInExistingProject.getFolder("virtual_folder.txt");
        IFile file = this.existingFolderInExistingProject.getFile("linked_file.txt");
        try {
            folder.create(8192, true, this.getMonitor());
        }
        catch (CoreException e1) {
            FilteredResourceTest.fail((String)"0.79", (Throwable)e1);
        }
        try {
            file.createLink(this.existingFileInExistingProject.getLocation(), 0, this.getMonitor());
        }
        catch (CoreException e1) {
            FilteredResourceTest.fail((String)"0.89", (Throwable)e1);
        }
        FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.txt");
        try {
            this.existingFolderInExistingProject.createFilter(2, matcherDescription, 0, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"0.99", (Throwable)e);
        }
        IWorkspace workspace = this.existingProject.getWorkspace();
        FilteredResourceTest.assertTrue((String)"1.0", (boolean)workspace.validateFiltered((IResource)folder).isOK());
        FilteredResourceTest.assertTrue((String)"1.1", (boolean)workspace.validateFiltered((IResource)file).isOK());
    }

    public void testCreateFilterOnLinkedFolderAndTarget2() {
        IPath location = this.existingFolderInExistingFolder.getLocation();
        IFolder folder = this.nonExistingFolderInExistingProject;
        try {
            folder.createLink(location, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"0.5");
        }
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.h");
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.cpp");
        try {
            folder.createFilter(5, matcherDescription1, 0, this.getMonitor());
            this.existingFolderInExistingFolder.createFilter(5, matcherDescription2, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IResource[] members = null;
        IFile newFile = this.existingFolderInExistingFolder.getFile("foo.cpp");
        try {
            this.create((IResource)newFile, true);
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e1) {
            FilteredResourceTest.fail((String)"1.6", (Throwable)e1);
        }
        FilteredResourceTest.assertEquals((String)"1.9", (int)1, (int)members.length);
        FilteredResourceTest.assertEquals((String)"2.0", (int)1, (int)members[0].getType());
        FilteredResourceTest.assertEquals((String)"2.1", (String)"foo.cpp", (String)members[0].getName());
        newFile = folder.getFile("foo.h");
        try {
            this.create((IResource)newFile, true);
        }
        catch (CoreException e1) {
            FilteredResourceTest.fail((String)"2.6", (Throwable)e1);
        }
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"4.2", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"4.3", (int)1, (int)members.length);
        FilteredResourceTest.assertEquals((String)"4.4", (int)1, (int)members[0].getType());
        FilteredResourceTest.assertEquals((String)"4.5", (String)"foo.h", (String)members[0].getName());
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.8", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.9", (int)1, (int)members.length);
        FilteredResourceTest.assertEquals((String)"3.0", (int)1, (int)members[0].getType());
        FilteredResourceTest.assertEquals((String)"3.1", (String)"foo.cpp", (String)members[0].getName());
        try {
            this.existingFolderInExistingFolder.refreshLocal(2, this.getMonitor());
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.8", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.9", (int)1, (int)members.length);
        FilteredResourceTest.assertEquals((String)"3.0", (int)1, (int)members[0].getType());
        FilteredResourceTest.assertEquals((String)"3.1", (String)"foo.cpp", (String)members[0].getName());
        try {
            this.modifyInWorkspace(folder.getFile("foo.h"));
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.8", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.9", (int)1, (int)members.length);
        FilteredResourceTest.assertEquals((String)"3.0", (int)1, (int)members[0].getType());
        FilteredResourceTest.assertEquals((String)"3.1", (String)"foo.cpp", (String)members[0].getName());
    }

    public void testCreateFilterOnLinkedFolderWithAlias() {
        ResourceInfo ri;
        IProject project = this.otherExistingProject;
        IPath parentLoc = this.existingFolderInExistingProject.getLocation();
        IPath childLoc = this.existingFolderInExistingFolder.getLocation();
        IFolder folder1 = this.nonExistingFolderInOtherExistingProject;
        IFolder folder2 = this.nonExistingFolder2InOtherExistingProject;
        FilteredResourceTest.assertTrue((String)"0.1", (!folder1.exists() ? 1 : 0) != 0);
        FilteredResourceTest.assertTrue((String)"0.2", (!folder2.exists() ? 1 : 0) != 0);
        FilteredResourceTest.assertTrue((String)"0.3", (boolean)parentLoc.isPrefixOf(childLoc));
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*");
        IResourceFilterDescription filterDescription1 = null;
        try {
            filterDescription1 = folder1.createFilter(10, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"0.5", (Throwable)e);
        }
        try {
            folder1.createLink(parentLoc, 0, this.getMonitor());
            folder2.createLink(childLoc, 0, this.getMonitor());
            this.existingProject.close(this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            FilteredResourceTest.assertTrue((String)"12.0", (boolean)folder1.exists());
            FilteredResourceTest.assertTrue((String)"12.2", (boolean)folder2.exists());
            FilteredResourceTest.assertTrue((String)"12.4", (boolean)folder1.isLinked());
            FilteredResourceTest.assertTrue((String)"12.6", (boolean)folder2.isLinked());
            FilteredResourceTest.assertTrue((String)"12.8", (boolean)folder1.getLocation().equals((Object)parentLoc));
            FilteredResourceTest.assertTrue((String)"12.10", (boolean)folder2.getLocation().equals((Object)childLoc));
            FilteredResourceTest.assertTrue((String)"12.12", (folder1.members().length == 0 ? 1 : 0) != 0);
            FilteredResourceTest.assertTrue((String)"12.14", (folder2.members().length == 0 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"12.20", (Throwable)e);
        }
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        try {
            try {
                workspace.prepareOperation((ISchedulingRule)project, this.getMonitor());
                workspace.beginOperation(true);
                ri = ((Resource)project).getResourceInfo(false, true);
                ri.clear(16);
            }
            finally {
                workspace.endOperation((ISchedulingRule)project, true, this.getMonitor());
            }
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.90", (Throwable)e);
        }
        try {
            project.close(this.getMonitor());
            FilteredResourceTest.assertTrue((String)"3.1", (!project.isOpen() ? 1 : 0) != 0);
            this.createFileInFileSystem(childLoc.append("foo"));
            project.open(0, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            FilteredResourceTest.assertTrue((String)"22.0", (boolean)folder1.exists());
            FilteredResourceTest.assertTrue((String)"22.2", (boolean)folder2.exists());
            FilteredResourceTest.assertTrue((String)"22.4", (boolean)folder1.isLinked());
            FilteredResourceTest.assertTrue((String)"22.6", (boolean)folder2.isLinked());
            FilteredResourceTest.assertTrue((String)"22.8", (boolean)folder1.getLocation().equals((Object)parentLoc));
            FilteredResourceTest.assertTrue((String)"22.10", (boolean)folder2.getLocation().equals((Object)childLoc));
            FilteredResourceTest.assertTrue((String)"22.12", (folder1.members().length == 0 ? 1 : 0) != 0);
            FilteredResourceTest.assertTrue((String)"22.12", (folder2.members().length == 1 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"22.20", (Throwable)e);
        }
        try {
            folder2.createLink(parentLoc, 256, this.getMonitor());
            folder1.createLink(childLoc, 257, this.getMonitor());
            folder2.createFilter(10, matcherDescription1, 0, this.getMonitor());
            filterDescription1.delete(0, this.getMonitor());
            FilteredResourceTest.assertTrue((folder1.getFilters().length == 0 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            try {
                workspace.prepareOperation((ISchedulingRule)project, this.getMonitor());
                workspace.beginOperation(true);
                ri = ((Resource)project).getResourceInfo(false, true);
                ri.clear(16);
            }
            finally {
                workspace.endOperation((ISchedulingRule)project, true, this.getMonitor());
            }
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"4.5", (Throwable)e);
        }
        try {
            project.close(this.getMonitor());
            FilteredResourceTest.assertTrue((String)"3.1", (!project.isOpen() ? 1 : 0) != 0);
            project.open(0, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"5.0", (Throwable)e);
        }
        try {
            FilteredResourceTest.assertTrue((String)"32.0", (boolean)folder1.exists());
            FilteredResourceTest.assertTrue((String)"32.2", (boolean)folder2.exists());
            FilteredResourceTest.assertTrue((String)"32.4", (boolean)folder1.isLinked());
            FilteredResourceTest.assertTrue((String)"32.6", (boolean)folder2.isLinked());
            FilteredResourceTest.assertTrue((String)"32.8", (boolean)folder2.getLocation().equals((Object)parentLoc));
            FilteredResourceTest.assertTrue((String)"32.10", (boolean)folder1.getLocation().equals((Object)childLoc));
            FilteredResourceTest.assertTrue((String)"32.12", (folder1.members().length == 1 ? 1 : 0) != 0);
            FilteredResourceTest.assertTrue((String)"32.12", (folder2.members().length == 0 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"32.20", (Throwable)e);
        }
    }

    public void testCreateFilterOnLinkedFolderWithAlias2() {
        IProject project = this.otherExistingProject;
        IPath parentLoc = this.existingFolderInExistingProject.getLocation();
        IPath childLoc = this.existingFolderInExistingFolder.getLocation();
        IFolder folder1 = this.nonExistingFolderInOtherExistingProject;
        IFolder folder2 = this.nonExistingFolder2InOtherExistingProject;
        FilteredResourceTest.assertTrue((String)"0.1", (!folder1.exists() ? 1 : 0) != 0);
        FilteredResourceTest.assertTrue((String)"0.2", (!folder2.exists() ? 1 : 0) != 0);
        FilteredResourceTest.assertTrue((String)"0.3", (boolean)parentLoc.isPrefixOf(childLoc));
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*");
        IResourceFilterDescription filterDescription1 = null;
        try {
            filterDescription1 = folder1.createFilter(10, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"0.5", (Throwable)e);
        }
        try {
            folder1.createLink(parentLoc, 0, this.getMonitor());
            folder2.createLink(childLoc, 0, this.getMonitor());
            this.existingProject.close(this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            FilteredResourceTest.assertTrue((String)"12.0", (boolean)folder1.exists());
            FilteredResourceTest.assertTrue((String)"12.2", (boolean)folder2.exists());
            FilteredResourceTest.assertTrue((String)"12.4", (boolean)folder1.isLinked());
            FilteredResourceTest.assertTrue((String)"12.6", (boolean)folder2.isLinked());
            FilteredResourceTest.assertTrue((String)"12.8", (boolean)folder1.getLocation().equals((Object)parentLoc));
            FilteredResourceTest.assertTrue((String)"12.10", (boolean)folder2.getLocation().equals((Object)childLoc));
            FilteredResourceTest.assertTrue((String)"12.12", (folder1.members().length == 0 ? 1 : 0) != 0);
            FilteredResourceTest.assertTrue((String)"12.14", (folder2.members().length == 0 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"12.20", (Throwable)e);
        }
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        try {
            try {
                workspace.prepareOperation((ISchedulingRule)project, this.getMonitor());
                workspace.beginOperation(true);
                ResourceInfo ri = ((Resource)project).getResourceInfo(false, true);
                ri.clear(16);
            }
            finally {
                workspace.endOperation((ISchedulingRule)project, true, this.getMonitor());
            }
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.90", (Throwable)e);
        }
        try {
            this.create((IResource)folder2.getFile("foo"), true);
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            FilteredResourceTest.assertTrue((String)"22.0", (boolean)folder1.exists());
            FilteredResourceTest.assertTrue((String)"22.2", (boolean)folder2.exists());
            FilteredResourceTest.assertTrue((String)"22.4", (boolean)folder1.isLinked());
            FilteredResourceTest.assertTrue((String)"22.6", (boolean)folder2.isLinked());
            FilteredResourceTest.assertTrue((String)"22.8", (boolean)folder1.getLocation().equals((Object)parentLoc));
            FilteredResourceTest.assertTrue((String)"22.10", (boolean)folder2.getLocation().equals((Object)childLoc));
            FilteredResourceTest.assertTrue((String)"22.12", (folder1.members().length == 0 ? 1 : 0) != 0);
            FilteredResourceTest.assertTrue((String)"22.12", (folder2.members().length == 1 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"22.20", (Throwable)e);
        }
        try {
            folder2.createLink(parentLoc, 256, this.getMonitor());
            folder1.createLink(childLoc, 257, this.getMonitor());
            folder2.createFilter(10, matcherDescription1, 0, this.getMonitor());
            filterDescription1.delete(0, this.getMonitor());
            FilteredResourceTest.assertTrue((folder1.getFilters().length == 0 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"4.0", (Throwable)e);
        }
        try {
            FilteredResourceTest.assertTrue((String)"32.0", (boolean)folder1.exists());
            FilteredResourceTest.assertTrue((String)"32.2", (boolean)folder2.exists());
            FilteredResourceTest.assertTrue((String)"32.4", (boolean)folder1.isLinked());
            FilteredResourceTest.assertTrue((String)"32.6", (boolean)folder2.isLinked());
            FilteredResourceTest.assertTrue((String)"32.8", (boolean)folder2.getLocation().equals((Object)parentLoc));
            FilteredResourceTest.assertTrue((String)"32.10", (boolean)folder1.getLocation().equals((Object)childLoc));
            FilteredResourceTest.assertTrue((String)"32.12", (folder1.members().length == 1 ? 1 : 0) != 0);
            FilteredResourceTest.assertTrue((String)"32.12", (folder2.members().length == 0 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"32.20", (Throwable)e);
        }
    }

    public void testCreateFilterOnLinkedFolderBeforeCreation() {
        IPath location = this.existingFolderInExistingFolder.getLocation();
        IFolder folder = this.nonExistingFolderInExistingProject;
        FilteredResourceTest.assertTrue((String)"0.1", (!folder.exists() ? 1 : 0) != 0);
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
        try {
            folder.createFilter(5, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"0.5");
        }
        try {
            folder.createLink(location, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = folder.getFile("foo");
        IFile bar = folder.getFile("bar");
        this.ensureExistsInWorkspace(new IResource[]{foo, bar}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            this.existingProject.close(this.getMonitor());
            this.existingProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.2", (Throwable)e);
        }
        IResourceFilterDescription[] filters = null;
        try {
            filters = folder.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.4", (int)filters.length, (int)1);
        FilteredResourceTest.assertEquals((String)"1.5", (String)filters[0].getFileInfoMatcherDescription().getId(), (String)REGEX_FILTER_PROVIDER);
        FilteredResourceTest.assertEquals((String)"1.6", (Object)filters[0].getFileInfoMatcherDescription().getArguments(), (Object)"foo");
        FilteredResourceTest.assertEquals((String)"1.7", (int)filters[0].getType(), (int)5);
        FilteredResourceTest.assertEquals((String)"1.8", (Object)filters[0].getResource(), (Object)folder);
        IResource[] members = null;
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.9", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.0", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"2.1", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)members[0].getName(), (String)"foo");
    }

    public void testCreateAndRemoveFilterOnFolder() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
        IResourceFilterDescription filterDescription = null;
        try {
            filterDescription = this.existingFolderInExistingFolder.createFilter(13, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingFolder.getFile("foo");
        IFile bar = this.existingFolderInExistingFolder.getFile("bar");
        this.ensureExistsInWorkspace(new IResource[]{foo, bar}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            this.existingProject.close(this.getMonitor());
            this.existingProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.2", (Throwable)e);
        }
        try {
            filterDescription.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        try {
            this.existingProject.close(this.getMonitor());
            this.existingProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.4", (Throwable)e);
        }
        IResourceFilterDescription[] filters = null;
        try {
            filters = this.existingFolderInExistingFolder.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.5", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.6", (int)filters.length, (int)0);
        IResource[] members = null;
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.7", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.8", (int)members.length, (int)2);
        FilteredResourceTest.assertEquals((String)"1.9", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.0", (String)members[0].getName(), (String)"bar");
        FilteredResourceTest.assertEquals((String)"2.1", (int)members[1].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)members[1].getName(), (String)"foo");
    }

    public void testCreateAndRemoveFilterOnFolderWithoutClosingProject() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
        IResourceFilterDescription filterDescription = null;
        try {
            filterDescription = this.existingFolderInExistingFolder.createFilter(13, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingFolder.getFile("foo");
        IFile bar = this.existingFolderInExistingFolder.getFile("bar");
        this.ensureExistsInWorkspace(new IResource[]{foo, bar}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            filterDescription.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        IResourceFilterDescription[] filters = null;
        try {
            filters = this.existingFolderInExistingFolder.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.5", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.6", (int)filters.length, (int)0);
        IResource[] members = null;
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.7", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.8", (int)members.length, (int)2);
        FilteredResourceTest.assertEquals((String)"1.9", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.0", (String)members[0].getName(), (String)"bar");
        FilteredResourceTest.assertEquals((String)"2.1", (int)members[1].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)members[1].getName(), (String)"foo");
    }

    public void testIncludeOnlyFilter() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.c");
        try {
            this.existingFolderInExistingProject.createFilter(13, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFile file = this.existingFolderInExistingProject.getFile("file.c");
        IFile bar = this.existingFolderInExistingProject.getFile("bar.h");
        this.ensureExistsInWorkspace(new IResource[]{foo, bar, file}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        IResource[] members = null;
        try {
            members = this.existingFolderInExistingProject.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.9", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.0", (int)members.length, (int)2);
        FilteredResourceTest.assertEquals((String)"2.1", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)members[0].getName(), (String)"file.c");
        FilteredResourceTest.assertEquals((String)"2.3", (int)members[1].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.4", (String)members[1].getName(), (String)"foo.c");
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.c");
        try {
            this.existingFolderInExistingProject.createFilter(13, matcherDescription2, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"3.0");
        }
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"3.1", (Throwable)e);
        }
        members = null;
        try {
            members = this.existingFolderInExistingProject.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"3.2", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"3.3", (int)members.length, (int)2);
        FilteredResourceTest.assertEquals((String)"3.4", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"3.5", (String)members[0].getName(), (String)"file.c");
        FilteredResourceTest.assertEquals((String)"3.6", (int)members[1].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"3.7", (String)members[1].getName(), (String)"foo.c");
    }

    public void testExcludeAllFilter() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.c");
        try {
            this.existingFolderInExistingFolder.createFilter(14, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingFolder.getFile("foo.c");
        IFile file = this.existingFolderInExistingFolder.getFile("file.c");
        IFile fooh = this.existingFolderInExistingFolder.getFile("foo.h");
        IFile bar = this.existingFolderInExistingFolder.getFile("bar.h");
        this.ensureExistsInWorkspace(new IResource[]{foo, bar, file, fooh}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        IResource[] members = null;
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.9", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.0", (int)members.length, (int)2);
        FilteredResourceTest.assertEquals((String)"2.1", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)members[0].getName(), (String)"bar.h");
        FilteredResourceTest.assertEquals((String)"2.3", (int)members[1].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.4", (String)members[1].getName(), (String)"foo.h");
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        try {
            this.existingFolderInExistingFolder.createFilter(14, matcherDescription2, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"3.0");
        }
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"3.1", (Throwable)e);
        }
        members = null;
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"3.2", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"3.3", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"3.4", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"3.5", (String)members[0].getName(), (String)"bar.h");
    }

    public void testMixedFilter() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.c");
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        try {
            this.existingFolderInExistingProject.createFilter(13, matcherDescription1, 0, this.getMonitor());
            this.existingFolderInExistingProject.createFilter(14, matcherDescription2, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFile file = this.existingFolderInExistingProject.getFile("file.c");
        IFile fooh = this.existingFolderInExistingProject.getFile("foo.h");
        IFile bar = this.existingFolderInExistingProject.getFile("bar.h");
        this.ensureExistsInWorkspace(new IResource[]{foo, bar, file, fooh}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        IResource[] members = null;
        try {
            members = this.existingFolderInExistingProject.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.9", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.0", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"2.1", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)members[0].getName(), (String)"file.c");
    }

    public void testInheritedFilter() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.c");
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        try {
            this.existingProject.createFilter(21, matcherDescription1, 0, this.getMonitor());
            this.existingFolderInExistingFolder.createFilter(14, matcherDescription2, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingFolder.getFile("foo.c");
        IFile file = this.existingFolderInExistingFolder.getFile("file.c");
        IFile fooh = this.existingFolderInExistingFolder.getFile("foo.h");
        IFile bar = this.existingFolderInExistingFolder.getFile("bar.h");
        this.ensureExistsInWorkspace(new IResource[]{foo, bar, file, fooh}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        IResource[] members = null;
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.9", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.0", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"2.1", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)members[0].getName(), (String)"file.c");
    }

    public void testFolderOnlyFilters() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        try {
            this.existingFolderInExistingFolder.createFilter(10, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingFolder.getFile("foo.c");
        IFolder food = this.existingFolderInExistingFolder.getFolder("foo.d");
        this.ensureExistsInWorkspace(new IResource[]{foo, food}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        IResource[] members = null;
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.9", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.0", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"2.1", (int)members[0].getType(), (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)members[0].getName(), (String)"foo.c");
    }

    public void testFileOnlyFilters() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        try {
            this.existingFolderInExistingFolder.createFilter(6, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingFolder.getFile("foo.c");
        IFolder food = this.existingFolderInExistingFolder.getFolder("foo.d");
        this.ensureExistsInWorkspace(new IResource[]{foo, food}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        IResource[] members = null;
        try {
            members = this.existingFolderInExistingFolder.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.9", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.0", (int)members.length, (int)1);
        FilteredResourceTest.assertEquals((String)"2.1", (int)members[0].getType(), (int)2);
        FilteredResourceTest.assertEquals((String)"2.2", (String)members[0].getName(), (String)"foo.d");
    }

    public void testMoveFolderWithFilterToAnotherProject() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        try {
            this.existingFolderInExistingProject.createFilter(6, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFolder food = this.existingFolderInExistingProject.getFolder("foo.d");
        this.ensureExistsInWorkspace(new IResource[]{foo, food}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        IFolder destination = this.otherExistingProject.getFolder("destination");
        try {
            this.existingFolderInExistingProject.move(destination.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.2");
        }
        IResourceFilterDescription[] filters = null;
        try {
            filters = this.existingFolderInExistingProject.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.4", (int)filters.length, (int)0);
        filters = null;
        try {
            filters = destination.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.5", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.6", (int)filters.length, (int)1);
        FilteredResourceTest.assertEquals((String)"1.7", (String)filters[0].getFileInfoMatcherDescription().getId(), (String)REGEX_FILTER_PROVIDER);
        FilteredResourceTest.assertEquals((String)"1.8", (Object)filters[0].getFileInfoMatcherDescription().getArguments(), (Object)"foo.*");
        FilteredResourceTest.assertEquals((String)"1.9", (int)filters[0].getType(), (int)6);
        FilteredResourceTest.assertEquals((String)"2.0", (Object)filters[0].getResource(), (Object)destination);
    }

    public void testCopyFolderWithFilterToAnotherProject() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        try {
            this.existingFolderInExistingProject.createFilter(6, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFolder food = this.existingFolderInExistingProject.getFolder("foo.d");
        this.ensureExistsInWorkspace(new IResource[]{foo, food}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        IFolder destination = this.otherExistingProject.getFolder("destination");
        try {
            this.existingFolderInExistingProject.copy(destination.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.2");
        }
        IResourceFilterDescription[] filters = null;
        try {
            filters = this.existingFolderInExistingProject.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.4", (int)filters.length, (int)1);
        FilteredResourceTest.assertEquals((String)"1.5", (String)filters[0].getFileInfoMatcherDescription().getId(), (String)REGEX_FILTER_PROVIDER);
        FilteredResourceTest.assertEquals((String)"1.6", (Object)filters[0].getFileInfoMatcherDescription().getArguments(), (Object)"foo.*");
        FilteredResourceTest.assertEquals((String)"1.7", (int)filters[0].getType(), (int)6);
        FilteredResourceTest.assertEquals((String)"1.8", (Object)filters[0].getResource(), (Object)this.existingFolderInExistingProject);
        filters = null;
        try {
            filters = destination.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.0", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.1", (int)filters.length, (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)filters[0].getFileInfoMatcherDescription().getId(), (String)REGEX_FILTER_PROVIDER);
        FilteredResourceTest.assertEquals((String)"2.3", (Object)filters[0].getFileInfoMatcherDescription().getArguments(), (Object)"foo.*");
        FilteredResourceTest.assertEquals((String)"2.4", (int)filters[0].getType(), (int)6);
        FilteredResourceTest.assertEquals((String)"2.5", (Object)filters[0].getResource(), (Object)destination);
    }

    public void testCopyFolderWithFilterToAnotherFolder() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        try {
            this.existingFolderInExistingProject.createFilter(6, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFolder food = this.existingFolderInExistingProject.getFolder("foo.d");
        this.ensureExistsInWorkspace(new IResource[]{foo, food}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        this.ensureExistsInWorkspace(new IResource[]{this.nonExistingFolderInExistingProject}, true);
        IFolder destination = this.nonExistingFolderInExistingProject.getFolder("destination");
        try {
            this.existingFolderInExistingProject.copy(destination.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.2");
        }
        IResourceFilterDescription[] filters = null;
        try {
            filters = this.existingFolderInExistingProject.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.4", (int)filters.length, (int)1);
        FilteredResourceTest.assertEquals((String)"1.5", (String)filters[0].getFileInfoMatcherDescription().getId(), (String)REGEX_FILTER_PROVIDER);
        FilteredResourceTest.assertEquals((String)"1.6", (Object)filters[0].getFileInfoMatcherDescription().getArguments(), (Object)"foo.*");
        FilteredResourceTest.assertEquals((String)"1.7", (int)filters[0].getType(), (int)6);
        FilteredResourceTest.assertEquals((String)"1.8", (Object)filters[0].getResource(), (Object)this.existingFolderInExistingProject);
        filters = null;
        try {
            filters = destination.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.0", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.1", (int)filters.length, (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)filters[0].getFileInfoMatcherDescription().getId(), (String)REGEX_FILTER_PROVIDER);
        FilteredResourceTest.assertEquals((String)"2.3", (Object)filters[0].getFileInfoMatcherDescription().getArguments(), (Object)"foo.*");
        FilteredResourceTest.assertEquals((String)"2.4", (int)filters[0].getType(), (int)6);
        FilteredResourceTest.assertEquals((String)"2.5", (Object)filters[0].getResource(), (Object)destination);
    }

    public void testMoveFolderWithFilterToAnotherFolder() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        try {
            this.existingFolderInExistingProject.createFilter(6, matcherDescription1, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFolder food = this.existingFolderInExistingProject.getFolder("foo.d");
        this.ensureExistsInWorkspace(new IResource[]{foo, food}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        this.ensureExistsInWorkspace(new IResource[]{this.nonExistingFolderInExistingProject}, true);
        IFolder destination = this.nonExistingFolderInExistingProject.getFolder("destination");
        try {
            this.existingFolderInExistingProject.move(destination.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.2");
        }
        IResourceFilterDescription[] filters = null;
        try {
            filters = this.existingFolderInExistingProject.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.4", (int)filters.length, (int)0);
        filters = null;
        try {
            filters = destination.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.0", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.1", (int)filters.length, (int)1);
        FilteredResourceTest.assertEquals((String)"2.2", (String)filters[0].getFileInfoMatcherDescription().getId(), (String)REGEX_FILTER_PROVIDER);
        FilteredResourceTest.assertEquals((String)"2.3", (Object)filters[0].getFileInfoMatcherDescription().getArguments(), (Object)"foo.*");
        FilteredResourceTest.assertEquals((String)"2.4", (int)filters[0].getType(), (int)6);
        FilteredResourceTest.assertEquals((String)"2.5", (Object)filters[0].getResource(), (Object)destination);
    }

    public void testDeleteFolderWithFilterToAnotherFolder() {
        FileInfoMatcherDescription matcherDescription1 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo.*");
        FileInfoMatcherDescription matcherDescription2 = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*\\.c");
        try {
            this.existingFolderInExistingProject.createFilter(6, matcherDescription1, 0, this.getMonitor());
            this.existingFolderInExistingFolder.createFilter(5, matcherDescription2, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        IFile foo = this.existingFolderInExistingProject.getFile("foo.c");
        IFolder food = this.existingFolderInExistingProject.getFolder("foo.d");
        this.ensureExistsInWorkspace(new IResource[]{foo, food}, true);
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        this.ensureExistsInWorkspace(new IResource[]{this.nonExistingFolderInExistingProject}, true);
        try {
            this.existingFolderInExistingProject.delete(0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.2");
        }
        IResourceFilterDescription[] filters = null;
        try {
            filters = this.existingFolderInExistingProject.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.4", (int)filters.length, (int)0);
        filters = null;
        try {
            filters = this.existingFolderInExistingFolder.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.0", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.1", (int)filters.length, (int)0);
    }

    public void testInvalidCharactersInRegExFilter() {
        RegexFileInfoMatcher matcher = new RegexFileInfoMatcher();
        try {
            matcher.initialize(this.existingProject, (Object)"*:*");
            FilteredResourceTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
    }

    public void testBug302146() {
        try {
            FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"foo");
            this.existingFolderInExistingProject.createFilter(13, matcherDescription, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.0");
        }
        try {
            this.existingProject.close(this.getMonitor());
            this.existingProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.0", (Throwable)e);
        }
        IResourceFilterDescription[] filters = null;
        try {
            filters = this.existingFolderInExistingProject.getFilters();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"3.0", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"4.0", (int)filters.length, (int)1);
        FilteredResourceTest.assertEquals((String)"4.1", (String)filters[0].getFileInfoMatcherDescription().getId(), (String)REGEX_FILTER_PROVIDER);
        FilteredResourceTest.assertEquals((String)"4.2", (Object)filters[0].getFileInfoMatcherDescription().getArguments(), (Object)"foo");
        FilteredResourceTest.assertEquals((String)"4.3", (int)filters[0].getType(), (int)13);
        FilteredResourceTest.assertEquals((String)"4.4", (Object)filters[0].getResource(), (Object)this.existingFolderInExistingProject);
        try {
            new ProjectDescriptionReader().read(this.existingProject.getFile(".project").getLocation());
        }
        catch (IOException e) {
            FilteredResourceTest.fail((String)"5.0", (Throwable)e);
        }
    }

    public void test317783() {
        IFolder folder = this.existingProject.getFolder("foo");
        this.ensureExistsInWorkspace((IResource)folder, true);
        IFile file = folder.getFile("bar.txt");
        this.ensureExistsInWorkspace(file, "content");
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*");
            this.existingProject.createFilter(10, matcherDescription, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.2");
        }
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        IResource[] members = null;
        try {
            members = this.existingProject.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.4", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"1.5", (int)2, (int)members.length);
        FilteredResourceTest.assertEquals((String)"1.6", (String)".project", (String)members[0].getName());
        FilteredResourceTest.assertEquals((String)"1.7", (String)this.existingFileInExistingProject.getName(), (String)members[1].getName());
        try {
            folder.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            members = this.existingProject.members();
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.1", (Throwable)e);
        }
        FilteredResourceTest.assertEquals((String)"2.2", (int)2, (int)members.length);
        FilteredResourceTest.assertEquals((String)"2.3", (String)".project", (String)members[0].getName());
        FilteredResourceTest.assertEquals((String)"2.4", (String)this.existingFileInExistingProject.getName(), (String)members[1].getName());
        FilteredResourceTest.assertEquals((String)"2.5", (boolean)false, (boolean)folder.exists());
        FilteredResourceTest.assertEquals((String)"2.6", (boolean)false, (boolean)file.exists());
    }

    public void test317824() {
        IFolder folder = this.existingProject.getFolder("foo");
        this.ensureExistsInWorkspace((IResource)folder, true);
        IFile file = folder.getFile("bar.txt");
        this.ensureExistsInWorkspace(file, "content");
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)".*");
            this.existingProject.createFilter(10, matcherDescription, 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            FilteredResourceTest.fail((String)"1.2");
        }
        try {
            FilteredResourceTest.assertEquals((int)1, (int)this.existingProject.getFilters().length);
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.3", (Throwable)e);
        }
        try {
            this.existingProject.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.4", (Throwable)e);
        }
        IPath newPath = this.existingProject.getFullPath().removeLastSegments(1).append(String.valueOf(this.existingProject.getName()) + "_moved");
        try {
            this.existingProject.move(newPath, true, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.5", (Throwable)e);
        }
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(this.existingProject.getName()) + "_moved");
        try {
            FilteredResourceTest.assertTrue((boolean)newProject.exists());
            FilteredResourceTest.assertEquals((int)1, (int)newProject.getFilters().length);
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.6", (Throwable)e);
        }
        newPath = newProject.getFullPath().removeLastSegments(1).append(String.valueOf(newProject.getName()) + "_copy");
        try {
            newProject.copy(newPath, true, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.7", (Throwable)e);
        }
        newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(newProject.getName()) + "_copy");
        try {
            FilteredResourceTest.assertTrue((boolean)newProject.exists());
            FilteredResourceTest.assertEquals((int)1, (int)newProject.getFilters().length);
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.8", (Throwable)e);
        }
    }

    public void test328464() {
        IFolder folder = this.existingProject.getFolder(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)folder, true);
        IFile file_a_txt = folder.getFile("a.txt");
        this.ensureExistsInWorkspace((IResource)file_a_txt, true);
        try {
            FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)"a\\.txt");
            this.existingProject.createFilter(22, matcherDescription, 0, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.0", (Throwable)e);
        }
        FilteredResourceTest.assertFalse((String)"2.0", (boolean)this.existingProject.getWorkspace().validateFiltered((IResource)file_a_txt).isOK());
        File ioFile = file_a_txt.getLocation().toFile();
        FilteredResourceTest.assertTrue((String)"3.0", (boolean)ioFile.exists());
        ioFile.renameTo(new File(file_a_txt.getLocation().removeLastSegments(1).append("A.txt").toString()));
        FilteredResourceTest.assertFalse((String)"4.0", (boolean)this.existingProject.getWorkspace().validateFiltered((IResource)file_a_txt).isOK());
        try {
            folder.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"5.0", (Throwable)e);
        }
        FilteredResourceTest.assertFalse((String)"6.0", (boolean)file_a_txt.exists());
        FilteredResourceTest.assertFalse((String)"7.0", (boolean)this.existingProject.getWorkspace().validateFiltered((IResource)file_a_txt).isOK());
        IFile file_A_txt = folder.getFile("A.txt");
        FilteredResourceTest.assertTrue((String)"9.0", (boolean)file_A_txt.exists());
        FilteredResourceTest.assertTrue((String)"10.0", (boolean)this.existingProject.getWorkspace().validateFiltered((IResource)file_A_txt).isOK());
    }

    public void test343914() {
        String subProjectName = "subProject";
        IPath subProjectLocation = this.existingProject.getLocation().append(subProjectName);
        try {
            FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(REGEX_FILTER_PROVIDER, (Object)subProjectName);
            this.existingProject.createFilter(30, matcherDescription, 0, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"1.0", (Throwable)e);
        }
        IPath fileLocation = subProjectLocation.append("file.txt");
        IWorkspaceRoot root = FilteredResourceTest.getWorkspace().getRoot();
        IFile result = root.getFileForLocation(fileLocation);
        FilteredResourceTest.assertTrue((String)"2.0", (result == null ? 1 : 0) != 0);
        IFile[] results = root.findFilesForLocation(fileLocation);
        FilteredResourceTest.assertTrue((String)"2.1", (results.length == 0 ? 1 : 0) != 0);
        IPath containerLocation = subProjectLocation.append("folder");
        IContainer resultContainer = root.getContainerForLocation(containerLocation);
        FilteredResourceTest.assertTrue((String)"2.2", (resultContainer == null ? 1 : 0) != 0);
        IContainer[] resultsContainer = root.findContainersForLocation(containerLocation);
        FilteredResourceTest.assertTrue((String)"2.3", (resultsContainer.length == 0 ? 1 : 0) != 0);
        IProject subProject = root.getProject(subProjectName);
        IProjectDescription newProjectDescription = FilteredResourceTest.getWorkspace().newProjectDescription(subProjectName);
        newProjectDescription.setLocation(subProjectLocation);
        try {
            subProject.create(newProjectDescription, this.getMonitor());
        }
        catch (CoreException e) {
            FilteredResourceTest.fail((String)"2.99", (Throwable)e);
        }
        result = root.getFileForLocation(fileLocation);
        FilteredResourceTest.assertTrue((String)"3.0", (result != null ? 1 : 0) != 0);
        FilteredResourceTest.assertEquals((String)"3.1", (Object)subProject, (Object)result.getProject());
        results = root.findFilesForLocation(fileLocation);
        FilteredResourceTest.assertTrue((String)"3.2", (results.length == 1 ? 1 : 0) != 0);
        FilteredResourceTest.assertEquals((String)"3.3", (Object)subProject, (Object)results[0].getProject());
        resultContainer = root.getContainerForLocation(containerLocation);
        FilteredResourceTest.assertTrue((String)"3.4", (resultContainer != null ? 1 : 0) != 0);
        FilteredResourceTest.assertEquals((String)"3.5", (Object)subProject, (Object)resultContainer.getProject());
        resultsContainer = root.findContainersForLocation(containerLocation);
        FilteredResourceTest.assertTrue((String)"3.6", (resultsContainer.length == 1 ? 1 : 0) != 0);
        FilteredResourceTest.assertEquals((String)"3.7", (Object)subProject, (Object)resultsContainer[0].getProject());
    }
}

