/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.tests.resources.ResourceTest;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class IProjectTest
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(IProjectTest.class);
    }

    public IProjectTest() {
    }

    public IProjectTest(String name) {
        super(name);
    }

    public void ensureExistsInWorkspace(final IProject project, final IProjectDescription description) {
        if (project == null) {
            return;
        }
        IWorkspaceRunnable body = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(description, monitor);
                project.open(monitor);
            }
        };
        try {
            IProjectTest.getWorkspace().run(body, null);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)("#ensureExistsInWorkspace(IProject, IProjectDescription): " + project.getFullPath()), (Throwable)e);
        }
    }

    public void setGetPersistentProperty(IResource target) throws CoreException {
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("itp-test", "testProperty");
        target.setPersistentProperty(name, value);
        IProjectTest.assertTrue((String)"get not equal set", (boolean)target.getPersistentProperty(name).equals(value));
        name = new QualifiedName("eclipse-test", "testNonProperty");
        IProjectTest.assertNull((String)"non-existant persistent property not missing", (Object)target.getPersistentProperty(name));
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testCopy() {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("Source");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            project.createMarker("org.eclipse.core.resources.taskmarker");
            IProject destination = IProjectTest.getWorkspace().getRoot().getProject("Destination");
            IProjectTest.assertTrue((String)"1.0", (!destination.exists() ? 1 : 0) != 0);
            project.copy(destination.getFullPath(), 0, this.getMonitor());
            IProjectTest.assertTrue((String)"1.1", (boolean)destination.exists());
            IProjectTest.assertEquals((String)"1.2", (int)0, (int)destination.findMarkers("org.eclipse.core.resources.taskmarker", true, 2).length);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testGetNature() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject("Project");
        try {
            project.getNature("org.eclipse.core.tests.resources.simpleNature");
            IProjectTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        try {
            project.getNature("no.such.nature.Missing");
            IProjectTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
        try {
            project.create(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            project.getNature("org.eclipse.core.tests.resources.simpleNature");
            IProjectTest.fail((String)"2.0");
        }
        catch (CoreException coreException) {}
        try {
            project.getNature("no.such.nature.Missing");
            IProjectTest.fail((String)"2.1");
        }
        catch (CoreException coreException) {}
        try {
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.99", (Throwable)e);
        }
        try {
            IProjectTest.assertNull((String)"3.0", (Object)project.getNature("org.eclipse.core.tests.resources.simpleNature"));
            IProjectTest.assertNull((String)"3.1", (Object)project.getNature("no.such.nature.Missing"));
            IProjectTest.assertNull((String)"3.2", (Object)project.getNature("org.eclipse.core.tests.resources.earthNature"));
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.99", (Throwable)e);
        }
        try {
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.99", (Throwable)e);
        }
        IProjectNature nature = null;
        try {
            nature = project.getNature("org.eclipse.core.tests.resources.simpleNature");
            IProjectTest.assertNotNull((String)"5.0", (Object)nature);
            IProjectTest.assertNull((String)"5.1", (Object)project.getNature("no.such.nature.Missing"));
            IProjectTest.assertNull((String)"5.2", (Object)project.getNature("org.eclipse.core.tests.resources.earthNature"));
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.99", (Throwable)e);
            return;
        }
        IProjectTest.assertEquals((String)"6.0", (Object)project, (Object)nature.getProject());
        IProject project2 = IProjectTest.getWorkspace().getRoot().getProject("testGetNature.Destination");
        IProjectNature nature2 = null;
        try {
            project.copy(project2.getFullPath(), 0, this.getMonitor());
            nature2 = project2.getNature("org.eclipse.core.tests.resources.simpleNature");
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"6.99", (Throwable)e);
            return;
        }
        IProjectTest.assertNotNull((String)"7.0", (Object)nature2);
        IProjectTest.assertEquals((String)"7.1", (Object)project2, (Object)nature2.getProject());
        IProjectTest.assertEquals((String)"7.2", (Object)project, (Object)nature.getProject());
    }

    public void testHasNature() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject("Project");
        try {
            project.hasNature("org.eclipse.core.tests.resources.simpleNature");
            IProjectTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        try {
            project.hasNature("no.such.nature.Missing");
            IProjectTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
        try {
            project.create(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            project.hasNature("org.eclipse.core.tests.resources.simpleNature");
            IProjectTest.fail((String)"2.0");
        }
        catch (CoreException coreException) {}
        try {
            project.hasNature("no.such.nature.Missing");
            IProjectTest.fail((String)"2.1");
        }
        catch (CoreException coreException) {}
        try {
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.99", (Throwable)e);
        }
        try {
            IProjectTest.assertTrue((String)"3.0", (!project.hasNature("org.eclipse.core.tests.resources.simpleNature") ? 1 : 0) != 0);
            IProjectTest.assertTrue((String)"3.1", (!project.hasNature("no.such.nature.Missing") ? 1 : 0) != 0);
            IProjectTest.assertTrue((String)"3.2", (!project.hasNature("org.eclipse.core.tests.resources.earthNature") ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.99", (Throwable)e);
        }
        try {
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.99", (Throwable)e);
        }
        try {
            IProjectTest.assertTrue((String)"5.0", (boolean)project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
            IProjectTest.assertTrue((String)"5.1", (!project.hasNature("no.such.nature.Missing") ? 1 : 0) != 0);
            IProjectTest.assertTrue((String)"5.2", (!project.hasNature("org.eclipse.core.tests.resources.earthNature") ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.99", (Throwable)e);
        }
    }

    public void testInvalidProjectNames() {
        IProject project;
        IWorkspaceRoot root = IProjectTest.getWorkspace().getRoot();
        String[] names = new String[]{"", "/"};
        int i = 0;
        while (i < names.length) {
            try {
                root.getProject(names[i]);
                IProjectTest.fail((String)"0.99");
            }
            catch (RuntimeException runtimeException) {}
            ++i;
        }
        names = new String[]{};
        names = IProjectTest.isWindows() ? new String[]{"foo:bar", "prn", "nul", "con", "aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "AUX", "con.foo", "LPT4.txt", "*", "?", "\"", "<", ">", "|", "::"} : new String[]{};
        i = 0;
        while (i < names.length) {
            project = root.getProject(names[i]);
            IProjectTest.assertTrue((String)("1.0 " + names[i]), (!project.exists() ? 1 : 0) != 0);
            try {
                project.create(this.getMonitor());
                project.open(this.getMonitor());
                IProjectTest.fail((String)("1.1 " + names[i]));
            }
            catch (CoreException coreException) {}
            IProjectTest.assertTrue((String)("1.2 " + names[i]), (!project.exists() ? 1 : 0) != 0);
            IProjectTest.assertTrue((String)("1.3 " + names[i]), (!project.isOpen() ? 1 : 0) != 0);
            ++i;
        }
        names = IProjectTest.isWindows() ? new String[]{"hello.prn.txt", "null", "con3", "foo.aux", "lpt0", "com0", "com10", "lpt10", ",", "'", ";"} : new String[]{"foo:bar", "prn", "nul", "con", "aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "con.foo", "LPT4.txt", "*", "?", "\"", "<", ">", "|", "hello.prn.txt", "null", "con3", "foo.aux", "lpt0", "com0", "com10", "lpt10", ",", "'", ";"};
        i = 0;
        while (i < names.length) {
            project = root.getProject(names[i]);
            IProjectTest.assertTrue((String)("2.0 " + names[i]), (!project.exists() ? 1 : 0) != 0);
            try {
                project.create(this.getMonitor());
                project.open(this.getMonitor());
            }
            catch (CoreException e) {
                IProjectTest.fail((String)("2.1 " + names[i]), (Throwable)e);
            }
            IProjectTest.assertTrue((String)("2.2 " + names[i]), (boolean)project.exists());
            IProjectTest.assertTrue((String)("2.3 " + names[i]), (boolean)project.isOpen());
            ++i;
        }
    }

    public void testIsNatureEnabled() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject("Project");
        try {
            project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature");
            IProjectTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        try {
            project.isNatureEnabled("no.such.nature.Missing");
            IProjectTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
        try {
            project.create(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature");
            IProjectTest.fail((String)"2.0");
        }
        catch (CoreException coreException) {}
        try {
            project.isNatureEnabled("no.such.nature.Missing");
            IProjectTest.fail((String)"2.1");
        }
        catch (CoreException coreException) {}
        try {
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.99", (Throwable)e);
        }
        try {
            IProjectTest.assertTrue((String)"3.0", (!project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature") ? 1 : 0) != 0);
            IProjectTest.assertTrue((String)"3.1", (!project.isNatureEnabled("no.such.nature.Missing") ? 1 : 0) != 0);
            IProjectTest.assertTrue((String)"3.2", (!project.isNatureEnabled("org.eclipse.core.tests.resources.earthNature") ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.99", (Throwable)e);
        }
        try {
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.99", (Throwable)e);
        }
        try {
            IProjectTest.assertTrue((String)"5.0", (boolean)project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature"));
            IProjectTest.assertTrue((String)"5.1", (!project.isNatureEnabled("no.such.nature.Missing") ? 1 : 0) != 0);
            IProjectTest.assertTrue((String)"5.2", (!project.isNatureEnabled("org.eclipse.core.tests.resources.earthNature") ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.99", (Throwable)e);
        }
    }

    public void testPathVariableLocation() {
        IPath varValue = Platform.getLocation().removeLastSegments(1);
        IPath rawLocation = new Path("ProjectLocatio").append("ProjectLocation");
        try {
            IProjectTest.getWorkspace().getPathVariableManager().setValue("ProjectLocatio", varValue);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.0", (Throwable)e);
        }
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("Project");
        IProjectDescription description = IProjectTest.getWorkspace().newProjectDescription("Project");
        description.setLocation(rawLocation);
        try {
            project.create(description, this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"9.99", (Throwable)e);
        }
        IProjectTest.assertEquals((String)"1.0", (Object)varValue, (Object)IProjectTest.getWorkspace().getPathVariableManager().getValue("ProjectLocatio"));
        IProjectTest.assertTrue((String)"1.1", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.2", (boolean)project.isOpen());
        IProjectTest.assertEquals((String)"1.3", (Object)rawLocation, (Object)project.getRawLocation());
        IProjectTest.assertEquals((String)"1.4", (Object)varValue.append(rawLocation.lastSegment()), (Object)project.getLocation());
    }

    public void testProjectCloseOpen() {
        IProject target = IProjectTest.getWorkspace().getRoot().getProject("Project");
        this.ensureExistsInWorkspace((IResource)target, true);
        IFolder folder = target.getFolder("Folder");
        this.ensureExistsInWorkspace((IResource)folder, true);
        try {
            target.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.1", (boolean)target.exists());
        IProjectTest.assertTrue((String)"1.2", (!target.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.3", (!folder.exists() ? 1 : 0) != 0);
        try {
            target.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.1", (boolean)target.isOpen());
        IProjectTest.assertTrue((String)"2.2", (boolean)folder.exists());
    }

    public void testProjectCopyVariations() {
        IProject project;
        QualifiedName qname = new QualifiedName("com.example", "myProperty");
        String actual = null;
        String value = "this is my property value.";
        IProject source = project = IProjectTest.getWorkspace().getRoot().getProject("SourceProject");
        String[] children = new String[]{"/1/", "/1/2"};
        IResource[] resources = this.buildResources((IContainer)project, children);
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace(resources, true);
        IProject destination = IProjectTest.getWorkspace().getRoot().getProject("DestProject");
        this.assertDoesNotExistInWorkspace("1.0", (IResource)destination);
        IResource sourceChild = resources[1];
        try {
            sourceChild.setPersistentProperty(qname, value);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            source.copy(destination.getFullPath(), false, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("1.3", (IResource)project);
        this.assertExistsInWorkspace("1.4", resources);
        resources = this.buildResources((IContainer)destination, children);
        this.assertExistsInWorkspace("1.5", (IResource)destination);
        this.assertExistsInWorkspace("1.6", resources);
        IResource destChild = resources[1];
        try {
            actual = destChild.getPersistentProperty(qname);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.7", (Throwable)e);
        }
        IProjectTest.assertNotNull((String)"1.8", (Object)actual);
        IProjectTest.assertEquals((String)"1.9", (String)value, (String)actual);
        try {
            IProjectTest.getWorkspace().getRoot().delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.10", (Throwable)e);
        }
        source = project = IProjectTest.getWorkspace().getRoot().getProject("SourceProject");
        children = new String[]{"/1/", "/1/2"};
        resources = this.buildResources((IContainer)project, children);
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace(resources, true);
        destination = IProjectTest.getWorkspace().getRoot().getProject("DestProject");
        IProjectDescription description = IProjectTest.getWorkspace().newProjectDescription(destination.getName());
        this.assertDoesNotExistInWorkspace("2.0", (IResource)destination);
        sourceChild = resources[1];
        try {
            sourceChild.setPersistentProperty(qname, value);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.1", (Throwable)e);
        }
        try {
            source.copy(description, false, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.3", (IResource)project);
        this.assertExistsInWorkspace("2.4", resources);
        resources = this.buildResources((IContainer)destination, children);
        this.assertExistsInWorkspace("2.5", (IResource)destination);
        this.assertExistsInWorkspace("2.6", resources);
        destChild = resources[1];
        try {
            actual = destChild.getPersistentProperty(qname);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.7", (Throwable)e);
        }
        IProjectTest.assertNotNull((String)"2.8", (Object)actual);
        IProjectTest.assertEquals((String)"2.9", (String)value, (String)actual);
        try {
            IProjectTest.getWorkspace().getRoot().delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.10", (Throwable)e);
        }
        source = project = IProjectTest.getWorkspace().getRoot().getProject("SourceProject");
        children = new String[]{"/1/", "/1/2"};
        resources = this.buildResources((IContainer)project, children);
        IProject destProject = IProjectTest.getWorkspace().getRoot().getProject("DestProject");
        destination = destProject.getFolder("MyFolder");
        this.ensureExistsInWorkspace(new IResource[]{project, destProject}, true);
        this.ensureExistsInWorkspace(resources, true);
        this.assertDoesNotExistInWorkspace("3.0", (IResource)destination);
        try {
            source.copy(destination.getFullPath(), true, this.getMonitor());
            IProjectTest.fail((String)"3.1");
        }
        catch (CoreException coreException) {}
        try {
            IProjectTest.getWorkspace().getRoot().delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.99", (Throwable)e);
        }
        project = IProjectTest.getWorkspace().getRoot().getProject("SourceProject");
        children = new String[]{"/1/", "/1/2"};
        source = project.getFolder("1");
        resources = this.buildResources((IContainer)project, children);
        destination = IProjectTest.getWorkspace().getRoot().getProject("DestProject");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace(resources, true);
        this.assertDoesNotExistInWorkspace("4.0", (IResource)destination);
        try {
            source.copy(destination.getFullPath(), true, this.getMonitor());
            IProjectTest.fail((String)"4.1");
        }
        catch (CoreException coreException) {}
        try {
            IProjectTest.getWorkspace().getRoot().delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.99", (Throwable)e);
        }
    }

    public void testProjectCreateOpenCloseDelete() {
        IProject target = IProjectTest.getWorkspace().getRoot().getProject("Project");
        try {
            target.create(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.1", (boolean)target.exists());
        try {
            target.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.1", (boolean)target.isOpen());
        try {
            target.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"3.1", (!target.isOpen() ? 1 : 0) != 0);
        try {
            target.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"4.1", (!target.exists() ? 1 : 0) != 0);
    }

    public void testProjectCreation() {
        IProject target = IProjectTest.getWorkspace().getRoot().getProject("Project");
        try {
            target.create(this.getMonitor());
            IProjectTest.assertTrue((String)"1.0", (boolean)target.exists());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.1", (Throwable)e);
        }
        IProjectTest.assertFalse((String)"1.2", (boolean)target.isOpen());
        try {
            target.open(this.getMonitor());
            IProjectTest.assertTrue((String)"2.0", (boolean)target.isOpen());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.1", (Throwable)e);
        }
    }

    public void testProjectCreationLineSeparator() throws BackingStoreException, CoreException {
        String newProjectValue;
        String newInstanceValue;
        String systemValue = System.getProperty("line.separator");
        if (systemValue.equals("\n")) {
            newInstanceValue = "\r";
            newProjectValue = "\r\n";
        } else if (systemValue.equals("\r")) {
            newInstanceValue = "\n";
            newProjectValue = "\r\n";
        } else {
            newInstanceValue = "\r";
            newProjectValue = "\n";
        }
        IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
        Preferences instanceNode = rootNode.node("instance").node("org.eclipse.core.runtime");
        String oldInstanceValue = instanceNode.get("line.separator", null);
        IProject project = IProjectTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFile file = project.getFile(".project");
        try {
            this.ensureExistsInWorkspace((IResource)project, true);
            IProjectTest.assertEquals((String)"1.0", (String)systemValue, (String)this.getLineSeparatorFromFile(file));
            instanceNode.put("line.separator", newInstanceValue);
            instanceNode.flush();
            IProjectDescription description = project.getDescription();
            description.setComment("some comment");
            project.setDescription(description, this.getMonitor());
            IProjectTest.assertEquals((String)"2.0", (String)systemValue, (String)this.getLineSeparatorFromFile(file));
            project.delete(true, this.getMonitor());
            this.ensureExistsInWorkspace((IResource)project, true);
            IProjectTest.assertEquals((String)"3.0", (String)newInstanceValue, (String)this.getLineSeparatorFromFile(file));
            if (oldInstanceValue == null) {
                instanceNode.remove("line.separator");
            } else {
                instanceNode.put("line.separator", oldInstanceValue);
            }
            instanceNode.flush();
            description = project.getDescription();
            description.setComment("some comment");
            project.setDescription(description, this.getMonitor());
            IProjectTest.assertEquals((String)"4.0", (String)newInstanceValue, (String)this.getLineSeparatorFromFile(file));
            project.delete(true, this.getMonitor());
            this.ensureExistsInWorkspace((IResource)project, true);
            IProjectTest.assertEquals((String)"5.0", (String)systemValue, (String)this.getLineSeparatorFromFile(file));
            Preferences projectNode = rootNode.node("project").node(project.getName()).node("org.eclipse.core.runtime");
            projectNode.put("line.separator", newProjectValue);
            projectNode.flush();
            file.delete(true, this.getMonitor());
            IProjectTest.assertFalse((String)"6.0", (boolean)file.exists());
            IProjectTest.getWorkspace().save(true, this.getMonitor());
            project.refreshLocal(2, this.getMonitor());
            IProjectTest.assertTrue((String)"7.0", (boolean)file.exists());
            IProjectTest.assertEquals((String)"8.0", (String)newProjectValue, (String)this.getLineSeparatorFromFile(file));
        }
        finally {
            if (oldInstanceValue == null) {
                instanceNode.remove("line.separator");
            } else {
                instanceNode.put("line.separator", oldInstanceValue);
            }
            instanceNode.flush();
            project.delete(true, this.getMonitor());
        }
    }

    public void testProjectCreationInvalidLocation() {
        IProject target = IProjectTest.getWorkspace().getRoot().getProject("Project");
        IProjectDescription description = IProjectTest.getWorkspace().newProjectDescription(target.getName());
        description.setLocation(Platform.getLocation().append(".metadata"));
        try {
            target.create(description, this.getMonitor());
            IProjectTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        target = IProjectTest.getWorkspace().getRoot().getProject(".metadata");
        description = IProjectTest.getWorkspace().newProjectDescription(target.getName());
        try {
            target.create(description, this.getMonitor());
            IProjectTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
        try {
            target.create(this.getMonitor());
            IProjectTest.fail((String)"1.2");
        }
        catch (CoreException coreException) {}
    }

    public void testProjectCreationLocationExistsWithDifferentCase() {
        if (IProjectTest.isWindows()) {
            String projectName = String.valueOf(this.getUniqueString()) + "a";
            IProject project = IProjectTest.getWorkspace().getRoot().getProject(projectName);
            try {
                project.create(this.getMonitor());
                project.delete(false, true, this.getMonitor());
            }
            catch (CoreException coreException) {
                IProjectTest.fail((String)"1.0");
            }
            project = IProjectTest.getWorkspace().getRoot().getProject(projectName.toUpperCase());
            try {
                project.create(this.getMonitor());
                IProjectTest.fail((String)"2.0");
            }
            catch (CoreException coreException) {}
            project = IProjectTest.getWorkspace().getRoot().getProject(projectName);
            try {
                project.create(this.getMonitor());
            }
            catch (CoreException e) {
                IProjectTest.fail((String)"3.0", (Throwable)e);
            }
        }
    }

    public void testProjectDeletionClosedDefaultInSync() {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        IFile otherFile = project.getFile("myotherfile.txt");
        this.ensureExistsInWorkspace(new IResource[]{project, file, otherFile}, true);
        IFileStore projectStore = ((Resource)project).getStore();
        IFileStore fileStore = ((Resource)file).getStore();
        IFileStore otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"1.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"1.2", (boolean)otherFile.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.4", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.5", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.6", (!project.isAccessible() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.7", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.8", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 4, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.9", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.10", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.11", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.12", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.13", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.14", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.15", (!otherFileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace(new IResource[]{project, file, otherFile}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"2.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"2.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"2.2", (boolean)otherFile.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.4", (boolean)project.exists());
        IProjectTest.assertTrue((String)"2.5", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.6", (!project.isAccessible() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.7", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.8", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 4;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.9", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.10", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.11", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.12", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.13", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.14", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.15", (!otherFileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace(new IResource[]{project, file, otherFile}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"3.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"3.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"3.2", (boolean)otherFile.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"3.4", (boolean)project.exists());
        IProjectTest.assertTrue((String)"3.5", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.6", (!project.isAccessible() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.7", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.8", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 8, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.9", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"3.10", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.11", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.12", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.13", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.14", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.15", (boolean)otherFileStore.fetchInfo().exists());
        this.clear(projectStore);
        this.ensureExistsInWorkspace(new IResource[]{project, file, otherFile}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"4.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"4.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"4.2", (boolean)otherFile.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"4.4", (boolean)project.exists());
        IProjectTest.assertTrue((String)"4.5", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.6", (!project.isAccessible() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.7", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.8", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 8;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.9", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"4.10", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.11", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.12", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.13", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.14", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.15", (boolean)otherFileStore.fetchInfo().exists());
        this.clear(projectStore);
        this.ensureExistsInWorkspace(new IResource[]{project, file, otherFile}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"5.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"5.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"5.2", (boolean)otherFile.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"5.4", (boolean)project.exists());
        IProjectTest.assertTrue((String)"5.5", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.6", (!project.isAccessible() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.7", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.8", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 1;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.9", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"5.10", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.11", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.12", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.13", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"5.14", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"5.15", (boolean)otherFileStore.fetchInfo().exists());
        this.clear(projectStore);
        this.ensureExistsInWorkspace(new IResource[]{project, file, otherFile}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"6.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"6.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"6.2", (boolean)otherFile.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"6.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"6.4", (boolean)project.exists());
        IProjectTest.assertTrue((String)"6.5", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.6", (!project.isAccessible() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.7", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.8", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 0;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"6.9", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"6.10", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.11", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.12", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.13", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"6.14", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"6.15", (boolean)otherFileStore.fetchInfo().exists());
        this.clear(projectStore);
    }

    public void testProjectDeletionClosedDefaultOutOfSync() {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        IFile otherFile = project.getFile("myotherfile.txt");
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        IFileStore projectStore = ((Resource)project).getStore();
        IFileStore fileStore = ((Resource)file).getStore();
        IFileStore otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"1.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"1.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.3", (Throwable)e);
        }
        this.createFileInFileSystem(otherFileStore);
        IProjectTest.assertTrue((String)"1.5", (boolean)otherFileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"1.6", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.7", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.8", (!project.isAccessible() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.9", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.10", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 4, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.11", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.12", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.13", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.14", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.15", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.16", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.17", (!otherFileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"2.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"2.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"2.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.3", (Throwable)e);
        }
        this.createFileInFileSystem(otherFileStore);
        IProjectTest.assertTrue((String)"2.5", (boolean)otherFileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"2.6", (boolean)project.exists());
        IProjectTest.assertTrue((String)"2.7", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.8", (!project.isAccessible() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.9", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.10", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 4;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.11", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.12", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.13", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.14", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.15", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.16", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.17", (!otherFileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"3.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"3.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"3.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.3", (Throwable)e);
        }
        this.createFileInFileSystem(otherFileStore);
        IProjectTest.assertTrue((String)"3.5", (boolean)otherFileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.6", (boolean)project.exists());
        IProjectTest.assertTrue((String)"3.7", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.8", (!project.isAccessible() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.9", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.10", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 8, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.11", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"3.12", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.13", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.14", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.15", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.16", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.17", (boolean)otherFileStore.fetchInfo().exists());
        this.clear(projectStore);
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"4.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"4.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"4.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.3", (Throwable)e);
        }
        this.createFileInFileSystem(otherFileStore);
        IProjectTest.assertTrue((String)"4.5", (boolean)otherFileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.6", (boolean)project.exists());
        IProjectTest.assertTrue((String)"4.7", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.8", (!project.isAccessible() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.9", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.10", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 8;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.11", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"4.12", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.13", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.14", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.15", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.16", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.17", (boolean)otherFileStore.fetchInfo().exists());
        this.clear(projectStore);
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"5.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"5.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"5.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.3", (Throwable)e);
        }
        this.createFileInFileSystem(otherFileStore);
        IProjectTest.assertTrue((String)"5.5", (boolean)otherFileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"5.6", (boolean)project.exists());
        IProjectTest.assertTrue((String)"5.7", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.8", (!project.isAccessible() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.9", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.10", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 1;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.11", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"5.12", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.13", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.14", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.15", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"5.16", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"5.17", (boolean)otherFileStore.fetchInfo().exists());
        this.clear(projectStore);
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"6.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"6.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"6.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"6.3", (Throwable)e);
        }
        this.createFileInFileSystem(otherFileStore);
        IProjectTest.assertTrue((String)"6.5", (boolean)otherFileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"6.6", (boolean)project.exists());
        IProjectTest.assertTrue((String)"6.7", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.8", (!project.isAccessible() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.9", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.10", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 0;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"6.11", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"6.12", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.13", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.14", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.15", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"6.16", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"6.17", (boolean)otherFileStore.fetchInfo().exists());
        this.clear(projectStore);
    }

    public void testProjectDeletionClosedUserDefinedInSync() {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        IProjectDescription description = IProjectTest.getWorkspace().newProjectDescription(project.getName());
        IFileStore projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        IFileStore fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"1.2", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.3", (boolean)file.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.4", (Throwable)e);
        }
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 4, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.5", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.6", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.7", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.8", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.9", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.clear(projectStore);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"2.2", (boolean)project.exists());
        IProjectTest.assertTrue((String)"2.3", (boolean)file.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.4", (Throwable)e);
        }
        try {
            int updateFlags = 4;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.5", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.6", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.7", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.8", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.9", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.clear(projectStore);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"3.2", (boolean)project.exists());
        IProjectTest.assertTrue((String)"3.3", (boolean)file.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.4", (Throwable)e);
        }
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 8, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.5", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"3.6", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.7", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.8", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.9", (boolean)fileStore.fetchInfo().exists());
        this.clear(projectStore);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"4.2", (boolean)project.exists());
        IProjectTest.assertTrue((String)"4.3", (boolean)file.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.4", (Throwable)e);
        }
        try {
            int updateFlags = 8;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.5", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"4.6", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.7", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.8", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.9", (boolean)fileStore.fetchInfo().exists());
        this.clear(projectStore);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"5.2", (boolean)project.exists());
        IProjectTest.assertTrue((String)"5.3", (boolean)file.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.4", (Throwable)e);
        }
        try {
            int updateFlags = 1;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.5", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"5.6", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.7", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.8", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"5.9", (boolean)fileStore.fetchInfo().exists());
        this.clear(projectStore);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"6.2", (boolean)project.exists());
        IProjectTest.assertTrue((String)"6.3", (boolean)file.exists());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"6.4", (Throwable)e);
        }
        try {
            int updateFlags = 0;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"6.5", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"6.6", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.7", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.8", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"6.9", (boolean)fileStore.fetchInfo().exists());
        this.clear(projectStore);
    }

    public void testProjectDeletionClosedUserDefinedOutOfSync() {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        IFile otherFile = project.getFile("myotherfile.txt");
        IProjectDescription description = IProjectTest.getWorkspace().newProjectDescription(project.getName());
        IFileStore projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        this.ensureExistsInFileSystem(otherFile);
        IFileStore fileStore = ((Resource)file).getStore();
        IFileStore otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"1.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"1.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.3", (Throwable)e);
        }
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 4, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.5", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.6", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.7", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.8", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.9", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.10", (!otherFileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.clear(projectStore);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        this.ensureExistsInFileSystem(otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"2.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"2.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"2.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.3", (Throwable)e);
        }
        try {
            int updateFlags = 4;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.5", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.6", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.7", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.8", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.9", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.10", (!otherFileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.clear(projectStore);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        this.ensureExistsInFileSystem(otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"3.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"3.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"3.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.3", (Throwable)e);
        }
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 8, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"3.5", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.6", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.7", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.8", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.9", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.10", (boolean)otherFileStore.fetchInfo().exists());
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        this.ensureExistsInFileSystem(otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"4.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"4.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"4.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.3", (Throwable)e);
        }
        try {
            int updateFlags = 8;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"4.5", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.6", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.7", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.8", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.9", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.10", (boolean)otherFileStore.fetchInfo().exists());
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        this.ensureExistsInFileSystem(otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"5.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"5.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"5.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.3", (Throwable)e);
        }
        try {
            int updateFlags = 1;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"5.5", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.6", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.7", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.8", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"5.9", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"5.10", (boolean)otherFileStore.fetchInfo().exists());
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        this.ensureExistsInFileSystem(otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"6.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"6.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"6.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"6.3", (Throwable)e);
        }
        try {
            int updateFlags = 0;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"6.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"6.5", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.6", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.7", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.8", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"6.9", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"6.10", (boolean)otherFileStore.fetchInfo().exists());
        this.clear(projectStore);
    }

    public void testProjectDeletionOpenDefaultInSync() {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        IFileStore projectStore = ((Resource)project).getStore();
        IFileStore fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"1.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.1", (boolean)file.exists());
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 4, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.2", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.3", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.4", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.5", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.6", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"2.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"2.1", (boolean)file.exists());
        try {
            int updateFlags = 4;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.2", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.3", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.4", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.5", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.6", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"3.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"3.1", (boolean)file.exists());
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 8, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.2", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"3.3", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.4", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.5", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.6", (boolean)fileStore.fetchInfo().exists());
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"4.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"4.1", (boolean)file.exists());
        try {
            int updateFlags = 8;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.2", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"4.3", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.4", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.5", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.6", (boolean)fileStore.fetchInfo().exists());
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"5.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"5.1", (boolean)file.exists());
        try {
            int updateFlags = 1;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.2", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"5.3", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.4", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.5", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.6", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"6.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"6.1", (boolean)file.exists());
        try {
            int updateFlags = 0;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"6.2", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"6.3", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.4", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.5", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.6", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
    }

    public void testProjectDeletionOpenDefaultOutOfSync() {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInFileSystem(file);
        IFileStore projectStore = ((Resource)project).getStore();
        IFileStore fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"1.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.1", (!file.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 4, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.2", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.3", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.4", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.5", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.6", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInFileSystem(file);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"2.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"2.1", (!file.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 4;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.2", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.3", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.4", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.5", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.6", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInFileSystem(file);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"3.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"3.1", (!file.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 8, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.2", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"3.3", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.4", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.5", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.6", (boolean)fileStore.fetchInfo().exists());
        this.clear(projectStore);
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInFileSystem(file);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"4.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"4.1", (!file.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 8;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.2", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"4.3", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.4", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.5", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.6", (boolean)fileStore.fetchInfo().exists());
        this.clear(projectStore);
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInFileSystem(file);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"5.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"5.1", (!file.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 1;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.2", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"5.3", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.4", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.5", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.6", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInFileSystem(file);
        projectStore = ((Resource)project).getStore();
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"6.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"6.1", (!file.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 0;
            project.delete(updateFlags, this.getMonitor());
            IProjectTest.fail((String)"6.2");
        }
        catch (CoreException coreException) {}
        IProjectTest.assertTrue((String)"6.3", (boolean)project.exists());
        IProjectTest.assertTrue((String)"6.4", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.5", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"6.6", (boolean)fileStore.fetchInfo().exists());
    }

    public void testProjectDeletionOpenUserDefinedInSync() {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("myfile.txt");
        IProjectDescription description = IProjectTest.getWorkspace().newProjectDescription(project.getName());
        IFileStore projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        IFileStore fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"1.2", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.3", (boolean)file.exists());
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 4, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.5", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.6", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.7", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.8", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"2.2", (boolean)project.exists());
        IProjectTest.assertTrue((String)"2.3", (boolean)file.exists());
        try {
            int updateFlags = 4;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.5", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.6", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.7", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.8", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"3.2", (boolean)project.exists());
        IProjectTest.assertTrue((String)"3.3", (boolean)file.exists());
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 8, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"3.5", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.6", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.7", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.8", (boolean)fileStore.fetchInfo().exists());
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"4.2", (boolean)project.exists());
        IProjectTest.assertTrue((String)"4.3", (boolean)file.exists());
        try {
            int updateFlags = 8;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"4.5", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.6", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.7", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.8", (boolean)fileStore.fetchInfo().exists());
        this.clear(projectStore);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"5.2", (boolean)project.exists());
        IProjectTest.assertTrue((String)"5.3", (boolean)file.exists());
        try {
            int updateFlags = 1;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"5.5", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.6", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.7", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.8", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        fileStore = ((Resource)file).getStore();
        IProjectTest.assertTrue((String)"6.2", (boolean)project.exists());
        IProjectTest.assertTrue((String)"6.3", (boolean)file.exists());
        try {
            int updateFlags = 0;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"6.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"6.5", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.6", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.7", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.8", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
    }

    public void testProjectDeletionOpenUserDefinedOutOfSync() {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("testProjectDeletionOpenUserDefinedOutOfSync");
        IFile file = project.getFile("myfile.txt");
        IFile otherFile = project.getFile("myotherfile.txt");
        IProjectDescription description = IProjectTest.getWorkspace().newProjectDescription(project.getName());
        IFileStore projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        this.ensureExistsInFileSystem(otherFile);
        IFileStore fileStore = ((Resource)file).getStore();
        IFileStore otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"1.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"1.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 4, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.4", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.5", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.6", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.7", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.8", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.9", (!otherFileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.clear(projectStore);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        this.ensureExistsInFileSystem(otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"2.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"2.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"2.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 4;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.4", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.5", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.6", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.7", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.8", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.9", (!otherFileStore.fetchInfo().exists() ? 1 : 0) != 0);
        this.clear(projectStore);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        this.ensureExistsInFileSystem(otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"3.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"3.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"3.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 1;
            project.delete(updateFlags |= 8, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"3.4", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.5", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.6", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"3.7", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.8", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"3.9", (boolean)otherFileStore.fetchInfo().exists());
        this.clear(projectStore);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        this.ensureExistsInFileSystem(otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"4.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"4.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"4.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 8;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"4.4", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.5", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.6", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.7", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.8", (boolean)fileStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"4.9", (boolean)otherFileStore.fetchInfo().exists());
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        this.ensureExistsInFileSystem(otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"5.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"5.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"5.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 1;
            project.delete(updateFlags, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"5.4", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.5", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.6", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.7", (!projectStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.8", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"5.9", (!otherFileStore.fetchInfo().exists() ? 1 : 0) != 0);
        projectStore = this.getTempStore();
        description.setLocationURI(projectStore.toURI());
        this.ensureExistsInWorkspace(project, description);
        this.ensureExistsInWorkspace((IResource)file, true);
        this.ensureExistsInFileSystem(otherFile);
        fileStore = ((Resource)file).getStore();
        otherFileStore = ((Resource)otherFile).getStore();
        IProjectTest.assertTrue((String)"6.0", (boolean)project.exists());
        IProjectTest.assertTrue((String)"6.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"6.2", (!otherFile.exists() ? 1 : 0) != 0);
        try {
            int updateFlags = 0;
            project.delete(updateFlags, this.getMonitor());
            IProjectTest.fail((String)"6.3");
        }
        catch (CoreException coreException) {}
        IProjectTest.assertTrue((String)"6.4", (boolean)project.exists());
        IProjectTest.assertTrue((String)"6.5", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.6", (!otherFile.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.7", (boolean)projectStore.fetchInfo().exists());
        IProjectTest.assertTrue((String)"6.8", (!fileStore.fetchInfo().exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"6.9", (boolean)otherFileStore.fetchInfo().exists());
    }

    public void testProjectDescriptionDynamic() {
        IProjectDescription desc = IProjectTest.getWorkspace().newProjectDescription("foo");
        IProject project1 = IProjectTest.getWorkspace().getRoot().getProject("P1");
        IProject project2 = IProjectTest.getWorkspace().getRoot().getProject("P2");
        IProjectTest.assertEquals((String)"2.0", (int)0, (int)desc.getDynamicReferences().length);
        IProject[] refs = new IProject[]{project1, project2};
        desc.setDynamicReferences(refs);
        IProject[] result = desc.getDynamicReferences();
        IProjectTest.assertEquals((String)"2.1", (int)2, (int)result.length);
        IProjectTest.assertEquals((String)"2.2", (Object)project1, (Object)result[0]);
        IProjectTest.assertEquals((String)"2.3", (Object)project2, (Object)result[1]);
        result[0] = null;
        result[1] = null;
        result = desc.getDynamicReferences();
        IProjectTest.assertEquals((String)"2.4", (int)2, (int)result.length);
        IProjectTest.assertEquals((String)"2.5", (Object)project1, (Object)result[0]);
        IProjectTest.assertEquals((String)"2.6", (Object)project2, (Object)result[1]);
        refs = new IProject[]{project1, project2, project2, project1, project1};
        desc.setDynamicReferences(refs);
        result = desc.getDynamicReferences();
        IProjectTest.assertEquals((String)"3.1", (int)2, (int)result.length);
        IProjectTest.assertEquals((String)"3.2", (Object)project1, (Object)result[0]);
        IProjectTest.assertEquals((String)"3.3", (Object)project2, (Object)result[1]);
    }

    public void testProjectDescriptionReferences() {
        IProjectDescription desc = IProjectTest.getWorkspace().newProjectDescription("foo");
        IProject project1 = IProjectTest.getWorkspace().getRoot().getProject("P1");
        IProject project2 = IProjectTest.getWorkspace().getRoot().getProject("P2");
        IProjectTest.assertEquals((String)"1.0", (String)"foo", (String)desc.getName());
        IProjectTest.assertEquals((String)"2.0", (int)0, (int)desc.getReferencedProjects().length);
        IProject[] refs = new IProject[]{project1, project2};
        desc.setReferencedProjects(refs);
        IProject[] result = desc.getReferencedProjects();
        IProjectTest.assertEquals((String)"2.1", (int)2, (int)result.length);
        IProjectTest.assertEquals((String)"2.2", (Object)project1, (Object)result[0]);
        IProjectTest.assertEquals((String)"2.3", (Object)project2, (Object)result[1]);
        result[0] = null;
        result[1] = null;
        result = desc.getReferencedProjects();
        IProjectTest.assertEquals((String)"2.4", (int)2, (int)result.length);
        IProjectTest.assertEquals((String)"2.5", (Object)project1, (Object)result[0]);
        IProjectTest.assertEquals((String)"2.6", (Object)project2, (Object)result[1]);
        refs = new IProject[]{project1, project2, project2, project1, project1};
        desc.setReferencedProjects(refs);
        result = desc.getReferencedProjects();
        IProjectTest.assertEquals((String)"3.1", (int)2, (int)result.length);
        IProjectTest.assertEquals((String)"3.2", (Object)project1, (Object)result[0]);
        IProjectTest.assertEquals((String)"3.3", (Object)project2, (Object)result[1]);
    }

    public void testProjectLocationValidation() {
        IProject project1 = IProjectTest.getWorkspace().getRoot().getProject("Project1");
        IPath root = IProjectTest.getWorkspace().getRoot().getLocation().removeLastSegments(1).append("temp");
        IPath path = root.append("foo");
        IProjectTest.assertTrue((String)"1.0", (boolean)IProjectTest.getWorkspace().validateProjectLocation(project1, path).isOK());
        path = Platform.getLocation().append(project1.getName());
        IProjectTest.assertTrue((String)"1.1", (!IProjectTest.getWorkspace().validateProjectLocation(project1, path).isOK() ? 1 : 0) != 0);
        try {
            project1.create(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.2", (Throwable)e);
        }
        IProjectDescription desc = IProjectTest.getWorkspace().newProjectDescription("Project2");
        IProject project2 = IProjectTest.getWorkspace().getRoot().getProject("Project2");
        path = root.append("project2");
        IProjectTest.assertTrue((String)"2.0", (boolean)IProjectTest.getWorkspace().validateProjectLocation(project2, path).isOK());
        desc.setLocation(path);
        try {
            project2.create(desc, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.1", (Throwable)e);
        }
        IProject project3 = IProjectTest.getWorkspace().getRoot().getProject("Project3");
        try {
            project3.create(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.0", (Throwable)e);
        }
        path = root.append("project3");
        IProjectTest.assertTrue((String)"3.1", (boolean)IProjectTest.getWorkspace().validateProjectLocation(project3, path).isOK());
        IProjectTest.assertTrue((String)"4.0", (boolean)IProjectTest.getWorkspace().validateProjectLocation(project3, root).isOK());
        IProjectTest.assertTrue((String)"4.1", (!IProjectTest.getWorkspace().validateProjectLocation(project3, root.append("project2")).isOK() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"4.2", (boolean)IProjectTest.getWorkspace().validateProjectLocation(project3, root.append("project2/foo")).isOK());
        IProjectTest.assertTrue((String)"4.3", (boolean)IProjectTest.getWorkspace().validateProjectLocation(project3, null).isOK());
        IProjectTest.assertTrue((String)"4.4", (boolean)IProjectTest.getWorkspace().validateProjectLocation(project3, root.append("%20foo")).isOK());
        try {
            project1.delete(true, this.getMonitor());
            project2.delete(true, this.getMonitor());
            project3.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"20.1", (Throwable)e);
        }
    }

    public void testProjectLocationWithEscapes() {
        IProject project1 = IProjectTest.getWorkspace().getRoot().getProject("Project1");
        IPath root = IProjectTest.getWorkspace().getRoot().getLocation().removeLastSegments(1).append("temp");
        IPath location = root.append("%20foo bar");
        IProjectDescription desc = IProjectTest.getWorkspace().newProjectDescription(project1.getName());
        desc.setLocation(location);
        try {
            try {
                project1.create(desc, this.getMonitor());
                project1.open(null);
                IProjectTest.assertTrue((String)"1.0", (boolean)project1.exists());
                IProjectTest.assertTrue((String)"1.1", (boolean)project1.isAccessible());
                IProjectTest.assertEquals((String)"1.2", (Object)location, (Object)project1.getLocation());
                IProjectTest.assertEquals((String)"1.3", (Object)location, (Object)project1.getRawLocation());
                project1.delete(1, this.getMonitor());
            }
            catch (CoreException e) {
                IProjectTest.fail((String)"1.99", (Throwable)e);
                Workspace.clear((File)location.toFile());
            }
        }
        finally {
            Workspace.clear((File)location.toFile());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void testProjectMoveContent() {
        project = IProjectTest.getWorkspace().getRoot().getProject("MyProject");
        children = new String[]{"/1/", "/1/2"};
        resources = this.buildResources((IContainer)project, children);
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace(resources, true);
        pathsToDelete = new HashSet<IPath>(5);
        try {
            destination = null;
            try {
                destination = project.getDescription();
            }
            catch (CoreException e) {
                IProjectTest.fail((String)"1.0", (Throwable)e);
            }
            oldPath = project.getLocation();
            newPath = this.getTempDir().append(Long.toString(System.currentTimeMillis()));
            pathsToDelete.add(newPath);
            destination.setLocation(newPath);
            try {
                project.move(destination, false, this.getMonitor());
            }
            catch (CoreException e) {
                IProjectTest.fail((String)"1.1", (Throwable)e);
            }
            newPath = project.getLocation();
            IProjectTest.assertTrue((String)"2.0", (boolean)(oldPath.equals((Object)newPath) == false));
            visitor = new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    IProjectTest.this.assertExistsInWorkspace("2.1." + resource.getFullPath(), resource);
                    return true;
                }
            };
            try {
                IProjectTest.getWorkspace().getRoot().accept(visitor);
            }
            catch (CoreException e) {
                IProjectTest.fail((String)"2.2", (Throwable)e);
            }
        }
        finally {
            i = pathsToDelete.iterator();
            ** while (i.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            Workspace.clear((File)((IPath)i.next()).toFile());
            continue;
        }
lbl39:
        // 1 sources

    }

    public void testProjectMoveVariations() {
        IProject project;
        IMarker[] markers = null;
        String actual = null;
        QualifiedName qname = new QualifiedName("com.example", "myProperty");
        String value = "this is my property value.";
        IProject source = project = IProjectTest.getWorkspace().getRoot().getProject("SourceProject");
        String[] children = new String[]{"/1/", "/1/2"};
        IResource[] resources = this.buildResources((IContainer)project, children);
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace(resources, true);
        IProject destination = IProjectTest.getWorkspace().getRoot().getProject("DestProject");
        this.assertDoesNotExistInWorkspace("1.0", (IResource)destination);
        IResource sourceChild = resources[1];
        try {
            sourceChild.setPersistentProperty(qname, value);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            sourceChild.createMarker("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.2", (Throwable)e);
        }
        try {
            source.move(destination.getFullPath(), false, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.3", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("1.4", (IResource)project);
        this.assertDoesNotExistInWorkspace("1.5", resources);
        resources = this.buildResources((IContainer)destination, children);
        this.assertExistsInWorkspace("1.6", (IResource)destination);
        this.assertExistsInWorkspace("1.7", resources);
        IResource destChild = resources[1];
        try {
            actual = destChild.getPersistentProperty(qname);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.6", (Throwable)e);
        }
        IProjectTest.assertNotNull((String)"1.7", (Object)actual);
        IProjectTest.assertEquals((String)"1.8", (String)value, (String)actual);
        try {
            markers = destChild.findMarkers(null, true, 0);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.9", (Throwable)e);
        }
        IProjectTest.assertEquals((String)"1.10", (int)1, (int)markers.length);
        try {
            IProjectTest.getWorkspace().getRoot().delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.11", (Throwable)e);
        }
        source = project = IProjectTest.getWorkspace().getRoot().getProject("SourceProject");
        children = new String[]{"/1/", "/1/2"};
        resources = this.buildResources((IContainer)project, children);
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace(resources, true);
        sourceChild = resources[1];
        try {
            sourceChild.setPersistentProperty(qname, value);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.1", (Throwable)e);
        }
        try {
            sourceChild.createMarker("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.2", (Throwable)e);
        }
        destination = IProjectTest.getWorkspace().getRoot().getProject("DestProject");
        IProjectDescription description = IProjectTest.getWorkspace().newProjectDescription(destination.getName());
        this.assertDoesNotExistInWorkspace("2.3", (IResource)destination);
        try {
            source.move(description, false, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.4", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("2.5", (IResource)project);
        this.assertDoesNotExistInWorkspace("2.6", resources);
        resources = this.buildResources((IContainer)destination, children);
        this.assertExistsInWorkspace("2.7", (IResource)destination);
        this.assertExistsInWorkspace("2.8", resources);
        destChild = resources[1];
        try {
            actual = destChild.getPersistentProperty(qname);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.9", (Throwable)e);
        }
        IProjectTest.assertNotNull((String)"2.10", (Object)actual);
        IProjectTest.assertEquals((String)"2.11", (String)value, (String)actual);
        try {
            markers = destChild.findMarkers(null, true, 0);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.12", (Throwable)e);
        }
        IProjectTest.assertEquals((String)"2.13", (int)1, (int)markers.length);
        try {
            IProjectTest.getWorkspace().getRoot().delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.14", (Throwable)e);
        }
        source = project = IProjectTest.getWorkspace().getRoot().getProject("SourceProject");
        IProject destProject = IProjectTest.getWorkspace().getRoot().getProject("DestProject");
        destination = destProject.getFolder("MyFolder");
        try {
            source.move(destination.getFullPath(), true, this.getMonitor());
            IProjectTest.fail((String)"3.3");
        }
        catch (CoreException coreException) {}
        project = IProjectTest.getWorkspace().getRoot().getProject("MySourceProject");
        children = new String[]{"/1/", "/1/2"};
        source = project.getFolder("1");
        resources = this.buildResources((IContainer)project, children);
        destination = IProjectTest.getWorkspace().getRoot().getProject("MyDestProject");
        try {
            source.move(destination.getFullPath(), true, this.getMonitor());
            IProjectTest.fail((String)"4.3");
        }
        catch (CoreException coreException) {}
    }

    public void testProjectMoveVariations_bug307140() {
        IProjectDescription description;
        IProject project = IProjectTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.0", (Throwable)e);
        }
        IPath originalLocation = project.getLocation();
        IFolder subFolder = project.getFolder(this.getUniqueString());
        try {
            description = project.getDescription();
            description.setLocation(subFolder.getLocation());
            project.move(description, true, this.getMonitor());
            IProjectTest.fail((String)"2.0");
        }
        catch (CoreException coreException) {}
        IProjectTest.assertEquals((String)"3.0", (Object)originalLocation, (Object)project.getLocation());
        try {
            IProjectTest.getWorkspace().getRoot().delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"4.0", (Throwable)e);
        }
        project = IProjectTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        description = IProjectTest.getWorkspace().newProjectDescription(project.getName());
        description.setLocation(this.getRandomLocation());
        try {
            project.create(description, this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"5.0", (Throwable)e);
        }
        originalLocation = project.getLocation();
        subFolder = project.getFolder(this.getUniqueString());
        try {
            description = project.getDescription();
            description.setLocation(subFolder.getLocation());
            project.move(description, true, this.getMonitor());
            IProjectTest.fail((String)"6.0");
        }
        catch (CoreException coreException) {}
        IProjectTest.assertEquals((String)"7.0", (Object)originalLocation, (Object)project.getLocation());
    }

    public void testRenameExternalProject() {
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("SourceProject");
        String[] children = new String[]{"/1/", "/1/2"};
        IResource[] resources = this.buildResources((IContainer)project, children);
        IProjectDescription description = IProjectTest.getWorkspace().newProjectDescription(project.getName());
        description.setLocationURI(this.getTempStore().toURI());
        try {
            project.create(description, this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.1", (Throwable)e);
        }
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace(resources, true);
        IResource sourceChild = resources[1];
        QualifiedName qname = new QualifiedName("com.example", "myProperty");
        String propertyValue = "this is my property value.";
        String actualPropertyValue = null;
        try {
            sourceChild.setPersistentProperty(qname, propertyValue);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.1", (Throwable)e);
        }
        try {
            sourceChild.createMarker("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.2", (Throwable)e);
        }
        IProject destination = IProjectTest.getWorkspace().getRoot().getProject("DestProject");
        description.setName(destination.getName());
        this.assertDoesNotExistInWorkspace("2.3", (IResource)destination);
        try {
            project.move(description, false, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.4", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("2.5", (IResource)project);
        this.assertDoesNotExistInWorkspace("2.6", resources);
        resources = this.buildResources((IContainer)destination, children);
        this.assertExistsInWorkspace("2.7", (IResource)destination);
        this.assertExistsInWorkspace("2.8", resources);
        IResource destChild = resources[1];
        try {
            actualPropertyValue = destChild.getPersistentProperty(qname);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.9", (Throwable)e);
        }
        IProjectTest.assertNotNull((String)"2.10", (Object)actualPropertyValue);
        IProjectTest.assertEquals((String)"2.11", (String)propertyValue, (String)actualPropertyValue);
        IMarker[] markers = null;
        try {
            markers = destChild.findMarkers(null, true, 0);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.12", (Throwable)e);
        }
        IProjectTest.assertEquals((String)"2.13", (int)1, (int)markers.length);
        try {
            IProjectTest.getWorkspace().getRoot().delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.14", (Throwable)e);
        }
    }

    public void testReplaceLocation() {
        IProjectDescription description;
        IProject target = IProjectTest.getWorkspace().getRoot().getProject("testReplaceLocation");
        this.ensureExistsInWorkspace((IResource)target, true);
        IFileStore projectStore = this.getTempStore();
        IFileStore childFile = projectStore.getChild("File.txt");
        IFolder folder = target.getFolder("Folder");
        IFile file = folder.getFile("File.txt");
        this.ensureExistsInWorkspace((IResource)file, true);
        IFile newFile = target.getFile(childFile.getName());
        this.createFileInFileSystem(childFile);
        try {
            description = target.getDescription();
            description.setLocationURI(projectStore.toURI());
            target.move(description, 256, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.99", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.0", (!folder.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.1", (!file.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"2.2", (boolean)newFile.exists());
        try {
            description = target.getDescription();
            description.setLocationURI(null);
            target.move(description, 256, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.99", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"3.0", (boolean)folder.exists());
        IProjectTest.assertTrue((String)"3.1", (boolean)file.exists());
        IProjectTest.assertTrue((String)"3.2", (!newFile.exists() ? 1 : 0) != 0);
    }

    public void testSetGetProjectPersistentProperty() {
        IProject target = IProjectTest.getWorkspace().getRoot().getProject("Project");
        this.ensureExistsInWorkspace((IResource)target, true);
        try {
            this.setGetPersistentProperty((IResource)target);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.0", (Throwable)e);
        }
    }

    public void testWorkspaceNotificationClose() {
        final int[] count = new int[1];
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IProjectTest.assertEquals((String)"1.0", (int)2, (int)event.getType());
                count[0] = count[0] + 1;
                IProjectTest.assertEquals((String)"1.1", (int)4, (int)event.getResource().getType());
                IProjectTest.assertTrue((String)"1.2", (boolean)event.getResource().exists());
                IProjectTest.assertTrue((String)"1.3", (boolean)((IProject)event.getResource()).isOpen());
            }
        };
        IProjectTest.getWorkspace().addResourceChangeListener(listener, 2);
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.4", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.5", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.6", (boolean)project.isOpen());
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.7", (Throwable)e);
        }
        IProjectTest.assertEquals((String)"1.8", (int)1, (int)count[0]);
        IProjectTest.assertTrue((String)"1.9", (boolean)project.exists());
        IProjectTest.assertTrue((String)"1.10", (!project.isOpen() ? 1 : 0) != 0);
        IProjectTest.getWorkspace().removeResourceChangeListener(listener);
    }

    public void testWorkspaceNotificationDelete() {
        final int[] count = new int[1];
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IProjectTest.assertEquals((String)"1.0", (int)4, (int)event.getType());
                count[0] = count[0] + 1;
                IProjectTest.assertEquals((String)"1.1", (int)4, (int)event.getResource().getType());
                IProjectTest.assertTrue((String)"1.2", (boolean)event.getResource().exists());
            }
        };
        IProjectTest.getWorkspace().addResourceChangeListener(listener, 4);
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.4", (boolean)project.exists());
        try {
            project.delete(1, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.5", (Throwable)e);
        }
        IProjectTest.assertEquals((String)"1.6", (int)1, (int)count[0]);
        IProjectTest.assertTrue((String)"1.7", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.getWorkspace().removeResourceChangeListener(listener);
    }

    public void testWorkspaceNotificationMove() {
        final int[] count = new int[1];
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IProjectTest.assertEquals((String)"1.0", (int)4, (int)event.getType());
                count[0] = count[0] + 1;
                IProjectTest.assertEquals((String)"1.1", (int)4, (int)event.getResource().getType());
                IProjectTest.assertTrue((String)"1.2", (boolean)event.getResource().exists());
            }
        };
        IProjectTest.getWorkspace().addResourceChangeListener(listener, 4);
        IProject project = IProjectTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.3", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"1.4", (boolean)project.exists());
        try {
            project.move((IPath)new Path("MyNewProject"), 1, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.5", (Throwable)e);
        }
        IProjectTest.assertEquals((String)"1.6", (int)1, (int)count[0]);
        IProjectTest.assertTrue((String)"1.7", (!project.exists() ? 1 : 0) != 0);
        IProjectTest.getWorkspace().removeResourceChangeListener(listener);
    }

    public void testCreateHiddenProject() {
        IProject hiddenProject = IProjectTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        this.ensureDoesNotExistInWorkspace((IResource)hiddenProject);
        try {
            hiddenProject.create(null, 4096, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"1.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"2.0", (boolean)hiddenProject.isHidden());
        try {
            hiddenProject.delete(false, this.getMonitor());
            hiddenProject.create(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"3.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"4.0", (!hiddenProject.isHidden() ? 1 : 0) != 0);
    }

    public void testProjectDeletion_Bug347220() throws CoreException {
        String projectName = this.getUniqueString();
        IProject project = IProjectTest.getWorkspace().getRoot().getProject(projectName);
        IFolder folder = project.getFolder(this.getUniqueString());
        IFile file = folder.getFile(this.getUniqueString());
        this.ensureExistsInWorkspace(new IResource[]{project, folder, file}, true);
        project.open(this.getMonitor());
        file.setContents((InputStream)new ByteArrayInputStream(this.getRandomString().getBytes()), true, true, this.getMonitor());
        project.delete(true, this.getMonitor());
        IPath p = ((Workspace)IProjectTest.getWorkspace()).getMetaArea().locationFor((IResource)project);
        IProjectTest.assertFalse((String)"1.0", (boolean)p.toFile().exists());
        IProject otherProject = IProjectTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        this.ensureExistsInWorkspace(new IResource[]{otherProject}, true);
        otherProject.open(this.getMonitor());
        IProjectDescription desc = IProjectTest.getWorkspace().newProjectDescription(projectName);
        try {
            otherProject.move(desc, true, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"2.0", (Throwable)e);
        }
    }
}

