/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.TestingSupport;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.internal.resources.TestActivator;
import org.eclipse.core.tests.resources.ResourceTest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class IWorkspaceTest
extends ResourceTest {
    public IWorkspaceTest() {
    }

    public IWorkspaceTest(String name) {
        super(name);
    }

    public String[] defineHierarchy() {
        return new String[]{"/", "/Project/", "/Project/Folder/", "/Project/Folder/File"};
    }

    protected IProjectNatureDescriptor findNature(IProjectNatureDescriptor[] descriptors, String id) {
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getNatureId().equals(id)) {
                return descriptors[i];
            }
            ++i;
        }
        return null;
    }

    public static Test suite() {
        return new TestSuite(IWorkspaceTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        IWorkspaceTest.getWorkspace().getRoot().refreshLocal(2, null);
        this.ensureDoesNotExistInWorkspace((IResource)IWorkspaceTest.getWorkspace().getRoot());
        super.tearDown();
    }

    public void testCancelRunnable() {
        boolean cancelled = false;
        try {
            IWorkspaceTest.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    throw new OperationCanceledException();
                }
            }, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"1.0", (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            cancelled = true;
        }
        IWorkspaceTest.assertTrue((String)"2.0", (boolean)cancelled);
    }

    public void testCopy() throws CoreException {
        IResource[] resources = this.buildResources();
        IProject project = (IProject)resources[1];
        IFolder folder = (IFolder)resources[2];
        IFile file = (IFile)resources[3];
        IFile file2 = folder.getFile("File2");
        IFile file3 = folder.getFile("File3");
        IFolder folder2 = project.getFolder("Folder2");
        IFolder folderCopy = folder2.getFolder("Folder");
        IFile fileCopy = folder2.getFile("File");
        IFile file2Copy = folder2.getFile("File2");
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[]{file}, folder.getFullPath(), false, this.getMonitor());
            IWorkspaceTest.fail((String)"0.0");
        }
        catch (CoreException coreException) {}
        this.createHierarchy();
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[]{file}, folder2.getFullPath().append("figment"), false, this.getMonitor());
            IWorkspaceTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[]{file}, folder2.getFullPath(), false, this.getMonitor());
            IWorkspaceTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
        try {
            folder2.create(false, true, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"1.2", (Throwable)e);
        }
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[]{file2}, folder2.getFullPath(), false, this.getMonitor());
            IWorkspaceTest.fail((String)"1.3");
        }
        catch (CoreException coreException) {}
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[]{file, file2}, folder2.getFullPath(), false, this.getMonitor());
            IWorkspaceTest.fail((String)"1.4");
        }
        catch (CoreException coreException) {}
        IWorkspaceTest.assertTrue((String)"1.5", (boolean)fileCopy.exists());
        try {
            fileCopy.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"1.6", (Throwable)e);
        }
        IFile projectFile = project.getFile("ProjectPhile");
        try {
            file2.create(this.getRandomContents(), false, this.getMonitor());
            file3.create(this.getRandomContents(), false, this.getMonitor());
            projectFile.create(this.getRandomContents(), false, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"1.7", (Throwable)e);
        }
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[]{file, projectFile}, folder2.getFullPath(), false, this.getMonitor());
            IWorkspaceTest.fail((String)"1.8");
        }
        catch (CoreException coreException) {}
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[]{file, file2, file}, folder2.getFullPath(), false, this.getMonitor());
            IWorkspaceTest.fail((String)"1.9");
        }
        catch (CoreException coreException) {}
        try {
            IFolder folder3 = folder2.getFolder("Folder3");
            folder3.create(false, true, this.getMonitor());
            IWorkspaceTest.getWorkspace().copy(new IResource[]{folder2}, folder3.getFullPath(), false, this.getMonitor());
            IWorkspaceTest.fail((String)"2.0");
        }
        catch (CoreException coreException) {}
        try {
            file2Copy.create(this.getRandomContents(), false, this.getMonitor());
            IWorkspaceTest.getWorkspace().copy(new IResource[]{file, file2}, folder2.getFullPath(), false, this.getMonitor());
            IWorkspaceTest.fail((String)"2.1");
        }
        catch (CoreException coreException) {}
        this.ensureDoesNotExistInWorkspace((IResource)file2Copy);
        this.ensureDoesNotExistInFileSystem((IResource)file2Copy);
        fileCopy = folder2.getFile("File");
        IWorkspaceTest.assertTrue((String)"2.2", (boolean)fileCopy.exists());
        try {
            fileCopy.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"2.3", (Throwable)e);
        }
        this.ensureOutOfSync(file);
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[]{file}, folder2.getFullPath(), false, this.getMonitor());
            IWorkspaceTest.fail((String)"2.5");
        }
        catch (CoreException coreException) {}
        file.refreshLocal(0, null);
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[0], folder2.getFullPath(), false, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"3.0", (Throwable)e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            IWorkspaceTest.fail((String)"Fails because of 1FTXL69", (Throwable)e);
        }
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[]{file}, folder2.getFullPath(), false, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"3.1", (Throwable)e);
        }
        IWorkspaceTest.assertTrue((String)"3.2", (boolean)fileCopy.exists());
        this.ensureDoesNotExistInWorkspace((IResource)fileCopy);
        this.ensureDoesNotExistInFileSystem((IResource)fileCopy);
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[]{file, file2}, folder2.getFullPath(), false, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"3.3", (Throwable)e);
        }
        IWorkspaceTest.assertTrue((String)"3.4", (boolean)fileCopy.exists());
        IWorkspaceTest.assertTrue((String)"3.5", (boolean)file2Copy.exists());
        this.ensureDoesNotExistInWorkspace((IResource)fileCopy);
        this.ensureDoesNotExistInWorkspace((IResource)file2Copy);
        this.ensureDoesNotExistInFileSystem((IResource)fileCopy);
        this.ensureDoesNotExistInFileSystem((IResource)file2Copy);
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[]{folder}, folder2.getFullPath(), false, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"3.6", (Throwable)e);
        }
        IWorkspaceTest.assertTrue((String)"3.7", (boolean)folderCopy.exists());
        try {
            IWorkspaceTest.assertTrue((String)"3.8", (folderCopy.members().length > 0 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"3.9", (Throwable)e);
        }
        this.ensureDoesNotExistInWorkspace((IResource)folderCopy);
        this.ensureDoesNotExistInFileSystem((IResource)folderCopy);
    }

    public void testDelete() throws CoreException {
        IResource[] resources = this.buildResources();
        IProject project = (IProject)resources[1];
        IFolder folder = (IFolder)resources[2];
        IFile file = (IFile)resources[3];
        IWorkspaceTest.assertTrue((boolean)IWorkspaceTest.getWorkspace().delete(new IResource[]{project, folder, file}, false, this.getMonitor()).isOK());
        IWorkspaceTest.assertTrue((boolean)IWorkspaceTest.getWorkspace().delete(new IResource[]{file}, false, this.getMonitor()).isOK());
        IWorkspaceTest.assertTrue((boolean)IWorkspaceTest.getWorkspace().delete(new IResource[0], false, this.getMonitor()).isOK());
        this.createHierarchy();
        resources = new IResource[]{file, project, folder};
        IWorkspaceTest.assertTrue((boolean)IWorkspaceTest.getWorkspace().delete(resources, false, this.getMonitor()).isOK());
        this.assertDoesNotExistInWorkspace(resources);
        this.createHierarchy();
        resources = new IResource[]{file};
        IWorkspaceTest.assertTrue((boolean)IWorkspaceTest.getWorkspace().delete(resources, false, this.getMonitor()).isOK());
        this.assertDoesNotExistInFileSystem(resources);
        this.assertDoesNotExistInWorkspace(resources);
        file.create(this.getRandomContents(), false, this.getMonitor());
        resources = new IResource[]{};
        IWorkspaceTest.assertTrue((boolean)IWorkspaceTest.getWorkspace().delete(resources, false, this.getMonitor()).isOK());
        this.assertDoesNotExistInFileSystem(resources);
        this.assertDoesNotExistInWorkspace(resources);
        this.createHierarchy();
        IProject fakeProject = IWorkspaceTest.getWorkspace().getRoot().getProject("pigment");
        IFolder fakeFolder = fakeProject.getFolder("ligament");
        resources = new IResource[]{file, folder, fakeFolder, project, fakeProject};
        IWorkspaceTest.assertTrue((boolean)IWorkspaceTest.getWorkspace().delete(resources, false, this.getMonitor()).isOK());
        this.assertDoesNotExistInWorkspace(resources);
        this.createHierarchy();
        resources = new IResource[]{fakeProject, file};
        IWorkspaceTest.assertTrue((boolean)IWorkspaceTest.getWorkspace().delete(resources, false, this.getMonitor()).isOK());
        this.assertDoesNotExistInFileSystem(resources);
        this.assertDoesNotExistInWorkspace(resources);
        file.create(this.getRandomContents(), false, this.getMonitor());
        resources = new IResource[]{fakeProject};
        IWorkspaceTest.assertTrue((boolean)IWorkspaceTest.getWorkspace().delete(resources, false, this.getMonitor()).isOK());
        this.assertDoesNotExistInWorkspace(resources);
        this.createHierarchy();
    }

    public void testForgetSavedTree() {
        try {
            IWorkspaceTest.getWorkspace().forgetSavedTree(null);
        }
        catch (RuntimeException e) {
            IWorkspaceTest.fail((String)"4.99", (Throwable)e);
        }
    }

    public void testGetNatureDescriptors() {
        IProjectNatureDescriptor[] descriptors = IWorkspaceTest.getWorkspace().getNatureDescriptors();
        IProjectNatureDescriptor current = this.findNature(descriptors, "org.eclipse.core.tests.resources.simpleNature");
        IWorkspaceTest.assertTrue((String)"2.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"2.1", (String)"org.eclipse.core.tests.resources.simpleNature", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"2.2", (String)"Simple", (String)current.getLabel());
        IWorkspaceTest.assertEquals((String)"2.3", (int)0, (int)current.getRequiredNatureIds().length);
        IWorkspaceTest.assertEquals((String)"2.4", (int)0, (int)current.getNatureSetIds().length);
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.snowNature");
        IWorkspaceTest.assertTrue((String)"3.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"3.1", (String)"org.eclipse.core.tests.resources.snowNature", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"3.2", (String)"Snow", (String)current.getLabel());
        String[] required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"3.3", (int)1, (int)required.length);
        IWorkspaceTest.assertEquals((String)"3.4", (String)"org.eclipse.core.tests.resources.waterNature", (String)required[0]);
        String[] sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"3.5", (int)1, (int)sets.length);
        IWorkspaceTest.assertEquals((String)"3.6", (String)"org.eclipse.core.tests.resources.otherSet", (String)sets[0]);
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.waterNature");
        IWorkspaceTest.assertTrue((String)"4.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"4.1", (String)"org.eclipse.core.tests.resources.waterNature", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"4.2", (String)"Water", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"4.3", (int)0, (int)required.length);
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"4.4", (int)1, (int)sets.length);
        IWorkspaceTest.assertEquals((String)"4.5", (String)"org.eclipse.core.tests.resources.stateSet", (String)sets[0]);
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.earthNature");
        IWorkspaceTest.assertTrue((String)"5.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"5.1", (String)"org.eclipse.core.tests.resources.earthNature", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"5.2", (String)"Earth", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"5.3", (int)0, (int)required.length);
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"5.4", (int)1, (int)sets.length);
        IWorkspaceTest.assertEquals((String)"5.5", (String)"org.eclipse.core.tests.resources.stateSet", (String)sets[0]);
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.mudNature");
        IWorkspaceTest.assertTrue((String)"6.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"6.1", (String)"org.eclipse.core.tests.resources.mudNature", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"6.2", (String)"Mud", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"6.3", (int)2, (int)required.length);
        if (required[0].equals("org.eclipse.core.tests.resources.waterNature")) {
            IWorkspaceTest.assertEquals((String)"6.4", (String)"org.eclipse.core.tests.resources.earthNature", (String)required[1]);
        } else {
            IWorkspaceTest.assertEquals((String)"6.5", (String)"org.eclipse.core.tests.resources.earthNature", (String)required[0]);
            IWorkspaceTest.assertEquals((String)"6.6", (String)"org.eclipse.core.tests.resources.waterNature", (String)required[0]);
        }
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"6.7", (int)1, (int)sets.length);
        IWorkspaceTest.assertEquals((String)"6.8", (String)"org.eclipse.core.tests.resources.otherSet", (String)sets[0]);
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.invalidNature");
        IWorkspaceTest.assertTrue((String)"7.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"7.1", (String)"org.eclipse.core.tests.resources.invalidNature", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"7.2", (String)"", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"7.3", (int)0, (int)required.length);
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"7.4", (int)0, (int)sets.length);
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.cycle1");
        IWorkspaceTest.assertTrue((String)"8.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"8.1", (String)"org.eclipse.core.tests.resources.cycle1", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"8.2", (String)"Cycle1", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"8.3", (int)1, (int)required.length);
        IWorkspaceTest.assertEquals((String)"8.4", (String)"org.eclipse.core.tests.resources.cycle2", (String)required[0]);
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"8.5", (int)0, (int)sets.length);
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.cycle2");
        IWorkspaceTest.assertTrue((String)"5.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"9.1", (String)"org.eclipse.core.tests.resources.cycle2", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"9.2", (String)"Cycle2", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"9.3", (int)1, (int)required.length);
        IWorkspaceTest.assertEquals((String)"9.4", (String)"org.eclipse.core.tests.resources.cycle3", (String)required[0]);
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"9.5", (int)0, (int)sets.length);
        current = this.findNature(descriptors, "org.eclipse.core.tests.resources.cycle3");
        IWorkspaceTest.assertTrue((String)"10.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"10.1", (String)"org.eclipse.core.tests.resources.cycle3", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"10.2", (String)"Cycle3", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"10.3", (int)1, (int)required.length);
        IWorkspaceTest.assertEquals((String)"10.4", (String)"org.eclipse.core.tests.resources.cycle1", (String)required[0]);
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"10.5", (int)0, (int)sets.length);
    }

    public void testGetNatureDescriptor() {
        IWorkspace ws = IWorkspaceTest.getWorkspace();
        IProjectNatureDescriptor current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.simpleNature");
        IWorkspaceTest.assertTrue((String)"2.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"2.1", (String)"org.eclipse.core.tests.resources.simpleNature", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"2.2", (String)"Simple", (String)current.getLabel());
        IWorkspaceTest.assertEquals((String)"2.3", (int)0, (int)current.getRequiredNatureIds().length);
        IWorkspaceTest.assertEquals((String)"2.4", (int)0, (int)current.getNatureSetIds().length);
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.snowNature");
        IWorkspaceTest.assertTrue((String)"3.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"3.1", (String)"org.eclipse.core.tests.resources.snowNature", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"3.2", (String)"Snow", (String)current.getLabel());
        String[] required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"3.3", (int)1, (int)required.length);
        IWorkspaceTest.assertEquals((String)"3.4", (String)"org.eclipse.core.tests.resources.waterNature", (String)required[0]);
        String[] sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"3.5", (int)1, (int)sets.length);
        IWorkspaceTest.assertEquals((String)"3.6", (String)"org.eclipse.core.tests.resources.otherSet", (String)sets[0]);
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.waterNature");
        IWorkspaceTest.assertTrue((String)"4.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"4.1", (String)"org.eclipse.core.tests.resources.waterNature", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"4.2", (String)"Water", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"4.3", (int)0, (int)required.length);
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"4.4", (int)1, (int)sets.length);
        IWorkspaceTest.assertEquals((String)"4.5", (String)"org.eclipse.core.tests.resources.stateSet", (String)sets[0]);
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.earthNature");
        IWorkspaceTest.assertTrue((String)"5.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"5.1", (String)"org.eclipse.core.tests.resources.earthNature", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"5.2", (String)"Earth", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"5.3", (int)0, (int)required.length);
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"5.4", (int)1, (int)sets.length);
        IWorkspaceTest.assertEquals((String)"5.5", (String)"org.eclipse.core.tests.resources.stateSet", (String)sets[0]);
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.mudNature");
        IWorkspaceTest.assertTrue((String)"6.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"6.1", (String)"org.eclipse.core.tests.resources.mudNature", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"6.2", (String)"Mud", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"6.3", (int)2, (int)required.length);
        if (required[0].equals("org.eclipse.core.tests.resources.waterNature")) {
            IWorkspaceTest.assertEquals((String)"6.4", (String)"org.eclipse.core.tests.resources.earthNature", (String)required[1]);
        } else {
            IWorkspaceTest.assertEquals((String)"6.5", (String)"org.eclipse.core.tests.resources.earthNature", (String)required[0]);
            IWorkspaceTest.assertEquals((String)"6.6", (String)"org.eclipse.core.tests.resources.waterNature", (String)required[0]);
        }
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"6.7", (int)1, (int)sets.length);
        IWorkspaceTest.assertEquals((String)"6.8", (String)"org.eclipse.core.tests.resources.otherSet", (String)sets[0]);
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.invalidNature");
        IWorkspaceTest.assertTrue((String)"7.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"7.1", (String)"org.eclipse.core.tests.resources.invalidNature", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"7.2", (String)"", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"7.3", (int)0, (int)required.length);
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"7.4", (int)0, (int)sets.length);
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.cycle1");
        IWorkspaceTest.assertTrue((String)"8.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"8.1", (String)"org.eclipse.core.tests.resources.cycle1", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"8.2", (String)"Cycle1", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"8.3", (int)1, (int)required.length);
        IWorkspaceTest.assertEquals((String)"8.4", (String)"org.eclipse.core.tests.resources.cycle2", (String)required[0]);
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"8.5", (int)0, (int)sets.length);
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.cycle2");
        IWorkspaceTest.assertTrue((String)"5.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"9.1", (String)"org.eclipse.core.tests.resources.cycle2", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"9.2", (String)"Cycle2", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"9.3", (int)1, (int)required.length);
        IWorkspaceTest.assertEquals((String)"9.4", (String)"org.eclipse.core.tests.resources.cycle3", (String)required[0]);
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"9.5", (int)0, (int)sets.length);
        current = ws.getNatureDescriptor("org.eclipse.core.tests.resources.cycle3");
        IWorkspaceTest.assertTrue((String)"10.0", (current != null ? 1 : 0) != 0);
        IWorkspaceTest.assertEquals((String)"10.1", (String)"org.eclipse.core.tests.resources.cycle3", (String)current.getNatureId());
        IWorkspaceTest.assertEquals((String)"10.2", (String)"Cycle3", (String)current.getLabel());
        required = current.getRequiredNatureIds();
        IWorkspaceTest.assertEquals((String)"10.3", (int)1, (int)required.length);
        IWorkspaceTest.assertEquals((String)"10.4", (String)"org.eclipse.core.tests.resources.cycle1", (String)required[0]);
        sets = current.getNatureSetIds();
        IWorkspaceTest.assertEquals((String)"10.5", (int)0, (int)sets.length);
    }

    public void testMove() throws CoreException {
        IProject project = IWorkspaceTest.getWorkspace().getRoot().getProject("Project");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile anotherFile = project.getFile("anotherFile.txt");
        IFile oneMoreFile = project.getFile("oneMoreFile.txt");
        this.ensureExistsInWorkspace(new IResource[]{project, folder, file, anotherFile, oneMoreFile}, true);
        IResource[] resources = new IResource[]{file, anotherFile, oneMoreFile};
        IWorkspaceTest.getWorkspace().move(resources, folder.getFullPath(), true, this.getMonitor());
        IWorkspaceTest.assertTrue((String)"1.1", (!file.exists() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"1.2", (!anotherFile.exists() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"1.3", (!oneMoreFile.exists() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"1.4", (boolean)folder.getFile(file.getName()).exists());
        IWorkspaceTest.assertTrue((String)"1.5", (boolean)folder.getFile(anotherFile.getName()).exists());
        IWorkspaceTest.assertTrue((String)"1.6", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        resources = new IResource[]{folder.getFile(file.getName()), folder.getFile(anotherFile.getName()), folder.getFile(oneMoreFile.getName()), folder.getFile(oneMoreFile.getName())};
        IStatus status = IWorkspaceTest.getWorkspace().move(resources, project.getFullPath(), true, this.getMonitor());
        IWorkspaceTest.assertTrue((String)"2.1", (boolean)status.isOK());
        IWorkspaceTest.assertTrue((String)"2.3", (boolean)file.exists());
        IWorkspaceTest.assertTrue((String)"2.4", (boolean)anotherFile.exists());
        IWorkspaceTest.assertTrue((String)"2.5", (boolean)oneMoreFile.exists());
        IWorkspaceTest.assertTrue((String)"2.6", (!folder.getFile(file.getName()).exists() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"2.7", (!folder.getFile(anotherFile.getName()).exists() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"2.8", (!folder.getFile(oneMoreFile.getName()).exists() ? 1 : 0) != 0);
        resources = new IResource[]{file, anotherFile, oneMoreFile, project};
        boolean ok = false;
        try {
            IWorkspaceTest.getWorkspace().move(resources, folder.getFullPath(), true, this.getMonitor());
        }
        catch (CoreException e) {
            ok = true;
            status = e.getStatus();
        }
        IWorkspaceTest.assertTrue((String)"3.0", (boolean)ok);
        IWorkspaceTest.assertTrue((String)"3.1", (!status.isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"3.2", (status.getChildren().length == 1 ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"3.3", (!file.exists() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"3.4", (!anotherFile.exists() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"3.5", (!oneMoreFile.exists() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"3.6", (boolean)folder.getFile(file.getName()).exists());
        IWorkspaceTest.assertTrue((String)"3.7", (boolean)folder.getFile(anotherFile.getName()).exists());
        IWorkspaceTest.assertTrue((String)"3.8", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        resources = new IResource[]{folder.getFile(file.getName()), folder.getFile(anotherFile.getName()), folder.getFile("inexisting"), folder.getFile(oneMoreFile.getName())};
        ok = false;
        try {
            IWorkspaceTest.getWorkspace().move(resources, project.getFullPath(), true, this.getMonitor());
        }
        catch (CoreException e) {
            ok = true;
            status = e.getStatus();
        }
        IWorkspaceTest.assertTrue((String)"4.0", (boolean)ok);
        IWorkspaceTest.assertTrue((String)"4.1", (!status.isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"4.3", (boolean)file.exists());
        IWorkspaceTest.assertTrue((String)"4.4", (boolean)anotherFile.exists());
        IWorkspaceTest.assertTrue((String)"4.5", (boolean)oneMoreFile.exists());
        IWorkspaceTest.assertTrue((String)"4.6", (!folder.getFile(file.getName()).exists() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"4.7", (!folder.getFile(anotherFile.getName()).exists() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"4.8", (!folder.getFile(oneMoreFile.getName()).exists() ? 1 : 0) != 0);
    }

    public void testMultiCopy() throws CoreException {
        IResource[] resources = this.buildResources();
        IProject project = (IProject)resources[1];
        IFolder folder = (IFolder)resources[2];
        this.ensureExistsInWorkspace((IResource)folder, true);
        this.ensureExistsInFileSystem((IResource)folder);
        IFile file1 = project.getFile("file.txt");
        this.ensureExistsInWorkspace((IResource)file1, true);
        this.ensureExistsInFileSystem(file1);
        IFile anotherFile = project.getFile("anotherFile.txt");
        this.ensureExistsInWorkspace((IResource)anotherFile, true);
        this.ensureExistsInFileSystem(anotherFile);
        IFile oneMoreFile = project.getFile("oneMoreFile.txt");
        this.ensureExistsInWorkspace((IResource)oneMoreFile, true);
        this.ensureExistsInFileSystem(oneMoreFile);
        resources = new IResource[]{file1, anotherFile, oneMoreFile};
        IWorkspaceTest.getWorkspace().copy(resources, folder.getFullPath(), true, this.getMonitor());
        IWorkspaceTest.assertTrue((String)"1.1", (boolean)file1.exists());
        IWorkspaceTest.assertTrue((String)"1.2", (boolean)anotherFile.exists());
        IWorkspaceTest.assertTrue((String)"1.3", (boolean)oneMoreFile.exists());
        IWorkspaceTest.assertTrue((String)"1.4", (boolean)folder.getFile(file1.getName()).exists());
        IWorkspaceTest.assertTrue((String)"1.5", (boolean)folder.getFile(anotherFile.getName()).exists());
        IWorkspaceTest.assertTrue((String)"1.6", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        this.ensureDoesNotExistInWorkspace((IResource)folder.getFile(file1.getName()));
        this.ensureDoesNotExistInWorkspace((IResource)folder.getFile(anotherFile.getName()));
        this.ensureDoesNotExistInWorkspace((IResource)folder.getFile(oneMoreFile.getName()));
        this.ensureDoesNotExistInFileSystem((IResource)folder.getFile(file1.getName()));
        this.ensureDoesNotExistInFileSystem((IResource)folder.getFile(anotherFile.getName()));
        this.ensureDoesNotExistInFileSystem((IResource)folder.getFile(oneMoreFile.getName()));
        resources = new IResource[]{file1, anotherFile, oneMoreFile, file1};
        IWorkspaceTest.getWorkspace().copy(resources, folder.getFullPath(), true, this.getMonitor());
        IWorkspaceTest.assertTrue((String)"2.2", (boolean)file1.exists());
        IWorkspaceTest.assertTrue((String)"2.3", (boolean)anotherFile.exists());
        IWorkspaceTest.assertTrue((String)"2.4", (boolean)oneMoreFile.exists());
        IWorkspaceTest.assertTrue((String)"2.5", (boolean)folder.getFile(file1.getName()).exists());
        IWorkspaceTest.assertTrue((String)"2.6", (boolean)folder.getFile(anotherFile.getName()).exists());
        IWorkspaceTest.assertTrue((String)"2.7", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        this.ensureDoesNotExistInWorkspace((IResource)folder.getFile(file1.getName()));
        this.ensureDoesNotExistInWorkspace((IResource)folder.getFile(anotherFile.getName()));
        this.ensureDoesNotExistInWorkspace((IResource)folder.getFile(oneMoreFile.getName()));
        this.ensureDoesNotExistInFileSystem((IResource)folder.getFile(file1.getName()));
        this.ensureDoesNotExistInFileSystem((IResource)folder.getFile(anotherFile.getName()));
        this.ensureDoesNotExistInFileSystem((IResource)folder.getFile(oneMoreFile.getName()));
        resources = new IResource[]{file1, anotherFile, oneMoreFile, project};
        IStatus status = null;
        boolean ok = false;
        try {
            IWorkspaceTest.getWorkspace().copy(resources, folder.getFullPath(), true, this.getMonitor());
        }
        catch (CoreException e) {
            ok = true;
            status = e.getStatus();
        }
        IWorkspaceTest.assertTrue((String)"3.0", (boolean)ok);
        IWorkspaceTest.assertTrue((String)"3.1", (!status.isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"3.2", (status.getChildren().length == 1 ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"3.3", (boolean)file1.exists());
        IWorkspaceTest.assertTrue((String)"3.4", (boolean)anotherFile.exists());
        IWorkspaceTest.assertTrue((String)"3.5", (boolean)oneMoreFile.exists());
        IWorkspaceTest.assertTrue((String)"3.6", (boolean)folder.getFile(file1.getName()).exists());
        IWorkspaceTest.assertTrue((String)"3.7", (boolean)folder.getFile(anotherFile.getName()).exists());
        IWorkspaceTest.assertTrue((String)"3.8", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        this.ensureDoesNotExistInWorkspace((IResource)folder.getFile(file1.getName()));
        this.ensureDoesNotExistInWorkspace((IResource)folder.getFile(anotherFile.getName()));
        this.ensureDoesNotExistInWorkspace((IResource)folder.getFile(oneMoreFile.getName()));
        this.ensureDoesNotExistInFileSystem((IResource)folder.getFile(file1.getName()));
        this.ensureDoesNotExistInFileSystem((IResource)folder.getFile(anotherFile.getName()));
        this.ensureDoesNotExistInFileSystem((IResource)folder.getFile(oneMoreFile.getName()));
        resources = new IResource[]{file1, anotherFile, project.getFile("inexisting"), oneMoreFile};
        ok = false;
        try {
            IWorkspaceTest.getWorkspace().copy(resources, folder.getFullPath(), true, this.getMonitor());
        }
        catch (CoreException e) {
            ok = true;
            status = e.getStatus();
        }
        IWorkspaceTest.assertTrue((String)"4.0", (boolean)ok);
        IWorkspaceTest.assertTrue((String)"4.1", (!status.isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"4.2", (boolean)file1.exists());
        IWorkspaceTest.assertTrue((String)"4.3", (boolean)anotherFile.exists());
        IWorkspaceTest.assertTrue((String)"4.4", (boolean)oneMoreFile.exists());
        IWorkspaceTest.assertTrue((String)"4.5", (boolean)folder.getFile(file1.getName()).exists());
        IWorkspaceTest.assertTrue((String)"4.6", (boolean)folder.getFile(anotherFile.getName()).exists());
        IWorkspaceTest.assertTrue((String)"4.7 Fails because of 1FVFOOQ", (boolean)folder.getFile(oneMoreFile.getName()).exists());
        IProject destination = IWorkspaceTest.getWorkspace().getRoot().getProject("destination");
        ok = false;
        try {
            IWorkspaceTest.getWorkspace().copy(new IResource[]{project}, destination.getFullPath(), true, this.getMonitor());
        }
        catch (CoreException e) {
            ok = true;
            status = e.getStatus();
        }
        IWorkspaceTest.assertTrue((String)"5.0", (boolean)ok);
        IWorkspaceTest.assertTrue((String)"5.1", (!status.isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"5.2", (status.getChildren().length == 1 ? 1 : 0) != 0);
    }

    public void testMultiCreation() throws Throwable {
        final IProject project = IWorkspaceTest.getWorkspace().getRoot().getProject("bar");
        final IResource[] resources = this.buildResources((IContainer)project, new String[]{"a/", "a/b"});
        IWorkspaceRunnable body = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(null);
                project.open(null);
                int i = 0;
                while (i < resources.length) {
                    IResource resource = resources[i];
                    switch (resource.getType()) {
                        case 1: {
                            ((IFile)resource).create(null, false, IWorkspaceTest.this.getMonitor());
                            break;
                        }
                        case 2: {
                            ((IFolder)resource).create(false, true, IWorkspaceTest.this.getMonitor());
                            break;
                        }
                        case 4: {
                            ((IProject)resource).create(IWorkspaceTest.this.getMonitor());
                        }
                    }
                    ++i;
                }
            }
        };
        IWorkspaceTest.getWorkspace().run(body, this.getMonitor());
        this.assertExistsInWorkspace((IResource)project);
        this.assertExistsInWorkspace(resources);
    }

    public void testMultiDeletion() throws Throwable {
        IProject project = IWorkspaceTest.getWorkspace().getRoot().getProject("testProject");
        IResource[] before = this.buildResources((IContainer)project, new String[]{"c/", "c/b/", "c/x", "c/b/y", "c/b/z"});
        this.ensureExistsInWorkspace(before, true);
        this.assertExistsInWorkspace(before);
        IWorkspaceTest.getWorkspace().delete(before, true, this.getMonitor());
        this.assertDoesNotExistInWorkspace(before);
    }

    public void testMultiSetDescription() {
        final CoreException[] errorPointer = new CoreException[1];
        Thread[] threads = new Thread[2];
        int i = 0;
        while (i < 2) {
            threads[i] = new Thread(new Runnable(){

                public void run() {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IWorkspaceDescription description = workspace.getDescription();
                    int j = 0;
                    while (j < 100) {
                        description.setAutoBuilding(false);
                        try {
                            workspace.setDescription(description);
                        }
                        catch (CoreException e) {
                            errorPointer[0] = e;
                            return;
                        }
                        description.setAutoBuilding(true);
                        try {
                            workspace.setDescription(description);
                        }
                        catch (CoreException e) {
                            errorPointer[0] = e;
                            return;
                        }
                        ++j;
                    }
                }
            }, "Autobuild " + i);
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < threads.length) {
            try {
                threads[i].join();
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        if (errorPointer[0] != null) {
            IWorkspaceTest.fail((String)"1.0", (Throwable)errorPointer[0]);
        }
    }

    public void testSave() {
        IProject project = IWorkspaceTest.getWorkspace().getRoot().getProject("Broken");
        this.ensureExistsInWorkspace((IResource)project, true);
        TestingSupport.waitForSnapshot();
        IFile descriptionFile = project.getFile(".project");
        try {
            descriptionFile.delete(0, null);
            IStatus result = IWorkspaceTest.getWorkspace().save(true, this.getMonitor());
            IWorkspaceTest.assertEquals((String)"1.0", (int)2, (int)result.getSeverity());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testSortNatureSet() {
        IWorkspace ws = IWorkspaceTest.getWorkspace();
        String[][] invalid = this.getInvalidNatureSets();
        int i = 0;
        while (i < invalid.length) {
            String[] sorted = ws.sortNatureSet(invalid[i]);
            IWorkspaceTest.assertTrue((String)"0.0", (sorted != null ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"0.1", (sorted.length <= invalid[i].length ? 1 : 0) != 0);
            ++i;
        }
        String[] sorted = ws.sortNatureSet(new String[0]);
        IWorkspaceTest.assertEquals((String)"1.0", (int)0, (int)sorted.length);
        sorted = ws.sortNatureSet(new String[]{"org.eclipse.core.tests.resources.simpleNature"});
        IWorkspaceTest.assertEquals((String)"2.0", (int)1, (int)sorted.length);
        IWorkspaceTest.assertEquals((String)"2.1", (String)"org.eclipse.core.tests.resources.simpleNature", (String)sorted[0]);
        sorted = ws.sortNatureSet(new String[]{"org.eclipse.core.tests.resources.snowNature", "org.eclipse.core.tests.resources.waterNature"});
        IWorkspaceTest.assertEquals((String)"3.0", (int)2, (int)sorted.length);
        IWorkspaceTest.assertEquals((String)"3.1", (String)"org.eclipse.core.tests.resources.waterNature", (String)sorted[0]);
        IWorkspaceTest.assertEquals((String)"3.2", (String)"org.eclipse.core.tests.resources.snowNature", (String)sorted[1]);
        sorted = ws.sortNatureSet(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.simpleNature", "org.eclipse.core.tests.resources.snowNature"});
        IWorkspaceTest.assertEquals((String)"4.0", (int)3, (int)sorted.length);
        boolean first = sorted[0].equals("org.eclipse.core.tests.resources.waterNature") && sorted[1].equals("org.eclipse.core.tests.resources.snowNature") && sorted[2].equals("org.eclipse.core.tests.resources.simpleNature");
        boolean second = sorted[0].equals("org.eclipse.core.tests.resources.waterNature") && sorted[1].equals("org.eclipse.core.tests.resources.simpleNature") && sorted[2].equals("org.eclipse.core.tests.resources.snowNature");
        boolean third = sorted[0].equals("org.eclipse.core.tests.resources.simpleNature") && sorted[1].equals("org.eclipse.core.tests.resources.waterNature") && sorted[2].equals("org.eclipse.core.tests.resources.snowNature");
        IWorkspaceTest.assertTrue((String)"4.1", (first || second || third ? 1 : 0) != 0);
    }

    public void testValidateEdit() {
        if (!this.isReadOnlySupported()) {
            return;
        }
        IProject project = IWorkspaceTest.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("myfile.txt");
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        IStatus result = IWorkspaceTest.getWorkspace().validateEdit(new IFile[]{file}, null);
        IWorkspaceTest.assertTrue((String)"1.0", (boolean)result.isOK());
        file.setReadOnly(true);
        result = IWorkspaceTest.getWorkspace().validateEdit(new IFile[]{file}, null);
        IWorkspaceTest.assertEquals((String)"1.1", (int)4, (int)result.getSeverity());
        file.setReadOnly(false);
    }

    public void testValidateLinkLocation() {
    }

    public void testValidateName() {
        IWorkspaceTest.assertTrue((String)"1.1", (boolean)IWorkspaceTest.getWorkspace().validateName("abcdef", 1).isOK());
        if (IWorkspaceTest.isWindows()) {
            IWorkspaceTest.assertTrue((String)"2.1", (!IWorkspaceTest.getWorkspace().validateName("dsa:sf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.2", (!IWorkspaceTest.getWorkspace().validateName("*dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.3", (!IWorkspaceTest.getWorkspace().validateName("?dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.4", (!IWorkspaceTest.getWorkspace().validateName("\"dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.5", (!IWorkspaceTest.getWorkspace().validateName("<dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.6", (!IWorkspaceTest.getWorkspace().validateName(">dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.7", (!IWorkspaceTest.getWorkspace().validateName("|dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.8", (!IWorkspaceTest.getWorkspace().validateName("\"dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.10", (!IWorkspaceTest.getWorkspace().validateName("\\dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.11", (!IWorkspaceTest.getWorkspace().validateName("...", 4).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.12", (!IWorkspaceTest.getWorkspace().validateName("foo.", 1).isOK() ? 1 : 0) != 0);
        } else {
            IWorkspaceTest.assertTrue((String)"3.3", (boolean)IWorkspaceTest.getWorkspace().validateName("...", 1).isOK());
            IWorkspaceTest.assertTrue((String)"3.4", (boolean)IWorkspaceTest.getWorkspace().validateName("....", 4).isOK());
            IWorkspaceTest.assertTrue((String)"3.7", (boolean)IWorkspaceTest.getWorkspace().validateName("abc.", 1).isOK());
        }
        IWorkspaceTest.assertTrue((String)"2.9", (!IWorkspaceTest.getWorkspace().validateName("/dsasf", 1).isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"2.9", (!IWorkspaceTest.getWorkspace().validateName("", 1).isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"3.1", (!IWorkspaceTest.getWorkspace().validateName(".", 1).isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"3.2", (!IWorkspaceTest.getWorkspace().validateName("..", 1).isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"3.3", (boolean)IWorkspaceTest.getWorkspace().validateName("...z", 1).isOK());
        IWorkspaceTest.assertTrue((String)"3.4", (boolean)IWorkspaceTest.getWorkspace().validateName("....z", 1).isOK());
        IWorkspaceTest.assertTrue((String)"3.5", (boolean)IWorkspaceTest.getWorkspace().validateName("....abc", 1).isOK());
        IWorkspaceTest.assertTrue((String)"3.6", (boolean)IWorkspaceTest.getWorkspace().validateName("abc....def", 1).isOK());
        IWorkspaceTest.assertTrue((String)"3.7", (boolean)IWorkspaceTest.getWorkspace().validateName("abc.d...z", 1).isOK());
    }

    public void testValidateNatureSet() {
        IWorkspace ws = IWorkspaceTest.getWorkspace();
        String[][] invalid = this.getInvalidNatureSets();
        int i = 0;
        while (i < invalid.length) {
            IStatus result = ws.validateNatureSet(invalid[i]);
            IWorkspaceTest.assertTrue((String)("invalid (severity): " + i), (!result.isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)("invalid (code): " + i), (result.getCode() != 0 ? 1 : 0) != 0);
            ++i;
        }
        String[][] valid = this.getValidNatureSets();
        int i2 = 0;
        while (i2 < valid.length) {
            IStatus result = ws.validateNatureSet(valid[i2]);
            IWorkspaceTest.assertTrue((String)("valid (severity): " + i2), (boolean)result.isOK());
            IWorkspaceTest.assertTrue((String)("valid (code): " + i2), (result.getCode() == 0 ? 1 : 0) != 0);
            ++i2;
        }
    }

    public void testValidatePath() {
        IWorkspaceTest.assertTrue((String)"1.1", (boolean)IWorkspaceTest.getWorkspace().validatePath("/one/two/three/four/", 3).isOK());
        boolean WINDOWS = IWorkspaceTest.isWindows();
        if (WINDOWS) {
            IWorkspaceTest.assertTrue((String)"2.1", (!IWorkspaceTest.getWorkspace().validatePath("\\dsa:sf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.2", (!IWorkspaceTest.getWorkspace().validatePath("/abc/*dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.3", (!IWorkspaceTest.getWorkspace().validatePath("/abc/?dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.4", (!IWorkspaceTest.getWorkspace().validatePath("/abc/\"dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.5", (!IWorkspaceTest.getWorkspace().validatePath("/abc/<dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.6", (!IWorkspaceTest.getWorkspace().validatePath("/abc/>dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.7", (!IWorkspaceTest.getWorkspace().validatePath("/abc/|dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"2.8", (!IWorkspaceTest.getWorkspace().validatePath("/abc/\"dsasf", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"5.2", (!IWorkspaceTest.getWorkspace().validatePath("\\", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"5.4", (!IWorkspaceTest.getWorkspace().validatePath("device:/abc/123", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"3.1", (!IWorkspaceTest.getWorkspace().validatePath("/abc/.../defghi", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"3.2", (!IWorkspaceTest.getWorkspace().validatePath("/abc/..../defghi", 1).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"3.3", (!IWorkspaceTest.getWorkspace().validatePath("/abc/def..../ghi", 1).isOK() ? 1 : 0) != 0);
        } else {
            IWorkspaceTest.assertTrue((String)"3.1", (boolean)IWorkspaceTest.getWorkspace().validatePath("/abc/.../defghi", 1).isOK());
            IWorkspaceTest.assertTrue((String)"3.2", (boolean)IWorkspaceTest.getWorkspace().validatePath("/abc/..../defghi", 1).isOK());
            IWorkspaceTest.assertTrue((String)"3.3", (boolean)IWorkspaceTest.getWorkspace().validatePath("/abc/def..../ghi", 1).isOK());
        }
        IWorkspaceTest.assertTrue((String)"3.4", (boolean)IWorkspaceTest.getWorkspace().validatePath("/abc/../ghi/j", 1).isOK());
        IWorkspaceTest.assertTrue((String)"3.5", (boolean)IWorkspaceTest.getWorkspace().validatePath("/abc/....def/ghi", 1).isOK());
        IWorkspaceTest.assertTrue((String)"3.6", (boolean)IWorkspaceTest.getWorkspace().validatePath("/abc/def....ghi/jkl", 1).isOK());
        IWorkspaceTest.assertTrue((String)"4.1", (boolean)IWorkspaceTest.getWorkspace().validatePath("/abc/.?./../def/as", 1).isOK());
        IWorkspaceTest.assertTrue((String)"4.2", (boolean)IWorkspaceTest.getWorkspace().validatePath("/abc/;*?\"'/../def/safd", 1).isOK());
        IWorkspaceTest.assertTrue((String)"4.3", (boolean)(IWorkspaceTest.getWorkspace().validatePath("/abc;*?\"':/def/asdf/sadf", 1).isOK() ^ WINDOWS));
        IWorkspaceTest.assertTrue((String)"5.1", (!IWorkspaceTest.getWorkspace().validatePath("/", 1).isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"5.3", (!IWorkspaceTest.getWorkspace().validatePath("", 1).isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"6.6", (boolean)IWorkspaceTest.getWorkspace().validatePath("/asf", 4).isOK());
        IWorkspaceTest.assertTrue((String)"6.7", (!IWorkspaceTest.getWorkspace().validatePath("/asf", 1).isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"6.8", (boolean)IWorkspaceTest.getWorkspace().validatePath("/asf", 5).isOK());
        IWorkspaceTest.assertTrue((String)"6.10", (boolean)IWorkspaceTest.getWorkspace().validatePath("/project/.metadata", 1).isOK());
        IWorkspaceTest.assertTrue((String)"6.11", (boolean)IWorkspaceTest.getWorkspace().validatePath("/.metadata/project", 1).isOK());
    }

    public void testValidateProjectLocation() {
        IPath platformLocation;
        IProject project;
        IWorkspace workspace;
        block22: {
            workspace = IWorkspaceTest.getWorkspace();
            project = workspace.getRoot().getProject("Project");
            IWorkspaceTest.assertTrue((String)"1.1", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("/one/two/three/four/")).isOK());
            boolean WINDOWS = IWorkspaceTest.isWindows();
            if (WINDOWS) {
                IWorkspaceTest.assertTrue((String)"2.1", (!workspace.validateProjectLocation(project, (IPath)new Path("d:\\dsa:sf")).isOK() ? 1 : 0) != 0);
                IWorkspaceTest.assertTrue((String)"2.2", (!workspace.validateProjectLocation(project, (IPath)new Path("/abc/*dsasf")).isOK() ? 1 : 0) != 0);
                IWorkspaceTest.assertTrue((String)"2.3", (!workspace.validateProjectLocation(project, (IPath)new Path("/abc/?dsasf")).isOK() ? 1 : 0) != 0);
                IWorkspaceTest.assertTrue((String)"2.4", (!workspace.validateProjectLocation(project, (IPath)new Path("/abc/\"dsasf")).isOK() ? 1 : 0) != 0);
                IWorkspaceTest.assertTrue((String)"2.5", (!workspace.validateProjectLocation(project, (IPath)new Path("/abc/<dsasf")).isOK() ? 1 : 0) != 0);
                IWorkspaceTest.assertTrue((String)"2.6", (!workspace.validateProjectLocation(project, (IPath)new Path("/abc/>dsasf")).isOK() ? 1 : 0) != 0);
                IWorkspaceTest.assertTrue((String)"2.7", (!workspace.validateProjectLocation(project, (IPath)new Path("/abc/|dsasf")).isOK() ? 1 : 0) != 0);
                IWorkspaceTest.assertTrue((String)"2.8", (!workspace.validateProjectLocation(project, (IPath)new Path("/abc/\"dsasf")).isOK() ? 1 : 0) != 0);
                IWorkspaceTest.assertTrue((String)"3.1", (!workspace.validateProjectLocation(project, (IPath)new Path("/abc/.../defghi")).isOK() ? 1 : 0) != 0);
                IWorkspaceTest.assertTrue((String)"3.2", (!workspace.validateProjectLocation(project, (IPath)new Path("/abc/..../defghi")).isOK() ? 1 : 0) != 0);
                IWorkspaceTest.assertTrue((String)"3.3", (!workspace.validateProjectLocation(project, (IPath)new Path("/abc/def..../ghi")).isOK() ? 1 : 0) != 0);
            } else {
                IWorkspaceTest.assertTrue((String)"3.1", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("/abc/.../defghi")).isOK());
                IWorkspaceTest.assertTrue((String)"3.2", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("/abc/..../defghi")).isOK());
                IWorkspaceTest.assertTrue((String)"3.3", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("/abc/def..../ghi")).isOK());
            }
            IWorkspaceTest.assertTrue((String)"3.4", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("/abc/....def/ghi")).isOK());
            IWorkspaceTest.assertTrue((String)"3.5", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("/abc/def....ghi/jkl")).isOK());
            IWorkspaceTest.assertTrue((String)"4.1", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("/abc/.?./../def/as")).isOK());
            IWorkspaceTest.assertTrue((String)"4.2", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("/abc/;*?\"'/../def/safd")).isOK());
            IWorkspaceTest.assertTrue((String)"4.3", (!workspace.validateProjectLocation(project, (IPath)new Path("c:/abc;*?\"':/def/asdf/sadf")).isOK() ? 1 : 0) != 0);
            platformLocation = Platform.getLocation();
            IWorkspaceTest.assertTrue((String)"5.1", (!workspace.validateProjectLocation(project, (IPath)new Path(platformLocation.getDevice(), "/")).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"5.2", (!workspace.validateProjectLocation(project, (IPath)new Path(platformLocation.getDevice(), "\\")).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"5.3", (!workspace.validateProjectLocation(project, (IPath)new Path(platformLocation.getDevice(), "")).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"5.4", (!workspace.validateProjectLocation(project, platformLocation).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"5.5", (!workspace.validateProjectLocation(project, platformLocation.append("foo")).isOK() ? 1 : 0) != 0);
            IPath anotherDevice = platformLocation.setDevice("u:");
            IWorkspaceTest.assertTrue((String)"6.1", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("u:", "/")).isOK());
            if (WINDOWS) {
                IWorkspaceTest.assertTrue((String)"6.2", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("u:", "\\")).isOK());
            }
            IWorkspaceTest.assertTrue((String)"6.4", (boolean)workspace.validateProjectLocation(project, anotherDevice).isOK());
            IWorkspaceTest.assertTrue((String)"6.5", (boolean)workspace.validateProjectLocation(project, anotherDevice.append("foo")).isOK());
            IWorkspaceTest.assertTrue((String)"7.1", (!workspace.validateProjectLocation(project, (IPath)new Path("u:", "")).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"7.2", (!workspace.validateProjectLocation(project, (IPath)new Path("c:")).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"7.3", (!workspace.validateProjectLocation(project, (IPath)new Path("c:foo")).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"7.4", (!workspace.validateProjectLocation(project, (IPath)new Path("foo/bar")).isOK() ? 1 : 0) != 0);
            IWorkspaceTest.assertTrue((String)"7.5", (!workspace.validateProjectLocation(project, (IPath)new Path("c:foo/bar")).isOK() ? 1 : 0) != 0);
            IPath PATH_VAR_VALUE = this.getRandomLocation();
            try {
                try {
                    Path varPath = new Path("FOOVAR");
                    workspace.getPathVariableManager().setValue("FOOVAR", PATH_VAR_VALUE);
                    IWorkspaceTest.assertTrue((String)"8.1", (boolean)workspace.validateProjectLocation(project, (IPath)varPath).isOK());
                    IWorkspaceTest.assertTrue((String)"8.2", (boolean)workspace.validateProjectLocation(project, varPath.append("test")).isOK());
                    IWorkspaceTest.assertTrue((String)"8.3", (boolean)workspace.validateProjectLocation(project, varPath.append("test/ing")).isOK());
                }
                finally {
                    workspace.getPathVariableManager().setValue("FOOVAR", null);
                }
            }
            catch (CoreException e) {
                IWorkspaceTest.fail((String)"8.99", (Throwable)e);
            }
            IPath openProjectLocation = this.getTempDir().append("OpenProject");
            IProject open = workspace.getRoot().getProject("OpenProject");
            IProjectDescription openDesc = workspace.newProjectDescription(open.getName());
            openDesc.setLocation(openProjectLocation);
            IPath closedProjectLocation = this.getTempDir().append("ClosedProject");
            IProject closed = workspace.getRoot().getProject("ClosedProject");
            IProjectDescription closedDesc = workspace.newProjectDescription(closed.getName());
            closedDesc.setLocation(closedProjectLocation);
            try {
                open.create(openDesc, null);
                open.open(null);
                closed.create(closedDesc, null);
            }
            catch (CoreException e) {
                IWorkspaceTest.fail((String)"9.99", (Throwable)e);
            }
            IPath linkLocation = this.getRandomLocation();
            try {
                try {
                    IProjectDescription desc = open.getDescription();
                    desc.setReferencedProjects(new IProject[]{project});
                    open.setDescription(desc, 1, this.getMonitor());
                    IWorkspaceTest.assertTrue((String)"9.1", (!workspace.validateProjectLocation(project, openProjectLocation).isOK() ? 1 : 0) != 0);
                    IWorkspaceTest.assertTrue((String)"9.2", (!workspace.validateProjectLocation(project, closedProjectLocation).isOK() ? 1 : 0) != 0);
                    IWorkspaceTest.assertTrue((String)"9.3", (boolean)workspace.validateProjectLocation(open, openProjectLocation).isOK());
                    IWorkspaceTest.assertTrue((String)"9.4", (!workspace.validateProjectLocation(open, openProjectLocation.append("sub")).isOK() ? 1 : 0) != 0);
                    linkLocation.toFile().mkdirs();
                    IWorkspaceTest.assertTrue((String)"10.1", (boolean)workspace.validateProjectLocation(open, linkLocation).isOK());
                    IFolder link = open.getFolder("link");
                    link.createLink(linkLocation, 0, this.getMonitor());
                    IWorkspaceTest.assertTrue((String)"10.2", (!workspace.validateProjectLocation(open, linkLocation).isOK() ? 1 : 0) != 0);
                    IWorkspaceTest.assertTrue((String)"10.3", (!workspace.validateProjectLocation(open, linkLocation.append("sub")).isOK() ? 1 : 0) != 0);
                    IWorkspaceTest.assertTrue((String)"10.4", (boolean)workspace.validateProjectLocation(project, linkLocation).isOK());
                }
                catch (CoreException e) {
                    IWorkspaceTest.fail((String)"10.99", (Throwable)e);
                    Workspace.clear((File)linkLocation.toFile());
                    try {
                        open.delete(4, this.getMonitor());
                        open.delete(4, this.getMonitor());
                    }
                    catch (CoreException coreException) {}
                    this.ensureDoesNotExistInFileSystem(openProjectLocation.toFile());
                    this.ensureDoesNotExistInFileSystem(closedProjectLocation.toFile());
                    break block22;
                }
            }
            catch (Throwable throwable) {
                Workspace.clear((File)linkLocation.toFile());
                try {
                    open.delete(4, this.getMonitor());
                    open.delete(4, this.getMonitor());
                }
                catch (CoreException coreException) {}
                this.ensureDoesNotExistInFileSystem(openProjectLocation.toFile());
                this.ensureDoesNotExistInFileSystem(closedProjectLocation.toFile());
                throw throwable;
            }
            Workspace.clear((File)linkLocation.toFile());
            try {
                open.delete(4, this.getMonitor());
                open.delete(4, this.getMonitor());
            }
            catch (CoreException coreException) {}
            this.ensureDoesNotExistInFileSystem(openProjectLocation.toFile());
            this.ensureDoesNotExistInFileSystem(closedProjectLocation.toFile());
        }
        IWorkspaceTest.assertTrue((String)"11.1", (!workspace.validateProjectLocation(project, platformLocation.addTrailingSeparator().append(".metadata")).isOK() ? 1 : 0) != 0);
        IProject metadataProject = workspace.getRoot().getProject(".metadata");
        IWorkspaceTest.assertTrue((String)"11.2", (!workspace.validateProjectLocation(metadataProject, null).isOK() ? 1 : 0) != 0);
        IWorkspaceTest.assertTrue((String)"23.1", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("/asf")).isOK());
        IWorkspaceTest.assertTrue((String)"23.2", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("/project/.metadata")).isOK());
        IWorkspaceTest.assertTrue((String)"23.3", (boolean)workspace.validateProjectLocation(project, (IPath)new Path("/.metadata/project")).isOK());
    }

    public void testValidateProjectLocationURI() {
        IWorkspace workspace = IWorkspaceTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("Project");
        try {
            URI uri = new URI("eferfsdfwer");
            IWorkspaceTest.assertTrue((String)"1.0", (!workspace.validateProjectLocationURI(project, uri).isOK() ? 1 : 0) != 0);
            uri = new URI("blorts://foo.com?bad");
            IWorkspaceTest.assertTrue((String)"1.1", (!workspace.validateProjectLocationURI(project, uri).isOK() ? 1 : 0) != 0);
        }
        catch (URISyntaxException e) {
            IWorkspaceTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testWorkspaceService() {
        BundleContext context = TestActivator.getContext();
        ServiceReference ref = context.getServiceReference(IWorkspace.SERVICE_NAME);
        IWorkspaceTest.assertNotNull((String)"1.0", (Object)ref);
        IWorkspace ws = (IWorkspace)context.getService(ref);
        IWorkspaceTest.assertNotNull((String)"1.1", (Object)ws);
    }

    public void testGetFilterMatcherDescriptor() {
        IFilterMatcherDescriptor descriptor = IWorkspaceTest.getWorkspace().getFilterMatcherDescriptor("");
        IWorkspaceTest.assertNull((String)"1.0", (Object)descriptor);
        descriptor = IWorkspaceTest.getWorkspace().getFilterMatcherDescriptor("org.eclipse.core.resources.regexFilterMatcher");
        IWorkspaceTest.assertNotNull((String)"1.1", (Object)descriptor);
    }
}

