/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.LinkedResourceTest;

public class LinkedResourceWithPathVariableTest
extends LinkedResourceTest {
    private static final String VARIABLE_NAME = "ROOT";
    private static final String PROJECT_VARIABLE_NAME = "PROOT";
    private static final String PROJECT_RELATIVE_VARIABLE_NAME = "RELATIVE_PROOT";
    private static final String PROJECT_RELATIVE_VARIABLE_VALUE = "${PROOT}";
    private final ArrayList toDelete = new ArrayList();
    private IFileStore toSetWritable = null;

    public LinkedResourceWithPathVariableTest() {
    }

    public LinkedResourceWithPathVariableTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(LinkedResourceWithPathVariableTest.class);
    }

    protected void setUp() throws Exception {
        IPath base = super.getRandomLocation();
        this.toDelete.add(base);
        LinkedResourceWithPathVariableTest.getWorkspace().getPathVariableManager().setValue(VARIABLE_NAME, base);
        base = super.getRandomLocation();
        this.toDelete.add(base);
        super.setUp();
        this.existingProject.getPathVariableManager().setValue(PROJECT_VARIABLE_NAME, base);
        this.existingProject.getPathVariableManager().setValue(PROJECT_RELATIVE_VARIABLE_NAME, Path.fromPortableString((String)PROJECT_RELATIVE_VARIABLE_VALUE));
    }

    protected void tearDown() throws Exception {
        if (this.toSetWritable != null) {
            IFileInfo info = this.toSetWritable.fetchInfo();
            info.setAttribute(2, false);
            this.toSetWritable.putInfo(info, 1024, this.getMonitor());
            this.toSetWritable = null;
        }
        LinkedResourceWithPathVariableTest.getWorkspace().getPathVariableManager().setValue(VARIABLE_NAME, null);
        IPath[] paths = this.toDelete.toArray(new IPath[0]);
        this.toDelete.clear();
        int i = 0;
        while (i < paths.length) {
            Workspace.clear((File)paths[i].toFile());
            ++i;
        }
        super.tearDown();
    }

    protected void convertLineEndings(IFileStore inStore, IFileStore outStore, IProgressMonitor mon) throws CoreException, IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = inStore.openInputStream(0, mon);
            os = outStore.openOutputStream(0, (IProgressMonitor)new NullProgressMonitor());
            int prevb = 0;
            int ib = is.read();
            while (ib >= 0) {
                switch (ib) {
                    case 13: {
                        os.write(10);
                        break;
                    }
                    case 10: {
                        if (prevb == 13) break;
                        os.write(13);
                        os.write(10);
                        break;
                    }
                    default: {
                        os.write(ib);
                    }
                }
                prevb = ib;
                ib = is.read();
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public IPath getRandomLocation() {
        IPathVariableManager pathVars = LinkedResourceWithPathVariableTest.getWorkspace().getPathVariableManager();
        Path parent = new Path(VARIABLE_NAME);
        IPath path = FileSystemHelper.computeRandomLocation((IPath)parent);
        while (pathVars.resolvePath(path).toFile().exists()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            path = FileSystemHelper.computeRandomLocation((IPath)parent);
        }
        this.toDelete.add(pathVars.resolvePath(path));
        return path;
    }

    public IPath getRandomProjectLocation() {
        IPathVariableManager pathVars = LinkedResourceWithPathVariableTest.getWorkspace().getPathVariableManager();
        Path parent = new Path(PROJECT_VARIABLE_NAME);
        IPath path = FileSystemHelper.computeRandomLocation((IPath)parent);
        while (pathVars.resolvePath(path).toFile().exists()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            path = FileSystemHelper.computeRandomLocation((IPath)parent);
        }
        this.toDelete.add(pathVars.resolvePath(path));
        return path;
    }

    public IPath getRandomRelativeProjectLocation() {
        IPathVariableManager pathVars = LinkedResourceWithPathVariableTest.getWorkspace().getPathVariableManager();
        Path parent = new Path(PROJECT_RELATIVE_VARIABLE_NAME);
        IPath path = FileSystemHelper.computeRandomLocation((IPath)parent);
        while (pathVars.resolvePath(path).toFile().exists()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            path = FileSystemHelper.computeRandomLocation((IPath)parent);
        }
        this.toDelete.add(pathVars.resolvePath(path));
        return path;
    }

    protected IPath resolve(IPath path) {
        return LinkedResourceWithPathVariableTest.getWorkspace().getPathVariableManager().resolvePath(path);
    }

    protected URI resolve(URI uri) {
        return LinkedResourceWithPathVariableTest.getWorkspace().getPathVariableManager().resolveURI(uri);
    }

    public void testProjectResolution() {
        IPath relativeValue;
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IPath value = manager.getValue(PROJECT_VARIABLE_NAME);
        LinkedResourceWithPathVariableTest.assertTrue((String)"1.0", (!value.equals((Object)(relativeValue = manager.getValue(PROJECT_RELATIVE_VARIABLE_NAME))) ? 1 : 0) != 0);
        IPath resolvedValue = manager.resolvePath(value);
        LinkedResourceWithPathVariableTest.assertTrue((String)"1.1", (boolean)value.equals((Object)resolvedValue));
        IPath resolvedRelativeValue = manager.resolvePath(relativeValue);
        LinkedResourceWithPathVariableTest.assertTrue((String)"1.2", (!relativeValue.equals((Object)resolvedRelativeValue) ? 1 : 0) != 0);
        LinkedResourceWithPathVariableTest.assertTrue((String)"1.3", (boolean)resolvedValue.equals((Object)resolvedRelativeValue));
    }

    public void testFileVariableRemoved() {
        IPathVariableManager manager = LinkedResourceWithPathVariableTest.getWorkspace().getPathVariableManager();
        IFile file = this.nonExistingFileInExistingProject;
        IPath existingValue = manager.getValue(VARIABLE_NAME);
        IPath variableBasedLocation = this.getRandomLocation();
        this.assertDoesNotExistInWorkspace("1.0", (IResource)file);
        try {
            file.createLink(variableBasedLocation, 16, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            file.setContents(this.getContents("contents for a file"), 1, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.0", (IResource)file);
        this.assertExistsInFileSystem("2.1", (IResource)file);
        try {
            manager.setValue(VARIABLE_NAME, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("3,1", (IResource)file);
        try {
            file.refreshLocal(1, this.getMonitor());
            file.getProject().refreshLocal(2, this.getMonitor());
        }
        catch (CoreException coreException) {
            LinkedResourceWithPathVariableTest.fail((String)"3.2");
        }
        this.assertExistsInWorkspace("3.3", (IResource)file);
        try {
            file.setContents(this.getContents("new contents"), 0, null);
            LinkedResourceWithPathVariableTest.fail((String)"3.4");
        }
        catch (CoreException coreException) {}
        this.assertExistsInWorkspace("3.5", (IResource)file);
        LinkedResourceWithPathVariableTest.assertNull((String)"3.6", (Object)file.getLocation());
        IFile other = this.existingProject.getFile("OtherVar");
        LinkedResourceWithPathVariableTest.getWorkspace().validateLinkLocation((IResource)other, this.getRandomLocation());
        try {
            manager.setValue(VARIABLE_NAME, existingValue);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"4.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("5.0", (IResource)file);
        LinkedResourceWithPathVariableTest.assertNotNull((String)"5.1", (Object)file.getLocation());
        this.assertExistsInFileSystem("5.2", (IResource)file);
        try {
            LinkedResourceWithPathVariableTest.assertTrue((String)"5.3", (boolean)this.compareContent(file.getContents(true), this.getContents("contents for a file")));
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"5.4", (Throwable)e);
        }
    }

    public void testFileProjectVariableRemoved() {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IFile file = this.nonExistingFileInExistingProject;
        IPath existingValue = manager.getValue(PROJECT_VARIABLE_NAME);
        IPath variableBasedLocation = this.getRandomProjectLocation();
        this.assertDoesNotExistInWorkspace("1.0", (IResource)file);
        try {
            file.createLink(variableBasedLocation, 16, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            file.setContents(this.getContents("contents for a file"), 1, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.0", (IResource)file);
        this.assertExistsInFileSystem("2.1", (IResource)file);
        try {
            manager.setValue(PROJECT_VARIABLE_NAME, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("3,1", (IResource)file);
        try {
            file.refreshLocal(1, this.getMonitor());
            file.getProject().refreshLocal(2, this.getMonitor());
        }
        catch (CoreException coreException) {
            LinkedResourceWithPathVariableTest.fail((String)"3.2");
        }
        this.assertExistsInWorkspace("3.3", (IResource)file);
        try {
            file.setContents(this.getContents("new contents"), 0, null);
            LinkedResourceWithPathVariableTest.fail((String)"3.4");
        }
        catch (CoreException coreException) {}
        this.assertExistsInWorkspace("3.5", (IResource)file);
        LinkedResourceWithPathVariableTest.assertNull((String)"3.6", (Object)file.getLocation());
        IFile other = this.existingProject.getFile("OtherVar");
        LinkedResourceWithPathVariableTest.getWorkspace().validateLinkLocation((IResource)other, this.getRandomLocation());
        try {
            manager.setValue(PROJECT_VARIABLE_NAME, existingValue);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"4.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("5.0", (IResource)file);
        LinkedResourceWithPathVariableTest.assertNotNull((String)"5.1", (Object)file.getLocation());
        this.assertExistsInFileSystem("5.2", (IResource)file);
        try {
            LinkedResourceWithPathVariableTest.assertTrue((String)"5.3", (boolean)this.compareContent(file.getContents(true), this.getContents("contents for a file")));
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"5.4", (Throwable)e);
        }
    }

    public void testMoveFileToDifferentProject() {
        IFile file = this.existingProjectInSubDirectory.getFile("my_link");
        IPath variableBasedLocation = null;
        IPath targetPath = this.existingProjectInSubDirectory.getLocation().removeLastSegments(1).append("outside.txt");
        if (!targetPath.toFile().exists()) {
            try {
                targetPath.toFile().createNewFile();
            }
            catch (IOException e2) {
                LinkedResourceWithPathVariableTest.fail((String)"0.4", (Throwable)e2);
            }
        }
        this.toDelete.add(targetPath);
        try {
            variableBasedLocation = this.convertToRelative(targetPath, (IResource)file, true, null);
        }
        catch (CoreException e1) {
            LinkedResourceWithPathVariableTest.fail((String)"0.99", (Throwable)e1);
        }
        IPath resolvedPath = URIUtil.toPath((URI)file.getPathVariableManager().resolveURI(URIUtil.toURI((IPath)variableBasedLocation)));
        this.assertDoesNotExistInWorkspace("1.0", (IResource)file);
        try {
            file.createLink(variableBasedLocation, 16, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.1", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.0", (IResource)file);
        this.assertExistsInFileSystem("2.1", (IResource)file);
        IFile newFile = this.nonExistingFileInExistingFolder;
        try {
            file.move(newFile.getFullPath(), 32, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("3,1", (IResource)newFile);
        LinkedResourceWithPathVariableTest.assertTrue((String)"3,2", (!newFile.getLocation().equals((Object)newFile.getRawLocation()) ? 1 : 0) != 0);
        LinkedResourceWithPathVariableTest.assertEquals((String)"3,3", (Object)newFile.getLocation(), (Object)resolvedPath);
    }

    private IPath convertToRelative(IPath path, IResource res, boolean force, String variableHint) throws CoreException {
        return URIUtil.toPath((URI)res.getPathVariableManager().convertToRelative(URIUtil.toURI((IPath)path), force, variableHint));
    }

    public void testPROJECT_LOC_MoveFileToDifferentProject() {
        String[] existingVariables = this.nonExistingFileInExistingFolder.getProject().getPathVariableManager().getPathVariableNames();
        int i = 0;
        while (i < existingVariables.length) {
            try {
                this.nonExistingFileInExistingFolder.getProject().getPathVariableManager().setValue(existingVariables[i], null);
            }
            catch (CoreException coreException) {}
            ++i;
        }
        IFile file = this.existingProjectInSubDirectory.getFile("my_link2");
        IPath variableBasedLocation = null;
        IPath targetPath = this.existingProjectInSubDirectory.getLocation().removeLastSegments(3).append("outside.txt");
        if (!targetPath.toFile().exists()) {
            try {
                targetPath.toFile().createNewFile();
            }
            catch (IOException e2) {
                LinkedResourceWithPathVariableTest.fail((String)"0.4", (Throwable)e2);
            }
        }
        this.toDelete.add(targetPath);
        try {
            this.existingProjectInSubDirectory.getPathVariableManager().setValue("P_RELATIVE", Path.fromPortableString((String)"${PARENT-3-PROJECT_LOC}"));
            variableBasedLocation = Path.fromPortableString((String)"P_RELATIVE/outside.txt");
        }
        catch (CoreException e1) {
            LinkedResourceWithPathVariableTest.fail((String)"0.99", (Throwable)e1);
        }
        IPath resolvedPath = this.existingProjectInSubDirectory.getPathVariableManager().resolvePath(variableBasedLocation);
        this.assertDoesNotExistInWorkspace("1.0", (IResource)file);
        try {
            file.createLink(variableBasedLocation, 16, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.1", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.0", (IResource)file);
        this.assertExistsInFileSystem("2.1", (IResource)file);
        IFile newFile = this.nonExistingFileInExistingFolder;
        try {
            file.move(newFile.getFullPath(), 32, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("3,1", (IResource)newFile);
        IPath newLocation = newFile.getLocation();
        LinkedResourceWithPathVariableTest.assertTrue((String)"3,2", (!newLocation.equals((Object)newFile.getRawLocation()) ? 1 : 0) != 0);
        IPath newRawLocation = newFile.getRawLocation();
        LinkedResourceWithPathVariableTest.assertTrue((String)"3,4", (boolean)newRawLocation.equals((Object)variableBasedLocation));
        LinkedResourceWithPathVariableTest.assertTrue((String)"3,5", (boolean)newLocation.equals((Object)resolvedPath));
    }

    public void testMoveFileProjectVariable() {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IFile file = this.nonExistingFileInExistingProject;
        IPath variableBasedLocation = this.getRandomProjectLocation();
        IPath resolvedPath = manager.resolvePath(variableBasedLocation);
        this.assertDoesNotExistInWorkspace("1.0", (IResource)file);
        try {
            file.createLink(variableBasedLocation, 16, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            file.setContents(this.getContents("contents for a file"), 1, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.0", (IResource)file);
        this.assertExistsInFileSystem("2.1", (IResource)file);
        IFile newFile = this.nonExistingFileInExistingFolder;
        try {
            file.move(newFile.getFullPath(), 32, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("3,1", (IResource)newFile);
        LinkedResourceWithPathVariableTest.assertTrue((String)"3,2", (!newFile.getLocation().equals((Object)newFile.getRawLocation()) ? 1 : 0) != 0);
        LinkedResourceWithPathVariableTest.assertTrue((String)"3,3", (boolean)newFile.getRawLocation().equals((Object)variableBasedLocation));
        LinkedResourceWithPathVariableTest.assertTrue((String)"3,4", (boolean)newFile.getRawLocation().equals((Object)variableBasedLocation));
        LinkedResourceWithPathVariableTest.assertTrue((String)"3,5", (boolean)newFile.getLocation().equals((Object)resolvedPath));
    }

    public void testMoveFileToNewProjectProjectVariable() {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IFile file = this.nonExistingFileInExistingProject;
        IPath variableBasedLocation = this.getRandomRelativeProjectLocation();
        IPath resolvedPath = manager.resolvePath(variableBasedLocation);
        this.assertDoesNotExistInWorkspace("1.0", (IResource)file);
        try {
            file.createLink(variableBasedLocation, 16, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            file.setContents(this.getContents("contents for a file"), 1, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.0", (IResource)file);
        this.assertExistsInFileSystem("2.1", (IResource)file);
        IFile newFile = this.nonExistingFileInOtherExistingProject;
        try {
            file.move(newFile.getFullPath(), 32, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("3,1", (IResource)newFile);
        LinkedResourceWithPathVariableTest.assertTrue((String)"3,2", (!newFile.getLocation().equals((Object)newFile.getRawLocation()) ? 1 : 0) != 0);
        LinkedResourceWithPathVariableTest.assertTrue((String)"3,3", (boolean)newFile.getRawLocation().equals((Object)variableBasedLocation));
        LinkedResourceWithPathVariableTest.assertTrue((String)"3,4", (boolean)newFile.getLocation().equals((Object)resolvedPath));
    }

    public void testFileProjectRelativeVariableRemoved() {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IFile file = this.nonExistingFileInExistingProject;
        IPath existingValue = manager.getValue(PROJECT_RELATIVE_VARIABLE_NAME);
        IPath variableBasedLocation = this.getRandomRelativeProjectLocation();
        this.assertDoesNotExistInWorkspace("1.0", (IResource)file);
        try {
            file.createLink(variableBasedLocation, 16, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            file.setContents(this.getContents("contents for a file"), 1, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.0", (IResource)file);
        this.assertExistsInFileSystem("2.1", (IResource)file);
        try {
            manager.setValue(PROJECT_RELATIVE_VARIABLE_NAME, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("3,1", (IResource)file);
        try {
            file.refreshLocal(1, this.getMonitor());
            file.getProject().refreshLocal(2, this.getMonitor());
        }
        catch (CoreException coreException) {
            LinkedResourceWithPathVariableTest.fail((String)"3.2");
        }
        this.assertExistsInWorkspace("3.3", (IResource)file);
        try {
            file.setContents(this.getContents("new contents"), 0, null);
            LinkedResourceWithPathVariableTest.fail((String)"3.4");
        }
        catch (CoreException coreException) {}
        this.assertExistsInWorkspace("3.5", (IResource)file);
        LinkedResourceWithPathVariableTest.assertNull((String)"3.6", (Object)file.getLocation());
        IFile other = this.existingProject.getFile("OtherVar");
        LinkedResourceWithPathVariableTest.getWorkspace().validateLinkLocation((IResource)other, this.getRandomLocation());
        try {
            manager.setValue(PROJECT_RELATIVE_VARIABLE_NAME, existingValue);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"4.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("5.0", (IResource)file);
        LinkedResourceWithPathVariableTest.assertNotNull((String)"5.1", (Object)file.getLocation());
        this.assertExistsInFileSystem("5.2", (IResource)file);
        try {
            LinkedResourceWithPathVariableTest.assertTrue((String)"5.3", (boolean)this.compareContent(file.getContents(true), this.getContents("contents for a file")));
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"5.4", (Throwable)e);
        }
    }

    public void testFolderVariableRemoved() {
        IPathVariableManager manager = LinkedResourceWithPathVariableTest.getWorkspace().getPathVariableManager();
        IFolder folder = this.nonExistingFolderInExistingProject;
        IFile childFile = folder.getFile(this.childName);
        IPath existingValue = manager.getValue(VARIABLE_NAME);
        IPath variableBasedLocation = this.getRandomLocation();
        this.assertDoesNotExistInWorkspace("1.0", (IResource)folder);
        try {
            folder.createLink(variableBasedLocation, 16, null);
            childFile.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            childFile.setContents(this.getContents("contents for a file"), 1, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.0", (IResource)folder);
        this.assertExistsInWorkspace("2.1", (IResource)childFile);
        this.assertExistsInFileSystem("2.2", (IResource)folder);
        this.assertExistsInFileSystem("2.3", (IResource)childFile);
        try {
            manager.setValue(VARIABLE_NAME, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("3.1", (IResource)folder);
        try {
            folder.refreshLocal(2, this.getMonitor());
            folder.getProject().refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"3.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("3.3", (IResource)folder);
        this.assertDoesNotExistInWorkspace("3.4", (IResource)childFile);
        IFile destination = folder.getFile(this.existingFileInExistingProject.getName());
        try {
            this.existingFileInExistingProject.copy(destination.getFullPath(), 0, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"3.5");
        }
        catch (CoreException coreException) {}
        LinkedResourceWithPathVariableTest.assertTrue((String)"3.6", (!destination.exists() ? 1 : 0) != 0);
        try {
            destination.create(this.getRandomContents(), 0, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"3.7");
        }
        catch (CoreException coreException) {}
        IFolder subFolder = folder.getFolder("SubFolder");
        try {
            subFolder.create(0, true, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"3.8");
        }
        catch (CoreException coreException) {}
        try {
            childFile.setContents(this.getContents("new contents"), 0, null);
            LinkedResourceWithPathVariableTest.fail((String)"4.0");
        }
        catch (CoreException coreException) {}
        this.assertExistsInWorkspace("4.1", (IResource)folder);
        LinkedResourceWithPathVariableTest.assertNull((String)"4.2", (Object)folder.getLocation());
        try {
            manager.setValue(VARIABLE_NAME, existingValue);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"5.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("6.0", (IResource)folder);
        LinkedResourceWithPathVariableTest.assertNotNull((String)"6.1", (Object)folder.getLocation());
        this.assertExistsInFileSystem("6.2", (IResource)folder);
        this.assertDoesNotExistInWorkspace("6.3", (IResource)childFile);
        this.assertExistsInFileSystem("6.4", (IResource)childFile);
        try {
            folder.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"7.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("7.1", (IResource)folder);
        this.assertExistsInWorkspace("7.2", (IResource)childFile);
    }

    public void testImportWrongLineEndings_Bug210664() throws IOException {
        IProject proj = this.existingProject;
        IFileStore projStore = null;
        IPath randomLocationWithPathVariable = this.getRandomLocation();
        try {
            projStore = EFS.getStore((URI)proj.getLocationURI());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.0", (Throwable)e);
        }
        if ((projStore.getFileSystem().attributes() & 2) == 0) {
            return;
        }
        try {
            IFolder folder = proj.getFolder("SOME_LINK");
            folder.createLink(randomLocationWithPathVariable, 16, null);
            IFileStore projFile = projStore.getChild(".project");
            proj.delete(8, this.getMonitor());
            IFileStore projNew = projStore.getChild(".project.new");
            this.convertLineEndings(projFile, projNew, this.getMonitor());
            projNew.move(projFile, 2, this.getMonitor());
            IFileInfo info = projFile.fetchInfo(0, this.getMonitor());
            info.setAttribute(2, true);
            projFile.putInfo(info, 1024, this.getMonitor());
            this.toSetWritable = projFile;
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            proj.create(null);
            proj.open(0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testFolderProjectVariableRemoved() {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IFolder folder = this.nonExistingFolderInExistingProject;
        IFile childFile = folder.getFile(this.childName);
        IPath existingValue = manager.getValue(PROJECT_VARIABLE_NAME);
        IPath variableBasedLocation = this.getRandomProjectLocation();
        this.assertDoesNotExistInWorkspace("1.0", (IResource)folder);
        try {
            folder.createLink(variableBasedLocation, 16, null);
            childFile.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            childFile.setContents(this.getContents("contents for a file"), 1, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.0", (IResource)folder);
        this.assertExistsInWorkspace("2.1", (IResource)childFile);
        this.assertExistsInFileSystem("2.2", (IResource)folder);
        this.assertExistsInFileSystem("2.3", (IResource)childFile);
        try {
            manager.setValue(PROJECT_VARIABLE_NAME, null);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("3.1", (IResource)folder);
        try {
            folder.refreshLocal(2, this.getMonitor());
            folder.getProject().refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"3.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("3.3", (IResource)folder);
        this.assertDoesNotExistInWorkspace("3.4", (IResource)childFile);
        IFile destination = folder.getFile(this.existingFileInExistingProject.getName());
        try {
            this.existingFileInExistingProject.copy(destination.getFullPath(), 0, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"3.5");
        }
        catch (CoreException coreException) {}
        LinkedResourceWithPathVariableTest.assertTrue((String)"3.6", (!destination.exists() ? 1 : 0) != 0);
        try {
            destination.create(this.getRandomContents(), 0, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"3.7");
        }
        catch (CoreException coreException) {}
        IFolder subFolder = folder.getFolder("SubFolder");
        try {
            subFolder.create(0, true, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"3.8");
        }
        catch (CoreException coreException) {}
        try {
            childFile.setContents(this.getContents("new contents"), 0, null);
            LinkedResourceWithPathVariableTest.fail((String)"4.0");
        }
        catch (CoreException coreException) {}
        this.assertExistsInWorkspace("4.1", (IResource)folder);
        LinkedResourceWithPathVariableTest.assertNull((String)"4.2", (Object)folder.getLocation());
        try {
            manager.setValue(PROJECT_VARIABLE_NAME, existingValue);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"5.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("6.0", (IResource)folder);
        LinkedResourceWithPathVariableTest.assertNotNull((String)"6.1", (Object)folder.getLocation());
        this.assertExistsInFileSystem("6.2", (IResource)folder);
        this.assertDoesNotExistInWorkspace("6.3", (IResource)childFile);
        this.assertExistsInFileSystem("6.4", (IResource)childFile);
        try {
            folder.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"7.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("7.1", (IResource)folder);
        this.assertExistsInWorkspace("7.2", (IResource)childFile);
    }

    public void testUndefinedVariable() {
        Path folderLocation = new Path("NOVAR/folder");
        Path fileLocation = new Path("NOVAR/abc.txt");
        IFile testFile = this.existingProject.getFile("UndefinedVar.txt");
        IFolder testFolder = this.existingProject.getFolder("UndefinedVarTest");
        try {
            testFile.createLink((IPath)fileLocation, 0, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        try {
            testFolder.createLink((IPath)folderLocation, 0, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
        LinkedResourceWithPathVariableTest.assertTrue((String)"1.2", (LinkedResourceWithPathVariableTest.getWorkspace().validateLinkLocation((IResource)testFolder, (IPath)folderLocation).getSeverity() == 2 ? 1 : 0) != 0);
        LinkedResourceWithPathVariableTest.assertTrue((String)"1.3", (LinkedResourceWithPathVariableTest.getWorkspace().validateLinkLocation((IResource)testFile, (IPath)fileLocation).getSeverity() == 2 ? 1 : 0) != 0);
        try {
            testFile.createLink((IPath)fileLocation, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            testFolder.createLink((IPath)folderLocation, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"2.1", (Throwable)e);
        }
        IPath copyFileDestination = this.existingProject.getFullPath().append("CopyFileDest");
        IPath copyFolderDestination = this.existingProject.getFullPath().append("CopyFolderDest");
        try {
            testFile.copy(copyFileDestination, 0, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
        try {
            testFolder.copy(copyFolderDestination, 0, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"3.1");
        }
        catch (CoreException coreException) {}
        IPath moveFileDestination = this.existingProject.getFullPath().append("MoveFileDest");
        IPath moveFolderDestination = this.existingProject.getFullPath().append("MoveFolderDest");
        try {
            testFile.move(moveFileDestination, 0, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"4.0");
        }
        catch (CoreException coreException) {}
        try {
            testFolder.move(moveFolderDestination, 0, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"4.1");
        }
        catch (CoreException coreException) {}
        try {
            testFile.refreshLocal(2, this.getMonitor());
            testFolder.refreshLocal(2, this.getMonitor());
            testFile.refreshLocal(0, this.getMonitor());
            testFolder.refreshLocal(0, this.getMonitor());
            this.existingProject.refreshLocal(0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"5.0", (Throwable)e);
        }
        try {
            IProject project = testFolder.getProject();
            IProjectDescription desc = project.getDescription();
            desc.setName("moveDest");
            project.move(desc, 33, this.getMonitor());
        }
        catch (CoreException coreException) {
            LinkedResourceWithPathVariableTest.fail((String)"6.0");
        }
        try {
            testFile.delete(0, this.getMonitor());
            testFolder.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"9.0", (Throwable)e);
        }
    }

    public void testVariableChanged() {
        IPathVariableManager manager = LinkedResourceWithPathVariableTest.getWorkspace().getPathVariableManager();
        IPath existingValue = manager.getValue(VARIABLE_NAME);
        IFile file = this.nonExistingFileInExistingProject;
        IPath variableBasedLocation = this.getRandomLocation();
        this.assertDoesNotExistInWorkspace("1.0", (IResource)file);
        try {
            file.createLink(variableBasedLocation, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            file.setContents(this.getContents("contents for a file"), 1, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.0", (IResource)file);
        this.assertExistsInFileSystem("2.1", (IResource)file);
        try {
            IPath newLocation = super.getRandomLocation();
            this.toDelete.add(newLocation);
            manager.setValue(VARIABLE_NAME, newLocation);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"2.2", (Throwable)e);
        }
        try {
            file.setContents(this.getContents("new contents"), 0, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"3.0");
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.assertEquals((String)"3.1", (int)274, (int)e.getStatus().getCode());
        }
        this.assertExistsInWorkspace("3.2", (IResource)file);
        this.assertDoesNotExistInFileSystem("3.3", (IResource)file);
        try {
            file.setContents(this.getContents("contents in different location"), 1, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"4.0", (Throwable)e);
        }
        this.assertExistsInFileSystem("4.1", (IResource)file);
        IPath expectedNewLocation = manager.resolvePath(variableBasedLocation);
        IPath actualNewLocation = file.getLocation();
        LinkedResourceWithPathVariableTest.assertEquals((String)"4.2", (Object)expectedNewLocation, (Object)actualNewLocation);
        try {
            LinkedResourceWithPathVariableTest.assertTrue((String)"4.3", (boolean)this.compareContent(file.getContents(), this.getContents("contents in different location")));
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"4.4", (Throwable)e);
        }
        this.ensureDoesNotExistInFileSystem((IResource)file);
        try {
            manager.setValue(VARIABLE_NAME, existingValue);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"5.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("5.1", (IResource)file);
        this.assertExistsInFileSystem("5.2", (IResource)file);
        try {
            LinkedResourceWithPathVariableTest.assertTrue((String)"5.3", (boolean)this.compareContent(file.getContents(true), this.getContents("contents for a file")));
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"5.4", (Throwable)e);
        }
    }

    public void testProjectVariableChanged() {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        IPath existingValue = manager.getValue(PROJECT_VARIABLE_NAME);
        IFile file = this.nonExistingFileInExistingProject;
        IPath variableBasedLocation = this.getRandomProjectLocation();
        this.assertDoesNotExistInWorkspace("1.0", (IResource)file);
        try {
            file.createLink(variableBasedLocation, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            file.setContents(this.getContents("contents for a file"), 1, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"1.2", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.0", (IResource)file);
        this.assertExistsInFileSystem("2.1", (IResource)file);
        try {
            IPath newLocation = super.getRandomLocation();
            this.toDelete.add(newLocation);
            manager.setValue(PROJECT_VARIABLE_NAME, newLocation);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"2.2", (Throwable)e);
        }
        try {
            file.setContents(this.getContents("new contents"), 0, this.getMonitor());
            LinkedResourceWithPathVariableTest.fail((String)"3.0");
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.assertEquals((String)"3.1", (int)274, (int)e.getStatus().getCode());
        }
        this.assertExistsInWorkspace("3.2", (IResource)file);
        this.assertDoesNotExistInFileSystem("3.3", (IResource)file);
        try {
            file.setContents(this.getContents("contents in different location"), 1, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"4.0", (Throwable)e);
        }
        this.assertExistsInFileSystem("4.1", (IResource)file);
        IPath expectedNewLocation = manager.resolvePath(variableBasedLocation);
        IPath actualNewLocation = file.getLocation();
        LinkedResourceWithPathVariableTest.assertEquals((String)"4.2", (Object)expectedNewLocation, (Object)actualNewLocation);
        try {
            LinkedResourceWithPathVariableTest.assertTrue((String)"4.3", (boolean)this.compareContent(file.getContents(), this.getContents("contents in different location")));
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"4.4", (Throwable)e);
        }
        this.ensureDoesNotExistInFileSystem((IResource)file);
        try {
            manager.setValue(PROJECT_VARIABLE_NAME, existingValue);
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"5.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("5.1", (IResource)file);
        this.assertExistsInFileSystem("5.2", (IResource)file);
        try {
            LinkedResourceWithPathVariableTest.assertTrue((String)"5.3", (boolean)this.compareContent(file.getContents(true), this.getContents("contents for a file")));
        }
        catch (CoreException e) {
            LinkedResourceWithPathVariableTest.fail((String)"5.4", (Throwable)e);
        }
    }

    public void testNonRedundentPathVariablesGenerated() {
        IFile file = this.existingProjectInSubDirectory.getFile("my_link");
        IPathVariableManager pathVariableManager = this.existingProjectInSubDirectory.getPathVariableManager();
        IPath variableBasedLocation = null;
        IPath targetPath = this.existingProjectInSubDirectory.getLocation().removeLastSegments(1).append("outside.txt");
        if (!targetPath.toFile().exists()) {
            try {
                targetPath.toFile().createNewFile();
            }
            catch (IOException e2) {
                LinkedResourceWithPathVariableTest.fail((String)"1.0", (Throwable)e2);
            }
        }
        this.toDelete.add(targetPath);
        try {
            variableBasedLocation = this.convertToRelative(targetPath, (IResource)file, true, null);
        }
        catch (CoreException e1) {
            LinkedResourceWithPathVariableTest.fail((String)"2.0", (Throwable)e1);
        }
        IPath resolvedPath = URIUtil.toPath((URI)pathVariableManager.resolveURI(URIUtil.toURI((IPath)variableBasedLocation)));
        this.assertDoesNotExistInWorkspace("3.0", (IResource)file);
        LinkedResourceWithPathVariableTest.assertEquals((String)"3.1", (Object)targetPath, (Object)resolvedPath);
        try {
            variableBasedLocation = this.convertToRelative(targetPath, (IResource)file, true, null);
        }
        catch (CoreException e1) {
            LinkedResourceWithPathVariableTest.fail((String)"4.0", (Throwable)e1);
        }
        resolvedPath = URIUtil.toPath((URI)pathVariableManager.resolveURI(URIUtil.toURI((IPath)variableBasedLocation)));
        this.assertDoesNotExistInWorkspace("5.0", (IResource)file);
        LinkedResourceWithPathVariableTest.assertEquals((String)"5.1", (Object)targetPath, (Object)resolvedPath);
    }

    public void testConvertToUserEditableFormat() {
        IPathVariableManager pathVariableManager = this.existingProject.getPathVariableManager();
        String[][] table = new String[][]{{"C:\\foo\\bar", "C:\\foo\\bar", "C:/foo/bar"}, {"C:/foo/bar", "C:/foo/bar"}, {"VAR/foo/bar", "VAR/foo/bar"}, {"${VAR}/foo/bar", "${VAR}/foo/bar"}, {"${VAR}/../foo/bar", "${VAR}/../foo/bar", "${PARENT-1-VAR}/foo/bar"}, {"${PARENT-1-VAR}/foo/bar", "${VAR}/../foo/bar"}, {"${PARENT-0-VAR}/foo/bar", "${VAR}/foo/bar", "${VAR}/foo/bar"}, {"${PARENT-VAR}/foo/bar", "${PARENT-VAR}/foo/bar"}, {"${PARENT-2}/foo/bar", "${PARENT-2}/foo/bar"}, {"${PARENT}/foo/bar", "${PARENT}/foo/bar"}, {"${PARENT-2-VAR}/foo/bar", "${VAR}/../../foo/bar"}, {"${PARENT-2-VAR}/foo/${PARENT-4-BAR}", "${VAR}/../../foo/${BAR}/../../../.."}, {"${PARENT-2-VAR}/foo${PARENT-4-BAR}", "${VAR}/../../foo${BAR}/../../../.."}, {"${PARENT-2-VAR}/${PARENT-4-BAR}/foo", "${VAR}/../../${BAR}/../../../../foo"}, {"${PARENT-2-VAR}/f${PARENT-4-BAR}/oo", "${VAR}/../../f${BAR}/../../../../oo"}};
        int i = 0;
        while (i < table.length) {
            String result = pathVariableManager.convertToUserEditableFormat(this.toOS(table[i][0]), false);
            LinkedResourceWithPathVariableTest.assertEquals((String)("1." + i), (String)this.toOS(table[i][1]), (String)result);
            String original = pathVariableManager.convertFromUserEditableFormat(result, false);
            LinkedResourceWithPathVariableTest.assertEquals((String)("2." + i), (String)this.toOS(table[i].length == 2 ? table[i][0] : table[i][2]), (String)original);
            ++i;
        }
        String[][] tableLocationFormat = new String[][]{{"C:\\foo\\bar", "C:\\foo\\bar", "C:/foo/bar"}, {"C:/foo/bar", "C:/foo/bar"}, {"VAR/foo/bar", "VAR/foo/bar"}, {"${VAR}/../foo/bar", "${VAR}/../foo/bar", "PARENT-1-VAR/foo/bar"}, {"PARENT-1-VAR/foo/bar", "VAR/../foo/bar"}, {"PARENT-0-VAR/foo/bar", "VAR/foo/bar", "VAR/foo/bar"}, {"PARENT-VAR/foo/bar", "PARENT-VAR/foo/bar"}, {"PARENT-2/foo/bar", "PARENT-2/foo/bar"}, {"PARENT/foo/bar", "PARENT/foo/bar"}, {"PARENT-2-VAR/foo/bar", "VAR/../../foo/bar"}, {"PARENT-2-VAR/foo/PARENT-4-BAR", "VAR/../../foo/PARENT-4-BAR"}, {"PARENT-2-VAR/fooPARENT-4-BAR", "VAR/../../fooPARENT-4-BAR"}, {"PARENT-2-VAR/PARENT-4-BAR/foo", "VAR/../../PARENT-4-BAR/foo"}, {"PARENT-2-VAR/fPARENT-4-BAR/oo", "VAR/../../fPARENT-4-BAR/oo"}, {"/foo/bar", "/foo/bar"}};
        int i2 = 0;
        while (i2 < table.length) {
            String result = pathVariableManager.convertToUserEditableFormat(this.toOS(tableLocationFormat[i2][0]), true);
            LinkedResourceWithPathVariableTest.assertEquals((String)("3." + i2), (String)this.toOS(tableLocationFormat[i2][1]), (String)result);
            String original = pathVariableManager.convertFromUserEditableFormat(result, true);
            LinkedResourceWithPathVariableTest.assertEquals((String)("4." + i2), (String)this.toOS(tableLocationFormat[i2].length == 2 ? tableLocationFormat[i2][0] : tableLocationFormat[i2][2]), (String)original);
            ++i2;
        }
    }

    private String toOS(String path) {
        return path.replace('/', File.separatorChar);
    }

    public void testPrefixVariablesAreNotConfused() {
        URI uri = this.nonExistingFileInExistingFolder.getPathVariableManager().getURIValue("PARENT");
        LinkedResourceWithPathVariableTest.assertEquals((String)"1.0", (Object)uri, null);
        uri = this.nonExistingFileInExistingFolder.getPathVariableManager().getURIValue("PARENT_LOC");
        LinkedResourceWithPathVariableTest.assertNotNull((String)"1.1", (Object)uri);
    }

    public void test338185() {
        IPathVariableManager manager = this.existingProject.getPathVariableManager();
        String[] variables = manager.getPathVariableNames();
        boolean found = false;
        int i = 0;
        while (i < variables.length) {
            if (variables[i].equals("Test338185")) {
                found = true;
            }
            ++i;
        }
        LinkedResourceWithPathVariableTest.assertTrue((boolean)found);
    }
}

