/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import junit.framework.TestResult;
import org.eclipse.core.tests.harness.LoggingPerformanceTestResult;
import org.eclipse.core.tests.harness.PerformanceTestResult;
import org.eclipse.core.tests.resources.ResourceTest;

public abstract class OldCorePerformanceTest
extends ResourceTest {
    protected long benchStart;
    protected LoggingPerformanceTestResult logger = null;
    protected PerformanceTestResult result = null;

    public OldCorePerformanceTest() {
    }

    public OldCorePerformanceTest(String name) {
        super(name);
    }

    protected PerformanceTestResult defaultTest() {
        return new PerformanceTestResult();
    }

    public void perfLog(String s) {
        if (this.logger != null) {
            this.logger.log(s);
        } else {
            System.out.println(s);
        }
    }

    public TestResult run() {
        PerformanceTestResult test = this.defaultTest();
        this.run(test);
        return test;
    }

    public void run(PerformanceTestResult test) {
        this.result = test;
        if (test instanceof LoggingPerformanceTestResult) {
            this.logger = (LoggingPerformanceTestResult)test;
        }
        super.run((TestResult)test);
    }

    protected void startBench() {
        int i = 0;
        while (i < 20) {
            System.gc();
            ++i;
        }
        this.benchStart = System.currentTimeMillis();
    }

    protected void startTimer(String timerName) {
        this.result.startTimer(timerName);
    }

    protected void stopBench(String benchName, int numOperations) {
        long duration = System.currentTimeMillis() - this.benchStart;
        double perOp = (double)duration / (double)numOperations;
        String opString = perOp > 100.0 ? "(" + perOp + "ms per operation)" : "(" + perOp * 1000.0 + "us per operation)";
        System.out.println(String.valueOf(benchName) + " took " + duration + "ms " + opString);
    }

    protected void stopTimer(String timerName) {
        this.result.stopTimer(timerName);
    }
}

