/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTest;

public class VirtualFolderTest
extends ResourceTest {
    protected IProject existingProject;
    protected IFolder existingVirtualFolderInExistingProject;

    public static Test suite() {
        return new TestSuite(VirtualFolderTest.class);
    }

    public VirtualFolderTest() {
    }

    public VirtualFolderTest(String name) {
        super(name);
    }

    protected void doCleanup() throws Exception {
        this.ensureExistsInWorkspace(new IResource[]{this.existingProject}, true);
        this.existingVirtualFolderInExistingProject.create(8192, true, this.getMonitor());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.existingProject = VirtualFolderTest.getWorkspace().getRoot().getProject("ExistingProject");
        this.existingVirtualFolderInExistingProject = this.existingProject.getFolder("existingVirtualFolderInExistingProject");
        this.doCleanup();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateVirtualFolder() {
        IFolder virtualFolder = this.existingProject.getFolder(this.getUniqueString());
        try {
            virtualFolder.create(8192, true, this.getMonitor());
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"1.0", (Throwable)e);
        }
        VirtualFolderTest.assertTrue((String)"2.0", (boolean)virtualFolder.exists());
        VirtualFolderTest.assertTrue((String)"3.0", (boolean)virtualFolder.isVirtual());
        try {
            virtualFolder.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"4.0", (Throwable)e);
        }
    }

    public void testCreateFileUnderVirtualFolder() {
        IFile file = this.existingVirtualFolderInExistingProject.getFile(this.getUniqueString());
        boolean failed = false;
        try {
            this.create((IResource)file, true);
            VirtualFolderTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {
            failed = true;
        }
        VirtualFolderTest.assertTrue((String)"2.0", (!file.exists() ? 1 : 0) != 0);
        VirtualFolderTest.assertTrue((String)"3.0", (boolean)failed);
    }

    public void testCreateFolderUnderVirtualFolder() {
        IFolder folder = this.existingVirtualFolderInExistingProject.getFolder(this.getUniqueString());
        boolean failed = false;
        try {
            this.create((IResource)folder, true);
            VirtualFolderTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {
            failed = true;
        }
        VirtualFolderTest.assertTrue((String)"2.0", (!folder.exists() ? 1 : 0) != 0);
        VirtualFolderTest.assertTrue((String)"3.0", (boolean)failed);
    }

    public void testCreateVirtualFolderUnderVirtualFolder() {
        IFolder virtualFolder = this.existingVirtualFolderInExistingProject.getFolder(this.getUniqueString());
        try {
            virtualFolder.create(8192, true, null);
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"1.0", (Throwable)e);
        }
        VirtualFolderTest.assertTrue((String)"2.0", (boolean)virtualFolder.exists());
        VirtualFolderTest.assertTrue((String)"3.0", (boolean)virtualFolder.isVirtual());
        try {
            virtualFolder.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"4.0", (Throwable)e);
        }
    }

    public void testCreateLinkedFolderUnderVirtualFolder() {
        IPath location = this.getRandomLocation();
        IFolder linkedFolder = this.existingVirtualFolderInExistingProject.getFolder(this.getUniqueString());
        try {
            linkedFolder.createLink(location, 16, this.getMonitor());
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"1.0", (Throwable)e);
        }
        VirtualFolderTest.assertTrue((String)"2.0", (boolean)linkedFolder.exists());
        VirtualFolderTest.assertEquals((String)"3.0", (Object)location, (Object)linkedFolder.getLocation());
        VirtualFolderTest.assertTrue((String)"4.0", (!location.toFile().exists() ? 1 : 0) != 0);
        try {
            VirtualFolderTest.assertEquals((String)"5.0", (int)0, (int)linkedFolder.members().length);
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"6.0", (Throwable)e);
        }
        try {
            linkedFolder.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"7.0", (Throwable)e);
        }
    }

    public void testCreateLinkedFileUnderVirtualFolder() {
        IPath location = this.getRandomLocation();
        IFile file = this.existingVirtualFolderInExistingProject.getFile(this.getUniqueString());
        try {
            file.createLink(location, 16, this.getMonitor());
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"1.0", (Throwable)e);
        }
        VirtualFolderTest.assertTrue((String)"2.0", (boolean)file.exists());
        VirtualFolderTest.assertEquals((String)"3.0", (Object)location, (Object)file.getLocation());
        VirtualFolderTest.assertTrue((String)"4.0", (!location.toFile().exists() ? 1 : 0) != 0);
        try {
            file.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"5.0", (Throwable)e);
        }
    }

    public void testCopyProjectWithVirtualFolder() {
        IPath fileLocation = this.getRandomLocation();
        IPath folderLocation = this.getRandomLocation();
        IFile linkedFile = this.existingVirtualFolderInExistingProject.getFile(this.getUniqueString());
        IFolder linkedFolder = this.existingVirtualFolderInExistingProject.getFolder(this.getUniqueString());
        try {
            try {
                this.createFileInFileSystem(fileLocation, this.getRandomContents());
                folderLocation.toFile().mkdir();
                linkedFolder.createLink(folderLocation, 0, this.getMonitor());
                linkedFile.createLink(fileLocation, 0, this.getMonitor());
            }
            catch (CoreException e) {
                VirtualFolderTest.fail((String)"1.0", (Throwable)e);
            }
            IProject destinationProject = VirtualFolderTest.getWorkspace().getRoot().getProject("CopyTargetProject");
            try {
                this.existingProject.copy(destinationProject.getFullPath(), 32, this.getMonitor());
            }
            catch (CoreException e) {
                VirtualFolderTest.fail((String)"2.0", (Throwable)e);
            }
            IFile newFile = destinationProject.getFile(linkedFile.getProjectRelativePath());
            VirtualFolderTest.assertTrue((String)"3.0", (boolean)newFile.isLinked());
            VirtualFolderTest.assertEquals((String)"3.1", (Object)linkedFile.getLocation(), (Object)newFile.getLocation());
            VirtualFolderTest.assertTrue((String)"3.2", (boolean)newFile.getParent().isVirtual());
            IFolder newFolder = destinationProject.getFolder(linkedFolder.getProjectRelativePath());
            VirtualFolderTest.assertTrue((String)"4.0", (boolean)newFolder.isLinked());
            VirtualFolderTest.assertEquals((String)"4.1", (Object)linkedFolder.getLocation(), (Object)newFolder.getLocation());
            VirtualFolderTest.assertTrue((String)"4.2", (boolean)newFolder.getParent().isVirtual());
            try {
                destinationProject.delete(0, this.getMonitor());
                this.existingProject.copy(destinationProject.getFullPath(), 0, this.getMonitor());
            }
            catch (CoreException e) {
                VirtualFolderTest.fail((String)"5.0", (Throwable)e);
            }
            VirtualFolderTest.assertTrue((String)"5.1", (boolean)newFile.isLinked());
            VirtualFolderTest.assertEquals((String)"5.2", (Object)linkedFile.getLocation(), (Object)newFile.getLocation());
            VirtualFolderTest.assertTrue((String)"5.3", (boolean)newFile.getParent().isVirtual());
            VirtualFolderTest.assertTrue((String)"5.4", (boolean)newFolder.isLinked());
            VirtualFolderTest.assertEquals((String)"5.5", (Object)linkedFolder.getLocation(), (Object)newFolder.getLocation());
            VirtualFolderTest.assertTrue((String)"5.6", (boolean)newFolder.getParent().isVirtual());
            try {
                destinationProject.delete(0, this.getMonitor());
            }
            catch (CoreException e) {
                VirtualFolderTest.fail((String)"6.0", (Throwable)e);
            }
        }
        finally {
            Workspace.clear((File)fileLocation.toFile());
            Workspace.clear((File)folderLocation.toFile());
        }
    }

    public void testMoveProjectWithVirtualFolder() {
        IPath fileLocation = this.getRandomLocation();
        IPath folderLocation = this.getRandomLocation();
        IFile file = this.existingVirtualFolderInExistingProject.getFile(this.getUniqueString());
        IFolder folder = this.existingVirtualFolderInExistingProject.getFolder(this.getUniqueString());
        IFile childFile = folder.getFile(this.getUniqueString());
        IResource[] oldResources = new IResource[]{this.existingProject, file, folder, childFile};
        try {
            this.assertDoesNotExistInWorkspace("1.0", new IResource[]{folder, file, childFile});
            try {
                this.createFileInFileSystem(fileLocation);
                folderLocation.toFile().mkdir();
                folder.createLink(folderLocation, 0, this.getMonitor());
                file.createLink(fileLocation, 0, this.getMonitor());
                childFile.create(this.getRandomContents(), true, this.getMonitor());
            }
            catch (CoreException e) {
                VirtualFolderTest.fail((String)"2.0", (Throwable)e);
            }
            IProject destinationProject = VirtualFolderTest.getWorkspace().getRoot().getProject("MoveTargetProject");
            this.assertDoesNotExistInWorkspace("3.0", (IResource)destinationProject);
            try {
                this.existingProject.move(destinationProject.getFullPath(), 32, this.getMonitor());
            }
            catch (CoreException e) {
                VirtualFolderTest.fail((String)"4.0", (Throwable)e);
            }
            IFile newFile = destinationProject.getFile(file.getProjectRelativePath());
            IFolder newFolder = destinationProject.getFolder(folder.getProjectRelativePath());
            IFile newChildFile = newFolder.getFile(childFile.getName());
            IResource[] newResources = new IResource[]{destinationProject, newFile, newFolder, newChildFile};
            this.assertExistsInWorkspace("5.0", newResources);
            this.assertDoesNotExistInWorkspace("6.1", oldResources);
            VirtualFolderTest.assertTrue((String)"7.0", (boolean)this.existingProject.isSynchronized(2));
            VirtualFolderTest.assertTrue((String)"8.0", (boolean)destinationProject.isSynchronized(2));
            VirtualFolderTest.assertTrue((String)"9.0", (boolean)newFile.getParent().isVirtual());
            VirtualFolderTest.assertTrue((String)"10.0", (boolean)newFile.isLinked());
            VirtualFolderTest.assertTrue((String)"11.0", (boolean)newFolder.isLinked());
            VirtualFolderTest.assertTrue((String)"12.0", (boolean)newFolder.getParent().isVirtual());
        }
        finally {
            Workspace.clear((File)fileLocation.toFile());
            Workspace.clear((File)folderLocation.toFile());
        }
    }

    public void testDeleteProjectWithVirtualFolder() {
        IFolder virtualFolder = this.existingProject.getFolder(this.getUniqueString());
        try {
            virtualFolder.create(8192, true, null);
            this.existingProject.delete(8, this.getMonitor());
            this.existingProject.create(this.getMonitor());
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"1.0", (Throwable)e);
        }
        VirtualFolderTest.assertTrue((String)"2.0", (!virtualFolder.exists() ? 1 : 0) != 0);
        try {
            this.existingProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"3.0", (Throwable)e);
        }
        VirtualFolderTest.assertTrue((String)"4.0", (boolean)virtualFolder.exists());
        VirtualFolderTest.assertTrue((String)"5.0", (boolean)virtualFolder.isVirtual());
    }

    public void testDeleteProjectWithVirtualFolderAndLink() {
        IPath folderLocation = this.getRandomLocation();
        IFolder virtualFolder = this.existingProject.getFolder(this.getUniqueString());
        IFolder linkedFolder = virtualFolder.getFolder("a_link");
        try {
            try {
                folderLocation.toFile().mkdir();
                virtualFolder.create(8192, true, null);
                linkedFolder.createLink(folderLocation, 0, this.getMonitor());
                this.existingProject.delete(8, this.getMonitor());
                this.existingProject.create(this.getMonitor());
            }
            catch (CoreException e) {
                VirtualFolderTest.fail((String)"1.0", (Throwable)e);
            }
            VirtualFolderTest.assertTrue((String)"2.0", (!virtualFolder.exists() ? 1 : 0) != 0);
            VirtualFolderTest.assertTrue((String)"3.0", (!linkedFolder.exists() ? 1 : 0) != 0);
            try {
                this.existingProject.open(this.getMonitor());
            }
            catch (CoreException e) {
                VirtualFolderTest.fail((String)"4.0", (Throwable)e);
            }
            VirtualFolderTest.assertTrue((String)"5.0", (boolean)virtualFolder.exists());
            VirtualFolderTest.assertTrue((String)"6.0", (boolean)virtualFolder.isVirtual());
            VirtualFolderTest.assertTrue((String)"7.0", (boolean)linkedFolder.exists());
            VirtualFolderTest.assertTrue((String)"8.0", (boolean)linkedFolder.isLinked());
            VirtualFolderTest.assertEquals((String)"9.0", (Object)folderLocation, (Object)linkedFolder.getLocation());
        }
        finally {
            Workspace.clear((File)folderLocation.toFile());
        }
    }

    public void testLinkedFolderInVirtualFolder_FileStoreURI() {
        IPath folderLocation = this.getRandomLocation();
        IFolder folder = this.existingVirtualFolderInExistingProject.getFolder(this.getUniqueString());
        try {
            folder.createLink(folderLocation, 16, this.getMonitor());
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"1.0", (Throwable)e);
        }
        VirtualFolderTest.assertTrue((String)"2.0", (boolean)folder.exists());
        VirtualFolderTest.assertEquals((String)"3.0", (Object)folderLocation, (Object)folder.getLocation());
        VirtualFolderTest.assertTrue((String)"4.0", (!folderLocation.toFile().exists() ? 1 : 0) != 0);
        try {
            IFileStore fs = EFS.getStore((URI)this.existingVirtualFolderInExistingProject.getLocationURI());
            fs = fs.getChild(folder.getName());
            VirtualFolderTest.assertNotNull((String)"5.0", (Object)fs);
            VirtualFolderTest.assertNotNull((String)"6.0", (Object)fs.toURI());
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"7.0", (Throwable)e);
        }
    }

    public void testIsVirtual() {
        IFolder virtualFolder = this.existingProject.getFolder(this.getUniqueString());
        try {
            virtualFolder.create(8192, true, null);
        }
        catch (CoreException e) {
            VirtualFolderTest.fail((String)"1.0", (Throwable)e);
        }
        VirtualFolderTest.assertTrue((String)"2.0", (boolean)virtualFolder.isVirtual());
    }

    public void testVirtualFolderInLinkedFolder() {
        IFolder topFolder = this.existingProject.getFolder("topFolder");
        IFolder linkedFolder = topFolder.getFolder("linkedFolder");
        IFolder subFolder = linkedFolder.getFolder("subFolder");
        IFolder virtualFolder = subFolder.getFolder("virtualFolder");
        IPath linkedFolderLocation = this.getRandomLocation();
        IPath subFolderLocation = linkedFolderLocation.append(subFolder.getName());
        try {
            try {
                linkedFolderLocation.toFile().mkdir();
                subFolderLocation.toFile().mkdir();
                this.ensureExistsInWorkspace((IResource)topFolder, true);
                linkedFolder.createLink(linkedFolderLocation, 0, this.getMonitor());
                virtualFolder.create(8192, true, this.getMonitor());
            }
            catch (CoreException e) {
                VirtualFolderTest.fail((String)"1.0", (Throwable)e);
            }
            VirtualFolderTest.assertEquals((String)"2.0", (Object)linkedFolderLocation, (Object)linkedFolder.getLocation());
            VirtualFolderTest.assertEquals((String)"3.0", (Object)linkedFolderLocation.append(subFolder.getName()), (Object)subFolder.getLocation());
            VirtualFolderTest.assertTrue((String)"4.0", (boolean)virtualFolder.isVirtual());
            VirtualFolderTest.assertTrue((String)"5.0", (virtualFolder.getLocation() == null ? 1 : 0) != 0);
            VirtualFolderTest.assertEquals((String)"6.0", (Object)URIUtil.toURI((IPath)linkedFolderLocation), (Object)linkedFolder.getLocationURI());
            VirtualFolderTest.assertEquals((String)"7.0", (Object)URIUtil.toURI((IPath)subFolderLocation), (Object)subFolder.getLocationURI());
        }
        finally {
            Workspace.clear((File)subFolderLocation.toFile());
            Workspace.clear((File)linkedFolderLocation.toFile());
        }
    }

    public void testGetVirtualFolderAttributes() {
        long timeStamp = this.existingVirtualFolderInExistingProject.getLocalTimeStamp();
        VirtualFolderTest.assertEquals((String)"1.0", (long)timeStamp, (long)-1L);
        ResourceAttributes attributes = this.existingVirtualFolderInExistingProject.getResourceAttributes();
        VirtualFolderTest.assertEquals((String)"1.1", (Object)attributes, null);
    }
}

