/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.content;

import junit.framework.Test;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.tests.resources.content.ContentTypeTest;
import org.eclipse.core.tests.resources.content.LocalSelectionPolicy;
import org.eclipse.test.OrderedTestSuite;

public class SpecificContextTest
extends ContentTypeTest {
    public static Test suite() {
        return new OrderedTestSuite(SpecificContextTest.class);
    }

    public SpecificContextTest(String name) {
        super(name);
    }

    public void testContentTypeLookup() {
        IContentTypeManager global = Platform.getContentTypeManager();
        SingleNodeScope scope = new SingleNodeScope();
        IContentTypeMatcher local = global.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), (IScopeContext)scope);
        IContentType textContentType = global.getContentType("org.eclipse.core.runtime.text");
        try {
            textContentType.addFileSpec(String.valueOf(this.getName()) + ".global", 4);
        }
        catch (CoreException e) {
            SpecificContextTest.fail((String)"0.1", (Throwable)e);
        }
        try {
            textContentType.getSettings((IScopeContext)scope).addFileSpec(String.valueOf(this.getName()) + ".local", 4);
        }
        catch (CoreException e) {
            SpecificContextTest.fail((String)"0.2", (Throwable)e);
        }
        SpecificContextTest.assertEquals((String)"1.0", (Object)textContentType, (Object)global.findContentTypeFor(String.valueOf(this.getName()) + ".global"));
        SpecificContextTest.assertEquals((String)"1.1", null, (Object)local.findContentTypeFor(String.valueOf(this.getName()) + ".global"));
        SpecificContextTest.assertEquals((String)"2.0", (Object)textContentType, (Object)local.findContentTypeFor(String.valueOf(this.getName()) + ".local"));
        SpecificContextTest.assertEquals((String)"2.1", null, (Object)global.findContentTypeFor(String.valueOf(this.getName()) + ".local"));
        try {
            textContentType.removeFileSpec(String.valueOf(this.getName()) + ".global", 4);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void testIsAssociatedWith() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        SingleNodeScope scope = new SingleNodeScope();
        IContentType textContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentTypeSettings localSettings = null;
        try {
            localSettings = textContentType.getSettings((IScopeContext)scope);
        }
        catch (CoreException e) {
            SpecificContextTest.fail((String)"0.1", (Throwable)e);
        }
        SpecificContextTest.assertTrue((String)"1.0", (!textContentType.isAssociatedWith("hello.foo", (IScopeContext)scope) ? 1 : 0) != 0);
        SpecificContextTest.assertTrue((String)"1.1", (!textContentType.isAssociatedWith("hello.foo") ? 1 : 0) != 0);
        try {
            localSettings.addFileSpec("foo", 8);
        }
        catch (CoreException e) {
            SpecificContextTest.fail((String)"1.5", (Throwable)e);
        }
        try {
            localSettings = textContentType.getSettings((IScopeContext)scope);
        }
        catch (CoreException e) {
            SpecificContextTest.fail((String)"2.1", (Throwable)e);
        }
        String[] fileSpecs = localSettings.getFileSpecs(8);
        SpecificContextTest.assertEquals((String)"2.2", (int)1, (int)fileSpecs.length);
        SpecificContextTest.assertEquals((String)"2.3", (String)"foo", (String)fileSpecs[0]);
        SpecificContextTest.assertTrue((String)"2.5", (boolean)textContentType.isAssociatedWith("hello.foo", (IScopeContext)scope));
        SpecificContextTest.assertTrue((String)"2.6", (!textContentType.isAssociatedWith("hello.foo") ? 1 : 0) != 0);
    }

    private class SingleNodeScope
    implements IScopeContext {
        private IEclipsePreferences node = new EclipsePreferences();

        SingleNodeScope() {
        }

        public IPath getLocation() {
            return null;
        }

        public String getName() {
            return "";
        }

        public IEclipsePreferences getNode(String qualifier) {
            SpecificContextTest.assertEquals((String)"org.eclipse.core.runtime/content-types", (String)qualifier);
            return this.node;
        }
    }
}

