/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.OldCorePerformanceTest;

public class BenchElementTree
extends OldCorePerformanceTest {
    static String[] javaLangUnits = new String[]{"AbstractMethodError.java", "ArithmeticException.java", "ArrayIndexOutOfBoundsException.java", "ArrayStoreException.java", "Boolean.java", "Byte.java", "Character.java", "Class.java", "ClassCastException.java", "ClassCircularityError.java", "ClassFormatError.java", "ClassLoader.java", "ClassNotFoundException.java", "Cloneable.java", "CloneNotSupportedException.java", "Compiler.java", "Double.java", "Error.java", "Exception.java", "ExceptionInInitializerError.java", "Float.java", "FloatingDecimal.java", "IllegalAccessError.java", "IllegalAccessException.java", "IllegalArgumentException.java", "IllegalMonitorStateException.java", "IllegalStateException.java", "IllegalThreadStateException.java", "IncompatibleClassChangeError.java", "IndexOutOfBoundsException.java", "InstantiationError.java", "InstantiationException.java", "Integer.java", "InternalError.java", "InterruptedException.java", "LinkageError.java", "Long.java", "Math.java", "NegativeArraySizeException.java", "NoClassDefFoundError.java", "NoSuchFieldError.java", "NoSuchFieldException.java", "NoSuchMethodError.java", "NoSuchMethodException.java", "NullPointerException.java", "Number.java", "NumberFormatException.java", "Object.java", "OutOfMemoryError.java", "Process.java", "Runnable.java", "Runtime.java", "RuntimeException.java", "SecurityException.java", "SecurityManager.java", "Short.java", "StackOverflowError.java", "String.java", "StringBuffer.java", "StringIndexOutOfBoundsException.java", "System.java", "Thread.java", "ThreadDeath.java", "ThreadGroup.java", "Throwable.java", "UnknownError.java", "UnsatisfiedLinkError.java", "VerifyError.java", "VirtualMachineError.java", "Void.java"};
    static final IPath solution = Path.ROOT.append("solution");
    static final IPath project = solution.append("project");
    static final IPath folder = project.append("folder");
    static final IPath[] files = BenchElementTree.getFilePaths();

    public BenchElementTree() {
    }

    public BenchElementTree(String name) {
        super(name);
    }

    public void testCreateElement() {
        new PerformanceTestRunner(){

            protected void test() {
                BenchElementTree.this.createTestTree(false);
            }
        }.run((TestCase)this, 10, 400);
    }

    public void benchDeleteElement() {
        ElementTree[] trees = new ElementTree[400];
        int i = 0;
        while (i < 400) {
            trees[i] = this.createTestTree(false);
            ++i;
        }
        this.startBench();
        int rep = 400;
        while (--rep >= 0) {
            int i2 = 0;
            int len = files.length;
            while (i2 < len) {
                trees[rep].deleteElement(files[i2]);
                ++i2;
            }
        }
        this.stopBench("benchDeleteElement", 400 * files.length);
    }

    public void benchGetElementData() {
        ElementTree tree = this.createTestTree(false);
        this.startBench();
        int rep = 500;
        while (--rep >= 0) {
            int i = 0;
            int len = files.length;
            while (i < len) {
                tree.getElementData(files[i]);
                ++i;
            }
        }
        this.stopBench("benchGetElementData", 500 * files.length);
    }

    public void benchMergeDeltaChain() {
        ElementTree[] bases = new ElementTree[50];
        ElementTree[][] chains = new ElementTree[50][];
        int i = 0;
        while (i < 50) {
            bases[i] = this.createTestTree(true);
            chains[i] = this.buildDeltaChain(this.createTestTree(false));
            ++i;
        }
        this.startBench();
        i = 50;
        while (--i >= 0) {
            bases[i].mergeDeltaChain(folder, chains[i]);
        }
        this.stopBench("benchMergeDeltaChain", 50);
    }

    public void benchRoutineOperations() {
        int opCount = 0;
        this.startBench();
        int i = 0;
        while (i < 75) {
            opCount += this.doRoutineOperations();
            ++i;
        }
        this.stopBench("benchRoutineOperations", opCount);
    }

    public void benchSetElementData() {
        ElementTree tree = this.createTestTree(false);
        Object data = new Object();
        this.startBench();
        int rep = 500;
        while (--rep >= 0) {
            int i = 0;
            int len = files.length;
            while (i < len) {
                tree.setElementData(files[i], data);
                ++i;
            }
        }
        this.stopBench("benchSetElementData", 500 * files.length);
    }

    private ElementTree[] buildDeltaChain(ElementTree tree) {
        String data;
        Vector<ElementTree> trees = new Vector<ElementTree>();
        trees.addElement(tree);
        int repeat = 1;
        tree = tree.newEmptyDelta();
        IPath[] filePaths = BenchElementTree.getFilePaths();
        int i = 0;
        while (i < filePaths.length) {
            data = filePaths[i].toString();
            tree.createElement(filePaths[i], (Object)data);
            tree.immutable();
            trees.addElement(tree);
            tree = tree.newEmptyDelta();
            ++i;
        }
        i = 0;
        while (i < repeat) {
            data = "data" + i;
            int f = 0;
            while (f < filePaths.length) {
                tree.setElementData(filePaths[f], (Object)data);
                tree.immutable();
                trees.addElement(tree);
                tree = tree.newEmptyDelta();
                ++f;
            }
            ++i;
        }
        i = 0;
        while (i < filePaths.length) {
            tree.deleteElement(filePaths[i]);
            tree.immutable();
            trees.addElement(tree);
            tree = tree.newEmptyDelta();
            ++i;
        }
        Object[] results = new ElementTree[trees.size()];
        trees.copyInto(results);
        return results;
    }

    ElementTree createTestTree(boolean withDeltas) {
        ElementTree tree = new ElementTree();
        Object data = new Object();
        tree.createElement(solution, data);
        if (withDeltas) {
            tree.immutable();
            tree = tree.newEmptyDelta();
        }
        tree.createElement(project, data);
        if (withDeltas) {
            tree.immutable();
            tree = tree.newEmptyDelta();
        }
        tree.createElement(folder, data);
        int i = 0;
        int len = javaLangUnits.length;
        while (i < len) {
            if (withDeltas) {
                tree.immutable();
                tree = tree.newEmptyDelta();
            }
            IPath file = folder.append(javaLangUnits[i]);
            tree.createElement(file, data);
            ++i;
        }
        return tree;
    }

    private int doRoutineOperations() {
        ElementTree tree = this.createTestTree(true);
        int repeat = 1;
        int i = 0;
        while (i < repeat) {
            String data = "data" + i;
            int f = 0;
            while (f < files.length) {
                tree = tree.newEmptyDelta();
                tree.setElementData(files[f], (Object)data);
                tree.immutable();
                ++f;
            }
            ++i;
        }
        i = 0;
        while (i < files.length) {
            tree = tree.newEmptyDelta();
            tree.deleteElement(files[i]);
            tree.immutable();
            ++i;
        }
        return (repeat + 2) * files.length;
    }

    static IPath[] getFilePaths() {
        IPath[] jcuIDs = new IPath[javaLangUnits.length];
        int i = 0;
        int len = javaLangUnits.length;
        while (i < len) {
            jcuIDs[i] = folder.append(javaLangUnits[i]);
            ++i;
        }
        return jcuIDs;
    }

    protected void setUp() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BenchElementTree.class.getName());
        suite.addTest((Test)new BenchElementTree("benchCreateElement"));
        suite.addTest((Test)new BenchElementTree("benchDeleteElement"));
        suite.addTest((Test)new BenchElementTree("benchDeltaLargeTreeFewChanges"));
        suite.addTest((Test)new BenchElementTree("benchDeltaLargeTreeManyChangesInOneLayer"));
        suite.addTest((Test)new BenchElementTree("benchDeltaSmallTreeManyChangesInSeperateLayers"));
        suite.addTest((Test)new BenchElementTree("benchGetElementData"));
        suite.addTest((Test)new BenchElementTree("benchReverseDeltaLargeTreeFewChanges"));
        suite.addTest((Test)new BenchElementTree("benchReverseDeltaLargeTreeManyChangesInOneLayer"));
        suite.addTest((Test)new BenchElementTree("benchReverseDeltaSmallTreeManyChangesInSeperateLayers"));
        suite.addTest((Test)new BenchElementTree("benchRoutineOperations"));
        suite.addTest((Test)new BenchElementTree("benchSetElementData"));
        return suite;
    }

    protected void tearDown() throws Exception {
    }
}

