/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceTest;

public class BenchWorkspace
extends ResourceTest {
    private static final int FILES_PER_FOLDER = 20;
    private static final int NUM_FOLDERS = 400;
    IProject project;

    public static Test suite() {
        return new TestSuite(BenchWorkspace.class);
    }

    public BenchWorkspace() {
    }

    public BenchWorkspace(String testName) {
        super(testName);
    }

    private void addProblems(final int problemCount) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                BenchWorkspace.getWorkspace().getRoot().accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        int i = 0;
                        while (i < problemCount) {
                            IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                            marker.setAttribute("severity", 1);
                            ++i;
                        }
                        return true;
                    }
                });
            }
        };
        try {
            BenchWorkspace.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            BenchWorkspace.fail((String)"1.0", (Throwable)e);
        }
    }

    public String[] defineHierarchy() {
        String[] names = new String[8400];
        int i = 0;
        int depth = 0;
        while (depth < 10) {
            int span = 0;
            while (span < 40) {
                names[i] = depth == 0 ? "TestProject/" + Integer.toString(span) + "/" : String.valueOf(names[i - 40]) + Integer.toString(span) + "/";
                ++i;
                ++span;
            }
            ++depth;
        }
        int folder = 0;
        while (folder < 400) {
            int file = 0;
            while (file < 20) {
                names[i++] = String.valueOf(names[folder]) + "file" + Integer.toString(file);
                ++file;
            }
            ++folder;
        }
        return names;
    }

    int findMaxProblemSeverity(IWorkspaceRoot root) {
        class ResourceVisitor
        implements IResourceVisitor {
            int maxSeverity = -1;

            ResourceVisitor() {
            }

            public boolean visit(IResource resource) throws CoreException {
                IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                int i = 0;
                while (i < markers.length) {
                    int severity = markers[i].getAttribute("severity", -1);
                    if (severity > this.maxSeverity) {
                        this.maxSeverity = severity;
                    }
                    ++i;
                }
                return true;
            }
        }
        ResourceVisitor visitor = new ResourceVisitor();
        try {
            root.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            BenchWorkspace.fail((String)"4.99", (Throwable)e);
            return -1;
        }
        return visitor.maxSeverity;
    }

    int findMaxProblemSeverity2(IWorkspaceRoot root) {
        try {
            return root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            BenchWorkspace.fail((String)"4.99", (Throwable)e);
            return -1;
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                BenchWorkspace.this.project = BenchWorkspace.getWorkspace().getRoot().getProject("TestProject");
                BenchWorkspace.this.project.create(null);
                BenchWorkspace.this.project.open(null);
                IResource[] resources = BenchWorkspace.this.buildResources((IContainer)BenchWorkspace.this.project, BenchWorkspace.this.defineHierarchy());
                BenchWorkspace.this.ensureExistsInWorkspace(resources, true);
            }
        };
        try {
            BenchWorkspace.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            BenchWorkspace.fail((String)"1.0", (Throwable)e);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.project.delete(true, true, null);
    }

    public void testCountResources() {
        final Workspace workspace = (Workspace)BenchWorkspace.getWorkspace();
        final IWorkspaceRoot root = workspace.getRoot();
        new PerformanceTestRunner(){

            protected void setUp() throws CoreException {
                super.setUp();
                BenchWorkspace.this.waitForBackgroundActivity();
            }

            protected void test() {
                workspace.countResources(root.getFullPath(), 2, true);
            }
        }.run((TestCase)this, 10, 100);
    }

    public void waitForBackgroundActivity() {
        this.waitForRefresh();
        this.waitForBuild();
    }

    public void testCountResourcesDuringOperation() {
        final Workspace workspace = (Workspace)BenchWorkspace.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                workspace.getRoot().accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        resource.touch(null);
                        return true;
                    }
                });
                new PerformanceTestRunner(){

                    protected void test() {
                        workspace.countResources((this).BenchWorkspace.this.project.getFullPath(), 2, true);
                    }
                }.run((TestCase)BenchWorkspace.this, 10, 10);
            }
        };
        try {
            workspace.run(runnable, this.getMonitor());
        }
        catch (CoreException e) {
            BenchWorkspace.fail((String)"1.0", (Throwable)e);
        }
    }

    public void testFindMaxProblemSeverity() {
        this.addProblems(10);
        Workspace workspace = (Workspace)BenchWorkspace.getWorkspace();
        final IWorkspaceRoot root = workspace.getRoot();
        new PerformanceTestRunner(){

            protected void test() {
                BenchWorkspace.this.findMaxProblemSeverity2(root);
            }
        }.run((TestCase)this, 10, 100);
    }
}

