/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.refresh;

import java.io.File;
import junit.framework.AssertionFailedError;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.tests.resources.ResourceTest;
import org.eclipse.core.tests.resources.refresh.TestRefreshProvider;

public class RefreshProviderTest
extends ResourceTest {
    public static TestSuite suite() {
        return new TestSuite(RefreshProviderTest.class);
    }

    public RefreshProviderTest() {
    }

    public RefreshProviderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestRefreshProvider.reset();
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        preferences.setValue("refresh.enabled", true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        TestRefreshProvider.reset();
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        preferences.setValue("refresh.enabled", false);
    }

    public void testLinkedFile() {
        IPath location = this.getRandomLocation();
        try {
            try {
                IProject project = RefreshProviderTest.getWorkspace().getRoot().getProject("testUnmonitorLinkedResource");
                this.ensureExistsInWorkspace((IResource)project, true);
                IFile link = project.getFile("Link");
                TestRefreshProvider provider = TestRefreshProvider.getInstance();
                RefreshProviderTest.assertEquals((String)"1.0", (int)1, (int)provider.getMonitoredResources().length);
                link.createLink(location, 16, this.getMonitor());
                RefreshProviderTest.assertEquals((String)"1.1", (int)2, (int)provider.getMonitoredResources().length);
                link.delete(1, this.getMonitor());
                RefreshProviderTest.assertEquals((String)"1.2", (int)1, (int)provider.getMonitoredResources().length);
                this.ensureDoesNotExistInWorkspace((IResource)project);
                RefreshProviderTest.assertEquals((String)"1.3", (int)0, (int)provider.getMonitoredResources().length);
                AssertionFailedError[] failures = provider.getFailures();
                if (failures.length > 0) {
                    RefreshProviderTest.fail((String)(failures.length + " failures"), (Throwable)failures[0]);
                }
            }
            catch (CoreException e) {
                RefreshProviderTest.fail((String)"1.99", (Throwable)e);
                Workspace.clear((File)location.toFile());
            }
        }
        finally {
            Workspace.clear((File)location.toFile());
        }
    }

    public void testProjectCloseOpen() {
        try {
            IProject project = RefreshProviderTest.getWorkspace().getRoot().getProject("testUnmonitorLinkedResource");
            this.ensureExistsInWorkspace((IResource)project, true);
            TestRefreshProvider provider = TestRefreshProvider.getInstance();
            RefreshProviderTest.assertEquals((String)"1.0", (int)1, (int)provider.getMonitoredResources().length);
            project.close(this.getMonitor());
            RefreshProviderTest.assertEquals((String)"1.1", (int)0, (int)provider.getMonitoredResources().length);
            project.open(this.getMonitor());
            RefreshProviderTest.assertEquals((String)"1.2", (int)1, (int)provider.getMonitoredResources().length);
            this.ensureDoesNotExistInWorkspace((IResource)project);
            RefreshProviderTest.assertEquals((String)"1.0", (int)0, (int)provider.getMonitoredResources().length);
            AssertionFailedError[] failures = provider.getFailures();
            if (failures.length > 0) {
                RefreshProviderTest.fail((String)(failures.length + " failures"), (Throwable)failures[0]);
            }
        }
        catch (CoreException e) {
            RefreshProviderTest.fail((String)"1.99", (Throwable)e);
        }
    }
}

