/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.refresh;

import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.AssertionFailedError;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.IRefreshResult;
import org.eclipse.core.resources.refresh.RefreshProvider;

public class TestRefreshProvider
extends RefreshProvider
implements IRefreshMonitor {
    private final ArrayList failures = new ArrayList();
    private final HashSet monitoredResources = new HashSet();
    private static TestRefreshProvider instance;

    public static TestRefreshProvider getInstance() {
        return instance;
    }

    public TestRefreshProvider() {
        instance = this;
    }

    public static void reset() {
        if (instance != null) {
            TestRefreshProvider.instance.failures.clear();
            TestRefreshProvider.instance.monitoredResources.clear();
        }
    }

    public AssertionFailedError[] getFailures() {
        return this.failures.toArray(new AssertionFailedError[this.failures.size()]);
    }

    public IResource[] getMonitoredResources() {
        return this.monitoredResources.toArray(new IResource[this.monitoredResources.size()]);
    }

    public IRefreshMonitor installMonitor(IResource resource, IRefreshResult result) {
        if (!this.monitoredResources.add(resource)) {
            this.failures.add(new AssertionFailedError("installMonitor on resource that is already monitored: " + resource));
        }
        return this;
    }

    public void unmonitor(IResource resource) {
        if (!this.monitoredResources.remove(resource)) {
            this.failures.add(new AssertionFailedError("Unmonitor on resource that is not monitored: " + resource));
        }
    }
}

