/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_027271
extends ResourceTest {
    static final String VARIABLE_PREFIX = "pathvariable.";
    private Preferences preferences;

    public Bug_027271(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        this.clearPathVariablesProperties();
    }

    protected void tearDown() throws Exception {
        this.clearPathVariablesProperties();
        super.tearDown();
    }

    private void clearPathVariablesProperties() {
        String[] propertyNames = this.preferences.propertyNames();
        int i = 0;
        while (i < propertyNames.length) {
            if (propertyNames[i].startsWith(VARIABLE_PREFIX)) {
                this.preferences.setToDefault(propertyNames[i]);
            }
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(Bug_027271.class);
    }

    public void testBug() {
        if (!Bug_027271.isWindows()) {
            return;
        }
        IPathVariableManager pvm = Bug_027271.getWorkspace().getPathVariableManager();
        Preferences prefs = ResourcesPlugin.getPlugin().getPluginPreferences();
        Bug_027271.assertEquals((String)"1.0", (int)0, (int)pvm.getPathVariableNames().length);
        prefs.setValue("pathvariable.VALID_VAR", new Path("c:/temp").toPortableString());
        Bug_027271.assertEquals((String)"1.1", (int)1, (int)pvm.getPathVariableNames().length);
        Bug_027271.assertEquals((String)"1.2", (String)"VALID_VAR", (String)pvm.getPathVariableNames()[0]);
        Path relativePath = new Path("temp");
        prefs.setValue("pathvariable.INVALID_VAR", relativePath.toPortableString());
        Bug_027271.assertEquals((String)"2.0", (int)1, (int)pvm.getPathVariableNames().length);
        Bug_027271.assertEquals((String)"2.1", (String)"VALID_VAR", (String)pvm.getPathVariableNames()[0]);
        Path invalidPath = new Path("c:\\a\\:\\b");
        prefs.setValue("pathvariable.ANOTHER_INVALID_VAR", invalidPath.toPortableString());
        Bug_027271.assertTrue((String)"3.0", (!Path.EMPTY.isValidPath(invalidPath.toPortableString()) ? 1 : 0) != 0);
        Bug_027271.assertEquals((String)"3.1", (int)1, (int)pvm.getPathVariableNames().length);
        Bug_027271.assertEquals((String)"3.2", (String)"VALID_VAR", (String)pvm.getPathVariableNames()[0]);
    }
}

