/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTest;
import org.eclipse.core.tests.resources.ResourceVisitorVerifier;

public class Bug_028981
extends ResourceTest {
    public Bug_028981(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBug() {
        QualifiedName partner = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        IWorkspace workspace = Bug_028981.getWorkspace();
        ISynchronizer synchronizer = workspace.getSynchronizer();
        synchronizer.add(partner);
        IProject project = workspace.getRoot().getProject("MyProject");
        IFile teamPrivateFile = project.getFile("teamPrivate.txt");
        IFile phantomFile = project.getFile("phantom.txt");
        IFile regularFile = project.getFile("regular.txt");
        IFile projectDescriptionFile = project.getFile(".project");
        this.ensureExistsInWorkspace(new IResource[]{teamPrivateFile, regularFile}, true);
        try {
            synchronizer.setSyncInfo(partner, (IResource)phantomFile, this.getRandomString().getBytes());
        }
        catch (CoreException e) {
            e.printStackTrace();
            Bug_028981.fail((String)"0.5");
        }
        try {
            teamPrivateFile.setTeamPrivateMember(true);
        }
        catch (CoreException e) {
            e.printStackTrace();
            Bug_028981.fail((String)"0.6");
        }
        Bug_028981.assertTrue((String)"0.7", (!regularFile.isPhantom() && !regularFile.isTeamPrivateMember() ? 1 : 0) != 0);
        Bug_028981.assertTrue((String)"0.8", (boolean)teamPrivateFile.isTeamPrivateMember());
        Bug_028981.assertTrue((String)"0.8b", (boolean)teamPrivateFile.exists());
        Bug_028981.assertTrue((String)"0.9", (boolean)phantomFile.isPhantom());
        Bug_028981.assertTrue((String)"0.9b", (!phantomFile.exists() ? 1 : 0) != 0);
        ResourceVisitorVerifier verifier = new ResourceVisitorVerifier();
        verifier.addExpected((IResource)project);
        verifier.addExpected((IResource)projectDescriptionFile);
        verifier.addExpected((IResource)regularFile);
        try {
            project.accept((IResourceVisitor)verifier);
        }
        catch (CoreException e) {
            Bug_028981.fail((String)"1.0", (Throwable)e);
        }
        Bug_028981.assertTrue((String)("1.1 - " + verifier.getMessage()), (boolean)verifier.isValid());
        verifier.reset();
        try {
            phantomFile.accept((IResourceVisitor)verifier);
            Bug_028981.fail((String)"2.0 - should fail");
        }
        catch (CoreException coreException) {}
        verifier.reset();
        verifier.addExpected((IResource)phantomFile);
        try {
            phantomFile.accept((IResourceVisitor)verifier, 2, 1);
        }
        catch (CoreException e) {
            Bug_028981.fail((String)"3.0", (Throwable)e);
        }
        Bug_028981.assertTrue((String)("3.1 - " + verifier.getMessage()), (boolean)verifier.isValid());
        verifier.reset();
        try {
            teamPrivateFile.accept((IResourceVisitor)verifier);
        }
        catch (CoreException e) {
            Bug_028981.fail((String)"4.0", (Throwable)e);
        }
        Bug_028981.assertTrue((String)("4.1 - " + verifier.getMessage()), (boolean)verifier.isValid());
        verifier.reset();
        verifier.addExpected((IResource)teamPrivateFile);
        try {
            teamPrivateFile.accept((IResourceVisitor)verifier, 2, 2);
        }
        catch (CoreException e) {
            Bug_028981.fail((String)"5.0", (Throwable)e);
        }
        Bug_028981.assertTrue((String)("5.1 - " + verifier.getMessage()), (boolean)verifier.isValid());
    }

    public static Test suite() {
        return new TestSuite(Bug_028981.class);
    }
}

