/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_032076
extends ResourceTest {
    public Bug_032076() {
        super("");
    }

    public Bug_032076(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(Bug_032076.class);
    }

    public void testFileBugOnWindows() {
        if (!Bug_032076.isWindows()) {
            return;
        }
        InputStream input = null;
        IProject project = null;
        try {
            IWorkspace workspace = Bug_032076.getWorkspace();
            project = workspace.getRoot().getProject(this.getUniqueString());
            IFolder sourceParent = project.getFolder("source_parent");
            IFolder destinationParent = project.getFolder("destination_parent");
            IFile sourceFile = sourceParent.getFile("file1.txt");
            IFile destinationFile = destinationParent.getFile(sourceFile.getName());
            this.ensureExistsInWorkspace(new IResource[]{sourceFile, destinationParent}, true);
            String attributeKey = this.getRandomString();
            String attributeValue = this.getRandomString();
            long markerId = -1L;
            try {
                IMarker bookmark = null;
                bookmark = sourceFile.createMarker("org.eclipse.core.resources.bookmark");
                bookmark.setAttribute(attributeKey, (Object)attributeValue);
                markerId = bookmark.getId();
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"0.1", (Throwable)e);
            }
            try {
                input = sourceFile.getContents();
            }
            catch (CoreException coreException) {
                Bug_032076.fail((String)"1.0");
            }
            try {
                sourceFile.move(destinationFile.getFullPath(), 1, this.getMonitor());
                Bug_032076.fail((String)"2.0");
            }
            catch (CoreException coreException) {}
            Bug_032076.assertTrue((String)"3.0", (boolean)sourceParent.isSynchronized(2));
            Bug_032076.assertTrue((String)"3.1", (boolean)destinationParent.isSynchronized(2));
            Bug_032076.assertTrue((String)"3.4", (boolean)destinationFile.exists());
            try {
                IMarker marker = destinationFile.findMarker(markerId);
                Bug_032076.assertNotNull((String)"3.6", (Object)marker);
                Bug_032076.assertEquals((String)"3.7", (Object)attributeValue, (Object)marker.getAttribute(attributeKey));
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"3.8", (Throwable)e);
            }
            Bug_032076.assertTrue((String)"4.1", (boolean)sourceFile.exists());
            Bug_032076.assertTrue((String)"4.2", (boolean)sourceFile.isSynchronized(0));
            try {
                sourceParent.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException coreException) {
                Bug_032076.fail((String)"4.4");
            }
            Bug_032076.assertTrue((String)"4.7", (boolean)sourceFile.exists());
        }
        finally {
            block28: {
                try {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e) {
                        Bug_032076.fail((String)"5.0", (Throwable)e);
                        if (project != null) {
                            this.ensureDoesNotExistInFileSystem((IResource)project);
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    if (project != null) {
                        this.ensureDoesNotExistInFileSystem((IResource)project);
                    }
                    throw throwable;
                }
                if (project != null) {
                    this.ensureDoesNotExistInFileSystem((IResource)project);
                }
            }
        }
    }

    public void testFolderBugOnWindows() {
        if (!Bug_032076.isWindows()) {
            return;
        }
        InputStream input = null;
        IProject project = null;
        try {
            IWorkspace workspace = Bug_032076.getWorkspace();
            project = workspace.getRoot().getProject(this.getUniqueString());
            IFolder sourceParent = project.getFolder("source_parent");
            IFolder destinationParent = project.getFolder("destination_parent");
            IFolder folder = sourceParent.getFolder("folder");
            IFolder destinationFolder = destinationParent.getFolder(folder.getName());
            IFile file1 = folder.getFile("file1.txt");
            IFile file2 = folder.getFile("file2.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file2, destinationParent}, true);
            String attributeKey = this.getRandomString();
            String attributeValue = this.getRandomString();
            long markerId = -1L;
            try {
                IMarker bookmark = null;
                bookmark = file1.createMarker("org.eclipse.core.resources.bookmark");
                bookmark.setAttribute(attributeKey, (Object)attributeValue);
                markerId = bookmark.getId();
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"0.1", (Throwable)e);
            }
            try {
                input = file1.getContents();
            }
            catch (CoreException ce) {
                Bug_032076.fail((String)"1.0", (Throwable)ce);
            }
            try {
                folder.move(destinationFolder.getFullPath(), 1, this.getMonitor());
                Bug_032076.fail((String)"2.0");
            }
            catch (CoreException coreException) {}
            Bug_032076.assertTrue((String)"3.0", (boolean)sourceParent.isSynchronized(2));
            Bug_032076.assertTrue((String)"3.1", (boolean)destinationParent.isSynchronized(2));
            Bug_032076.assertTrue((String)"3.3", (boolean)destinationFolder.exists());
            Bug_032076.assertTrue((String)"3.4", (boolean)destinationFolder.getFile(file1.getName()).exists());
            Bug_032076.assertTrue((String)"3.5", (boolean)destinationFolder.getFile(file2.getName()).exists());
            try {
                IMarker marker = destinationFolder.getFile(file1.getName()).findMarker(markerId);
                Bug_032076.assertNotNull((String)"3.6", (Object)marker);
                Bug_032076.assertEquals((String)"3.7", (Object)attributeValue, (Object)marker.getAttribute(attributeKey));
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"3.8", (Throwable)e);
            }
            Bug_032076.assertTrue((String)"4.1", (boolean)folder.exists());
            Bug_032076.assertTrue((String)"4.2", (boolean)file1.exists());
            Bug_032076.assertTrue((String)"4.3", (!file2.exists() ? 1 : 0) != 0);
            try {
                sourceParent.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException coreException) {
                Bug_032076.fail((String)"4.4");
            }
            Bug_032076.assertTrue((String)"4.6", (boolean)folder.exists());
            Bug_032076.assertTrue((String)"4.7", (boolean)file1.exists());
            Bug_032076.assertTrue((String)"4.8", (!file2.exists() ? 1 : 0) != 0);
        }
        finally {
            block28: {
                try {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e) {
                        Bug_032076.fail((String)"5.0", (Throwable)e);
                        if (project != null) {
                            this.ensureDoesNotExistInFileSystem((IResource)project);
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    if (project != null) {
                        this.ensureDoesNotExistInFileSystem((IResource)project);
                    }
                    throw throwable;
                }
                if (project != null) {
                    this.ensureDoesNotExistInFileSystem((IResource)project);
                }
            }
        }
    }

    public void testProjectBugOnWindows() {
        if (!Bug_032076.isWindows()) {
            return;
        }
        IProject sourceProject = null;
        IProject destinationProject = null;
        InputStream input = null;
        try {
            IWorkspace workspace = Bug_032076.getWorkspace();
            sourceProject = workspace.getRoot().getProject(String.valueOf(this.getUniqueString()) + ".source");
            destinationProject = workspace.getRoot().getProject(String.valueOf(this.getUniqueString()) + ".dest");
            IFile file1 = sourceProject.getFile("file1.txt");
            IFile file2 = sourceProject.getFile("file2.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file2}, true);
            String attributeKey = this.getRandomString();
            String attributeValue = this.getRandomString();
            long markerId = -1L;
            try {
                IMarker bookmark = null;
                bookmark = file1.createMarker("org.eclipse.core.resources.bookmark");
                bookmark.setAttribute(attributeKey, (Object)attributeValue);
                markerId = bookmark.getId();
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"0.1", (Throwable)e);
            }
            try {
                input = file1.getContents();
            }
            catch (CoreException ce) {
                Bug_032076.fail((String)"1.0", (Throwable)ce);
            }
            try {
                sourceProject.move(destinationProject.getFullPath(), 1, this.getMonitor());
                Bug_032076.fail((String)"2.0");
            }
            catch (CoreException coreException) {}
            Bug_032076.assertTrue((String)"3.0", (!sourceProject.exists() ? 1 : 0) != 0);
            Bug_032076.assertTrue((String)"3.1", (boolean)sourceProject.isSynchronized(2));
            Bug_032076.assertTrue((String)"3.2", (boolean)destinationProject.exists());
            Bug_032076.assertTrue((String)"3.3", (boolean)destinationProject.isSynchronized(2));
            Bug_032076.assertTrue((String)"3.4", (boolean)destinationProject.getFile(file1.getProjectRelativePath()).exists());
            Bug_032076.assertTrue((String)"3.5", (boolean)destinationProject.getFile(file2.getProjectRelativePath()).exists());
            try {
                IMarker marker = destinationProject.getFile(file1.getProjectRelativePath()).findMarker(markerId);
                Bug_032076.assertNotNull((String)"3.6", (Object)marker);
                Bug_032076.assertEquals((String)"3.7", (Object)attributeValue, (Object)marker.getAttribute(attributeKey));
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"3.8", (Throwable)e);
            }
            Bug_032076.assertTrue((String)"5.0", (boolean)workspace.getRoot().isSynchronized(2));
        }
        catch (Throwable throwable) {
            block33: {
                try {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e) {
                        Bug_032076.fail((String)"6.0", (Throwable)e);
                        if (sourceProject != null) {
                            this.ensureDoesNotExistInFileSystem((IResource)sourceProject);
                        }
                        if (destinationProject != null) {
                            this.ensureDoesNotExistInFileSystem((IResource)destinationProject);
                        }
                        break block33;
                    }
                }
                catch (Throwable throwable2) {
                    if (sourceProject != null) {
                        this.ensureDoesNotExistInFileSystem((IResource)sourceProject);
                    }
                    if (destinationProject != null) {
                        this.ensureDoesNotExistInFileSystem((IResource)destinationProject);
                    }
                    throw throwable2;
                }
                if (sourceProject != null) {
                    this.ensureDoesNotExistInFileSystem((IResource)sourceProject);
                }
                if (destinationProject != null) {
                    this.ensureDoesNotExistInFileSystem((IResource)destinationProject);
                }
            }
            throw throwable;
        }
        try {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                Bug_032076.fail((String)"6.0", (Throwable)e);
                if (sourceProject != null) {
                    this.ensureDoesNotExistInFileSystem((IResource)sourceProject);
                }
                if (destinationProject != null) {
                    this.ensureDoesNotExistInFileSystem((IResource)destinationProject);
                }
            }
        }
        finally {
            if (sourceProject != null) {
                this.ensureDoesNotExistInFileSystem((IResource)sourceProject);
            }
            if (destinationProject != null) {
                this.ensureDoesNotExistInFileSystem((IResource)destinationProject);
            }
        }
    }

    public void _testFileBugOnLinux() {
        if (!Platform.getOS().equals("linux") || !this.isReadOnlySupported()) {
            return;
        }
        IFileStore roFolderStore = null;
        IProject project = null;
        try {
            IWorkspace workspace = Bug_032076.getWorkspace();
            project = workspace.getRoot().getProject(this.getUniqueString());
            IFolder sourceParent = project.getFolder("source_parent");
            IFolder roFolder = sourceParent.getFolder("sub-folder");
            IFolder destinationParent = project.getFolder("destination_parent");
            IFile sourceFile = roFolder.getFile("file.txt");
            IFile destinationFile = destinationParent.getFile("file.txt");
            this.ensureExistsInWorkspace(new IResource[]{sourceFile, destinationParent}, true);
            roFolderStore = ((Resource)roFolder).getStore();
            String attributeKey = this.getRandomString();
            String attributeValue = this.getRandomString();
            long markerId = -1L;
            try {
                IMarker bookmark = null;
                bookmark = sourceFile.createMarker("org.eclipse.core.resources.bookmark");
                bookmark.setAttribute(attributeKey, (Object)attributeValue);
                markerId = bookmark.getId();
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"0.1", (Throwable)e);
            }
            this.setReadOnly((IResource)roFolder, true);
            try {
                sourceFile.move(destinationFile.getFullPath(), 1, this.getMonitor());
                Bug_032076.fail((String)"2.0");
            }
            catch (CoreException coreException) {}
            Bug_032076.assertTrue((String)"3.0", (!sourceParent.isSynchronized(2) ? 1 : 0) != 0);
            Bug_032076.assertTrue((String)"3.1", (boolean)destinationParent.isSynchronized(2));
            Bug_032076.assertTrue((String)"3.4", (boolean)destinationFile.exists());
            try {
                IMarker marker = destinationFile.findMarker(markerId);
                Bug_032076.assertNotNull((String)"3.6", (Object)marker);
                Bug_032076.assertEquals((String)"3.7", (Object)attributeValue, (Object)marker.getAttribute(attributeKey));
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"3.8", (Throwable)e);
            }
            Bug_032076.assertTrue((String)"4.1", (!sourceFile.exists() ? 1 : 0) != 0);
            try {
                sourceParent.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException coreException) {
                Bug_032076.fail((String)"4.4");
            }
            Bug_032076.assertTrue((String)"4.7", (boolean)sourceFile.exists());
        }
        catch (Throwable throwable) {
            if (roFolderStore != null) {
                this.setReadOnly(roFolderStore, false);
            }
            if (project != null) {
                this.ensureDoesNotExistInFileSystem((IResource)project);
            }
            throw throwable;
        }
        if (roFolderStore != null) {
            this.setReadOnly(roFolderStore, false);
        }
        if (project != null) {
            this.ensureDoesNotExistInFileSystem((IResource)project);
        }
    }

    public void _testFolderBugOnLinux() {
        if (!Platform.getOS().equals("linux") || !this.isReadOnlySupported()) {
            return;
        }
        IFileStore roFolderLocation = null;
        IFileStore destinationROFolderLocation = null;
        IProject project = null;
        try {
            IWorkspace workspace = Bug_032076.getWorkspace();
            project = workspace.getRoot().getProject(this.getUniqueString());
            IFolder sourceParent = project.getFolder("source_parent");
            IFolder roFolder = sourceParent.getFolder("sub-folder");
            IFolder folder = roFolder.getFolder("folder");
            IFile file1 = roFolder.getFile("file1.txt");
            IFile file2 = folder.getFile("file2.txt");
            IFolder destinationParent = project.getFolder("destination_parent");
            IFolder destinationROFolder = destinationParent.getFolder(roFolder.getName());
            this.ensureExistsInWorkspace(new IResource[]{file1, file2, destinationParent}, true);
            roFolderLocation = ((Resource)roFolder).getStore();
            destinationROFolderLocation = ((Resource)destinationROFolder).getStore();
            String attributeKey = this.getRandomString();
            String attributeValue = this.getRandomString();
            long markerId = -1L;
            try {
                IMarker bookmark = null;
                bookmark = file1.createMarker("org.eclipse.core.resources.bookmark");
                bookmark.setAttribute(attributeKey, (Object)attributeValue);
                markerId = bookmark.getId();
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"0.1", (Throwable)e);
            }
            this.setReadOnly((IResource)roFolder, true);
            try {
                roFolder.move(destinationParent.getFullPath().append(roFolder.getName()), 1, this.getMonitor());
                Bug_032076.fail((String)"2.0");
            }
            catch (CoreException coreException) {}
            Bug_032076.assertTrue((String)"3.0", (!sourceParent.isSynchronized(2) ? 1 : 0) != 0);
            Bug_032076.assertTrue((String)"3.1", (boolean)destinationParent.isSynchronized(2));
            IFolder destinationFolder = destinationROFolder.getFolder(folder.getName());
            IFile destinationFile1 = destinationROFolder.getFile(file1.getName());
            IFile destinationFile2 = destinationFolder.getFile(file2.getName());
            Bug_032076.assertTrue((String)"3.2", (boolean)destinationROFolder.exists());
            Bug_032076.assertTrue((String)"3.4", (boolean)destinationFolder.exists());
            Bug_032076.assertTrue((String)"3.5", (boolean)destinationFile1.exists());
            Bug_032076.assertTrue((String)"3.6", (boolean)destinationFile2.exists());
            try {
                IMarker marker = destinationROFolder.getFile(file1.getName()).findMarker(markerId);
                Bug_032076.assertNotNull((String)"3.7", (Object)marker);
                Bug_032076.assertEquals((String)"3.8", (Object)attributeValue, (Object)marker.getAttribute(attributeKey));
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"3.9", (Throwable)e);
            }
            Bug_032076.assertTrue((String)"4.0", (!roFolder.exists() ? 1 : 0) != 0);
            Bug_032076.assertTrue((String)"4.1", (!folder.exists() ? 1 : 0) != 0);
            Bug_032076.assertTrue((String)"4.2", (!file1.exists() ? 1 : 0) != 0);
            Bug_032076.assertTrue((String)"4.3", (!file2.exists() ? 1 : 0) != 0);
            try {
                sourceParent.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException coreException) {
                Bug_032076.fail((String)"4.4");
            }
            Bug_032076.assertTrue((String)"4.5", (boolean)roFolder.exists());
            Bug_032076.assertTrue((String)"4.6", (boolean)folder.exists());
            Bug_032076.assertTrue((String)"4.7", (boolean)file1.exists());
            Bug_032076.assertTrue((String)"4.8", (!file2.exists() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            if (roFolderLocation != null) {
                this.setReadOnly(roFolderLocation, false);
            }
            if (destinationROFolderLocation != null) {
                this.setReadOnly(destinationROFolderLocation, false);
            }
            if (project != null) {
                this.ensureDoesNotExistInFileSystem((IResource)project);
            }
            throw throwable;
        }
        if (roFolderLocation != null) {
            this.setReadOnly(roFolderLocation, false);
        }
        if (destinationROFolderLocation != null) {
            this.setReadOnly(destinationROFolderLocation, false);
        }
        if (project != null) {
            this.ensureDoesNotExistInFileSystem((IResource)project);
        }
    }

    public void _testProjectBugOnLinux() {
        if (!Platform.getOS().equals("linux") || !this.isReadOnlySupported()) {
            return;
        }
        IWorkspace workspace = Bug_032076.getWorkspace();
        IProject sourceProject = workspace.getRoot().getProject(String.valueOf(this.getUniqueString()) + ".source");
        IProject destinationProject = null;
        IFileStore projectParentStore = this.getTempStore();
        IFileStore projectStore = projectParentStore.getChild(sourceProject.getName());
        try {
            IProjectDescription sourceDescription = workspace.newProjectDescription(sourceProject.getName());
            sourceDescription.setLocationURI(projectStore.toURI());
            destinationProject = workspace.getRoot().getProject(String.valueOf(this.getUniqueString()) + ".dest");
            IProjectDescription destinationDescription = workspace.newProjectDescription(destinationProject.getName());
            try {
                sourceProject.create(sourceDescription, this.getMonitor());
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"0.1", (Throwable)e);
            }
            try {
                sourceProject.open(this.getMonitor());
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"0.2", (Throwable)e);
            }
            IFile file1 = sourceProject.getFile("file1.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1}, true);
            String attributeKey = this.getRandomString();
            String attributeValue = this.getRandomString();
            long markerId = -1L;
            try {
                IMarker bookmark = null;
                bookmark = file1.createMarker("org.eclipse.core.resources.bookmark");
                bookmark.setAttribute(attributeKey, (Object)attributeValue);
                markerId = bookmark.getId();
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"0.5", (Throwable)e);
            }
            this.setReadOnly(projectParentStore, true);
            try {
                sourceProject.move(destinationDescription, 1, this.getMonitor());
                Bug_032076.fail((String)"2.0");
            }
            catch (CoreException coreException) {}
            Bug_032076.assertTrue((String)"3.0", (!sourceProject.exists() ? 1 : 0) != 0);
            Bug_032076.assertTrue((String)"3.1", (boolean)destinationProject.exists());
            Bug_032076.assertTrue((String)"3.2", (boolean)destinationProject.isSynchronized(2));
            Bug_032076.assertTrue((String)"3.4", (boolean)destinationProject.getFile(file1.getProjectRelativePath()).exists());
            try {
                IMarker marker = destinationProject.getFile(file1.getProjectRelativePath()).findMarker(markerId);
                Bug_032076.assertNotNull((String)"3.6", (Object)marker);
                Bug_032076.assertEquals((String)"3.7", (Object)attributeValue, (Object)marker.getAttribute(attributeKey));
            }
            catch (CoreException e) {
                Bug_032076.fail((String)"3.8", (Throwable)e);
            }
            Bug_032076.assertTrue((String)"4.0", (boolean)projectStore.fetchInfo().exists());
            Bug_032076.assertTrue((String)"5.0", (boolean)workspace.getRoot().isSynchronized(2));
        }
        catch (Throwable throwable) {
            this.setReadOnly(projectParentStore, false);
            this.ensureDoesNotExistInFileSystem((IResource)sourceProject);
            if (destinationProject != null) {
                this.ensureDoesNotExistInFileSystem((IResource)destinationProject);
            }
            throw throwable;
        }
        this.setReadOnly(projectParentStore, false);
        this.ensureDoesNotExistInFileSystem((IResource)sourceProject);
        if (destinationProject != null) {
            this.ensureDoesNotExistInFileSystem((IResource)destinationProject);
        }
    }
}

