/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_126104
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(Bug_126104.class);
    }

    public Bug_126104(String name) {
        super(name);
    }

    public void testBug() {
        IProject project = Bug_126104.getWorkspace().getRoot().getProject("p1");
        IFile source = project.getFile("source");
        this.ensureExistsInWorkspace((IResource)source, true);
        IFolder link = project.getFolder("link");
        IFileStore location = this.getTempStore();
        try {
            link.createLink(location.toURI(), 16, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_126104.fail((String)"0.99", (Throwable)e);
        }
        IFile destination = link.getFile(source.getName());
        try {
            source.copy(destination.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_126104.fail((String)"1.99", (Throwable)e);
        }
        Bug_126104.assertTrue((String)"1.0", (boolean)destination.exists());
        this.ensureDoesNotExistInWorkspace((IResource)destination);
        try {
            location.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_126104.fail((String)"2.99", (Throwable)e);
        }
        try {
            source.move(destination.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_126104.fail((String)"3.99", (Throwable)e);
        }
        Bug_126104.assertTrue((String)"3.0", (!source.exists() ? 1 : 0) != 0);
        Bug_126104.assertTrue((String)"3.1", (boolean)destination.exists());
    }
}

