/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.util.concurrent.Semaphore;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.tests.resources.ResourceTest;
import org.eclipse.core.tests.resources.usecase.SignaledBuilder;

public class Bug_378156
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(Bug_378156.class);
    }

    public void testBugTwoThreads() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project1 = root.getProject("Bug_378156");
        IFile file = project1.getFile("content.txt");
        this.ensureExistsInWorkspace((IResource)project1, true);
        IProjectDescription desc = project1.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sigbuilder");
        desc.setBuildSpec(new ICommand[]{command});
        project1.setDescription(desc, this.getMonitor());
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        Thread.sleep(2000L);
        this.waitForBuild();
        SignaledBuilder builder = SignaledBuilder.getInstance(project1);
        builder.reset();
        Semaphore semaphore = new Semaphore(0);
        ModifyFileJob runningJob = new ModifyFileJob(file, semaphore);
        runningJob.setRule((ISchedulingRule)file);
        runningJob.schedule();
        ModifyFileJob waitingJob = new ModifyFileJob(file, semaphore);
        waitingJob.setCancel();
        waitingJob.schedule();
        waitingJob.join();
        semaphore.release();
        runningJob.join();
        this.waitForBuild();
        Bug_378156.assertTrue((String)"1.0", (boolean)builder.wasExecuted());
    }

    public void testBugOneThread() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project1 = root.getProject("Bug_378156");
        final IFile file = project1.getFile("content.txt");
        this.ensureExistsInWorkspace((IResource)project1, true);
        IProjectDescription desc = project1.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sigbuilder");
        desc.setBuildSpec(new ICommand[]{command});
        project1.setDescription(desc, this.getMonitor());
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        this.waitForBuild();
        SignaledBuilder builder = SignaledBuilder.getInstance(project1);
        builder.reset();
        Bug_378156.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file.setContents(Bug_378156.this.getRandomContents(), 0, null);
                try {
                    Bug_378156.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            throw new OperationCanceledException();
                        }
                    }, null);
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
        }, null);
        this.waitForBuild();
        Bug_378156.assertTrue((String)"1.0", (boolean)builder.wasExecuted());
    }

    class ModifyFileJob
    extends WorkspaceJob {
        private boolean cancel;
        private IFile jobFile;
        private Semaphore jobFlag;

        public ModifyFileJob(IFile file, Semaphore semaphore) {
            super("Modifying " + file);
            this.jobFlag = semaphore;
            this.jobFile = file;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            if (this.cancel) {
                throw new OperationCanceledException();
            }
            this.jobFile.setContents(Bug_378156.this.getRandomContents(), 0, null);
            try {
                this.jobFlag.acquire();
            }
            catch (InterruptedException e) {
                Bug_378156.fail((String)"0.99", (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        public void setCancel() {
            this.cancel = true;
        }
    }
}

