/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public class NLTest
extends ResourceTest {
    public NLTest() {
    }

    public NLTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NLTest.class);
    }

    public void getFileNames(List list, char begin, char end) {
        char current = begin;
        int index = 0;
        StringBuffer name = new StringBuffer();
        name.append(String.valueOf((int)current) + "_");
        while (current <= end) {
            if (!Character.isLetterOrDigit(current)) {
                current = (char)(current + '\u0001');
                continue;
            }
            name.append(current);
            current = (char)(current + '\u0001');
            if (++index != 10) continue;
            list.add(name.toString());
            index = 0;
            name.setLength(0);
            name.append(String.valueOf((int)current) + "_");
        }
        if (name.length() > 0) {
            list.add(name.toString());
        }
    }

    public String[] getFileNames(String language) {
        ArrayList names = new ArrayList(20);
        if (language.equalsIgnoreCase("en")) {
            this.getFileNames(names, 'A', 'Z');
            this.getFileNames(names, 'a', 'z');
        } else if (language.equalsIgnoreCase("ja")) {
            this.getFileNames(names, '\u3040', '\u3093');
            this.getFileNames(names, '\u3095', '\u309f');
            this.getFileNames(names, '\u30a0', '\u30f6');
            this.getFileNames(names, '\u30fb', '\u30ff');
        } else if (language.equalsIgnoreCase("de") || language.equalsIgnoreCase("pt")) {
            this.getFileNames(names, '\u00c0', '\u00ff');
        } else if (language.equalsIgnoreCase("he") || language.equalsIgnoreCase("iw")) {
            this.getFileNames(names, '\u0590', '\u05ff');
        }
        return names.toArray(new String[names.size()]);
    }

    public void testFileNames() {
        IProject project = NLTest.getWorkspace().getRoot().getProject("project");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            NLTest.fail((String)"1.0", (Throwable)e);
        }
        String[] files = this.getFileNames(Locale.ENGLISH.getLanguage());
        IResource[] resources = this.buildResources((IContainer)project, files);
        this.ensureExistsInWorkspace(resources, true);
        try {
            project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            NLTest.fail((String)"2.0", (Throwable)e);
        }
        this.assertExistsInFileSystem("2.1", resources);
        this.assertExistsInWorkspace("2.2", resources);
        this.ensureDoesNotExistInWorkspace(resources);
        files = this.getFileNames(Locale.getDefault().getLanguage());
        resources = this.buildResources((IContainer)project, files);
        this.ensureExistsInWorkspace(resources, true);
        try {
            project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            NLTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertExistsInFileSystem("3.1", resources);
        this.assertExistsInWorkspace("3.2", resources);
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            NLTest.fail((String)"20.0", (Throwable)e);
        }
    }
}

