/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class FindDeletedMembersTest
extends WorkspaceSessionTest {
    protected IWorkspaceRoot root;
    protected IProject project;
    protected IFile pfile;
    protected IFile folderAsFile;
    protected IFolder folder;
    protected IFile file;
    protected IFile file1;
    protected IFile file2;
    protected IFolder folder2;
    protected IFile file3;

    public FindDeletedMembersTest() {
    }

    public FindDeletedMembersTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.root = FindDeletedMembersTest.getWorkspace().getRoot();
        this.project = this.root.getProject("MyProject");
        this.pfile = this.project.getFile("file.txt");
        this.folder = this.project.getFolder("folder");
        this.file = this.folder.getFile("file.txt");
        this.folderAsFile = this.project.getFile(this.folder.getProjectRelativePath());
        this.file1 = this.folder.getFile("file1.txt");
        this.file2 = this.folder.getFile("file2.txt");
        this.folder2 = this.folder.getFolder("folder2");
        this.file3 = this.folder2.getFile("file3.txt");
    }

    protected void tearDown() throws Exception {
        FindDeletedMembersTest.getWorkspace().save(true, this.getMonitor());
    }

    public void test1() {
        try {
            this.project.create(this.getMonitor());
            this.project.open(this.getMonitor());
            IFile[] df = this.project.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.1", (int)0, (int)df.length);
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"0.0", (Throwable)e);
        }
        try {
            this.pfile.create(this.getRandomContents(), true, this.getMonitor());
            this.pfile.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"0.99", (Throwable)e);
        }
    }

    public void test2() {
        try {
            IFile[] df = this.project.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.1", (int)1, (int)df.length);
            FindDeletedMembersTest.assertEquals((String)"0.2", (Object)this.pfile, (Object)df[0]);
            df = this.project.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.3", (int)1, (int)df.length);
            FindDeletedMembersTest.assertEquals((String)"0.4", (Object)this.pfile, (Object)df[0]);
            df = this.project.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.5", (int)0, (int)df.length);
            df = this.root.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.5.1", (int)0, (int)df.length);
            df = this.root.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.5.2", (int)1, (int)df.length);
            FindDeletedMembersTest.assertEquals((String)"0.5.3", (Object)this.pfile, (Object)df[0]);
            df = this.root.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.5.4", (int)0, (int)df.length);
            this.pfile.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"0.99", (Throwable)e);
        }
    }

    public void test3() {
        IFile[] df;
        try {
            df = this.project.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.6", (int)0, (int)df.length);
            df = this.project.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.7", (int)0, (int)df.length);
            df = this.project.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.8", (int)0, (int)df.length);
            df = this.root.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.8.1", (int)0, (int)df.length);
            df = this.root.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.8.2", (int)0, (int)df.length);
            df = this.root.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.8.3", (int)0, (int)df.length);
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"0.99", (Throwable)e);
        }
        try {
            this.project.delete(true, this.getMonitor());
            this.project.create(this.getMonitor());
            this.project.open(this.getMonitor());
            df = this.project.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"0.9", (int)0, (int)df.length);
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"0.10", (Throwable)e);
        }
        try {
            this.folder.create(true, true, this.getMonitor());
            this.file.create(this.getRandomContents(), true, this.getMonitor());
            this.file.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void test4() {
        try {
            IFile[] df = this.project.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.1", (int)0, (int)df.length);
            df = this.project.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.2", (int)1, (int)df.length);
            FindDeletedMembersTest.assertEquals((String)"1.3", (Object)this.file, (Object)df[0]);
            df = this.project.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.4", (int)0, (int)df.length);
            this.file.create(this.getRandomContents(), true, this.getMonitor());
            df = this.project.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.5", (int)0, (int)df.length);
            df = this.project.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.6", (int)0, (int)df.length);
            df = this.project.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.7", (int)0, (int)df.length);
            this.folder.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void test5() {
        IFile[] df;
        try {
            df = this.project.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.8", (int)0, (int)df.length);
            df = this.project.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.9", (int)1, (int)df.length);
            FindDeletedMembersTest.assertEquals((String)"1.10", (Object)this.file, (Object)df[0]);
            df = this.project.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.11", (int)0, (int)df.length);
            this.folderAsFile.create(this.getRandomContents(), true, this.getMonitor());
            this.folderAsFile.delete(true, true, this.getMonitor());
            this.folder.create(true, true, this.getMonitor());
            df = this.folder.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.12", (int)1, (int)df.length);
            FindDeletedMembersTest.assertEquals((String)"1.13", (Object)this.folderAsFile, (Object)df[0]);
            df = this.folder.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.14", (int)2, (int)df.length);
            List<IFile> dfList = Arrays.asList(df);
            FindDeletedMembersTest.assertTrue((String)"1.15", (boolean)dfList.contains(this.file));
            FindDeletedMembersTest.assertTrue((String)"1.16", (boolean)dfList.contains(this.folderAsFile));
            df = this.folder.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.17", (int)2, (int)df.length);
            dfList = Arrays.asList(df);
            FindDeletedMembersTest.assertTrue((String)"1.18", (boolean)dfList.contains(this.file));
            FindDeletedMembersTest.assertTrue((String)"1.19", (boolean)dfList.contains(this.folderAsFile));
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"1.00", (Throwable)e);
        }
        try {
            this.project.delete(true, this.getMonitor());
            this.project.create(this.getMonitor());
            this.project.open(this.getMonitor());
            df = this.project.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"1.50", (int)0, (int)df.length);
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"1.51", (Throwable)e);
        }
        try {
            this.folder.create(true, true, this.getMonitor());
            this.folder2.create(true, true, this.getMonitor());
            this.file1.create(this.getRandomContents(), true, this.getMonitor());
            this.file2.create(this.getRandomContents(), true, this.getMonitor());
            this.file3.create(this.getRandomContents(), true, this.getMonitor());
            this.folder.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"3.99", (Throwable)e);
        }
    }

    public void test6() {
        try {
            IFile[] df = this.root.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"3.1", (int)0, (int)df.length);
            df = this.root.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"3.2", (int)0, (int)df.length);
            df = this.root.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"3.3", (int)3, (int)df.length);
            List<IFile> dfList = Arrays.asList(df);
            FindDeletedMembersTest.assertTrue((String)"3.3.1", (boolean)dfList.contains(this.file1));
            FindDeletedMembersTest.assertTrue((String)"3.3.2", (boolean)dfList.contains(this.file2));
            FindDeletedMembersTest.assertTrue((String)"3.3.3", (boolean)dfList.contains(this.file3));
            df = this.project.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"3.4", (int)0, (int)df.length);
            df = this.project.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"3.5", (int)0, (int)df.length);
            df = this.project.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"3.6", (int)3, (int)df.length);
            dfList = Arrays.asList(df);
            FindDeletedMembersTest.assertTrue((String)"3.6.1", (boolean)dfList.contains(this.file1));
            FindDeletedMembersTest.assertTrue((String)"3.6.2", (boolean)dfList.contains(this.file2));
            FindDeletedMembersTest.assertTrue((String)"3.6.3", (boolean)dfList.contains(this.file3));
            df = this.folder.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"3.7", (int)0, (int)df.length);
            df = this.folder.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"3.8", (int)2, (int)df.length);
            df = this.folder.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"3.9", (int)3, (int)df.length);
            df = this.folder2.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"3.10", (int)0, (int)df.length);
            df = this.folder2.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"3.11", (int)1, (int)df.length);
            df = this.folder2.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"3.12", (int)1, (int)df.length);
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"3.00", (Throwable)e);
        }
        try {
            this.project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"3.5", (Throwable)e);
        }
    }

    public void test7() {
        try {
            IFile[] df = this.root.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"4.1", (int)0, (int)df.length);
            df = this.root.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"4.2", (int)0, (int)df.length);
            df = this.root.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"4.3", (int)0, (int)df.length);
            df = this.project.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"4.4", (int)0, (int)df.length);
            df = this.project.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"4.5", (int)0, (int)df.length);
            df = this.project.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"4.6", (int)0, (int)df.length);
            df = this.folder.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"4.7", (int)0, (int)df.length);
            df = this.folder.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"4.8", (int)0, (int)df.length);
            df = this.folder.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"4.9", (int)0, (int)df.length);
            df = this.folder2.findDeletedMembersWithHistory(0, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"4.10", (int)0, (int)df.length);
            df = this.folder2.findDeletedMembersWithHistory(1, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"4.11", (int)0, (int)df.length);
            df = this.folder2.findDeletedMembersWithHistory(2, this.getMonitor());
            FindDeletedMembersTest.assertEquals((String)"4.12", (int)0, (int)df.length);
        }
        catch (CoreException e) {
            FindDeletedMembersTest.fail((String)"4.00", (Throwable)e);
        }
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", FindDeletedMembersTest.class);
    }
}

