/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestBug202384
extends WorkspaceSessionTest {
    public TestBug202384() {
    }

    public TestBug202384(String name) {
        super(name);
    }

    public void testInitializeWorkspace() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("project");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            project.setDefaultCharset("UTF-8", this.getMonitor());
        }
        catch (CoreException e) {
            TestBug202384.fail((String)"1.0", (Throwable)e);
        }
        try {
            TestBug202384.assertEquals((String)"2.0", (String)"UTF-8", (String)project.getDefaultCharset(false));
        }
        catch (CoreException e) {
            TestBug202384.fail((String)"3.0", (Throwable)e);
        }
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            TestBug202384.fail((String)"4.0", (Throwable)e);
        }
        try {
            workspace.save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug202384.fail((String)"5.0", (Throwable)e);
        }
    }

    public void testStartWithClosedProject() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("project");
        TestBug202384.assertFalse((String)"1.0", (boolean)project.isOpen());
        try {
            TestBug202384.assertNull((String)"2.0", (Object)project.getDefaultCharset(false));
        }
        catch (CoreException e) {
            TestBug202384.fail((String)"3.0", (Throwable)e);
        }
        try {
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            TestBug202384.fail((String)"4.0", (Throwable)e);
        }
        try {
            TestBug202384.assertEquals((String)"5.0", (String)"UTF-8", (String)project.getDefaultCharset(false));
        }
        catch (CoreException e) {
            TestBug202384.fail((String)"6.0", (Throwable)e);
        }
        try {
            workspace.save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug202384.fail((String)"7.0", (Throwable)e);
        }
    }

    public void testStartWithOpenProject() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject("project");
        TestBug202384.assertTrue((String)"1.0", (boolean)project.isOpen());
        try {
            TestBug202384.assertEquals((String)"2.0", (String)"UTF-8", (String)project.getDefaultCharset(false));
        }
        catch (CoreException e) {
            TestBug202384.fail((String)"3.0", (Throwable)e);
        }
        try {
            workspace.save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug202384.fail((String)"4.0", (Throwable)e);
        }
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestBug202384.class);
    }
}

