/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.resources.SavedState;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class TestBug297635
extends WorkspaceSessionTest
implements ISaveParticipant {
    private static final String BUNDLE01_ID = "org.eclipse.bundle01";

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestBug297635.class);
    }

    public BundleContext getContext() {
        return Platform.getBundle((String)"org.eclipse.core.tests.resources").getBundleContext();
    }

    public void test1() {
        try {
            Bundle b = BundleTestingHelper.installBundle((String)"1", (BundleContext)this.getContext(), (String)"Plugin_Testing/content/bundle01");
            BundleTestingHelper.resolveBundles((BundleContext)this.getContext(), (Bundle[])new Bundle[]{b});
            b.start(1);
        }
        catch (MalformedURLException e) {
            TestBug297635.fail((String)"1.0", (Throwable)e);
        }
        catch (BundleException e) {
            TestBug297635.fail((String)"1.1", (Throwable)e);
        }
        catch (IOException e) {
            TestBug297635.fail((String)"1.2", (Throwable)e);
        }
        try {
            TestBug297635.getWorkspace().addSaveParticipant(BUNDLE01_ID, (ISaveParticipant)this);
        }
        catch (CoreException e) {
            TestBug297635.fail((String)"2.0", (Throwable)e);
        }
        IProject project = TestBug297635.getWorkspace().getRoot().getProject("Project1");
        IFile file = project.getFile("file1.txt");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        try {
            TestBug297635.getWorkspace().save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug297635.fail((String)"3.0", (Throwable)e);
        }
    }

    public void test2() {
        try {
            Bundle coreResourcesBundle = Platform.getBundle((String)"org.eclipse.core.resources");
            coreResourcesBundle.stop(1);
            Bundle b = BundleTestingHelper.installBundle((String)"1", (BundleContext)this.getContext(), (String)"Plugin_Testing/content/bundle01");
            BundleTestingHelper.resolveBundles((BundleContext)this.getContext(), (Bundle[])new Bundle[]{b});
            coreResourcesBundle.start(1);
        }
        catch (MalformedURLException e2) {
            TestBug297635.fail((String)"1.0", (Throwable)e2);
        }
        catch (BundleException e2) {
            TestBug297635.fail((String)"1.1", (Throwable)e2);
        }
        catch (IOException e2) {
            TestBug297635.fail((String)"1.2", (Throwable)e2);
        }
        IProject project = TestBug297635.getWorkspace().getRoot().getProject("Project1");
        IFile file = project.getFile("file2.txt");
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        Map savedStates = null;
        try {
            Field field = SaveManager.class.getDeclaredField("savedStates");
            field.setAccessible(true);
            savedStates = (Map)field.get(((Workspace)TestBug297635.getWorkspace()).getSaveManager());
        }
        catch (IllegalArgumentException e) {
            TestBug297635.fail((String)"2.0", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            TestBug297635.fail((String)"2.1", (Throwable)e);
        }
        catch (SecurityException e) {
            TestBug297635.fail((String)"2.2", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            TestBug297635.fail((String)"2.3", (Throwable)e);
        }
        try {
            TestBug297635.getWorkspace().addSaveParticipant(BUNDLE01_ID, (ISaveParticipant)this);
        }
        catch (CoreException e) {
            TestBug297635.fail((String)"3.0", (Throwable)e);
        }
        this.assertStateTrees((SavedState)savedStates.get(BUNDLE01_ID), false);
        try {
            ((Workspace)TestBug297635.getWorkspace()).getSaveManager().save(2, true, null, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug297635.fail((String)"4.0", (Throwable)e);
        }
        this.assertStateTrees((SavedState)savedStates.get(BUNDLE01_ID), true);
    }

    private void assertStateTrees(SavedState savedState, boolean isNull) {
        Object oldTree = null;
        Object newTree = null;
        try {
            Field oldTreeField = SavedState.class.getDeclaredField("oldTree");
            oldTreeField.setAccessible(true);
            oldTree = oldTreeField.get(savedState);
            Field newTreeField = SavedState.class.getDeclaredField("newTree");
            newTreeField.setAccessible(true);
            newTree = newTreeField.get(savedState);
        }
        catch (SecurityException e) {
            TestBug297635.fail((String)"1.0", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            TestBug297635.fail((String)"2.0", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TestBug297635.fail((String)"3.0", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            TestBug297635.fail((String)"4.0", (Throwable)e);
        }
        if (isNull) {
            TestBug297635.assertNull(oldTree);
            TestBug297635.assertNull(newTree);
        } else {
            TestBug297635.assertNotNull(oldTree);
            TestBug297635.assertNotNull(newTree);
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
        context.needDelta();
        context.needSaveNumber();
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
    }
}

