/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.SortBuilder;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestBug6995
extends WorkspaceSessionTest {
    public TestBug6995() {
    }

    public TestBug6995(String name) {
        super(name);
    }

    public void test1() {
        IWorkspace workspace = TestBug6995.getWorkspace();
        try {
            IWorkspaceDescription desc = workspace.getDescription();
            desc.setAutoBuilding(false);
            workspace.setDescription(desc);
        }
        catch (CoreException e) {
            TestBug6995.fail((String)"1.0", (Throwable)e);
        }
        IProject project = workspace.getRoot().getProject("Project");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            IProjectDescription description = project.getDescription();
            ICommand command = description.newCommand();
            Map args = command.getArguments();
            args.put("BuildID", "Project1Build1");
            command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            command.setArguments(args);
            description.setBuildSpec(new ICommand[]{command});
            project.setDescription(description, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug6995.fail((String)"2.0", (Throwable)e);
        }
        try {
            project.build(6, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug6995.fail((String)"3.0", (Throwable)e);
        }
        try {
            workspace.save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug6995.fail((String)"4.0", (Throwable)e);
        }
    }

    public void test2() {
        IWorkspace workspace = TestBug6995.getWorkspace();
        IProject project = workspace.getRoot().getProject("Project");
        try {
            workspace.save(false, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug6995.fail((String)"1.0", (Throwable)e);
        }
        try {
            IFile file = project.getFile("File");
            file.create(this.getRandomContents(), true, this.getMonitor());
            project.build(10, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug6995.fail((String)"2.0", (Throwable)e);
        }
        SortBuilder builder = SortBuilder.getInstance();
        TestBug6995.assertTrue((String)"3.0", (!builder.wasDeltaNull() ? 1 : 0) != 0);
        TestBug6995.assertTrue((String)"3.1", (boolean)builder.wasIncrementalBuild());
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestBug6995.class);
    }
}

