/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.session.WorkspaceSerializationTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestSaveWithClosedProject
extends WorkspaceSerializationTest {
    public TestSaveWithClosedProject() {
    }

    public TestSaveWithClosedProject(String name) {
        super(name);
    }

    public void test1() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("CrashProject");
        IFile file = project.getFile("CrashFile");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            file.create(this.getRandomContents(), true, null);
            project.close(this.getMonitor());
            this.workspace.save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestSaveWithClosedProject.fail((String)"1.99", (Throwable)e);
        }
    }

    public void test2() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("CrashProject");
        IFile file = project.getFile("CrashFile");
        TestSaveWithClosedProject.assertTrue((String)"1.0", (boolean)project.exists());
        TestSaveWithClosedProject.assertTrue((String)"1.1", (!project.isOpen() ? 1 : 0) != 0);
        TestSaveWithClosedProject.assertTrue((String)"1.2", (!file.exists() ? 1 : 0) != 0);
        try {
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            TestSaveWithClosedProject.fail((String)"1.99", (Throwable)e);
        }
        TestSaveWithClosedProject.assertTrue((String)"2.0", (boolean)project.isOpen());
        TestSaveWithClosedProject.assertTrue((String)"2.1", (boolean)file.exists());
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestSaveWithClosedProject.class);
    }
}

