/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public class HistoryStorePerformanceTest
extends ResourceTest {
    public HistoryStorePerformanceTest() {
    }

    public HistoryStorePerformanceTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        IProject project = HistoryStorePerformanceTest.getWorkspace().getRoot().getProject("Project");
        project.create(this.getMonitor());
        project.open(this.getMonitor());
        IWorkspaceDescription description = HistoryStorePerformanceTest.getWorkspace().getDescription();
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStates(10000);
        description.setMaxFileStateSize(0x100000L);
        HistoryStorePerformanceTest.getWorkspace().setDescription(description);
    }

    public static Test suite() {
        return new TestSuite(HistoryStorePerformanceTest.class);
    }

    protected void tearDown() throws Exception {
        IProject project = HistoryStorePerformanceTest.getWorkspace().getRoot().getProject("Project");
        project.clearHistory(this.getMonitor());
        project.delete(true, true, this.getMonitor());
    }

    public void testPerformance() {
        IProject project = HistoryStorePerformanceTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("file.txt");
        try {
            file.create(null, true, null);
        }
        catch (CoreException e) {
            HistoryStorePerformanceTest.fail((String)"0.0", (Throwable)e);
        }
        String contents = "fixed contents for performance test";
        int nTimes = 1000;
        long startTime = System.currentTimeMillis();
        int i = 0;
        while (i < nTimes) {
            try {
                file.setContents(this.getContents(contents), true, true, null);
            }
            catch (CoreException e) {
                HistoryStorePerformanceTest.fail((String)"1.0", (Throwable)e);
            }
            ++i;
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Adding " + nTimes + " states: " + (endTime - startTime) + " milliseconds.");
        startTime = System.currentTimeMillis();
        try {
            file.getHistory(null);
        }
        catch (CoreException e) {
            HistoryStorePerformanceTest.fail((String)"2.0", (Throwable)e);
        }
        endTime = System.currentTimeMillis();
        System.out.println("Retrieving " + nTimes + " states: " + (endTime - startTime) + " milliseconds.");
        startTime = System.currentTimeMillis();
        try {
            file.clearHistory(null);
        }
        catch (CoreException e) {
            HistoryStorePerformanceTest.fail((String)"3.0", (Throwable)e);
        }
        endTime = System.currentTimeMillis();
        System.out.println("Removing " + nTimes + " states: " + (endTime - startTime) + " milliseconds.");
    }
}

