/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.Comparator;
import org.eclipse.core.tests.resources.usecase.IResourceTest;

public class IProjectTest
extends IResourceTest {
    public static String LOCAL_LOCATION_PATH_STRING_0;

    public IProjectTest() {
    }

    public IProjectTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        LOCAL_LOCATION_PATH_STRING_0 = IProjectTest.getWorkspace().getRoot().getLocation().append("temp/location0").toOSString();
    }

    protected void commonFailureTests(IProject proj, boolean created) {
        String method = "commonFailureTests(IProject," + (created ? "CREATED" : "NONEXISTENT") + "): ";
        this.commonFailureTestsForResource((IResource)proj, created);
        try {
            proj.getDescription();
            IProjectTest.fail((String)(String.valueOf(method) + "4.1"));
        }
        catch (CoreException coreException) {}
    }

    protected void nonexistentProjectFailureTests(IProject proj) {
        String method = "nonexistentProjectFailureTests(IProject,ISolution,IWorkspace): ";
        this.commonFailureTests(proj, false);
        IProgressMonitor monitor = null;
        IWorkspace wb = IProjectTest.getWorkspace();
        try {
            proj.open(monitor);
            IProjectTest.fail((String)(String.valueOf(method) + "0.0"));
        }
        catch (CoreException coreException) {}
        IProjectTest.assertTrue((String)(String.valueOf(method) + "0.1"), (!proj.isOpen() ? 1 : 0) != 0);
        try {
            proj.getDescription().setLocation((IPath)new Path(LOCAL_LOCATION_PATH_STRING_0));
            IProjectTest.fail((String)(String.valueOf(method) + "1"));
        }
        catch (Exception exception) {}
        IProjectTest.assertTrue((String)(String.valueOf(method) + "2.1"), (wb.getRoot().getProjects().length == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(IProjectTest.class.getName());
        suite.addTest((Test)new IProjectTest("testProject"));
        return suite;
    }

    public void testProject() {
        IWorkspace wb = IProjectTest.getWorkspace();
        IProgressMonitor monitor = null;
        IProject proj = wb.getRoot().getProject(PROJECT);
        IProjectTest.assertTrue((String)"1.1", (!proj.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.2", (boolean)proj.getWorkspace().equals(wb));
        IProjectTest.assertTrue((String)"1.4", (proj.getType() == 4 ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.5", (boolean)proj.getFullPath().equals((Object)new Path("/" + PROJECT)));
        IProjectTest.assertTrue((String)"1.6", (boolean)proj.getName().equals(PROJECT));
        IProjectTest.assertTrue((String)"1.9", (!wb.getRoot().exists(proj.getFullPath()) ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.11", (wb.getRoot().findMember(proj.getFullPath()) == null ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"1.12", (boolean)proj.getParent().equals((Object)wb.getRoot()));
        IProjectTest.assertTrue((String)"1.13", (boolean)proj.getProject().equals((Object)proj));
        IProjectTest.assertTrue((String)"1.14", (boolean)proj.getProjectRelativePath().equals((Object)new Path("")));
        IProjectTest.assertTrue((String)"6.1", (wb.getRoot().getProjects().length == 0 ? 1 : 0) != 0);
        this.nonexistentProjectFailureTests(proj);
        try {
            proj.create(monitor);
        }
        catch (CoreException coreException) {
            IProjectTest.fail((String)"8");
        }
        IProjectTest.assertTrue((String)"9.0", (boolean)proj.exists());
        IProjectTest.assertTrue((String)"9.1", (boolean)wb.getRoot().findMember(proj.getName()).exists());
        IProjectTest.assertTrue((String)"9.3", (boolean)wb.getRoot().exists(proj.getFullPath()));
        IProjectTest.assertTrue((String)"9.4", (!proj.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"9.5", (boolean)wb.getRoot().findMember(proj.getFullPath()).equals((Object)proj));
        this.unopenedProjectFailureTests(proj);
        try {
            proj.open(monitor);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"11.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"11.1", (boolean)proj.isOpen());
        IProjectTest.assertTrue((String)"11.2", (proj.getLocation() != null ? 1 : 0) != 0);
        try {
            IProjectTest.assertTrue((String)"12.0", (proj.getSessionProperty(Q_NAME_SESSION) == null ? 1 : 0) != 0);
        }
        catch (CoreException coreException) {
            IProjectTest.fail((String)"12.1");
        }
        try {
            proj.setSessionProperty(Q_NAME_SESSION, (Object)STRING_VALUE);
        }
        catch (CoreException coreException) {
            IProjectTest.fail((String)"12.2");
        }
        try {
            IProjectTest.assertTrue((String)"12.3", (boolean)proj.getSessionProperty(Q_NAME_SESSION).equals(STRING_VALUE));
        }
        catch (CoreException coreException) {
            IProjectTest.fail((String)"12.4");
        }
        try {
            proj.setSessionProperty(Q_NAME_SESSION, null);
        }
        catch (CoreException coreException) {
            IProjectTest.fail((String)"12.5");
        }
        try {
            IProjectTest.assertTrue((String)"12.6", (proj.getSessionProperty(Q_NAME_SESSION) == null ? 1 : 0) != 0);
        }
        catch (CoreException coreException) {
            IProjectTest.fail((String)"12.7");
        }
        IProjectDescription desc = null;
        try {
            desc = proj.getDescription();
        }
        catch (CoreException coreException) {
            IProjectTest.fail((String)"14.0");
        }
        IProjectTest.assertTrue((String)"15.1", (desc.getBuildSpec().length == 0 ? 1 : 0) != 0);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.buildername");
        ICommand[] commands = new ICommand[]{command};
        Hashtable<String, String> arguments = new Hashtable<String, String>(2);
        arguments.put("param0", "arg0");
        command.setArguments(arguments);
        desc.setBuildSpec(commands);
        IProjectTest.assertTrue((String)"15.5", (boolean)Comparator.equals(desc.getBuildSpec(), commands));
        IProjectTest.assertTrue((String)"18.0", (boolean)proj.isLocal(0));
        IProjectTest.assertTrue((String)"18.1", (boolean)proj.isLocal(1));
        IProjectTest.assertTrue((String)"18.2", (boolean)proj.isLocal(2));
        try {
            proj.close(monitor);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"19.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"19.1", (!proj.isOpen() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"19.2", (boolean)proj.exists());
        IProjectTest.assertTrue((String)"19.5", (boolean)wb.getRoot().findMember(proj.getFullPath()).equals((Object)proj));
        IProjectTest.assertTrue((String)"19.6", (boolean)wb.getRoot().exists(proj.getFullPath()));
        this.unopenedProjectFailureTests(proj);
        try {
            proj.delete(false, monitor);
        }
        catch (CoreException e) {
            IProjectTest.fail((String)"20.0", (Throwable)e);
        }
        IProjectTest.assertTrue((String)"20.1", (!proj.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"20.2", (wb.getRoot().getProjects().length == 0 ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)"20.4", (wb.getRoot().findMember(proj.getFullPath()) == null ? 1 : 0) != 0);
        this.nonexistentProjectFailureTests(proj);
        IProjectTest.assertTrue((String)"20.5", (!wb.getRoot().exists(proj.getFullPath()) ? 1 : 0) != 0);
    }

    protected void unopenedProjectFailureTests(IProject proj) {
        this.commonFailureTests(proj, true);
    }

    protected void unopenedSolutionFailureTests(IProject proj, IWorkspace wb) {
        String method = "unopenedSolutionFailureTests(IProject,IWorkspace): ";
        IProgressMonitor monitor = null;
        try {
            proj.create(monitor);
            IProjectTest.fail((String)(String.valueOf(method) + "1"));
        }
        catch (CoreException coreException) {}
        IProjectTest.assertTrue((String)(String.valueOf(method) + "2"), (!proj.exists() ? 1 : 0) != 0);
        IProjectTest.assertTrue((String)(String.valueOf(method) + "3"), (!wb.getRoot().exists(proj.getFullPath()) ? 1 : 0) != 0);
    }
}

