/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.usecase.Snapshot3Test;
import org.eclipse.core.tests.resources.usecase.SnapshotTest;

public class Snapshot4Test
extends SnapshotTest {
    public Snapshot4Test() {
    }

    public Snapshot4Test(String name) {
        super(name);
    }

    protected static String[] defineHierarchy1() {
        ArrayList<String> result = new ArrayList<String>();
        String[] old = Snapshot3Test.defineHierarchy1();
        int i = 0;
        while (i < old.length) {
            result.add(old[i]);
            ++i;
        }
        result.remove(new Path("MyProject").append("added file").toString());
        result.remove(new Path("MyProject").append("yet another file").toString());
        result.remove(new Path("MyProject").append("a folder").addTrailingSeparator().toString());
        return result.toArray(new String[result.size()]);
    }

    protected static String[] defineHierarchy2() {
        return new String[0];
    }

    public void testChangeMyProject() {
        IProject project = Snapshot4Test.getWorkspace().getRoot().getProject("MyProject");
        Snapshot4Test.assertTrue((String)"0.1", (boolean)project.exists());
        Snapshot4Test.assertTrue((String)"0.2", (boolean)project.isOpen());
        IFile file = project.getFile("added file");
        try {
            file.delete(true, true, null);
        }
        catch (CoreException e) {
            Snapshot4Test.fail((String)"1.0", (Throwable)e);
        }
        this.assertDoesNotExistInFileSystem("1.1", (IResource)file);
        this.assertDoesNotExistInWorkspace("1.2", (IResource)file);
        try {
            Snapshot4Test.getWorkspace().save(true, null);
        }
        catch (CoreException e) {
            Snapshot4Test.fail((String)"2.0", (Throwable)e);
        }
        file = project.getFile("yet another file");
        try {
            file.delete(true, true, null);
        }
        catch (CoreException e) {
            Snapshot4Test.fail((String)"3.0", (Throwable)e);
        }
        this.assertDoesNotExistInFileSystem("3.1", (IResource)file);
        this.assertDoesNotExistInWorkspace("3.2", (IResource)file);
        try {
            Snapshot4Test.getWorkspace().save(false, null);
        }
        catch (CoreException e) {
            Snapshot4Test.fail((String)"4.0", (Throwable)e);
        }
        IFolder folder = project.getFolder("a folder");
        try {
            folder.delete(true, true, null);
        }
        catch (CoreException e) {
            Snapshot4Test.fail((String)"5.0", (Throwable)e);
        }
        this.assertDoesNotExistInFileSystem("5.1", (IResource)folder);
        this.assertDoesNotExistInWorkspace("5.2", (IResource)folder);
        try {
            Snapshot4Test.getWorkspace().save(false, null);
        }
        catch (CoreException e) {
            Snapshot4Test.fail((String)"6.0", (Throwable)e);
        }
    }

    public void testChangeProject2() {
        IProject project = Snapshot4Test.getWorkspace().getRoot().getProject("Project2");
        Snapshot4Test.assertTrue((String)"0.1", (boolean)project.exists());
        Snapshot4Test.assertTrue((String)"0.2", (boolean)project.isOpen());
        try {
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            Snapshot4Test.fail((String)"1.0", (Throwable)e);
        }
        Snapshot4Test.assertTrue((String)"1.1", (!project.exists() ? 1 : 0) != 0);
        try {
            Snapshot4Test.getWorkspace().save(false, null);
        }
        catch (CoreException e) {
            Snapshot4Test.fail((String)"4.0", (Throwable)e);
        }
    }

    public void testVerifyPreviousSession() {
        IProject project = Snapshot4Test.getWorkspace().getRoot().getProject("MyProject");
        Snapshot4Test.assertTrue((String)"0.0", (boolean)project.exists());
        Snapshot4Test.assertTrue((String)"0.1", (boolean)project.isOpen());
        IResource[] resources = this.buildResources((IContainer)project, Snapshot3Test.defineHierarchy1());
        this.assertExistsInFileSystem("2.1", resources);
        this.assertExistsInWorkspace("2.2", resources);
        project = Snapshot4Test.getWorkspace().getRoot().getProject("Project2");
        Snapshot4Test.assertTrue((String)"3.0", (boolean)project.exists());
        Snapshot4Test.assertTrue((String)"3.1", (boolean)project.isOpen());
        try {
            Snapshot4Test.assertEquals((String)"4.0", (int)4, (int)project.members().length);
            Snapshot4Test.assertNotNull((String)"4.1", (Object)project.findMember(".project"));
        }
        catch (CoreException e) {
            Snapshot4Test.fail((String)"4.2", (Throwable)e);
        }
        resources = this.buildResources((IContainer)project, Snapshot3Test.defineHierarchy2());
        this.assertExistsInFileSystem("5.1", resources);
        this.assertExistsInWorkspace("5.2", resources);
    }
}

