/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.BuildEventListener;

public class BuilderEventTest
extends AbstractBuilderTest {
    private BuildEventListener listener;

    public static Test suite() {
        return new TestSuite(BuilderEventTest.class);
    }

    public BuilderEventTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.listener = new BuildEventListener();
        int mask = 25;
        BuilderEventTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener, mask);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        BuilderEventTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.listener);
    }

    public void testEventsOnClean() {
        IProject project = BuilderEventTest.getWorkspace().getRoot().getProject("PROJECT");
        try {
            this.setAutoBuilding(false);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            BuilderEventTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            IProjectDescription desc = project.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.deltaverifierbuilder", "Project2Build2")});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderEventTest.fail((String)"1.1", (Throwable)e);
        }
        this.listener.reset();
        try {
            BuilderEventTest.getWorkspace().build(10, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderEventTest.fail((String)"2.99", (Throwable)e);
        }
        BuilderEventTest.assertEquals((String)"2.0", (Object)BuilderEventTest.getWorkspace(), (Object)this.listener.getSource());
        BuilderEventTest.assertEquals((String)"2.1", (int)10, (int)this.listener.getBuildKind());
        BuilderEventTest.assertEquals((String)"2.2", (boolean)true, (boolean)this.listener.hadPreBuild());
        BuilderEventTest.assertEquals((String)"2.3", (boolean)true, (boolean)this.listener.hadPostBuild());
        BuilderEventTest.assertEquals((String)"2.4", (boolean)true, (boolean)this.listener.hadPostChange());
        this.listener.reset();
        try {
            BuilderEventTest.getWorkspace().build(10, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderEventTest.fail((String)"2.99", (Throwable)e);
        }
        BuilderEventTest.assertEquals((String)"2.0", (Object)BuilderEventTest.getWorkspace(), (Object)this.listener.getSource());
        BuilderEventTest.assertEquals((String)"2.1", (int)10, (int)this.listener.getBuildKind());
        BuilderEventTest.assertEquals((String)"2.2", (boolean)true, (boolean)this.listener.hadPreBuild());
        BuilderEventTest.assertEquals((String)"2.3", (boolean)true, (boolean)this.listener.hadPostBuild());
        BuilderEventTest.assertEquals((String)"2.4", (boolean)true, (boolean)this.listener.hadPostChange());
        this.listener.reset();
        try {
            BuilderEventTest.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderEventTest.fail((String)"3.99", (Throwable)e);
        }
        BuilderEventTest.assertEquals((String)"3.0", (Object)BuilderEventTest.getWorkspace(), (Object)this.listener.getSource());
        BuilderEventTest.assertEquals((String)"3.1", (int)6, (int)this.listener.getBuildKind());
        BuilderEventTest.assertEquals((String)"3.2", (boolean)true, (boolean)this.listener.hadPreBuild());
        BuilderEventTest.assertEquals((String)"3.3", (boolean)true, (boolean)this.listener.hadPostBuild());
        BuilderEventTest.assertEquals((String)"3.4", (boolean)true, (boolean)this.listener.hadPostChange());
        this.listener.reset();
        try {
            BuilderEventTest.getWorkspace().build(15, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderEventTest.fail((String)"4.99", (Throwable)e);
        }
        BuilderEventTest.assertEquals((String)"4.0", (Object)BuilderEventTest.getWorkspace(), (Object)this.listener.getSource());
        BuilderEventTest.assertEquals((String)"4.1", (int)15, (int)this.listener.getBuildKind());
        BuilderEventTest.assertEquals((String)"4.2", (boolean)true, (boolean)this.listener.hadPreBuild());
        BuilderEventTest.assertEquals((String)"4.3", (boolean)true, (boolean)this.listener.hadPostBuild());
        BuilderEventTest.assertEquals((String)"4.4", (boolean)true, (boolean)this.listener.hadPostChange());
    }
}

