/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.tests.harness.TestBarrier;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;
import org.eclipse.core.tests.internal.builders.EmptyDeltaBuilder;
import org.eclipse.core.tests.internal.builders.EmptyDeltaBuilder2;
import org.eclipse.core.tests.internal.builders.TestBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelaxedSchedRuleBuilderTest
extends AbstractBuilderTest {
    public static Test suite() {
        return new TestSuite(RelaxedSchedRuleBuilderTest.class);
    }

    public RelaxedSchedRuleBuilderTest() {
        super(null);
    }

    public RelaxedSchedRuleBuilderTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        RelaxedSchedRuleBuilderTest.getWorkspace().getRoot().delete(true, null);
        TestBuilder builder = DeltaVerifierBuilder.getInstance();
        if (builder != null) {
            builder.reset();
        }
        if ((builder = EmptyDeltaBuilder.getInstance()) != null) {
            builder.reset();
        }
        if ((builder = EmptyDeltaBuilder2.getInstance()) != null) {
            builder.reset();
        }
    }

    public void testBasicRelaxedSchedulingRules() throws Exception {
        String name = "TestRelaxed";
        this.setAutoBuilding(false);
        final IProject project = RelaxedSchedRuleBuilderTest.getWorkspace().getRoot().getProject(name);
        this.create((IResource)project, false);
        this.addBuilder(project, "org.eclipse.core.tests.resources.emptydeltabuilder");
        project.build(15, this.getMonitor());
        final TestBarrier tb = new TestBarrier(0);
        EmptyDeltaBuilder builder = EmptyDeltaBuilder.getInstance();
        builder.setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            @Override
            public ISchedulingRule getRule(String name, IncrementalProjectBuilder builder, int trigger, Map<String, String> args) {
                return null;
            }

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                RelaxedSchedRuleBuilderTest.assertTrue((Job.getJobManager().currentRule() == null ? 1 : 0) != 0);
                tb.setStatus(1);
                while (!monitor.isCanceled()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                tb.setStatus(5);
                return super.build(kind, args, monitor);
            }
        });
        Job j = new Job("build job"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    project.build(6, monitor);
                }
                catch (CoreException coreException) {
                    RelaxedSchedRuleBuilderTest.fail();
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        tb.waitForStatus(1);
        this.create((IResource)project.getFile("foo.c"), false);
        RelaxedSchedRuleBuilderTest.assertTrue((boolean)project.getFile("foo.c").exists());
        j.cancel();
        tb.waitForStatus(5);
    }

    public void testTwoBuildersRunInOneBuild() throws Exception {
        String name = "testTwoBuildersRunInOneBuild";
        this.setAutoBuilding(false);
        final IProject project = RelaxedSchedRuleBuilderTest.getWorkspace().getRoot().getProject(name);
        this.create((IResource)project, false);
        IProjectDescription desc = project.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.emptydeltabuilder", "Project1Build1"), this.createCommand(desc, "org.eclipse.core.tests.resources.emptydeltabuilder2", "Project1Build2")});
        project.setDescription(desc, this.getMonitor());
        project.build(15, this.getMonitor());
        final TestBarrier tb1 = new TestBarrier(0);
        final TestBarrier tb2 = new TestBarrier(0);
        EmptyDeltaBuilder builder = EmptyDeltaBuilder.getInstance();
        EmptyDeltaBuilder2 builder2 = EmptyDeltaBuilder2.getInstance();
        builder.setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            public ISchedulingRule getRule(String name, IncrementalProjectBuilder builder, int trigger, Map args) {
                tb1.setStatus(1);
                return project;
            }

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                RelaxedSchedRuleBuilderTest.assertTrue((boolean)Job.getJobManager().currentRule().contains((ISchedulingRule)project));
                tb1.setStatus(3);
                tb1.waitForStatus(4);
                tb1.setStatus(5);
                return super.build(kind, args, monitor);
            }
        });
        builder2.setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            @Override
            public ISchedulingRule getRule(String name, IncrementalProjectBuilder builder, int trigger, Map<String, String> args) {
                tb2.setStatus(1);
                return null;
            }

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                RelaxedSchedRuleBuilderTest.assertTrue((Job.getJobManager().currentRule() == null || Job.getJobManager().currentRule().contains((ISchedulingRule)RelaxedSchedRuleBuilderTest.getWorkspace().getRoot()) ? 1 : 0) != 0);
                tb2.setStatus(3);
                tb2.waitForStatus(4);
                tb2.setStatus(5);
                return super.build(kind, args, monitor);
            }
        });
        Job j = new Job("build job1"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    project.build(6, monitor);
                }
                catch (CoreException coreException) {
                    RelaxedSchedRuleBuilderTest.fail();
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        tb1.waitForStatus(3);
        tb1.setStatus(4);
        tb1.waitForStatus(5);
        tb2.waitForStatus(3);
        tb2.setStatus(4);
        tb2.waitForStatus(5);
    }

    private HashSet<ISchedulingRule> getRulesAsSet(ISchedulingRule rule) {
        HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
        if (rule == null) {
            return rules;
        }
        if (rule instanceof MultiRule) {
            rules.addAll(Arrays.asList(((MultiRule)rule).getChildren()));
        } else {
            rules.add(rule);
        }
        return rules;
    }

    public void testBuilderDeltaUsingRelaxedRuleBug343256() throws Exception {
        String name = "testBuildDeltaUsingRelaxedRuleBug343256";
        this.setAutoBuilding(false);
        final IProject project = RelaxedSchedRuleBuilderTest.getWorkspace().getRoot().getProject(name);
        final IFile foo = project.getFile("foo");
        this.create((IResource)project, false);
        IProjectDescription desc = project.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.emptydeltabuilder", "Project1Build1")});
        project.setDescription(desc, this.getMonitor());
        project.build(6, this.getMonitor());
        final TestBarrier tb1 = new TestBarrier(0);
        EmptyDeltaBuilder builder = EmptyDeltaBuilder.getInstance();
        builder.setRuleCallback(new TestBuilder.BuilderRuleCallback(){
            boolean called = false;

            public ISchedulingRule getRule(String name, IncrementalProjectBuilder builder, int trigger, Map args) {
                if (!this.called) {
                    this.called = true;
                    return project;
                }
                tb1.setStatus(1);
                tb1.waitForStatus(2);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    RelaxedSchedRuleBuilderTest.fail();
                }
                return project;
            }

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                RelaxedSchedRuleBuilderTest.assertTrue((boolean)Job.getJobManager().currentRule().equals(project));
                IResourceDelta delta = this.getDelta(project);
                RelaxedSchedRuleBuilderTest.assertNotNull((String)"1.1", (Object)delta);
                RelaxedSchedRuleBuilderTest.assertTrue((String)"1.2", (delta.getAffectedChildren().length == 1 ? 1 : 0) != 0);
                RelaxedSchedRuleBuilderTest.assertTrue((String)"1.3", (boolean)delta.getAffectedChildren()[0].getResource().equals((Object)foo));
                tb1.setStatus(5);
                return super.build(kind, args, monitor);
            }
        });
        Job j = new Job("IProject.build()"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    RelaxedSchedRuleBuilderTest.getWorkspace().build(new IBuildConfiguration[]{project.getActiveBuildConfig()}, 10, true, monitor);
                }
                catch (CoreException coreException) {
                    RelaxedSchedRuleBuilderTest.fail();
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        tb1.waitForStatus(1);
        j = new Job("IProject.build()"){

            protected IStatus run(IProgressMonitor monitor) {
                tb1.setStatus(2);
                RelaxedSchedRuleBuilderTest.this.ensureExistsInWorkspace(foo, new ByteArrayInputStream(new byte[0]));
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        tb1.waitForStatus(5);
    }

    public void testBug343256() throws Exception {
        String name = "testBug343256";
        this.setAutoBuilding(false);
        final IProject project = RelaxedSchedRuleBuilderTest.getWorkspace().getRoot().getProject(name);
        this.create((IResource)project, false);
        IProjectDescription desc = project.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.emptydeltabuilder", "Project1Build1"), this.createCommand(desc, "org.eclipse.core.tests.resources.emptydeltabuilder2", "Project1Build2")});
        project.setDescription(desc, this.getMonitor());
        project.build(15, this.getMonitor());
        final TestBarrier tb1 = new TestBarrier(0);
        final TestBarrier tb2 = new TestBarrier(0);
        final ISchedulingRule[] getRules = new ISchedulingRule[2];
        final ISchedulingRule[] buildRules = new ISchedulingRule[2];
        EmptyDeltaBuilder builder = EmptyDeltaBuilder.getInstance();
        EmptyDeltaBuilder2 builder2 = EmptyDeltaBuilder2.getInstance();
        builder.setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            public ISchedulingRule getRule(String name, IncrementalProjectBuilder builder, int trigger, Map args) {
                tb1.waitForStatus(1);
                return getRules[0];
            }

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                HashSet h1 = RelaxedSchedRuleBuilderTest.this.getRulesAsSet(Job.getJobManager().currentRule());
                HashSet h2 = RelaxedSchedRuleBuilderTest.this.getRulesAsSet(buildRules[0]);
                RelaxedSchedRuleBuilderTest.assertTrue((boolean)h1.equals(h2));
                tb1.setStatus(5);
                return super.build(kind, args, monitor);
            }
        });
        builder2.setRuleCallback(new TestBuilder.BuilderRuleCallback(){

            @Override
            public ISchedulingRule getRule(String name, IncrementalProjectBuilder builder, int trigger, Map<String, String> args) {
                tb2.waitForStatus(1);
                return getRules[1];
            }

            @Override
            public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
                HashSet h1 = RelaxedSchedRuleBuilderTest.this.getRulesAsSet(Job.getJobManager().currentRule());
                HashSet h2 = RelaxedSchedRuleBuilderTest.this.getRulesAsSet(buildRules[1]);
                RelaxedSchedRuleBuilderTest.assertTrue((boolean)h1.equals(h2));
                tb2.setStatus(5);
                return super.build(kind, args, monitor);
            }
        });
        Job j = new Job("IWorkspace.build(IBuildConfiguration[],...)"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    RelaxedSchedRuleBuilderTest.getWorkspace().build(new IBuildConfiguration[]{project.getActiveBuildConfig()}, 6, true, monitor);
                }
                catch (CoreException e) {
                    RelaxedSchedRuleBuilderTest.fail((String)e.toString());
                }
                return Status.OK_STATUS;
            }
        };
        this.invokeTestBug343256(project, getRules, buildRules, tb1, tb2, j);
    }

    private void invokeTestBug343256(IProject project, ISchedulingRule[] getRules, ISchedulingRule[] buildRules, TestBarrier tb1, TestBarrier tb2, Job j) {
        getRules[0] = getRules[1] = project;
        buildRules[0] = buildRules[1] = new MultiRule(new ISchedulingRule[]{getRules[0]});
        tb1.setStatus(1);
        tb2.setStatus(1);
        j.schedule();
        tb1.waitForStatus(5);
        tb2.waitForStatus(5);
        getRules[1] = null;
        getRules[0] = null;
        buildRules[1] = null;
        buildRules[0] = null;
        tb1.setStatus(1);
        tb2.setStatus(1);
        j.schedule();
        tb1.waitForStatus(5);
        tb2.waitForStatus(5);
        getRules[0] = buildRules[0] = project;
        getRules[1] = buildRules[1] = RelaxedSchedRuleBuilderTest.getWorkspace().getRoot().getProject("other");
        tb1.setStatus(1);
        tb2.setStatus(1);
        j.schedule();
        tb1.waitForStatus(5);
        tb2.waitForStatus(5);
        getRules[0] = buildRules[0] = project;
        buildRules[1] = null;
        getRules[1] = null;
        buildRules[0] = buildRules[1] = RelaxedSchedRuleBuilderTest.getWorkspace().getRoot();
        tb1.setStatus(1);
        tb2.setStatus(1);
        j.schedule();
        tb1.waitForStatus(5);
        tb2.waitForStatus(5);
    }
}

