/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.dtree;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.dtree.AbstractDataTree;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.IComparator;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.internal.dtree.TestHelper;
import org.eclipse.core.internal.watson.DefaultElementComparator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.dtree.DataTreeTest;

public class DeltaDataTreeTest
extends DataTreeTest {
    DeltaDataTree tree;
    DeltaDataTree emptyTree;
    DeltaDataTree changedTree;
    DeltaDataTree deltaTree;

    public DeltaDataTreeTest() {
    }

    public DeltaDataTreeTest(String name) {
        super(name);
    }

    public void assertDelta(DeltaDataTree originalTree) {
        DeltaDataTreeTest.assertTrue((String)"1", (boolean)originalTree.includes(this.rootKey));
        DeltaDataTreeTest.assertTrue((String)"2", (boolean)originalTree.includes(this.leftKey));
        DeltaDataTreeTest.assertTrue((String)"3", (boolean)originalTree.includes(this.rightKey));
        DeltaDataTreeTest.assertTrue((String)"4", (boolean)originalTree.includes(this.rootKey.append("newTopLevel")));
        DeltaDataTreeTest.assertTrue((String)"5", (boolean)originalTree.includes(this.leftKey.append("new")));
        DeltaDataTreeTest.assertTrue((String)"6", (boolean)originalTree.includes(this.leftKey.append("two")));
        DeltaDataTreeTest.assertTrue((String)"7", (boolean)originalTree.includes(this.leftKey.append("three")));
        DeltaDataTreeTest.assertTrue((String)"8", (boolean)originalTree.includes(this.rightKey.append("rightOfRight")));
        DeltaDataTreeTest.assertTrue((String)"9", (!originalTree.includes(this.leftKey.append("one")) ? 1 : 0) != 0);
    }

    public void assertTree(DeltaDataTree originalTree) {
        DeltaDataTreeTest.assertTrue((String)"1", (boolean)originalTree.includes(this.rootKey));
        DeltaDataTreeTest.assertTrue((String)"2", (boolean)originalTree.includes(this.leftKey));
        DeltaDataTreeTest.assertTrue((String)"3", (boolean)originalTree.includes(this.rightKey));
        DeltaDataTreeTest.assertTrue((String)"4", (boolean)originalTree.includes(this.leftKey.append("one")));
        DeltaDataTreeTest.assertTrue((String)"5", (boolean)originalTree.includes(this.leftKey.append("two")));
        DeltaDataTreeTest.assertTrue((String)"6", (boolean)originalTree.includes(this.leftKey.append("three")));
        DeltaDataTreeTest.assertTrue((String)"7", (boolean)originalTree.includes(this.rightKey.append("rightOfRight")));
    }

    protected void setUp() {
        this.emptyTree = new DeltaDataTree();
        this.tree = new DeltaDataTree();
        this.rootKey = Path.ROOT;
        try {
            this.tree.createChild(this.rootKey, "leftOfRoot");
            this.tree.createChild(this.rootKey, "rightOfRoot");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new Error("(1) Error in setUp");
        }
        this.leftKey = this.rootKey.append("leftOfRoot");
        this.rightKey = this.rootKey.append("rightOfRoot");
        try {
            this.tree.createChild(this.leftKey, "one");
            this.tree.createChild(this.leftKey, "two");
            this.tree.createChild(this.leftKey, "three");
            this.tree.createChild(this.rightKey, "rightOfRight");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new Error("(2) Error in setUp");
        }
        this.changedTree = new DeltaDataTree();
        this.changedTree.createSubtree(this.rootKey, this.tree.copyCompleteSubtree(this.rootKey));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(DeltaDataTreeTest.class.getName());
        suite.addTest((Test)new DeltaDataTreeTest("testSetup"));
        suite.addTest((Test)new DeltaDataTreeTest("testAddAndRemoveOnSameLayer"));
        suite.addTest((Test)new DeltaDataTreeTest("testAddTwiceAndDelete"));
        suite.addTest((Test)new DeltaDataTreeTest("testAssembleWithIn"));
        suite.addTest((Test)new DeltaDataTreeTest("testCreateChild"));
        suite.addTest((Test)new DeltaDataTreeTest("testDeleteChild"));
        suite.addTest((Test)new DeltaDataTreeTest("testDeltaOnCompletelyDifferentTrees"));
        suite.addTest((Test)new DeltaDataTreeTest("testEmpty"));
        suite.addTest((Test)new DeltaDataTreeTest("testForwardDeltaOnDataDeltaNode"));
        suite.addTest((Test)new DeltaDataTreeTest("testForwardDeltaWith"));
        suite.addTest((Test)new DeltaDataTreeTest("testForwardDeltaWithEquality"));
        suite.addTest((Test)new DeltaDataTreeTest("testGetChild"));
        suite.addTest((Test)new DeltaDataTreeTest("testGetChildCount"));
        suite.addTest((Test)new DeltaDataTreeTest("testGetChildren"));
        suite.addTest((Test)new DeltaDataTreeTest("testGetNameOfChild"));
        suite.addTest((Test)new DeltaDataTreeTest("testGetNamesOfChildren"));
        suite.addTest((Test)new DeltaDataTreeTest("testIncludes"));
        suite.addTest((Test)new DeltaDataTreeTest("testLongDeltaChain"));
        suite.addTest((Test)new DeltaDataTreeTest("testNewEmptyDeltaTree"));
        suite.addTest((Test)new DeltaDataTreeTest("testRegression1FVVP6L"));
        suite.addTest((Test)new DeltaDataTreeTest("testRegression1FVVP6LWithChildren"));
        suite.addTest((Test)new DeltaDataTreeTest("testReroot"));
        return suite;
    }

    public void testAddAndRemoveOnSameLayer() {
        IPath elementA = Path.ROOT.append("A");
        DeltaDataTree tree1 = new DeltaDataTree();
        tree1.createChild((IPath)Path.ROOT, "A", (Object)"Data for A");
        tree1.immutable();
        DeltaDataTree tree2 = tree1.newEmptyDeltaTree();
        tree2.createChild(elementA, "B", (Object)"New B Data");
        tree2.deleteChild(elementA, "B");
        tree2.immutable();
        tree1.compareWith(tree2, (IComparator)DefaultElementComparator.getComparator());
        tree2.compareWith(tree1, (IComparator)DefaultElementComparator.getComparator());
        tree1.forwardDeltaWith(tree2, (IComparator)DefaultElementComparator.getComparator());
        tree2.forwardDeltaWith(tree1, (IComparator)DefaultElementComparator.getComparator());
        tree1.copyCompleteSubtree((IPath)Path.ROOT);
        tree2.copyCompleteSubtree((IPath)Path.ROOT);
        tree1.reroot();
        tree2.reroot();
        tree1.makeComplete();
        tree2.makeComplete();
    }

    public void testAddTwiceAndDelete() {
        DeltaDataTree tree1 = new DeltaDataTree();
        tree1.createChild((IPath)Path.ROOT, "A", (Object)"Data for A");
        tree1.immutable();
        tree1 = tree1.newEmptyDeltaTree();
        tree1.createChild((IPath)Path.ROOT, "A", (Object)"New A Data");
        tree1.immutable();
        tree1 = tree1.newEmptyDeltaTree();
        tree1.deleteChild((IPath)Path.ROOT, "A");
        tree1.immutable();
        DeltaDataTreeTest.assertTrue((tree1.getChildCount((IPath)Path.ROOT) == 0 ? 1 : 0) != 0);
    }

    public void testAssembleWithIn() {
        this.changedTree.deleteChild(this.leftKey, "two");
        this.deltaTree = this.tree.forwardDeltaWith(this.changedTree, (IComparator)DefaultElementComparator.getComparator());
        DeltaDataTree assembledTree = this.tree.assembleWithForwardDelta(this.deltaTree);
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.rootKey));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey.append("one")));
        DeltaDataTreeTest.assertTrue((!assembledTree.includes(this.leftKey.append("two")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey.append("three")));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.rightKey));
    }

    public void testCreateChild() {
        block19: {
            boolean caught;
            block17: {
                caught = false;
                try {
                    try {
                        this.tree.createChild(this.rootKey.append("bogus"), "foobar");
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        caught = true;
                        DeltaDataTreeTest.assertTrue((String)"1", (boolean)caught);
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    DeltaDataTreeTest.assertTrue((String)"1", (boolean)caught);
                    throw throwable;
                }
                DeltaDataTreeTest.assertTrue((String)"1", (boolean)caught);
            }
            caught = false;
            try {
                try {
                    this.emptyTree.createChild(this.rootKey.append("bogus"), "foobar");
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    caught = true;
                    DeltaDataTreeTest.assertTrue((String)"2", (boolean)caught);
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DeltaDataTreeTest.assertTrue((String)"2", (boolean)caught);
                throw throwable;
            }
            DeltaDataTreeTest.assertTrue((String)"2", (boolean)caught);
        }
        try {
            this.emptyTree.createChild(this.rootKey, "first");
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        DeltaDataTreeTest.assertTrue((String)"3", (boolean)this.emptyTree.includes(this.rootKey.append("first")));
        try {
            this.tree.createChild(this.rootKey, "NewTopLevel");
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        DeltaDataTreeTest.assertTrue((String)"4", (boolean)this.tree.includes(this.rootKey.append("NewTopLevel")));
        DeltaDataTreeTest.assertTrue((String)"5", (boolean)this.tree.includes(this.leftKey));
        DeltaDataTreeTest.assertTrue((String)"6", (boolean)this.tree.includes(this.rightKey));
        DeltaDataTreeTest.assertTrue((String)"7", (boolean)this.tree.includes(this.leftKey.append("one")));
        try {
            this.tree.createChild(this.leftKey.append("one"), "NewBottom");
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        DeltaDataTreeTest.assertTrue((String)"8", (boolean)this.tree.includes(this.leftKey));
        DeltaDataTreeTest.assertTrue((String)"9", (boolean)this.tree.includes(this.rightKey));
        DeltaDataTreeTest.assertTrue((String)"10", (boolean)this.tree.includes(this.leftKey.append("one")));
        DeltaDataTreeTest.assertTrue((String)"11", (boolean)this.tree.includes(this.leftKey.append("one").append("NewBottom")));
        try {
            this.tree.createChild(this.rightKey, "NewRight");
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        DeltaDataTreeTest.assertTrue((String)"12", (boolean)this.tree.includes(this.leftKey));
        DeltaDataTreeTest.assertTrue((String)"13", (boolean)this.tree.includes(this.rightKey));
        DeltaDataTreeTest.assertTrue((String)"14", (boolean)this.tree.includes(this.rightKey.append("rightOfRight")));
        DeltaDataTreeTest.assertTrue((String)"15", (boolean)this.tree.includes(this.rightKey.append("NewRight")));
        int size = this.tree.getNamesOfChildren(this.leftKey).length;
        this.tree.createChild(this.leftKey, "double");
        this.tree.createChild(this.leftKey, "double");
        DeltaDataTreeTest.assertTrue((this.tree.getNamesOfChildren(this.leftKey).length == size + 1 ? 1 : 0) != 0);
    }

    public void testDeleteChild() {
        block27: {
            boolean caught;
            block25: {
                block23: {
                    block21: {
                        caught = false;
                        try {
                            try {
                                this.emptyTree.deleteChild(this.rootKey, "non-existant");
                            }
                            catch (ObjectNotFoundException objectNotFoundException) {
                                caught = true;
                                DeltaDataTreeTest.assertTrue((String)"1", (boolean)caught);
                                break block21;
                            }
                        }
                        catch (Throwable throwable) {
                            DeltaDataTreeTest.assertTrue((String)"1", (boolean)caught);
                            throw throwable;
                        }
                        DeltaDataTreeTest.assertTrue((String)"1", (boolean)caught);
                    }
                    caught = false;
                    try {
                        try {
                            this.tree.deleteChild(this.rootKey, "rightOfRight");
                        }
                        catch (ObjectNotFoundException objectNotFoundException) {
                            caught = true;
                            DeltaDataTreeTest.assertTrue((String)"2", (boolean)caught);
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        DeltaDataTreeTest.assertTrue((String)"2", (boolean)caught);
                        throw throwable;
                    }
                    DeltaDataTreeTest.assertTrue((String)"2", (boolean)caught);
                }
                DeltaDataTreeTest.assertTrue((String)"3", (boolean)this.tree.includes(this.rightKey.append("rightOfRight")));
                caught = false;
                try {
                    try {
                        this.tree.deleteChild(this.rootKey.append("bogus"), "rightOfRight");
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        caught = true;
                        DeltaDataTreeTest.assertTrue((String)"4", (boolean)caught);
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    DeltaDataTreeTest.assertTrue((String)"4", (boolean)caught);
                    throw throwable;
                }
                DeltaDataTreeTest.assertTrue((String)"4", (boolean)caught);
            }
            DeltaDataTreeTest.assertTrue((String)"5", (boolean)this.tree.includes(this.rightKey.append("rightOfRight")));
            caught = false;
            try {
                try {
                    this.tree.deleteChild(this.leftKey, "four");
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    caught = true;
                    DeltaDataTreeTest.assertTrue((String)"6", (boolean)caught);
                    break block27;
                }
            }
            catch (Throwable throwable) {
                DeltaDataTreeTest.assertTrue((String)"6", (boolean)caught);
                throw throwable;
            }
            DeltaDataTreeTest.assertTrue((String)"6", (boolean)caught);
        }
        DeltaDataTreeTest.assertTrue((String)"7", (boolean)this.tree.includes(this.leftKey));
        try {
            this.tree.deleteChild(this.rootKey, "leftOfRoot");
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        DeltaDataTreeTest.assertTrue((String)"8", (!this.tree.includes(this.leftKey) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((String)"9", (!this.tree.includes(this.leftKey.append("one")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((String)"10", (boolean)this.tree.includes(this.rootKey));
        try {
            this.tree.deleteChild(this.rightKey, "rightOfRight");
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        DeltaDataTreeTest.assertTrue((String)"11", (!this.tree.includes(this.rightKey.append("rightOfRight")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((String)"12", (boolean)this.tree.includes(this.rightKey));
    }

    public void testDeltaOnCompletelyDifferentTrees() {
        DeltaDataTree newTree = new DeltaDataTree();
        try {
            newTree.createChild(this.rootKey, "newLeft");
            newTree.createChild(this.rootKey, "newRight");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new Error("(1) Error in setUp");
        }
        try {
            newTree.createChild(this.rootKey.append("newLeft"), "newOne");
            newTree.createChild(this.rootKey.append("newLeft"), "newTwo");
            newTree.createChild(this.rootKey.append("newLeft"), "newThree");
            newTree.createChild(this.rootKey.append("newRight"), "newRightOfRight");
            newTree.createChild(this.rootKey.append("newRight").append("newRightOfRight"), "bottom");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new Error("(2) Error in setUp");
        }
        this.deltaTree = newTree.forwardDeltaWith(this.tree, (IComparator)DefaultElementComparator.getComparator());
        this.assertTree(this.deltaTree);
        DeltaDataTreeTest.assertTrue((!this.deltaTree.includes(this.rootKey.append("newLeft")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((!this.deltaTree.includes(this.rootKey.append("newRight")) ? 1 : 0) != 0);
    }

    public void testEmpty() {
        DeltaDataTreeTest.assertTrue((String)"1", (boolean)this.emptyTree.includes(this.rootKey));
        DeltaDataTreeTest.assertTrue((String)"2", (TestHelper.getRootNode((AbstractDataTree)this.emptyTree) != null ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((String)"3", (TestHelper.getRootNode((AbstractDataTree)this.emptyTree).getChildren().length == 0 ? 1 : 0) != 0);
    }

    public void testForwardDeltaOnDataDeltaNode() {
        this.tree.immutable();
        DeltaDataTree tree1 = this.tree.newEmptyDeltaTree();
        tree1.setData(this.leftKey, (Object)"replaced");
        DeltaDataTree delta = tree1.forwardDeltaWith(this.changedTree, (IComparator)DefaultElementComparator.getComparator());
        DeltaDataTreeTest.assertTrue((delta.getData(this.leftKey) == null ? 1 : 0) != 0);
    }

    public void testForwardDeltaWith() {
        this.changedTree.deleteChild(this.leftKey, "two");
        this.changedTree.createChild(this.leftKey, "four");
        this.changedTree.createChild(this.leftKey, "five");
        this.changedTree.createChild(this.leftKey, "six");
        this.changedTree.createChild(this.rootKey, "NewTopLevel");
        this.deltaTree = this.tree.forwardDeltaWith(this.changedTree, (IComparator)DefaultElementComparator.getComparator());
        DeltaDataTree assembledTree = this.tree.assembleWithForwardDelta(this.deltaTree);
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.rootKey));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.rightKey));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.rootKey.append("NewTopLevel")));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey.append("one")));
        DeltaDataTreeTest.assertTrue((!assembledTree.includes(this.leftKey.append("two")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey.append("three")));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey.append("four")));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey.append("five")));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey.append("six")));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.rightKey.append("rightOfRight")));
    }

    public void testForwardDeltaWithEquality() {
        this.changedTree.deleteChild(this.leftKey, "two");
        this.changedTree.createChild(this.leftKey, "four");
        IPath oneKey = this.leftKey.append("one");
        this.changedTree.setData(oneKey, (Object)"New");
        this.deltaTree = this.tree.forwardDeltaWith(this.changedTree, (IComparator)DefaultElementComparator.getComparator());
        DeltaDataTree assembledTree = this.tree.assembleWithForwardDelta(this.deltaTree);
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.rootKey));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.rightKey));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey.append("one")));
        DeltaDataTreeTest.assertTrue((!assembledTree.includes(this.leftKey.append("two")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey.append("three")));
        DeltaDataTreeTest.assertTrue((boolean)assembledTree.includes(this.leftKey.append("four")));
        Object data = assembledTree.getData(oneKey);
        DeltaDataTreeTest.assertTrue((data != null && data.equals("New") ? 1 : 0) != 0);
    }

    public void testGetChild() {
        boolean caught = false;
        try {
            DeltaDataTreeTest.assertTrue((boolean)this.tree.getChild(this.rootKey, 0).equals((Object)this.leftKey));
            DeltaDataTreeTest.assertTrue((boolean)this.tree.getChild(this.leftKey, 2).equals((Object)this.leftKey.append("two")));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DeltaDataTreeTest.assertTrue((!caught ? 1 : 0) != 0);
        caught = false;
        try {
            this.tree.getChild(this.rootKey, 99);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            caught = true;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new Error();
        }
        DeltaDataTreeTest.assertTrue((boolean)caught);
        caught = false;
        try {
            this.tree.getChild(this.leftKey, 99);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            caught = true;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new Error();
        }
        DeltaDataTreeTest.assertTrue((boolean)caught);
        caught = false;
        try {
            this.tree.getChild(this.leftKey.append("one"), 99);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            caught = true;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new Error();
        }
        DeltaDataTreeTest.assertTrue((boolean)caught);
        caught = false;
        try {
            this.tree.getChild(this.rootKey.append("bogus"), 0);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DeltaDataTreeTest.assertTrue((boolean)caught);
    }

    public void testGetChildCount() {
        boolean caught;
        block9: {
            caught = false;
            try {
                try {
                    DeltaDataTreeTest.assertTrue((String)"1", (this.emptyTree.getChildCount(this.rootKey) == 0 ? 1 : 0) != 0);
                    DeltaDataTreeTest.assertTrue((String)"2", (this.tree.getChildCount(this.rootKey) == 2 ? 1 : 0) != 0);
                    DeltaDataTreeTest.assertTrue((String)"3", (this.tree.getChildCount(this.leftKey) == 3 ? 1 : 0) != 0);
                    DeltaDataTreeTest.assertTrue((String)"4", (this.tree.getChildCount(this.rightKey) == 1 ? 1 : 0) != 0);
                    DeltaDataTreeTest.assertTrue((String)"5", (this.tree.getChildCount(this.leftKey.append("one")) == 0 ? 1 : 0) != 0);
                    DeltaDataTreeTest.assertTrue((String)"6", (this.tree.getChildCount(this.leftKey.append("three")) == 0 ? 1 : 0) != 0);
                    DeltaDataTreeTest.assertTrue((String)"7", (this.tree.getChildCount(this.rightKey.append("rightOfRight")) == 0 ? 1 : 0) != 0);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    caught = true;
                    DeltaDataTreeTest.assertTrue((!caught ? 1 : 0) != 0);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DeltaDataTreeTest.assertTrue((!caught ? 1 : 0) != 0);
                throw throwable;
            }
            DeltaDataTreeTest.assertTrue((!caught ? 1 : 0) != 0);
        }
        caught = false;
        try {
            this.tree.getChildCount(this.rootKey.append("bogus"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DeltaDataTreeTest.assertTrue((boolean)caught);
        caught = false;
        try {
            this.emptyTree.getChildCount(this.rootKey.append("bogus"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DeltaDataTreeTest.assertTrue((boolean)caught);
    }

    public void testGetChildren() {
        boolean caught;
        block9: {
            IPath[] rootChildren = new IPath[]{this.leftKey, this.rightKey};
            IPath[] leftChildren = new IPath[]{this.leftKey.append("one"), this.leftKey.append("two"), this.leftKey.append("three")};
            IPath[] rightChildren = new IPath[]{this.rightKey.append("rightOfRight")};
            caught = false;
            try {
                try {
                    IPath[] testChildren = this.emptyTree.getChildren(this.rootKey);
                    DeltaDataTreeTest.assertTrue((String)"1", (testChildren.length == 0 ? 1 : 0) != 0);
                    testChildren = this.tree.getChildren(this.rootKey);
                    DeltaDataTreeTest.assertTrue((String)"2", (testChildren.length == 2 ? 1 : 0) != 0);
                    DeltaDataTreeTest.assertTrue((String)"3", (boolean)testChildren[0].equals((Object)rootChildren[0]));
                    DeltaDataTreeTest.assertTrue((String)"4", (boolean)testChildren[1].equals((Object)rootChildren[1]));
                    testChildren = this.tree.getChildren(this.leftKey);
                    DeltaDataTreeTest.assertTrue((String)"5", (testChildren.length == 3 ? 1 : 0) != 0);
                    DeltaDataTreeTest.assertTrue((String)"6", (boolean)testChildren[0].equals((Object)leftChildren[0]));
                    DeltaDataTreeTest.assertTrue((String)"7", (boolean)testChildren[2].equals((Object)leftChildren[1]));
                    DeltaDataTreeTest.assertTrue((String)"8", (boolean)testChildren[1].equals((Object)leftChildren[2]));
                    testChildren = this.tree.getChildren(leftChildren[0]);
                    DeltaDataTreeTest.assertTrue((String)"9", (testChildren.length == 0 ? 1 : 0) != 0);
                    testChildren = this.tree.getChildren(rightChildren[0]);
                    DeltaDataTreeTest.assertTrue((String)"10", (testChildren.length == 0 ? 1 : 0) != 0);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    caught = true;
                    DeltaDataTreeTest.assertTrue((String)"11", (!caught ? 1 : 0) != 0);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DeltaDataTreeTest.assertTrue((String)"11", (!caught ? 1 : 0) != 0);
                throw throwable;
            }
            DeltaDataTreeTest.assertTrue((String)"11", (!caught ? 1 : 0) != 0);
        }
        caught = false;
        try {
            this.tree.getChildren(this.rootKey.append("bogus"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DeltaDataTreeTest.assertTrue((String)"12", (boolean)caught);
        caught = false;
        try {
            this.emptyTree.getChildren(this.rootKey.append("bogus"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DeltaDataTreeTest.assertTrue((String)"13", (boolean)caught);
    }

    public void testGetNameOfChild() {
    }

    public void testGetNamesOfChildren() {
        boolean caught;
        block9: {
            String[] rootChildren = new String[]{"leftOfRoot", "rightOfRoot"};
            String[] leftChildren = new String[]{"one", "two", "three"};
            String[] rightChildren = new String[]{"rightOfRight"};
            caught = false;
            try {
                try {
                    String[] testChildren = this.emptyTree.getNamesOfChildren(this.rootKey);
                    DeltaDataTreeTest.assertTrue((String)"1", (testChildren.length == 0 ? 1 : 0) != 0);
                    testChildren = this.tree.getNamesOfChildren(this.rootKey);
                    DeltaDataTreeTest.assertTrue((String)"2", (testChildren.length == 2 ? 1 : 0) != 0);
                    DeltaDataTreeTest.assertTrue((String)"3", (boolean)testChildren[0].equals(rootChildren[0]));
                    DeltaDataTreeTest.assertTrue((String)"4", (boolean)testChildren[1].equals(rootChildren[1]));
                    testChildren = this.tree.getNamesOfChildren(this.leftKey);
                    DeltaDataTreeTest.assertTrue((String)"5", (testChildren.length == 3 ? 1 : 0) != 0);
                    DeltaDataTreeTest.assertTrue((String)"6", (boolean)testChildren[0].equals(leftChildren[0]));
                    DeltaDataTreeTest.assertTrue((String)"7", (boolean)testChildren[2].equals(leftChildren[1]));
                    DeltaDataTreeTest.assertTrue((String)"8", (boolean)testChildren[1].equals(leftChildren[2]));
                    testChildren = this.tree.getNamesOfChildren(this.rightKey);
                    DeltaDataTreeTest.assertTrue((String)"8.1", (testChildren.length == 1 ? 1 : 0) != 0);
                    DeltaDataTreeTest.assertTrue((String)"8.2", (boolean)testChildren[0].equals(rightChildren[0]));
                    testChildren = this.tree.getNamesOfChildren(this.leftKey.append("one"));
                    DeltaDataTreeTest.assertTrue((String)"9", (testChildren.length == 0 ? 1 : 0) != 0);
                    testChildren = this.tree.getNamesOfChildren(this.rightKey.append("rightOfRight"));
                    DeltaDataTreeTest.assertTrue((String)"10", (testChildren.length == 0 ? 1 : 0) != 0);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    caught = true;
                    DeltaDataTreeTest.assertTrue((String)"11", (!caught ? 1 : 0) != 0);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DeltaDataTreeTest.assertTrue((String)"11", (!caught ? 1 : 0) != 0);
                throw throwable;
            }
            DeltaDataTreeTest.assertTrue((String)"11", (!caught ? 1 : 0) != 0);
        }
        caught = false;
        try {
            this.tree.getNamesOfChildren(this.rootKey.append("bogus"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DeltaDataTreeTest.assertTrue((String)"12", (boolean)caught);
        caught = false;
        try {
            this.emptyTree.getNamesOfChildren(this.rootKey.append("bogus"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DeltaDataTreeTest.assertTrue((String)"13", (boolean)caught);
    }

    public void testIncludes() {
        DeltaDataTreeTest.assertTrue((boolean)this.emptyTree.includes(this.rootKey));
        DeltaDataTreeTest.assertTrue((boolean)this.tree.includes(this.rootKey));
        DeltaDataTreeTest.assertTrue((boolean)this.tree.includes(this.leftKey));
        DeltaDataTreeTest.assertTrue((boolean)this.tree.includes(this.rightKey));
        DeltaDataTreeTest.assertTrue((boolean)this.tree.includes(this.leftKey.append("one")));
        DeltaDataTreeTest.assertTrue((boolean)this.tree.includes(this.rightKey.append("rightOfRight")));
        DeltaDataTreeTest.assertTrue((!this.emptyTree.includes(this.rootKey.append("bogus")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((!this.tree.includes(this.rootKey.append("bogus")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((!this.tree.includes(this.leftKey.append("bogus")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((!this.tree.includes(this.leftKey.append("one").append("bogus")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((!this.tree.includes(this.rightKey.append("bogus")) ? 1 : 0) != 0);
    }

    public void testLongDeltaChain() {
        DeltaDataTree[] deltas = new DeltaDataTree[10];
        this.tree.immutable();
        deltas[0] = this.tree.newEmptyDeltaTree();
        deltas[0].createChild(this.leftKey, "new");
        this.assertTree(deltas[0]);
        DeltaDataTreeTest.assertTrue((boolean)deltas[0].includes(this.leftKey.append("new")));
        deltas[0].immutable();
        deltas[1] = deltas[0].newEmptyDeltaTree();
        deltas[1].deleteChild(this.leftKey, "one");
        DeltaDataTreeTest.assertEquals((String)"parent 0 -> 1", (Object)deltas[1].getParent(), (Object)deltas[0]);
        DeltaDataTreeTest.assertTrue((!deltas[1].includes(this.leftKey.append("one")) ? 1 : 0) != 0);
        deltas[1].immutable();
        deltas[2] = deltas[1].newEmptyDeltaTree();
        deltas[2].createChild(this.rootKey, "newTopLevel");
        DeltaDataTreeTest.assertEquals((String)"parent 1 -> 2", (Object)deltas[2].getParent(), (Object)deltas[1]);
        DeltaDataTreeTest.assertEquals((String)"parent 0 -> 2", (Object)deltas[2].getParent().getParent(), (Object)deltas[0]);
        DeltaDataTreeTest.assertTrue((!deltas[2].includes(this.leftKey.append("one")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((boolean)deltas[2].includes(this.rootKey.append("newTopLevel")));
    }

    public void testNewEmptyDeltaTree() {
        this.tree.immutable();
        DeltaDataTree delta = this.tree.newEmptyDeltaTree();
        DeltaDataTreeTest.assertEquals((String)"parent", (Object)this.tree, (Object)delta.getParent());
        this.assertTree(delta);
    }

    public void testRegression1FVVP6L() {
        IPath elementA = Path.ROOT.append("A");
        DeltaDataTree tree1 = new DeltaDataTree();
        tree1.createChild((IPath)Path.ROOT, "A", (Object)"Data for A");
        tree1.createChild(elementA, "B", (Object)"Data for B");
        tree1.immutable();
        tree1 = tree1.newEmptyDeltaTree();
        tree1.deleteChild(elementA, "B");
        tree1.createChild(elementA, "B", (Object)"New B Data");
        tree1.immutable();
        tree1 = tree1.newEmptyDeltaTree();
        tree1.deleteChild(elementA, "B");
        try {
            tree1.copyCompleteSubtree((IPath)Path.ROOT);
        }
        catch (RuntimeException runtimeException) {
            DeltaDataTreeTest.assertTrue((String)"Unexpected error copying tree", (boolean)false);
        }
    }

    public void testRegression1FVVP6LWithChildren() {
        IPath elementA = Path.ROOT.append("A");
        IPath elementB = elementA.append("B");
        IPath elementC = elementB.append("C");
        DeltaDataTree tree1 = new DeltaDataTree();
        tree1.createChild((IPath)Path.ROOT, "A", (Object)"Data for A");
        tree1.createChild(elementA, "B", (Object)"Data for B");
        tree1.createChild(elementB, "C", (Object)"Data for C");
        tree1.immutable();
        tree1 = tree1.newEmptyDeltaTree();
        tree1.deleteChild(elementA, "B");
        tree1.createChild(elementA, "B", (Object)"New B Data");
        tree1.immutable();
        tree1 = tree1.newEmptyDeltaTree();
        DeltaDataTreeTest.assertTrue((String)"Child exists after deletion", (!tree1.includes(elementC) ? 1 : 0) != 0);
        try {
            tree1.copyCompleteSubtree((IPath)Path.ROOT);
        }
        catch (RuntimeException runtimeException) {
            DeltaDataTreeTest.assertTrue((String)"Unexpected error copying tree", (boolean)false);
        }
    }

    public void testReroot() {
        DeltaDataTree[] deltas = new DeltaDataTree[10];
        this.tree.immutable();
        deltas[0] = this.tree.newEmptyDeltaTree();
        deltas[0].createChild(this.leftKey, "new");
        this.assertTree(deltas[0]);
        DeltaDataTreeTest.assertTrue((boolean)deltas[0].includes(this.leftKey.append("new")));
        deltas[0].immutable();
        deltas[1] = deltas[0].newEmptyDeltaTree();
        deltas[1].deleteChild(this.leftKey, "one");
        DeltaDataTreeTest.assertEquals((String)"parent 0 -> 1", (Object)deltas[1].getParent(), (Object)deltas[0]);
        DeltaDataTreeTest.assertTrue((!deltas[1].includes(this.leftKey.append("one")) ? 1 : 0) != 0);
        deltas[1].immutable();
        deltas[2] = deltas[1].newEmptyDeltaTree();
        deltas[2].createChild(this.rootKey, "newTopLevel");
        DeltaDataTreeTest.assertEquals((String)"parent 1 -> 2", (Object)deltas[2].getParent(), (Object)deltas[1]);
        DeltaDataTreeTest.assertEquals((String)"parent 0 -> 2", (Object)deltas[2].getParent().getParent(), (Object)deltas[0]);
        DeltaDataTreeTest.assertTrue((!deltas[2].includes(this.leftKey.append("one")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((boolean)deltas[2].includes(this.rootKey.append("newTopLevel")));
        deltas[2].immutable();
        deltas[3] = deltas[2].newEmptyDeltaTree();
        deltas[3].immutable();
        deltas[3].reroot();
        DeltaDataTreeTest.assertTrue((deltas[3].getParent() == null ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((deltas[2].getParent() == deltas[3] ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((deltas[1].getParent() == deltas[2] ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((deltas[0].getParent() == deltas[1] ? 1 : 0) != 0);
        this.assertTree(this.tree);
        DeltaDataTreeTest.assertTrue((!this.tree.includes(this.leftKey.append("new")) ? 1 : 0) != 0);
        DeltaDataTreeTest.assertTrue((boolean)this.tree.includes(this.leftKey.append("one")));
        this.assertTree(deltas[0]);
        DeltaDataTreeTest.assertTrue((boolean)deltas[0].includes(this.leftKey.append("new")));
        DeltaDataTreeTest.assertTrue((boolean)deltas[0].includes(this.leftKey.append("one")));
        DeltaDataTreeTest.assertTrue((boolean)deltas[1].includes(this.leftKey.append("new")));
        DeltaDataTreeTest.assertTrue((!deltas[1].includes(this.leftKey.append("one")) ? 1 : 0) != 0);
        this.assertDelta(deltas[2]);
        this.assertDelta(deltas[3]);
    }

    public void testSetup() {
        this.assertTree(this.tree);
        this.assertTree(this.changedTree);
    }
}

