/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.filesystem.remote;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryFileStore;

public class RemoteFileStore
extends MemoryFileStore {
    private String userInfo;
    private String host;
    private int port;
    private IPath remotePath;

    private static String createAuthoritySegment(String userInfo, String host, int port) {
        String authority = host;
        if (userInfo != null) {
            authority = String.valueOf(userInfo) + "___" + authority;
        }
        if (port != -1) {
            authority = String.valueOf(authority) + "___" + port;
        }
        return authority;
    }

    public RemoteFileStore(String userInfo, String host, int port, IPath path) {
        super(Path.ROOT.append(RemoteFileStore.createAuthoritySegment(userInfo, host, port)).append(path));
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.remotePath = path;
    }

    public IFileStore getChild(String name) {
        return new RemoteFileStore(this.userInfo, this.host, this.port, this.remotePath.append(name));
    }

    public IFileStore getParent() {
        if (this.remotePath.segmentCount() == 0) {
            return null;
        }
        return new RemoteFileStore(this.userInfo, this.host, this.port, this.remotePath.removeLastSegments(1));
    }

    public URI toURI() {
        try {
            return new URI("remote", this.userInfo, this.host, this.port, this.remotePath.toString(), null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

