/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class RefreshLocalTest
extends LocalStoreTest
implements ICoreConstants {
    public static Test suite() {
        return new TestSuite(RefreshLocalTest.class);
    }

    public RefreshLocalTest() {
    }

    public RefreshLocalTest(String name) {
        super(name);
    }

    public void testDiscoverCaseChange() {
        IProject project = this.projects[0];
        IFolder folder = project.getFolder("A");
        IFolder folderVariant = project.getFolder("a");
        IFile file = folder.getFile("file");
        IFile fileVariant = folderVariant.getFile(file.getName());
        this.ensureExistsInWorkspace((IResource)file, true);
        project.getLocation().append("A").toFile().renameTo(project.getLocation().append("a").toFile());
        try {
            project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            RefreshLocalTest.fail((String)"1.99", (Throwable)e);
        }
        RefreshLocalTest.assertTrue((String)"1.1", (boolean)folderVariant.exists());
        RefreshLocalTest.assertTrue((String)"1.2", (boolean)fileVariant.exists());
        RefreshLocalTest.assertTrue((String)"1.3", (!folder.exists() ? 1 : 0) != 0);
        RefreshLocalTest.assertTrue((String)"1.4", (!file.exists() ? 1 : 0) != 0);
        RefreshLocalTest.assertTrue((String)"1.5", (boolean)project.isSynchronized(2));
    }

    public void testDiscoverLinkedResource() {
    }

    public void testFileDiscovery() throws Throwable {
        IProject project = this.projects[0];
        IFolder folder = project.getFolder("Folder");
        IFile file = folder.getFile("File");
        IResource[] both = new IResource[]{folder, file};
        this.ensureExistsInFileSystem(both);
        this.ensureDoesNotExistInWorkspace(both);
        RefreshLocalTest.assertTrue((String)"1.0", (!file.exists() ? 1 : 0) != 0);
        RefreshLocalTest.assertTrue((String)"1.1", (!folder.exists() ? 1 : 0) != 0);
        RefreshLocalTest.assertTrue((String)"1.2", (!file.isSynchronized(0) ? 1 : 0) != 0);
        RefreshLocalTest.assertTrue((String)"1.3", (!folder.isSynchronized(2) ? 1 : 0) != 0);
        file.refreshLocal(0, this.getMonitor());
        RefreshLocalTest.assertTrue((String)"1.4", (boolean)file.exists());
        RefreshLocalTest.assertTrue((String)"1.5", (boolean)folder.exists());
        project.delete(1, this.getMonitor());
        this.ensureExistsInFileSystem(both);
        this.ensureDoesNotExistInWorkspace(both);
        RefreshLocalTest.assertTrue((String)"2.0", (!file.exists() ? 1 : 0) != 0);
        RefreshLocalTest.assertTrue((String)"2.1", (!folder.exists() ? 1 : 0) != 0);
        file.refreshLocal(0, this.getMonitor());
        RefreshLocalTest.assertTrue((String)"2.2", (!file.exists() ? 1 : 0) != 0);
        RefreshLocalTest.assertTrue((String)"2.3", (!folder.exists() ? 1 : 0) != 0);
    }

    public void testFileToFolder() throws Throwable {
        IProject project = this.projects[0];
        IFile file = project.getFile("file");
        file.create(null, true, null);
        this.ensureDoesNotExistInFileSystem((IResource)file);
        File target = file.getLocation().toFile();
        target.mkdirs();
        RefreshLocalTest.assertTrue((String)"1.1", (boolean)file.exists());
        RefreshLocalTest.assertTrue((String)"1.2", (boolean)target.isDirectory());
        file.refreshLocal(0, null);
        RefreshLocalTest.assertTrue((String)"1.3", (!file.exists() ? 1 : 0) != 0);
        IFolder folder = project.getFolder("file");
        RefreshLocalTest.assertTrue((String)"1.4", (boolean)folder.exists());
    }

    public void testFolderToFile() throws Throwable {
        IProject project = this.projects[0];
        IFolder folder = project.getFolder("folder");
        folder.create(true, true, null);
        this.ensureDoesNotExistInFileSystem((IResource)folder);
        IFile file = project.getFile("folder");
        this.ensureExistsInFileSystem(file);
        RefreshLocalTest.assertTrue((String)"1.1", (boolean)folder.exists());
        folder.refreshLocal(0, null);
        RefreshLocalTest.assertTrue((String)"1.2", (!folder.exists() ? 1 : 0) != 0);
        RefreshLocalTest.assertTrue((String)"1.3", (boolean)file.exists());
    }

    public void testRefreshClosedProject() {
        IProject project = this.projects[0];
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            RefreshLocalTest.fail((String)"0.99", (Throwable)e);
        }
        try {
            project.refreshLocal(2, this.getMonitor());
            project.refreshLocal(0, this.getMonitor());
            project.refreshLocal(1, this.getMonitor());
        }
        catch (CoreException e) {
            RefreshLocalTest.fail((String)"1.0", (Throwable)e);
        }
    }

    public void testRefreshFolder() throws Throwable {
        IFile file;
        IProject project = this.projects[0];
        final IFile hackFile = file = project.getFile("file");
        final Workspace workspace = (Workspace)RefreshLocalTest.getWorkspace();
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                workspace.createResource((IResource)hackFile, false);
                ((Resource)hackFile).getResourceInfo(false, true).set(2);
            }
        };
        workspace.run(operation, null);
        RefreshLocalTest.assertTrue((String)"1.0", (boolean)file.exists());
        RefreshLocalTest.assertTrue((String)"1.1", (boolean)file.isLocal(0));
        project.refreshLocal(2, null);
        RefreshLocalTest.assertTrue((String)"1.2", (!file.exists() ? 1 : 0) != 0);
        this.ensureDoesNotExistInWorkspace((IResource)file);
        this.ensureDoesNotExistInFileSystem((IResource)file);
        file = project.getFile("file");
        this.ensureExistsInFileSystem(file);
        RefreshLocalTest.assertTrue((String)"2.0", (!file.exists() ? 1 : 0) != 0);
        project.refreshLocal(2, null);
        RefreshLocalTest.assertTrue((String)"2.1", (boolean)file.exists());
        this.ensureDoesNotExistInWorkspace((IResource)file);
        this.ensureDoesNotExistInFileSystem((IResource)file);
        IFolder folder = project.getFolder("folder");
        folder.create(true, true, null);
        file = folder.getFile("file");
        this.ensureExistsInFileSystem(file);
        RefreshLocalTest.assertTrue((String)"3.1", (boolean)folder.exists());
        RefreshLocalTest.assertTrue((String)"3.2", (boolean)folder.isLocal(0));
        RefreshLocalTest.assertTrue((String)"3.3", (!file.exists() ? 1 : 0) != 0);
        folder.refreshLocal(0, null);
        RefreshLocalTest.assertTrue((String)"3.4", (boolean)folder.exists());
        RefreshLocalTest.assertTrue((String)"3.5", (boolean)folder.isLocal(0));
        RefreshLocalTest.assertTrue((String)"3.6", (!file.exists() ? 1 : 0) != 0);
        folder.refreshLocal(1, null);
        RefreshLocalTest.assertTrue((String)"3.7", (boolean)folder.exists());
        RefreshLocalTest.assertTrue((String)"3.8", (boolean)folder.isLocal(0));
        RefreshLocalTest.assertTrue((String)"3.9", (boolean)file.exists());
        this.ensureDoesNotExistInWorkspace((IResource)folder);
        this.ensureDoesNotExistInFileSystem((IResource)folder);
        file = project.getFile("file");
        IFileStore fileStore = ((Resource)file).getStore();
        this.ensureExistsInWorkspace((IResource)file, true);
        RefreshLocalTest.assertTrue((String)"4.1", (boolean)file.exists());
        RefreshLocalTest.assertTrue((String)"4.2", (boolean)file.isLocal(0));
        RefreshLocalTest.assertEquals((String)"4.3", (long)fileStore.fetchInfo().getLastModified(), (long)((Resource)file).getResourceInfo(false, false).getLocalSyncInfo());
        this.ensureOutOfSync(file);
        RefreshLocalTest.assertTrue((String)"4.4", (((Resource)file).getResourceInfo(false, false).getLocalSyncInfo() != fileStore.fetchInfo().getLastModified() ? 1 : 0) != 0);
        project.refreshLocal(2, null);
        RefreshLocalTest.assertEquals((String)"4.5", (long)fileStore.fetchInfo().getLastModified(), (long)((Resource)file).getResourceInfo(false, false).getLocalSyncInfo());
        this.ensureDoesNotExistInWorkspace((IResource)file);
        this.ensureDoesNotExistInFileSystem((IResource)file);
    }

    public void testSimpleRefresh() throws Throwable {
        IProject project = this.projects[0];
        IFile file = project.getFile("file");
        this.ensureExistsInWorkspace((IResource)file, true);
        this.ensureDoesNotExistInFileSystem((IResource)file);
        RefreshLocalTest.assertTrue((String)"1.0", (boolean)file.exists());
        file.refreshLocal(2, null);
        RefreshLocalTest.assertTrue((String)"1.1", (!file.exists() ? 1 : 0) != 0);
        IFolder folder = project.getFolder("folder");
        IFileStore target = ((Resource)folder).getStore();
        this.createTree(this.getTree(target));
        RefreshLocalTest.assertTrue((String)"2.0", (!folder.exists() ? 1 : 0) != 0);
        folder.refreshLocal(2, null);
        RefreshLocalTest.assertTrue((String)"2.1", (boolean)folder.exists());
        RefreshLocalTest.assertTrue((String)"2.2", (((Resource)folder).countResources(2, false) == this.getTree(target).length + 1 ? 1 : 0) != 0);
    }
}

