/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.mapping;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ModelStatus;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.mapping.ChangeDescription;
import org.eclipse.core.tests.internal.mapping.TestModelProvider;
import org.eclipse.core.tests.resources.ResourceTest;

public class ChangeValidationTest
extends ResourceTest {
    private IResourceChangeDescriptionFactory factory;
    private IProject project;

    public static Test suite() {
        return new TestSuite(ChangeValidationTest.class);
    }

    private void assertStatusEqual(IStatus status, String[] expectedMessages) {
        ArrayList<String> actualMessages = new ArrayList<String>();
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                String message = this.getModelMessage(children[i]);
                if (message != null) {
                    actualMessages.add(message);
                }
                ++i;
            }
        } else {
            String message = this.getModelMessage(status);
            if (message != null) {
                actualMessages.add(message);
            }
        }
        if (expectedMessages.length < actualMessages.size()) {
            for (String actual : actualMessages) {
                boolean found = false;
                int i = 0;
                while (i < expectedMessages.length) {
                    String expected = expectedMessages[i];
                    if (actual.equals(expected)) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (found) continue;
                ChangeValidationTest.fail((String)("Unexpected message returned: " + actual));
            }
        } else {
            int i = 0;
            while (i < expectedMessages.length) {
                String string = expectedMessages[i];
                if (!actualMessages.contains(string)) {
                    ChangeValidationTest.fail((String)("Expect message missing: " + string));
                }
                ++i;
            }
        }
    }

    private IResourceChangeDescriptionFactory createEmptyChangeDescription() {
        return ResourceChangeValidator.getValidator().createDeltaFactory();
    }

    private String getModelMessage(IStatus status) {
        ModelStatus ms;
        String id;
        if (status instanceof ModelStatus && (id = (ms = (ModelStatus)status).getModelProviderId()).equals("org.eclipse.core.tests.resources.modelProvider")) {
            return status.getMessage();
        }
        return null;
    }

    protected void setUp() throws Exception {
        TestModelProvider.enabled = true;
        super.setUp();
        this.project = ChangeValidationTest.getWorkspace().getRoot().getProject("Project");
        IResource[] before = this.buildResources((IContainer)this.project, new String[]{"c/", "c/b/", "c/a/", "c/x", "c/b/y", "c/b/z"});
        this.ensureExistsInWorkspace(before, true);
        this.assertExistsInWorkspace(before);
        this.factory = this.createEmptyChangeDescription();
    }

    protected void tearDown() throws Exception {
        TestModelProvider.enabled = false;
        super.tearDown();
    }

    public void testCopyReplaceDeletedFolder() {
        IResource folder = this.project.findMember("c/b/");
        IFolder destination = this.project.getFolder("/c/a/");
        this.factory.delete((IResource)destination);
        this.factory.copy(folder, destination.getFullPath());
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Copied {0}", folder)});
    }

    public void testFileChanges() {
        this.factory.change((IFile)this.project.findMember("c/x"));
        this.factory.change((IFile)this.project.findMember("c/b/y"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Changed {0}", this.project.findMember("c/x")), ChangeDescription.getMessageFor("Changed {0}", this.project.findMember("c/b/y"))});
    }

    public void testFileCopy() {
        this.factory.copy(this.project.findMember("c/x"), (IPath)new Path("c/x2"));
        this.factory.copy(this.project.findMember("c/b/y"), (IPath)new Path("c/y"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Copied {0}", this.project.findMember("c/x")), ChangeDescription.getMessageFor("Copied {0}", this.project.findMember("c/b/y"))});
    }

    public void testFileCreate() {
        IFile file = this.project.getFile("file");
        this.factory.create((IResource)file);
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Added {0}", (IResource)file)});
    }

    public void testFileInFolderCreate() {
        IFolder folder = this.project.getFolder("folder");
        IFile file = folder.getFile("file");
        this.factory.create((IResource)folder);
        this.factory.create((IResource)file);
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Added {0}", (IResource)folder)});
    }

    public void testFileDeletion() {
        this.factory.delete(this.project.findMember("c/x"));
        this.factory.delete(this.project.findMember("c/b/y"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Removed {0}", this.project.findMember("c/x")), ChangeDescription.getMessageFor("Removed {0}", this.project.findMember("c/b/y"))});
    }

    public void testFileMoves() {
        this.factory.move(this.project.findMember("c/x"), (IPath)new Path("c/x2"));
        this.factory.move(this.project.findMember("c/b/y"), (IPath)new Path("c/y"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Moved {0}", this.project.findMember("c/x")), ChangeDescription.getMessageFor("Moved {0}", this.project.findMember("c/b/y"))});
    }

    public void testFolderCopy() {
        IResource folder = this.project.findMember("c/b/");
        this.factory.copy(folder, (IPath)new Path("c/d"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Copied {0}", folder)});
    }

    public void testFolderDeletion() {
        IResource folder = this.project.findMember("c/b/");
        this.factory.delete(folder);
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Removed {0}", this.project.findMember("c/b"))});
    }

    public void testFolderMove() {
        IResource folder = this.project.findMember("c/b/");
        this.factory.move(folder, (IPath)new Path("c/d"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Moved {0}", folder)});
    }

    public void testMoveReplaceDeletedFolder() {
        IResource folder = this.project.findMember("c/b/");
        IFolder destination = this.project.getFolder("/c/a/");
        this.factory.delete((IResource)destination);
        this.factory.move(folder, destination.getFullPath());
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Moved {0}", folder)});
    }

    public void testProjectClose() {
        this.factory.close(this.project);
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Closed {0}", (IResource)this.project)});
    }

    public void testProjectCopy() {
        this.factory.copy((IResource)this.project, (IPath)new Path("MovedProject"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Copied {0}", (IResource)this.project)});
    }

    public void testProjectDeletion() {
        this.factory.delete((IResource)this.project);
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Removed {0}", (IResource)this.project)});
    }

    public void testProjectMove() {
        this.factory.move((IResource)this.project, (IPath)new Path("MovedProject"));
        IStatus status = this.validateChange(this.factory);
        this.assertStatusEqual(status, new String[]{ChangeDescription.getMessageFor("Moved {0}", (IResource)this.project)});
    }

    private IStatus validateChange(IResourceChangeDescriptionFactory factory) {
        return ResourceChangeValidator.getValidator().validateChange(factory.getDelta(), this.getMonitor());
    }
}

