/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.BuildConfiguration;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public class ProjectBuildConfigsTest
extends ResourceTest {
    private IProject project;
    private String variantId0 = "Variant0";
    private String variantId1 = "Variant1";
    private String variantId2 = "Variant2";
    private IBuildConfiguration variant0;
    private IBuildConfiguration variant1;
    private IBuildConfiguration variant2;
    private IBuildConfiguration defaultVariant;

    public static Test suite() {
        return new TestSuite(ProjectBuildConfigsTest.class);
    }

    public ProjectBuildConfigsTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.project = ProjectBuildConfigsTest.getWorkspace().getRoot().getProject("ProjectBuildConfigsTest_Project");
        this.ensureExistsInWorkspace((IResource[])new IProject[]{this.project}, true);
        this.variant0 = new BuildConfiguration(this.project, this.variantId0);
        this.variant1 = new BuildConfiguration(this.project, this.variantId1);
        this.variant2 = new BuildConfiguration(this.project, this.variantId2);
        this.defaultVariant = new BuildConfiguration(this.project, "");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.project.delete(true, null);
    }

    public void testBasics() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        String[] configs = new String[]{this.variantId0, this.variantId1};
        desc.setBuildConfigs(configs);
        this.project.setDescription(desc, this.getMonitor());
        this.assertEquals("1.0", new IBuildConfiguration[]{this.variant0, this.variant1}, this.project.getBuildConfigs());
        ProjectBuildConfigsTest.assertEquals((String)"1.1", (Object)this.variant0, (Object)this.project.getBuildConfig(this.variantId0));
        ProjectBuildConfigsTest.assertEquals((String)"1.2", (Object)this.variant1, (Object)this.project.getBuildConfig(this.variantId1));
        ProjectBuildConfigsTest.assertTrue((String)"2.0", (boolean)this.project.hasBuildConfig(this.variant0.getName()));
        ProjectBuildConfigsTest.assertTrue((String)"2.1", (boolean)this.project.hasBuildConfig(this.variant1.getName()));
        ProjectBuildConfigsTest.assertFalse((String)"2.2", (boolean)this.project.hasBuildConfig(this.variant2.getName()));
        ProjectBuildConfigsTest.assertEquals((String)"3.0", (Object)this.variant0, (Object)this.project.getActiveBuildConfig());
        desc = this.project.getDescription();
        desc.setActiveBuildConfig(this.variantId1);
        this.project.setDescription(desc, this.getMonitor());
        ProjectBuildConfigsTest.assertEquals((String)"3.1", (Object)this.variant1, (Object)this.project.getActiveBuildConfig());
        desc.setActiveBuildConfig(this.variantId2);
        ProjectBuildConfigsTest.assertEquals((String)"3.2", (Object)this.variant1, (Object)this.project.getActiveBuildConfig());
        IBuildConfiguration variant = this.project.getBuildConfigs()[0];
        ProjectBuildConfigsTest.assertEquals((String)"4.0", (Object)this.project, (Object)variant.getProject());
        ProjectBuildConfigsTest.assertEquals((String)"4.1", (String)this.variantId0, (String)variant.getName());
    }

    public void testDuplicates() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        desc.setBuildConfigs(new String[]{this.variantId0, this.variantId1, this.variantId0});
        this.project.setDescription(desc, this.getMonitor());
        this.assertEquals("1.0", new IBuildConfiguration[]{this.variant0, this.variant1}, this.project.getBuildConfigs());
    }

    public void testDefaultVariant() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        desc.setBuildConfigs(new String[0]);
        this.project.setDescription(desc, this.getMonitor());
        this.assertEquals("1.0", new IBuildConfiguration[]{this.defaultVariant}, this.project.getBuildConfigs());
        ProjectBuildConfigsTest.assertTrue((String)"1.1", (boolean)this.project.hasBuildConfig(this.defaultVariant.getName()));
        ProjectBuildConfigsTest.assertEquals((String)"2.0", (Object)this.defaultVariant, (Object)this.project.getActiveBuildConfig());
        desc = this.project.getDescription();
        desc.setActiveBuildConfig("");
        this.project.setDescription(desc, this.getMonitor());
        ProjectBuildConfigsTest.assertEquals((String)"2.1", (Object)this.defaultVariant, (Object)this.project.getActiveBuildConfig());
    }

    public void testRemoveActiveVariant() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        desc.setBuildConfigs(new String[0]);
        desc.setBuildConfigs(new String[]{this.variant0.getName(), this.variant1.getName()});
        this.project.setDescription(desc, this.getMonitor());
        ProjectBuildConfigsTest.assertEquals((String)"1.0", (Object)this.variant0, (Object)this.project.getActiveBuildConfig());
        desc.setBuildConfigs(new String[]{this.variant0.getName(), this.variant2.getName()});
        this.project.setDescription(desc, this.getMonitor());
        ProjectBuildConfigsTest.assertEquals((String)"2.0", (Object)this.variant0, (Object)this.project.getActiveBuildConfig());
        desc = this.project.getDescription();
        desc.setActiveBuildConfig(this.variantId2);
        this.project.setDescription(desc, this.getMonitor());
        desc.setBuildConfigs(new String[]{this.variant0.getName(), this.variant1.getName()});
        this.project.setDescription(desc, this.getMonitor());
        ProjectBuildConfigsTest.assertEquals((String)"3.0", (Object)this.variant0, (Object)this.project.getActiveBuildConfig());
    }

    public void testProjectMove() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        IBuildConfiguration[] configs = new IBuildConfiguration[]{this.variant0, this.variant1};
        desc.setBuildConfigs(new String[]{configs[0].getName(), configs[1].getName()});
        this.project.setDescription(desc, this.getMonitor());
        String newProjectName = "projectMoved";
        desc = this.project.getDescription();
        desc.setName(newProjectName);
        this.project.move(desc, false, this.getMonitor());
        IProject newProject = ProjectBuildConfigsTest.getWorkspace().getRoot().getProject(newProjectName);
        ProjectBuildConfigsTest.assertTrue((String)"1.0", (boolean)newProject.exists());
        IBuildConfiguration[] newConfigs = newProject.getBuildConfigs();
        int i = 0;
        while (i < configs.length) {
            ProjectBuildConfigsTest.assertEquals((String)("2." + i * 3), (Object)newProject, (Object)newConfigs[i].getProject());
            ProjectBuildConfigsTest.assertEquals((String)("2." + i * 3 + 1), (String)configs[i].getName(), (String)newConfigs[i].getName());
            ++i;
        }
    }
}

