/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTest;

public class ResourceInfoTest
extends ResourceTest {
    public ResourceInfoTest() {
    }

    public ResourceInfoTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ResourceInfoTest.class);
    }

    public static void assertEquals(String message, byte[] expected, byte[] actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            ResourceInfoTest.assertTrue((String)message, (boolean)false);
        }
        ResourceInfoTest.assertEquals((String)message, (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < expected.length) {
            ResourceInfoTest.assertEquals((String)message, (byte)expected[i], (byte)actual[i]);
            ++i;
        }
    }

    public static void assertEquals(String message, Hashtable expected, Hashtable actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            ResourceInfoTest.assertTrue((String)message, (boolean)false);
        }
        ResourceInfoTest.assertEquals((String)message, (int)expected.size(), (int)actual.size());
        Enumeration e = expected.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            ResourceInfoTest.assertTrue((String)message, (boolean)actual.containsKey(key));
            Object expectedValue = expected.get(key);
            Object actualValue = actual.get(key);
            if (expectedValue instanceof byte[] && actualValue instanceof byte[]) {
                ResourceInfoTest.assertEquals(message, (byte[])expectedValue, (byte[])actualValue);
                continue;
            }
            ResourceInfoTest.assertEquals((String)message, expectedValue, actualValue);
        }
    }

    public static void assertEquals(String message, ResourceInfo expected, ResourceInfo actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            ResourceInfoTest.assertTrue((String)message, (boolean)false);
        }
        boolean different = false;
        different &= expected.getFlags() == actual.getFlags();
        different &= expected.getContentId() == actual.getContentId();
        different &= expected.getModificationStamp() == actual.getModificationStamp();
        different &= expected.getNodeId() == actual.getNodeId();
        different &= expected.getLocalSyncInfo() == actual.getLocalSyncInfo();
        if (different &= expected.getMarkerGenerationCount() == actual.getMarkerGenerationCount()) {
            ResourceInfoTest.assertTrue((String)message, (boolean)false);
        }
    }

    public void testSerialization() {
        ByteArrayInputStream input = null;
        ByteArrayOutputStream output = null;
        ResourceInfo info = new ResourceInfo();
        ResourceInfo newInfo = new ResourceInfo();
        try {
            output = new ByteArrayOutputStream();
            info.writeTo((DataOutput)new DataOutputStream(output));
        }
        catch (IOException e) {
            ResourceInfoTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            input = new ByteArrayInputStream(output.toByteArray());
            newInfo.readFrom(0, (DataInput)new DataInputStream(input));
        }
        catch (IOException e) {
            ResourceInfoTest.fail((String)"1.1", (Throwable)e);
        }
        ResourceInfoTest.assertEquals("1.2", info, newInfo);
        info = new ResourceInfo();
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests", "myTest1");
        byte[] bytes = new byte[]{};
        info.setSyncInfo(qname, bytes);
        qname = new QualifiedName("org.eclipse.core.tests", "myTest2");
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        bytes = byArray;
        info.setSyncInfo(qname, bytes);
        try {
            output = new ByteArrayOutputStream();
            info.writeTo((DataOutput)new DataOutputStream(output));
        }
        catch (IOException e) {
            ResourceInfoTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            newInfo = new ResourceInfo();
            input = new ByteArrayInputStream(output.toByteArray());
            newInfo.readFrom(0, (DataInput)new DataInputStream(input));
        }
        catch (IOException e) {
            ResourceInfoTest.fail((String)"2.1", (Throwable)e);
        }
        ResourceInfoTest.assertEquals("2.2", info, newInfo);
    }
}

