/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import junit.framework.ComparisonFailure;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.LocalMetaArea;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.resources.WorkspacePreferences;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.tests.resources.ResourceTest;

public class WorkspacePreferencesTest
extends ResourceTest {
    private IWorkspace workspace;
    private Preferences preferences;

    public WorkspacePreferencesTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.workspace = ResourcesPlugin.getWorkspace();
        this.preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        this.workspace.setDescription((IWorkspaceDescription)Workspace.defaultWorkspaceDescription());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.workspace.setDescription((IWorkspaceDescription)Workspace.defaultWorkspaceDescription());
    }

    public void testDefaults() {
        WorkspaceDescription description = Workspace.defaultWorkspaceDescription();
        this.assertEquals("1.0", (IWorkspaceDescription)description, this.preferences);
        String[] descriptionProperties = new String[]{"description.autobuilding", "description.defaultbuildorder", "description.filestatelongevity", "description.maxbuilditerations", "description.maxfilestatesize", "description.maxfilestates", "description.snapshotinterval"};
        List<String> defaultPropertiesList = Arrays.asList(this.preferences.defaultPropertyNames());
        int i = 0;
        while (i < descriptionProperties.length) {
            String property = descriptionProperties[i];
            WorkspacePreferencesTest.assertTrue((String)("2.0 - Description property is not default: " + property), (boolean)defaultPropertiesList.contains(property));
            ++i;
        }
    }

    public void testSetPreferences() {
        this.preferences.setValue("description.autobuilding", true);
        WorkspacePreferencesTest.assertTrue((String)"1.0", (boolean)this.workspace.getDescription().isAutoBuilding());
        this.preferences.setValue("description.autobuilding", false);
        WorkspacePreferencesTest.assertTrue((String)"1.1", (!this.workspace.getDescription().isAutoBuilding() ? 1 : 0) != 0);
        this.preferences.setValue("description.defaultbuildorder", true);
        WorkspacePreferencesTest.assertTrue((String)"2.0", (this.workspace.getDescription().getBuildOrder() == null ? 1 : 0) != 0);
        this.preferences.setValue("description.defaultbuildorder", false);
        WorkspacePreferencesTest.assertTrue((String)"2.1", (this.workspace.getDescription().getBuildOrder() != null ? 1 : 0) != 0);
        this.preferences.setValue("description.buildorder", "x/y,:z/z");
        List<String> expectedList = Arrays.asList("x", "y,:z", "z");
        List<String> actualList = Arrays.asList(this.workspace.getDescription().getBuildOrder());
        WorkspacePreferencesTest.assertEquals((String)"2.2", expectedList, actualList);
        this.preferences.setValue("description.buildorder", "");
        WorkspacePreferencesTest.assertTrue((String)"2.3", (this.workspace.getDescription().getBuildOrder().length == 0 ? 1 : 0) != 0);
        long snapshotInterval = 800000000L;
        this.preferences.setValue("description.snapshotinterval", snapshotInterval);
        WorkspacePreferencesTest.assertEquals((String)"3.0", (long)snapshotInterval, (long)this.workspace.getDescription().getSnapshotInterval());
        long defaultSnapshotInterval = this.preferences.getDefaultLong("description.snapshotinterval");
        this.preferences.setValue("description.snapshotinterval", defaultSnapshotInterval);
        WorkspacePreferencesTest.assertEquals((String)"3.1", (long)defaultSnapshotInterval, (long)this.workspace.getDescription().getSnapshotInterval());
        this.preferences.setToDefault("description.snapshotinterval");
        WorkspacePreferencesTest.assertEquals((String)"3.2", (long)defaultSnapshotInterval, (long)this.workspace.getDescription().getSnapshotInterval());
        this.assertEquals("Description not synchronized", this.workspace.getDescription(), this.preferences);
    }

    public void testEvents() {
        IWorkspaceDescription original = this.workspace.getDescription();
        IWorkspaceDescription modified = this.workspace.getDescription();
        modified.setAutoBuilding(!original.isAutoBuilding());
        modified.setBuildOrder(new String[]{"a", "b", "c"});
        modified.setApplyFileStatePolicy(!original.isApplyFileStatePolicy());
        modified.setFileStateLongevity((original.getFileStateLongevity() + 1L) * 2L);
        modified.setMaxBuildIterations((original.getMaxBuildIterations() + 1) * 2);
        modified.setMaxFileStates((original.getMaxFileStates() + 1) * 2);
        modified.setMaxFileStateSize((original.getMaxFileStateSize() + 1L) * 2L);
        modified.setSnapshotInterval((original.getSnapshotInterval() + 1L) * 2L);
        final LinkedList changedProperties = new LinkedList();
        Preferences.IPropertyChangeListener listener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                changedProperties.add(event.getProperty());
            }
        };
        try {
            this.preferences.addPropertyChangeListener(listener);
            try {
                this.workspace.setDescription(original);
            }
            catch (CoreException e) {
                WorkspacePreferencesTest.fail((String)"1.0", (Throwable)e);
            }
            WorkspacePreferencesTest.assertEquals((String)"1.1 - wrong number of properties changed ", (int)0, (int)changedProperties.size());
            try {
                this.workspace.setDescription(modified);
            }
            catch (CoreException e) {
                WorkspacePreferencesTest.fail((String)"2.0", (Throwable)e);
            }
            WorkspacePreferencesTest.assertEquals((String)"2.1 - wrong number of properties changed ", (int)9, (int)changedProperties.size());
        }
        finally {
            this.preferences.removePropertyChangeListener(listener);
        }
    }

    public void testImportExport() {
        IPath originalPreferencesFile = this.getRandomLocation().append("original.epf");
        IPath modifiedPreferencesFile = this.getRandomLocation().append("modified.epf");
        try {
            IWorkspaceDescription original = this.workspace.getDescription();
            this.preferences.setValue("foo.bar", this.getRandomString());
            try {
                Preferences.exportPreferences((IPath)originalPreferencesFile);
            }
            catch (CoreException e) {
                WorkspacePreferencesTest.fail((String)"1.0", (Throwable)e);
            }
            IWorkspaceDescription modified = this.workspace.getDescription();
            modified.setAutoBuilding(!original.isAutoBuilding());
            modified.setBuildOrder(new String[]{"a", "b", "c"});
            modified.setApplyFileStatePolicy(!original.isApplyFileStatePolicy());
            modified.setFileStateLongevity((original.getFileStateLongevity() + 1L) * 2L);
            modified.setMaxBuildIterations((original.getMaxBuildIterations() + 1) * 2);
            modified.setMaxFileStates((original.getMaxFileStates() + 1) * 2);
            modified.setMaxFileStateSize((original.getMaxFileStateSize() + 1L) * 2L);
            modified.setSnapshotInterval((original.getSnapshotInterval() + 1L) * 2L);
            try {
                this.workspace.setDescription(modified);
            }
            catch (CoreException ce) {
                WorkspacePreferencesTest.fail((String)"2.0", (Throwable)ce);
            }
            this.assertEquals("2.1", modified, this.workspace.getDescription());
            try {
                Preferences.exportPreferences((IPath)modifiedPreferencesFile);
            }
            catch (CoreException e) {
                WorkspacePreferencesTest.fail((String)"3.0", (Throwable)e);
            }
            try {
                Preferences.importPreferences((IPath)originalPreferencesFile);
            }
            catch (CoreException e) {
                WorkspacePreferencesTest.fail((String)"4.0", (Throwable)e);
            }
            this.assertEquals("4.1", original, this.workspace.getDescription());
            try {
                Preferences.importPreferences((IPath)modifiedPreferencesFile);
            }
            catch (CoreException e) {
                WorkspacePreferencesTest.fail((String)"5.0", (Throwable)e);
            }
            this.assertEquals("5.1", modified, this.workspace.getDescription());
        }
        finally {
            this.ensureDoesNotExistInFileSystem(originalPreferencesFile.removeLastSegments(1).toFile());
            this.ensureDoesNotExistInFileSystem(modifiedPreferencesFile.removeLastSegments(1).toFile());
        }
    }

    public void testSetDescription() {
        IWorkspaceDescription description = this.workspace.getDescription();
        description.setAutoBuilding(false);
        description.setBuildOrder(new String[]{"a", "b,c", "c"});
        description.setFileStateLongevity(300000L);
        description.setMaxBuildIterations(35);
        description.setMaxFileStates(16);
        description.setMaxFileStateSize(100050L);
        description.setSnapshotInterval(1234567L);
        try {
            this.workspace.setDescription(description);
        }
        catch (CoreException ce) {
            WorkspacePreferencesTest.fail((String)"2.0", (Throwable)ce);
        }
        this.assertEquals("2.1 - Preferences not synchronized", description, this.preferences);
        description.setFileStateLongevity(90000L);
        try {
            this.workspace.setDescription(description);
        }
        catch (CoreException ce) {
            WorkspacePreferencesTest.fail((String)"3.0", (Throwable)ce);
        }
        description.setFileStateLongevity(100000L);
        WorkspacePreferencesTest.assertEquals((String)"3.1", (long)90000L, (long)this.workspace.getDescription().getFileStateLongevity());
        WorkspacePreferencesTest.assertEquals((String)"3.2", (long)90000L, (long)this.preferences.getLong("description.filestatelongevity"));
    }

    public void testMigration() {
        WorkspaceDescription description = new WorkspaceDescription("Legacy workspace");
        description.setAutoBuilding(false);
        String[] buildOrder = new String[]{"g", "r", "e", "p"};
        description.setBuildOrder(buildOrder);
        description.setFileStateLongevity(Math.abs((long)(Math.random() * 100000.0)));
        description.setMaxFileStates(Math.abs((int)(Math.random() * 100000.0)));
        description.setMaxFileStateSize(Math.abs((long)(Math.random() * 100000.0)));
        description.setSnapshotInterval(Math.abs((long)(Math.random() * 100000.0)));
        LocalMetaArea localMetaArea = ((Workspace)this.workspace).getMetaArea();
        try {
            localMetaArea.write(description);
        }
        catch (CoreException ce) {
            WorkspacePreferencesTest.fail((String)"1.0", (Throwable)ce);
        }
        WorkspacePreferencesTest.assertTrue((String)"2.0 - file .description does not exist", (boolean)localMetaArea.getOldWorkspaceDescriptionLocation().toFile().isFile());
        WorkspaceDescription descriptionFromDisk = localMetaArea.readOldWorkspace();
        WorkspacePreferencesTest.assertTrue((String)"2.1 - file .description still exists", (!localMetaArea.getOldWorkspaceDescriptionLocation().toFile().isFile() ? 1 : 0) != 0);
        this.assertEquals("3.0", (IWorkspaceDescription)description, (IWorkspaceDescription)descriptionFromDisk);
    }

    public void assertEquals(String message, IWorkspaceDescription description, Preferences preferences) throws ComparisonFailure {
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 1"), (boolean)description.isAutoBuilding(), (boolean)preferences.getBoolean("description.autobuilding"));
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 2"), (description.getBuildOrder() == null ? 1 : 0) != 0, (boolean)preferences.getBoolean("description.defaultbuildorder"));
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 3"), (String)WorkspacePreferences.convertStringArraytoString((String[])description.getBuildOrder()), (String)preferences.getString("description.buildorder"));
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 4"), (boolean)description.isApplyFileStatePolicy(), (boolean)preferences.getBoolean("description.applyfilestatepolicy"));
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 5"), (long)description.getFileStateLongevity(), (long)preferences.getLong("description.filestatelongevity"));
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 6"), (int)description.getMaxFileStates(), (int)preferences.getInt("description.maxfilestates"));
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 7"), (long)description.getMaxFileStateSize(), (long)preferences.getLong("description.maxfilestatesize"));
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 8"), (long)description.getSnapshotInterval(), (long)preferences.getLong("description.snapshotinterval"));
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 9"), (long)description.getMaxBuildIterations(), (long)preferences.getLong("description.maxbuilditerations"));
    }

    public void assertEquals(String message, IWorkspaceDescription description1, IWorkspaceDescription description2) throws ComparisonFailure {
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 1"), (boolean)description1.isAutoBuilding(), (boolean)description2.isAutoBuilding());
        this.assertEquals(String.valueOf(message) + " - 2", description1.getBuildOrder(), description2.getBuildOrder());
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 3"), (String)WorkspacePreferences.convertStringArraytoString((String[])description1.getBuildOrder()), (String)WorkspacePreferences.convertStringArraytoString((String[])description2.getBuildOrder()));
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 4"), (boolean)description1.isApplyFileStatePolicy(), (boolean)description2.isApplyFileStatePolicy());
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 5"), (long)description1.getFileStateLongevity(), (long)description2.getFileStateLongevity());
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 6"), (int)description1.getMaxFileStates(), (int)description2.getMaxFileStates());
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 7"), (long)description1.getMaxFileStateSize(), (long)description2.getMaxFileStateSize());
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 8"), (long)description1.getSnapshotInterval(), (long)description2.getSnapshotInterval());
        WorkspacePreferencesTest.assertEquals((String)(String.valueOf(message) + " - 9"), (int)description1.getMaxBuildIterations(), (int)description2.getMaxBuildIterations());
    }

    public static Test suite() {
        return new TestSuite(WorkspacePreferencesTest.class);
    }
}

