/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.utils;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.utils.Queue;

public class QueueTest
extends TestCase {
    public QueueTest() {
        super(null);
    }

    public QueueTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(QueueTest.class);
    }

    public void testElements() {
        Queue queue = new Queue(5, false);
        int i = 0;
        while (i < 10) {
            queue.add((Object)String.valueOf(i));
            ++i;
        }
        Iterator elements = queue.iterator();
        int i2 = 0;
        while (i2 < 10) {
            QueueTest.assertTrue((String)"1.0", (boolean)((String)elements.next()).equals(String.valueOf(i2)));
            ++i2;
        }
        queue = new Queue(5, false);
        i2 = 0;
        while (i2 < 5) {
            queue.add((Object)String.valueOf(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < 4) {
            queue.remove();
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            queue.add((Object)String.valueOf(i2));
            ++i2;
        }
        elements = queue.iterator();
        i2 = 4;
        while (i2 < 5) {
            QueueTest.assertTrue((String)"2.0", (boolean)((String)elements.next()).equals(String.valueOf(i2)));
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            QueueTest.assertTrue((String)"2.1", (boolean)((String)elements.next()).equals(String.valueOf(i2)));
            ++i2;
        }
    }

    public void testGrow() {
        Queue queue = new Queue(5, false);
        int i = 0;
        while (i < 10) {
            queue.add((Object)String.valueOf(i));
            ++i;
        }
        QueueTest.assertTrue((String)"1.0", (queue.size() == 10 ? 1 : 0) != 0);
        queue = new Queue(5, false);
        i = 0;
        while (i < 5) {
            queue.add((Object)String.valueOf(i));
            ++i;
        }
        i = 0;
        while (i < 4) {
            queue.remove();
            ++i;
        }
        i = 0;
        while (i < 10) {
            queue.add((Object)String.valueOf(i));
            ++i;
        }
        QueueTest.assertTrue((String)"2.0", (queue.size() == 11 ? 1 : 0) != 0);
    }

    public void testRemoveTail() {
        Queue queue = new Queue(10, false);
        int i = 0;
        while (i < 8) {
            queue.add((Object)String.valueOf(i));
            ++i;
        }
        QueueTest.assertTrue((String)"1.0", (boolean)((String)queue.peekTail()).equals("7"));
        QueueTest.assertTrue((String)"1.1", (boolean)((String)queue.removeTail()).equals("7"));
        QueueTest.assertTrue((String)"1.2", (boolean)((String)queue.peekTail()).equals("6"));
        queue = new Queue(5, false);
        i = 0;
        while (i < 5) {
            queue.add((Object)String.valueOf(i));
            ++i;
        }
        i = 0;
        while (i < 4) {
            queue.remove();
            ++i;
        }
        i = 0;
        while (i < 10) {
            queue.add((Object)String.valueOf(i));
            ++i;
        }
        QueueTest.assertTrue((String)"2.0", (boolean)((String)queue.peekTail()).equals("9"));
        QueueTest.assertTrue((String)"2.1", (boolean)((String)queue.removeTail()).equals("9"));
        QueueTest.assertTrue((String)"2.2", (boolean)((String)queue.peekTail()).equals("8"));
    }

    public void testReusableElements() {
        class ReusableObject {
            ReusableObject() {
            }
        }
        ReusableObject o;
        Queue queue = new Queue(10, true);
        int i = 0;
        while (i < 9) {
            o = new ReusableObject();
            queue.add((Object)o);
            ++i;
        }
        i = 0;
        while (i < 9) {
            queue.remove();
            ++i;
        }
        queue.add((Object)new ReusableObject());
        i = 0;
        while (i < 9) {
            o = (ReusableObject)queue.getNextAvailableObject();
            QueueTest.assertTrue((String)"1.0", (o != null ? 1 : 0) != 0);
            queue.add((Object)o);
            ++i;
        }
    }
}

