/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.watson.DefaultElementComparator;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeReader;
import org.eclipse.core.internal.watson.ElementTreeWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.watson.ElementTreeSerializationTest;
import org.eclipse.core.tests.internal.watson.TestUtil;

public class DeltaFlatteningTest
extends ElementTreeSerializationTest {
    protected ElementTree fNewTree;
    protected IPath project3;
    protected IPath folder5;
    protected IPath file4;
    protected IPath file5;

    public DeltaFlatteningTest() {
        super(null);
    }

    public DeltaFlatteningTest(String name) {
        super(name);
    }

    public Object doRead(ElementTreeReader reader, DataInputStream input) throws IOException {
        return reader.readDelta(this.fNewTree, (DataInput)input);
    }

    public void doTest(IPath path, int depth) {
        this.fTree = TestUtil.createTestElementTree();
        this.fSubtreePath = path;
        this.fDepth = depth;
        ElementTree newTree = (ElementTree)this.doPipeTest();
        TestUtil.assertEqualTrees(String.valueOf(this.getClass().toString()) + "test0", this.fTree, newTree, this.fSubtreePath, this.fDepth);
    }

    public void doWrite(ElementTreeWriter writer, DataOutputStream output) throws IOException {
        writer.writeDelta(this.fTree, this.fNewTree, this.fSubtreePath, this.fDepth, (DataOutput)output, DefaultElementComparator.getComparator());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fTree = TestUtil.createTestElementTree();
        this.fNewTree = this.fTree.newEmptyDelta();
        this.project3 = solution.append("project3");
        this.folder5 = this.project3.append("folder5");
        this.file4 = project2.append("file4");
        this.file5 = folder1.append("file5");
        this.fNewTree.createElement(this.project3, (Object)"project3");
        this.fNewTree.createElement(this.folder5, (Object)"folder5");
        this.fNewTree.deleteElement(file1);
        this.fNewTree.createElement(folder2, (Object)"ChangedData");
        this.fNewTree.createElement(this.file4, (Object)"file4");
        this.fNewTree.createElement(this.file5, (Object)"file5");
        this.fNewTree.deleteElement(folder3);
        this.fNewTree.immutable();
        TestUtil.assertHasPaths(this.fNewTree, new IPath[]{solution, project1, project2, this.project3, file2, this.file4, this.file5, folder1, folder2, folder4, this.folder5});
        TestUtil.assertNoPaths(this.fNewTree, new IPath[]{file1, file3, folder3});
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(DeltaFlatteningTest.class);
        return suite;
    }

    public void test0() {
        this.doExhaustiveTests();
    }
}

