/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.watson;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.watson.IPathConstants;
import org.eclipse.core.tests.internal.watson.TestUtil;
import org.eclipse.core.tests.internal.watson.WatsonTest;

public class ElementTreeDeltaChainTest
extends WatsonTest
implements IPathConstants {
    protected ElementTree fTree;
    protected IPath project3;

    public ElementTreeDeltaChainTest() {
        super(null);
    }

    public ElementTreeDeltaChainTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.fTree = TestUtil.createTestElementTree();
        this.project3 = solution.append("project3");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ElementTreeDeltaChainTest.class);
        return suite;
    }

    protected void tearDown() throws Exception {
    }

    public void testIllegalMerges() {
        Object[] trees;
        RuntimeException ex;
        boolean caught;
        block22: {
            block20: {
                block18: {
                    this.fTree = this.fTree.newEmptyDelta();
                    caught = false;
                    ex = null;
                    try {
                        try {
                            this.fTree.mergeDeltaChain(solution, null);
                        }
                        catch (RuntimeException e) {
                            caught = true;
                            ex = e;
                            ElementTreeDeltaChainTest.assertTrue((String)"", (boolean)caught);
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        ElementTreeDeltaChainTest.assertTrue((String)"", (boolean)caught);
                        throw throwable;
                    }
                    ElementTreeDeltaChainTest.assertTrue((String)"", (boolean)caught);
                }
                ElementTree projectTree = new ElementTree();
                projectTree.createElement(solution, (Object)"Dummy");
                projectTree.createElement(this.project3, (Object)"project3");
                trees = TestUtil.doManyRoutineOperations(projectTree, this.project3);
                TestUtil.scramble(trees);
                caught = false;
                try {
                    try {
                        this.fTree.mergeDeltaChain(null, (ElementTree[])trees);
                    }
                    catch (RuntimeException e) {
                        caught = true;
                        ex = e;
                        ElementTreeDeltaChainTest.assertTrue((String)ex.getMessage(), (boolean)caught);
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    ElementTreeDeltaChainTest.assertTrue((String)ex.getMessage(), (boolean)caught);
                    throw throwable;
                }
                ElementTreeDeltaChainTest.assertTrue((String)ex.getMessage(), (boolean)caught);
            }
            caught = false;
            try {
                try {
                    this.fTree.mergeDeltaChain(solution.append("bogosity"), (ElementTree[])trees);
                }
                catch (RuntimeException e) {
                    caught = true;
                    ex = e;
                    ElementTreeDeltaChainTest.assertTrue((String)ex.getMessage(), (boolean)caught);
                    break block22;
                }
            }
            catch (Throwable throwable) {
                ElementTreeDeltaChainTest.assertTrue((String)ex.getMessage(), (boolean)caught);
                throw throwable;
            }
            ElementTreeDeltaChainTest.assertTrue((String)ex.getMessage(), (boolean)caught);
        }
        caught = false;
        try {
            try {
                this.fTree.immutable();
                this.fTree.mergeDeltaChain(solution, (ElementTree[])trees);
            }
            catch (RuntimeException e) {
                caught = true;
                ex = e;
                ElementTreeDeltaChainTest.assertTrue((String)ex.getMessage(), (boolean)caught);
            }
        }
        finally {
            ElementTreeDeltaChainTest.assertTrue((String)ex.getMessage(), (boolean)caught);
        }
    }

    public void testMergeDeltaChain() {
        ElementTree projectTree = new ElementTree();
        projectTree.createElement(solution, (Object)"Dummy");
        projectTree.createElement(this.project3, (Object)"project3");
        Object[] trees = TestUtil.doManyRoutineOperations(projectTree, this.project3);
        ElementTree copyTree = new ElementTree();
        copyTree.createElement(solution, (Object)"Dummy");
        copyTree.createElement(this.project3, (Object)"project3");
        Object[] copies = TestUtil.doManyRoutineOperations(copyTree, this.project3);
        TestUtil.scramble(trees, copies);
        TestUtil.doRoutineOperations(this.fTree, solution);
        this.fTree = this.fTree.newEmptyDelta();
        ElementTree newTree = this.fTree.mergeDeltaChain(this.project3, (ElementTree[])trees);
        ElementTreeDeltaChainTest.assertTrue((String)"returned tree should be different", (newTree != this.fTree ? 1 : 0) != 0);
        ElementTreeDeltaChainTest.assertTrue((String)"returned tree should be open", (!newTree.isImmutable() ? 1 : 0) != 0);
        int i = 0;
        while (i < trees.length) {
            TestUtil.assertEqualTrees("testMergeDeltaChain: " + i, copies[i].getSubtree(this.project3), trees[i].getSubtree(this.project3));
            ++i;
        }
        TestUtil.assertHasPaths(newTree, TestUtil.getTreePaths());
        TestUtil.assertHasPaths(newTree, new IPath[]{this.project3});
    }

    public void testMergeOverwrite() {
        ElementTree projectTree = new ElementTree();
        projectTree.createElement(solution, (Object)"Dummy");
        projectTree.createElement(this.project3, (Object)"project3");
        Object[] trees = TestUtil.doManyRoutineOperations(this.fTree, solution);
        TestUtil.scramble(trees);
        ElementTree newTree = projectTree.mergeDeltaChain(solution, (ElementTree[])trees);
        ElementTreeDeltaChainTest.assertTrue((newTree != projectTree ? 1 : 0) != 0);
        ElementTreeDeltaChainTest.assertTrue((boolean)newTree.getElementData(solution).equals("solution"));
        TestUtil.assertTreeStructure(newTree);
    }
}

